/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.swagger;

import com.atlassian.oai.validator.interaction.response.CustomResponseValidator;
import com.atlassian.oai.validator.interaction.response.ResponseValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.schema.transform.AdditionalPropertiesInjectionTransformer;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.google.common.net.MediaType;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerValidatorUtils;

public class SwaggerResponseValidator {
    private final MessageResolver normalValidatorMessages;
    private final SchemaValidator normalSchemaValidator;
    private final ResponseValidator normalValidator;
    private final MessageResolver fileValidatorMessages;
    private final SchemaValidator fileSchemaValidator;
    private final ResponseValidator fileValidator;
    private final boolean validateWildcardSubtypeAsJson;

    public SwaggerResponseValidator(OpenAPI openApi, OpenapiLibraryValidatorConfig config) {
        List transformers;
        this.validateWildcardSubtypeAsJson = config.isValidateWildcardSubtypeAsJson();
        LevelResolver.Builder errorLevelResolverBuilder = SwaggerResponseValidator.getLevelResolverBuilder(config);
        this.normalValidatorMessages = new MessageResolver(errorLevelResolverBuilder.build());
        this.normalSchemaValidator = new SchemaValidator(openApi, this.normalValidatorMessages);
        if (!config.isSwaggerRequestValidator_InjectingAdditionalPropertiesFalse()) {
            transformers = this.normalSchemaValidator.transformers;
            this.normalSchemaValidator.transformers = transformers.stream().filter(t -> t != AdditionalPropertiesInjectionTransformer.getInstance()).collect(Collectors.toList());
        }
        this.normalValidator = new ResponseValidator(this.normalSchemaValidator, this.normalValidatorMessages, openApi, Arrays.asList(new CustomResponseValidator[0]));
        errorLevelResolverBuilder.withLevel("validation.response.body", ValidationReport.Level.IGNORE);
        errorLevelResolverBuilder.withLevel("validation.response.body.missing", ValidationReport.Level.ERROR);
        this.fileValidatorMessages = new MessageResolver(errorLevelResolverBuilder.build());
        this.fileSchemaValidator = new SchemaValidator(openApi, this.fileValidatorMessages);
        if (!config.isSwaggerRequestValidator_InjectingAdditionalPropertiesFalse()) {
            transformers = this.fileSchemaValidator.transformers;
            this.fileSchemaValidator.transformers = transformers.stream().filter(t -> t != AdditionalPropertiesInjectionTransformer.getInstance()).collect(Collectors.toList());
        }
        this.fileValidator = new ResponseValidator(this.fileSchemaValidator, this.fileValidatorMessages, openApi, Arrays.asList(new CustomResponseValidator[0]));
    }

    public ValidationReport validateResponse(Response response, ApiOperation apiOperation) {
        ApiResponse responseSchema = this.getApiResponse(response, apiOperation);
        if (responseSchema.getContent() == null) {
            return this.normalValidator.validateResponse(response, apiOperation);
        }
        Content contentSchema = responseSchema.getContent();
        if (contentSchema != null && !contentSchema.isEmpty() && response.getContentType().isEmpty()) {
            return ValidationReport.singleton((ValidationReport.Message)this.normalValidatorMessages.create("validation.response.contentType.notAllowed", "[RESPONSE] Required Content-Type is missing", new String[0]));
        }
        if (response.getResponseBody().isPresent() && response.getContentType().isEmpty()) {
            return ValidationReport.singleton((ValidationReport.Message)this.normalValidatorMessages.create("validation.response.contentType.notAllowed", "[RESPONSE] Empty Content-Type not allowed if body is present", new String[0]));
        }
        Optional mostSpecificMatch = ContentTypeUtils.findMostSpecificMatch((Response)response, (Set)responseSchema.getContent().keySet());
        if (!mostSpecificMatch.isPresent()) {
            return this.normalValidator.validateResponse(response, apiOperation);
        }
        io.swagger.v3.oas.models.media.MediaType mediaType = (io.swagger.v3.oas.models.media.MediaType)responseSchema.getContent().get(mostSpecificMatch.get());
        MediaType responseMediaType = MediaType.parse((String)((String)mostSpecificMatch.get()));
        Body responseBody = response.getResponseBody().orElse(null);
        ValidationReport report = ValidationReport.empty();
        if (SwaggerValidatorUtils.isBinarySchemaFile(mediaType.getSchema()) && responseBody != null) {
            if (ContentTypeUtils.isJsonContentType((Response)response)) {
                report = report.merge(SwaggerValidatorUtils.validateJsonFormat(responseBody, this.normalValidatorMessages, false)).merge(this.fileValidator.validateResponse(response, apiOperation));
            }
        } else {
            report = SwaggerValidatorUtils.isBase64SchemaFile(mediaType.getSchema()) && responseBody != null ? report.merge(SwaggerValidatorUtils.validateBase64Body(responseBody, this.normalValidatorMessages, false)).merge(this.fileValidator.validateResponse(response, apiOperation)) : (this.validateWildcardSubtypeAsJson && responseMediaType.subtype().equals("*") ? this.normalSchemaValidator.validate(() -> ((Body)response.getResponseBody().get()).toJsonNode(), mediaType.getSchema(), "response.body").merge(this.normalValidator.validateResponse(response, apiOperation)) : this.normalValidator.validateResponse(response, apiOperation));
        }
        return report;
    }

    private static LevelResolver.Builder getLevelResolverBuilder(OpenapiLibraryValidatorConfig config) {
        LevelResolver.Builder errorLevelResolver = LevelResolver.create();
        if (!config.isValidateResponseHeaders()) {
            errorLevelResolver.withLevel("validation.response.parameter.header", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateResponseBody()) {
            errorLevelResolver.withLevel("validation.response.body", ValidationReport.Level.IGNORE);
        }
        return errorLevelResolver;
    }

    private ApiResponse getApiResponse(Response response, ApiOperation apiOperation) {
        ApiResponse apiResponse = (ApiResponse)apiOperation.getOperation().getResponses().get((Object)Integer.toString(response.getStatus()));
        if (apiResponse == null) {
            return (ApiResponse)apiOperation.getOperation().getResponses().get((Object)"default");
        }
        return apiResponse;
    }
}

