/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ListReportProvider;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.swagger.util.Json;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerValidatorUtils;

public class SwaggerOpenApiValidator {
    private static final String SCHEMA_OPENAPI3_FILE = "schema-openapi3.json";
    private static final String SCHEMA_SWAGGER2_FILE = "schema-swagger-v2.json";
    private static final String INVALID_VERSION = "Unsupported Swagger version";
    static ObjectMapper JsonMapper = Json.mapper();
    private JsonSchema schemaV2;
    private JsonSchema schemaV3;

    public SwaggerOpenApiValidator() {
        String prefix = "/org/openspcoop2/utils/openapi/validator/swagger/";
        this.schemaV2 = this.resolveJsonSchema(this.getResourceFileAsString(prefix + SCHEMA_SWAGGER2_FILE), true);
        this.schemaV3 = this.resolveJsonSchema(this.getResourceFileAsString(prefix + SCHEMA_OPENAPI3_FILE), true);
    }

    public Optional<String> validate(JsonNode spec) throws ProcessingException {
        boolean isVersion2 = false;
        String version = SwaggerValidatorUtils.getSchemaVersion(spec);
        if (SwaggerValidatorUtils.isSchemaV1(version)) {
            return Optional.of(INVALID_VERSION);
        }
        if (SwaggerValidatorUtils.isSchemaV2(version)) {
            isVersion2 = true;
        } else if (version == null || SwaggerValidatorUtils.isSchemaV3(version)) {
            // empty if block
        }
        JsonSchema schema = this.getSchema(isVersion2);
        ProcessingReport report = schema.validateUnchecked(spec);
        ListProcessingReport lp = new ListProcessingReport();
        lp.mergeWith(report);
        StringBuilder result = new StringBuilder("");
        for (ProcessingMessage pm : lp) {
            result.append(pm.toString());
            result.append("\n");
        }
        return result.length() == 0 ? Optional.empty() : Optional.of(result.toString());
    }

    private JsonSchema getSchema(boolean isVersion2) {
        if (isVersion2) {
            return this.schemaV2;
        }
        return this.schemaV3;
    }

    private JsonSchema resolveJsonSchema(String schemaAsString, boolean removeId) {
        try {
            JsonNode schemaObject = JsonMapper.readTree(schemaAsString);
            if (removeId) {
                ObjectNode oNode = (ObjectNode)schemaObject;
                if (oNode.get("id") != null) {
                    oNode.remove("id");
                }
                if (oNode.get("$schema") != null) {
                    oNode.remove("$schema");
                }
                if (oNode.get("description") != null) {
                    oNode.remove("description");
                }
            }
            JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setReportProvider((ReportProvider)new ListReportProvider(LogLevel.WARNING, LogLevel.FATAL)).freeze();
            return factory.getJsonSchema(schemaObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Errore inatteso durante il parsing JSON dello schema: " + e.getMessage());
        }
    }

    public String getResourceFileAsString(String fileName) {
        try {
            InputStream is = SwaggerOpenApiValidator.class.getResourceAsStream(fileName);
            if (is != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String ret = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                reader.close();
                return ret;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Errore inatteso durante la lettura del file dello schema: " + e.getMessage());
        }
        return null;
    }
}

