/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.test;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.openapi.AbstractOpenapiApiReader;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class CoreTest {
    public static void test(URI uri, String testName, ApiFormats format, String baseUri) throws Exception {
        IApiReader apiReader = ApiFactory.newApiReader(format);
        apiReader.init(LoggerWrapperFactory.getLogger(CoreTest.class), new File(uri), new ApiReaderConfig());
        if (apiReader instanceof AbstractOpenapiApiReader) {
            ((AbstractOpenapiApiReader)apiReader).setDebug(true);
        }
        Api api = apiReader.read();
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        File f = Files.createTempDirectory("test", attr).toFile();
        if (!f.exists()) {
            System.out.println("[" + testName + "] Creazione dir non riuscita: " + f.getAbsolutePath());
            return;
        }
        System.out.println("[" + testName + "] Test scritti nella directory: " + f.getAbsolutePath());
        File fApi = new File(f, "API.txt");
        FileSystemUtilities.writeFile(fApi, api.toString().getBytes());
        System.out.println("[" + testName + "] API COMPLESSIVA scritta in: " + fApi.getAbsolutePath());
        System.out.println("[" + testName + "] Validazione ... ");
        api.validate(false);
        System.out.println("[" + testName + "] Validazione effettuata con successo");
        String test = baseUri + "/pets";
        System.out.println("[" + testName + "] API-Op [" + test + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.POST, test), f, "POST_petsAbsolute"));
        String testSenzaBaseUri = "/pets";
        System.out.println("[" + testName + "] API-Op [" + testSenzaBaseUri + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.POST, testSenzaBaseUri), f, "POST_pets"));
        testSenzaBaseUri = "/pets";
        System.out.println("[" + testName + "] API-Op [" + testSenzaBaseUri + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.PUT, testSenzaBaseUri), f, "PUT_pets"));
        testSenzaBaseUri = "/pets";
        System.out.println("[" + testName + "] API-Op [" + testSenzaBaseUri + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.DELETE, testSenzaBaseUri), f, "DELETE_pets"));
        String testConPetid = "/pets/2";
        System.out.println("[" + testName + "] API-Op [" + testConPetid + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.GET, testConPetid), f, "GET_pets_2"));
        System.out.println("[" + testName + "] API-Op [" + testConPetid + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.PUT, testConPetid), f, "PUT_pets_2"));
        String testConPetid2 = "/pets/2/uploadImage";
        System.out.println("[" + testName + "] API-Op [" + testConPetid2 + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.POST, testConPetid2), f, "POST_pets_2_uploadImage"));
        String testPathInesistente = "/pets/find/inesistente";
        System.out.println("[" + testName + "] API-Op [" + testPathInesistente + "]: " + CoreTest.checkNull(api.findOperation(HttpRequestMethod.GET, testPathInesistente), f, "GET_pets_find_inesistente"));
        String testConRequestConParametriInline = "/pets/findByStatus";
        System.out.println("[" + testName + "] API-Op [" + testConRequestConParametriInline + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.GET, testConRequestConParametriInline), f, "GET_pets_findByStatus"));
        String testConRequestCompleta = "/pets/2/completa";
        System.out.println("[" + testName + "] API-Op [" + testConRequestCompleta + "]: " + CoreTest.checkCompleta(api.findOperation(HttpRequestMethod.POST, testConRequestCompleta), f, "POST_pets_2_completa", format));
    }

    public static void testIndentazione(URI uri, String testName, ApiFormats format, String baseUri) throws Exception {
        IApiReader apiReader = ApiFactory.newApiReader(ApiFormats.OPEN_API_3);
        byte[] bytes = FileSystemUtilities.readBytesFromFile(new File(uri));
        ApiReaderConfig config = new ApiReaderConfig();
        config.setProcessInclude(false);
        apiReader.init(LoggerWrapperFactory.getLogger(CoreTest.class), bytes, config);
        if (apiReader instanceof AbstractOpenapiApiReader) {
            ((AbstractOpenapiApiReader)apiReader).setDebug(true);
        }
        Api api = apiReader.read();
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        File f = Files.createTempDirectory("test", attr).toFile();
        if (!f.exists()) {
            System.out.println("[" + testName + "] Creazione dir non riuscita: " + f.getAbsolutePath());
            return;
        }
        System.out.println("[" + testName + "] Test scritti nella directory: " + f.getAbsolutePath());
        File fApi = new File(f, "APIIndentazione.txt");
        FileSystemUtilities.writeFile(fApi, api.toString().getBytes());
        System.out.println("[" + testName + "] API COMPLESSIVA scritta in: " + fApi.getAbsolutePath());
        System.out.println("[" + testName + "] Validazione ... ");
        api.validate(false);
        System.out.println("[" + testName + "] Validazione effettuata con successo");
        String test = baseUri + "/test";
        System.out.println("[" + testName + "] API-Op [" + test + "]: " + CoreTest.checkNotNull(api.findOperation(HttpRequestMethod.GET, test), f, "GET_test"));
    }

    private static String checkCompleta(ApiOperation api, File f, String nome, ApiFormats apiFormat) throws Exception {
        String resp = CoreTest.checkNotNull(api, f, nome);
        if (api.getRequest().sizeBodyParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene body parameters");
        }
        if (api.getRequest().sizeHeaderParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene header parameters");
        }
        if (api.getRequest().sizeQueryParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene query parameters");
        }
        if (api.getRequest().sizeDynamicPathParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene dynamic path parameters");
        }
        if (!apiFormat.equals(ApiFormats.SWAGGER_2) && api.getRequest().sizeCookieParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene cookie parameters");
        }
        if (api.getResponses().isEmpty()) {
            throw new Exception("Resource " + nome + " non contiene responses");
        }
        if (api.getResponses().get(0).sizeHeaderParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene response header parameters");
        }
        if (api.getResponses().get(0).sizeBodyParameters() <= 0) {
            throw new Exception("Resource " + nome + " non contiene response body parameters");
        }
        return resp;
    }

    private static String checkNull(ApiOperation api, File f, String nome) throws Exception {
        if (api != null) {
            throw new Exception("Resource " + nome + " found ??");
        }
        return "Resource non trovata come atteso nel test";
    }

    private static String checkNotNull(ApiOperation api, File f, String nome) throws Exception {
        if (api == null) {
            throw new Exception("Resource " + nome + " not found");
        }
        File fApi = new File(f, nome + ".txt");
        FileSystemUtilities.writeFile(fApi, api.toString().getBytes());
        return "Resource " + nome + " scritta in: " + fApi.getAbsolutePath();
    }
}

