/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mime;

import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.openspcoop2.utils.UtilsException;

public class MimeMultipart {
    private jakarta.mail.internet.MimeMultipart mimeMultipartObject = null;
    private static final String CONTENT_ID = "Content-ID";
    private static final String CONTENT_LOCATION = "Content-Location";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";

    public MimeMultipart() throws UtilsException {
        try {
            this.mimeMultipartObject = new jakarta.mail.internet.MimeMultipart();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public MimeMultipart(String subType) throws UtilsException {
        try {
            this.mimeMultipartObject = new jakarta.mail.internet.MimeMultipart(subType);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public MimeMultipart(InputStream is, String contentType) throws UtilsException {
        try {
            ByteArrayDataSource ds = new ByteArrayDataSource(is, contentType);
            this.mimeMultipartObject = new jakarta.mail.internet.MimeMultipart((DataSource)ds);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addBodyPart(BodyPart bodyPart) throws UtilsException {
        try {
            this.mimeMultipartObject.addBodyPart(bodyPart);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void addBodyPart(BodyPart bodyPart, int index) throws UtilsException {
        try {
            this.mimeMultipartObject.addBodyPart(bodyPart, index);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public BodyPart createBodyPart(InputStream is) throws UtilsException {
        try {
            return new MimeBodyPart(is);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public BodyPart createBodyPart(InternetHeaders headers, byte[] content) throws UtilsException {
        try {
            return new MimeBodyPart(headers, content);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public int countBodyParts() throws UtilsException {
        try {
            return this.mimeMultipartObject.getCount();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public BodyPart getBodyPart(int index) throws UtilsException {
        try {
            return this.mimeMultipartObject.getBodyPart(index);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public BodyPart getBodyPart(String contentID) throws UtilsException {
        try {
            return this.mimeMultipartObject.getBodyPart(contentID);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void removeBodyPart(int index) throws UtilsException {
        try {
            this.mimeMultipartObject.removeBodyPart(index);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void removeBodyPart(String contentID) throws UtilsException {
        try {
            BodyPart bodyPart = this.getBodyPart(contentID);
            if (bodyPart != null) {
                this.mimeMultipartObject.removeBodyPart(bodyPart);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void removeBodyPart(BodyPart bodyPart) throws UtilsException {
        try {
            this.mimeMultipartObject.removeBodyPart(bodyPart);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void writeTo(OutputStream os) throws UtilsException {
        try {
            this.mimeMultipartObject.writeTo(os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getContentType() throws UtilsException {
        try {
            String contentType = this.mimeMultipartObject.getContentType();
            while (contentType.contains("\r")) {
                contentType = contentType.replace("\r", "");
            }
            while (contentType.contains("\n")) {
                contentType = contentType.replace("\n", "");
            }
            while (contentType.contains("\t")) {
                contentType = contentType.replace("\t", " ");
            }
            while (contentType.contains("  ")) {
                contentType = contentType.replace("  ", " ");
            }
            return contentType;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getContentID(BodyPart bodyPart) throws UtilsException {
        return this.getHeaderValue(CONTENT_ID, bodyPart);
    }

    public String getContentLocation(BodyPart bodyPart) throws UtilsException {
        return this.getHeaderValue(CONTENT_LOCATION, bodyPart);
    }

    public String getContentDisposition(BodyPart bodyPart) throws UtilsException {
        return this.getHeaderValue(CONTENT_DISPOSITION, bodyPart);
    }

    private String getHeaderValue(String headerName, BodyPart bodyPart) throws UtilsException {
        try {
            Enumeration enHdr = bodyPart.getAllHeaders();
            while (enHdr.hasMoreElements()) {
                Object o = enHdr.nextElement();
                String header = null;
                Header mh = null;
                if (o instanceof String) {
                    header = (String)o;
                    if (!this.match(headerName, header)) continue;
                    return bodyPart.getHeader(header)[0];
                }
                if (!(o instanceof Header) || !this.match(headerName, header = (mh = (Header)o).getName())) continue;
                return mh.getValue();
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private boolean match(String headerName, String check) {
        return headerName.equalsIgnoreCase(check);
    }
}

