/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.logger.beans.context.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransactionWithClient;
import org.openspcoop2.utils.logger.beans.context.core.BaseServer;

public class ApplicationTransaction
extends AbstractTransactionWithClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<BaseServer> servers = new ArrayList<BaseServer>();

    public List<BaseServer> getServers() {
        return this.servers;
    }

    public Map<String, BaseServer> getServersMap() {
        HashMap<String, BaseServer> map = new HashMap<String, BaseServer>();
        int index = 1;
        for (BaseServer baseServer : this.servers) {
            if (baseServer.getName() != null && !map.containsKey(baseServer.getName())) {
                map.put(baseServer.getName(), baseServer);
            } else {
                map.put("_server-" + index, baseServer);
            }
            ++index;
        }
        return map;
    }

    public void addServer(BaseServer server) {
        this.servers.add(server);
    }

    public int sizeServers() {
        return this.servers.size();
    }

    public BaseServer getServer(int index) {
        return this.servers.get(index);
    }

    public BaseServer getServer(String name) {
        for (BaseServer baseServer : this.servers) {
            if (!name.equals(baseServer.getName())) continue;
            return baseServer;
        }
        return null;
    }

    public BaseServer getLastServer() {
        return this.servers.get(this.servers.size() - 1);
    }

    public BaseServer getFirstServer() {
        return this.servers.get(0);
    }
}

