/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.IJsonSchemaValidator;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonSchemaValidatorConfig;
import org.openspcoop2.utils.json.ValidationException;
import org.openspcoop2.utils.json.ValidationResponse;
import org.openspcoop2.utils.json.validation.ValidationUtils;
import org.slf4j.Logger;

public class FGEJsonschemaValidator
implements IJsonSchemaValidator {
    private JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();
    private JsonNode schema;
    private byte[] schemaBytes;
    private ObjectMapper jsonMapper = new ObjectMapper();
    private Logger log;
    private boolean logError;

    @Override
    public void setSchema(byte[] schema, JsonSchemaValidatorConfig config, Logger log) throws ValidationException {
        this.log = log;
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(FGEJsonschemaValidator.class);
        }
        this.logError = config != null ? config.isEmitLogError() : true;
        this.schemaBytes = schema;
        try {
            this.schema = this.jsonMapper.readTree(schema);
            if (config != null) {
                switch (config.getAdditionalProperties()) {
                    case DEFAULT: {
                        break;
                    }
                    case FORCE_DISABLE: {
                        ValidationUtils.disableAdditionalProperties(this.jsonMapper, this.schema, true, true);
                        break;
                    }
                    case FORCE_STRING: {
                        ValidationUtils.disableAdditionalProperties(this.jsonMapper, this.schema, false, true);
                        break;
                    }
                    case IF_NULL_DISABLE: {
                        ValidationUtils.disableAdditionalProperties(this.jsonMapper, this.schema, true, false);
                        break;
                    }
                    case IF_NULL_STRING: {
                        ValidationUtils.disableAdditionalProperties(this.jsonMapper, this.schema, false, false);
                        break;
                    }
                }
            }
            if (config != null) {
                switch (config.getPoliticaInclusioneTipi()) {
                    case DEFAULT: {
                        break;
                    }
                    case ALL: {
                        ValidationUtils.addTypes(this.jsonMapper, this.schema, config.getTipi(), true);
                        break;
                    }
                    case ANY: {
                        ValidationUtils.addTypes(this.jsonMapper, this.schema, config.getTipi(), false);
                        break;
                    }
                }
            }
            if (config != null && config.isVerbose()) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    JSONUtils.getInstance(true).writeTo(this.schema, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    this.log.debug("JSON Schema: " + bout.toString());
                }
                catch (Exception e) {
                    this.log.debug("JSON Schema build error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public ValidationResponse validate(byte[] rawObject) throws ValidationException {
        ValidationResponse response = new ValidationResponse();
        try {
            boolean expectedString = false;
            if (this.schema.has("type")) {
                try {
                    JsonNode type = this.schema.get("type");
                    String vType = type.asText();
                    expectedString = "string".equals(vType);
                }
                catch (Exception type) {
                    // empty catch block
                }
            }
            Object object = null;
            try {
                object = expectedString ? this.jsonMapper.getNodeFactory().textNode(new String(rawObject)) : this.jsonMapper.readTree(rawObject);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                String messageString = "Read rawObject as jsonNode failed: " + e.getMessage();
                response.setEsito(ValidationResponse.ESITO.KO);
                if (this.logError) {
                    ValidationUtils.logError(this.log, messageString.toString(), rawObject, this.schemaBytes, this.schema);
                }
                response.setException(new Exception(messageString.toString()));
            }
            if (object != null) {
                ProcessingReport report = this.validator.validate(this.schema, object, true);
                if (report.isSuccess()) {
                    response.setEsito(ValidationResponse.ESITO.OK);
                } else {
                    response.setEsito(ValidationResponse.ESITO.KO);
                    for (ProcessingMessage msg : report) {
                        StringBuilder messageString = new StringBuilder();
                        if (msg.getLogLevel().equals((Object)LogLevel.ERROR) || msg.getLogLevel().equals((Object)LogLevel.FATAL)) {
                            response.getErrors().add(msg.getMessage());
                            messageString.append(msg.getMessage()).append("\n");
                        }
                        if (this.logError) {
                            ValidationUtils.logError(this.log, messageString.toString(), rawObject, this.schemaBytes, this.schema);
                        }
                        response.setException(new Exception(messageString.toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        return response;
    }
}

