/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.core.jackson.mixin.MediaTypeMixin;
import io.swagger.v3.core.jackson.mixin.SchemaMixin;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.AbstractUtils;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.YamlSnakeLimits;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YAMLUtils
extends AbstractUtils {
    private static YAMLUtils yamlUtils;
    private static YAMLUtils yamlUtilsPretty;
    private static Semaphore semaphore;
    private static YAMLMapper internalMapper;
    private static ObjectWriter writer;
    private static ObjectWriter writerPrettyPrint;

    private static synchronized void init(boolean prettyPrint) {
        if (prettyPrint) {
            if (yamlUtilsPretty == null) {
                yamlUtilsPretty = new YAMLUtils(true);
            }
        } else if (yamlUtils == null) {
            yamlUtils = new YAMLUtils(false);
        }
    }

    public static YAMLUtils getInstance() {
        return YAMLUtils.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YAMLUtils getInstance(boolean prettyPrint) {
        if (prettyPrint) {
            if (yamlUtilsPretty != null) return yamlUtilsPretty;
            Class<YAMLUtils> clazz = YAMLUtils.class;
            synchronized (YAMLUtils.class) {
                YAMLUtils.init(true);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return yamlUtilsPretty;
            }
        }
        if (yamlUtils != null) return yamlUtils;
        Class<YAMLUtils> clazz = YAMLUtils.class;
        synchronized (YAMLUtils.class) {
            YAMLUtils.init(false);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return yamlUtils;
        }
    }

    private static synchronized void initMapper() {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("initMapper");
        try {
            if (internalMapper == null) {
                internalMapper = new YAMLMapper();
                internalMapper.setTimeZone(TimeZone.getDefault());
                internalMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                internalMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
                internalMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                internalMapper.addMixIn(Schema.class, SchemaMixin.class);
                internalMapper.addMixIn(MediaType.class, MediaTypeMixin.class);
            }
        }
        finally {
            semaphore.release(lock, "initMapper");
        }
    }

    public static void setMapperTimeZone(TimeZone timeZone) {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("setMapperTimeZone");
        try {
            internalMapper.setTimeZone(timeZone);
        }
        finally {
            semaphore.release(lock, "setMapperTimeZone");
        }
    }

    public static void registerJodaModule() {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("registerJodaModule");
        try {
            internalMapper.registerModule((Module)new JodaModule());
        }
        finally {
            semaphore.release(lock, "registerJodaModule");
        }
    }

    public static void registerJavaTimeModule() {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("registerJavaTimeModule");
        try {
            internalMapper.registerModule((Module)new JavaTimeModule());
        }
        finally {
            semaphore.release(lock, "registerJavaTimeModule");
        }
    }

    public static YAMLMapper getObjectMapper() {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        return internalMapper;
    }

    private static synchronized void initWriter() {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        if (writer == null) {
            writer = internalMapper.writer();
        }
    }

    public static ObjectWriter getObjectWriter() {
        if (writer == null) {
            YAMLUtils.initWriter();
        }
        return writer;
    }

    private static synchronized void initWriterPrettyPrint() {
        if (internalMapper == null) {
            YAMLUtils.initMapper();
        }
        if (writerPrettyPrint == null) {
            writerPrettyPrint = internalMapper.writer().withDefaultPrettyPrinter();
        }
    }

    public static ObjectWriter getObjectWriterPrettyPrint() {
        if (writerPrettyPrint == null) {
            YAMLUtils.initWriterPrettyPrint();
        }
        return writerPrettyPrint;
    }

    private YAMLUtils(boolean prettyPrint) {
        super(prettyPrint);
    }

    @Override
    protected void _initMapper() {
        YAMLUtils.initMapper();
    }

    @Override
    protected void _initWriter(boolean prettyPrint) {
        if (prettyPrint) {
            YAMLUtils.initWriterPrettyPrint();
        } else {
            YAMLUtils.initWriter();
        }
    }

    @Override
    protected ObjectMapper _getObjectMapper() {
        return YAMLUtils.getObjectMapper();
    }

    @Override
    protected ObjectWriter _getObjectWriter(boolean prettyPrint) {
        if (prettyPrint) {
            return YAMLUtils.getObjectWriterPrettyPrint();
        }
        return YAMLUtils.getObjectWriter();
    }

    public boolean isYaml(byte[] jsonBytes) {
        return !JSONUtils.getInstance().isJson(jsonBytes) && this.isValid(jsonBytes);
    }

    public boolean isYaml(String jsonString) {
        return !JSONUtils.getInstance().isJson(jsonString) && this.isValid(jsonString);
    }

    public static boolean containsKeyAnchor(String yaml) {
        return YAMLUtils.containsMergeKeyAnchor(yaml) || YAMLUtils.containsRefKeyAnchor(yaml);
    }

    public static boolean containsMergeKeyAnchor(String yaml) {
        return yaml != null && yaml.contains("<<: *");
    }

    public static boolean containsRefKeyAnchor(String yaml) {
        return yaml != null && yaml.contains(" *") && yaml.contains(" &");
    }

    public static String resolveMergeKeyAndConvertToJson(String yaml) throws UtilsException {
        return YAMLUtils.resolveMergeKeyAndConvertToJson(yaml, JSONUtils.getInstance());
    }

    public static String resolveMergeKeyAndConvertToJson(String yaml, JSONUtils jsonUtils) throws UtilsException {
        return YAMLUtils.resolveAnchorAndConvertToJson(yaml, jsonUtils, false);
    }

    public static String resolveKeyAnchorAndConvertToJson(String yaml) throws UtilsException {
        return YAMLUtils.resolveKeyAnchorAndConvertToJson(yaml, JSONUtils.getInstance());
    }

    public static String resolveKeyAnchorAndConvertToJson(String yaml, JSONUtils jsonUtils) throws UtilsException {
        return YAMLUtils.resolveAnchorAndConvertToJson(yaml, jsonUtils, true);
    }

    private static String resolveAnchorAndConvertToJson(String yaml, JSONUtils jsonUtils, boolean resolveAllAnchor) throws UtilsException {
        boolean contains;
        boolean bl = contains = resolveAllAnchor ? YAMLUtils.containsKeyAnchor(yaml) : YAMLUtils.containsMergeKeyAnchor(yaml);
        if (contains) {
            Map obj = (Map)new Yaml().load(yaml);
            return jsonUtils.toString(obj);
        }
        return null;
    }

    public static boolean containsEmptySchema(String yaml) {
        String pattern = "(?m)^([ \\t]*)schema\\s*:\\s*\\{\\s*\\}\\s*$";
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(yaml);
            return matcher.find();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String resolveEmptySchema(String yaml) {
        return yaml.replaceAll("(?m)^([ \\t]*)schema:\\s*\\{\\s*\\}", "$1schema:\n$1  type: string");
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, String raw) {
        return this.convertToMap(log, source, raw, null);
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, String raw, List<String> claimsToConvert) {
        if (this.isYaml(raw)) {
            return super.convertToMapEngine(log, source, raw, claimsToConvert);
        }
        return new HashMap<String, Serializable>();
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, byte[] raw) {
        return this.convertToMap(log, source, raw, null);
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, byte[] raw, List<String> claimsToConvert) {
        if (this.isYaml(raw)) {
            return super.convertToMapEngine(log, source, raw, claimsToConvert);
        }
        return new HashMap<String, Serializable>();
    }

    static {
        YamlSnakeLimits.initialize();
        yamlUtils = null;
        yamlUtilsPretty = null;
        semaphore = new Semaphore("JSONUtils");
    }
}

