/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.cache.Cache;
import com.jayway.jsonpath.spi.cache.CacheProvider;
import com.jayway.jsonpath.spi.cache.NOOPCache;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathException;
import org.openspcoop2.utils.json.JsonPathNotFoundException;
import org.openspcoop2.utils.json.JsonPathNotValidException;
import org.openspcoop2.utils.json.JsonPathReturnType;
import org.slf4j.Logger;

public class JsonPathExpressionEngine {
    private static JSONUtils jsonUtils;

    public static void disableCacheJsonPathEngine() {
        CacheProvider.setCache((Cache)new NOOPCache());
    }

    public static String getAsString(JsonNode element) {
        try {
            return JsonPathExpressionEngine.getJsonUtils().toString(element);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized void initJsonUtils() throws UtilsException {
        if (jsonUtils == null) {
            jsonUtils = JSONUtils.getInstance();
        }
    }

    public static JSONUtils getJsonUtils() throws UtilsException {
        if (jsonUtils == null) {
            JsonPathExpressionEngine.initJsonUtils();
        }
        return jsonUtils;
    }

    public static JSONObject getJSONObject(InputStream is) throws JsonPathException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        try {
            return (JSONObject)JsonPathExpressionEngine.getJSONParser().parse(is, JSONObject.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONArray getJSONArray(InputStream is) throws JsonPathException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        try {
            return (JSONArray)JsonPathExpressionEngine.getJSONParser().parse(is, JSONArray.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONObject getJSONObject(String contenuto) throws JsonPathException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        try {
            return (JSONObject)JsonPathExpressionEngine.getJSONParser().parse(contenuto, JSONObject.class);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONArray getJSONArray(String contenuto) throws JsonPathException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        try {
            return (JSONArray)JsonPathExpressionEngine.getJSONParser().parse(contenuto, JSONArray.class);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONObject getJSONObject(JsonNode document) throws JsonPathException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        try {
            return (JSONObject)JsonPathExpressionEngine.getJSONParser().parse(JsonPathExpressionEngine.getAsString(document), JSONObject.class);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONArray getJSONArray(JsonNode document) throws JsonPathException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        try {
            return (JSONArray)JsonPathExpressionEngine.getJSONParser().parse(JsonPathExpressionEngine.getAsString(document), JSONArray.class);
        }
        catch (ParseException e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public static JSONParser getJSONParser() {
        return new JSONParser(-1);
    }

    public List<String> getStringMatchPattern(JSONObject input, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JSONObject) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<String> l = new ArrayList<String>();
            Object o = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseStringMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<String> getStringMatchPattern(JsonNode document, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<String> l = new ArrayList<String>();
            Object o = JsonPath.read((String)JsonPathExpressionEngine.getAsString(document), (String)pattern, (Predicate[])new Predicate[0]);
            this._parseStringMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<String> getStringMatchPattern(InputStream is, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<String> l = new ArrayList<String>();
            Object o = JsonPath.read((InputStream)is, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseStringMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<String> getStringMatchPattern(String contenuto, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<String> l = new ArrayList<String>();
            Object o = JsonPath.read((String)contenuto, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseStringMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    private void _parseStringMatchPatternResult(Object o, List<String> l) throws Exception {
        if (o != null) {
            if (o instanceof Map) {
                throw new Exception("Unexpected type '" + o.getClass().getName() + "' (is instanceof Map)");
            }
            if (o instanceof List) {
                List lO = (List)o;
                if (!lO.isEmpty()) {
                    int position = 0;
                    for (Object object : lO) {
                        if (object != null) {
                            if (object instanceof String) {
                                l.add((String)object);
                            } else if (object instanceof Number) {
                                l.add(object.toString());
                            } else if (object instanceof Boolean) {
                                l.add(object.toString());
                            } else {
                                throw new Exception("Unexpected type '" + object.getClass().getName() + "' at position " + position);
                            }
                        }
                        ++position;
                    }
                }
            } else if (o instanceof String) {
                l.add((String)o);
            } else if (o instanceof Number) {
                l.add(o.toString());
            } else if (o instanceof Boolean) {
                l.add(o.toString());
            } else {
                throw new Exception("Unexpected type '" + o.getClass().getName() + "'");
            }
        }
    }

    public List<Number> getNumberMatchPattern(JSONObject input, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JSONObject) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Number> l = new ArrayList<Number>();
            Object o = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseNumberMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Number> getNumberMatchPattern(JsonNode document, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Number> l = new ArrayList<Number>();
            Object o = JsonPath.read((String)JsonPathExpressionEngine.getAsString(document), (String)pattern, (Predicate[])new Predicate[0]);
            this._parseNumberMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Number> getNumberMatchPattern(InputStream is, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Number> l = new ArrayList<Number>();
            Object o = JsonPath.read((InputStream)is, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseNumberMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Number> getNumberMatchPattern(String contenuto, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Number> l = new ArrayList<Number>();
            Object o = JsonPath.read((String)contenuto, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseNumberMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    private void _parseNumberMatchPatternResult(Object o, List<Number> l) throws Exception {
        if (o != null) {
            if (o instanceof List) {
                List lO = (List)o;
                if (!lO.isEmpty()) {
                    int position = 0;
                    for (Object object : lO) {
                        if (object != null) {
                            if (object instanceof Number) {
                                l.add((Number)object);
                            } else {
                                throw new Exception("Unexpected type '" + object.getClass().getName() + "' at position " + position);
                            }
                        }
                        ++position;
                    }
                }
            } else if (o instanceof Number) {
                l.add((Number)o);
            } else {
                throw new Exception("Unexpected type '" + o.getClass().getName() + "'");
            }
        }
    }

    public List<Boolean> getBooleanMatchPattern(JSONObject input, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JSONObject) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Boolean> l = new ArrayList<Boolean>();
            Object o = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseBooleanMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Boolean> getBooleanMatchPattern(JsonNode document, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Boolean> l = new ArrayList<Boolean>();
            Object o = JsonPath.read((String)JsonPathExpressionEngine.getAsString(document), (String)pattern, (Predicate[])new Predicate[0]);
            this._parseBooleanMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Boolean> getBooleanMatchPattern(InputStream is, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Boolean> l = new ArrayList<Boolean>();
            Object o = JsonPath.read((InputStream)is, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseBooleanMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public List<Boolean> getBooleanMatchPattern(String contenuto, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            ArrayList<Boolean> l = new ArrayList<Boolean>();
            Object o = JsonPath.read((String)contenuto, (String)pattern, (Predicate[])new Predicate[0]);
            this._parseBooleanMatchPatternResult(o, l);
            if (l == null || l.size() <= 0) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return l;
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    private void _parseBooleanMatchPatternResult(Object o, List<Boolean> l) throws Exception {
        if (o != null) {
            if (o instanceof List) {
                List lO = (List)o;
                if (!lO.isEmpty()) {
                    int position = 0;
                    for (Object object : lO) {
                        if (object != null) {
                            if (object instanceof Boolean) {
                                l.add((Boolean)object);
                            } else {
                                throw new Exception("Unexpected type '" + object.getClass().getName() + "' at position " + position);
                            }
                        }
                        ++position;
                    }
                }
            } else if (o instanceof Boolean) {
                l.add((Boolean)o);
            } else {
                throw new Exception("Unexpected type '" + o.getClass().getName() + "'");
            }
        }
    }

    public JsonNode getJsonNodeMatchPattern(JSONObject input, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JSONObject) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            Object object = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
            if (object == null) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return this.convertToJsonNode(object);
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public JsonNode getJsonNodeMatchPattern(JsonNode document, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (document == null) {
            throw new JsonPathException("Document (JsonNode) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            String inputString = JsonPathExpressionEngine.getAsString(document);
            Object object = JsonPath.read((String)inputString, (String)pattern, (Predicate[])new Predicate[0]);
            if (object == null) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return this.convertToJsonNode(object);
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public JsonNode getJsonNodeMatchPattern(InputStream is, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (is == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            Object object = JsonPath.read((InputStream)is, (String)pattern, (Predicate[])new Predicate[0]);
            if (object == null) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return this.convertToJsonNode(object);
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    public JsonNode getJsonNodeMatchPattern(String contenuto, String pattern) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (contenuto == null) {
            throw new JsonPathException("Document (String) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        try {
            Object object = JsonPath.read((String)contenuto, (String)pattern, (Predicate[])new Predicate[0]);
            if (object == null) {
                throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
            }
            return this.convertToJsonNode(object);
        }
        catch (PathNotFoundException notFound) {
            throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new JsonPathException(e.getMessage(), e);
        }
    }

    private JsonNode convertToJsonNode(Object object) throws UtilsException {
        if (object instanceof String) {
            return JsonPathExpressionEngine.getJsonUtils().getAsNode("\"" + (String)object + "\"");
        }
        if (object instanceof JSONArray) {
            JSONArray jsonObject = (JSONArray)object;
            return JsonPathExpressionEngine.getJsonUtils().getAsNode(jsonObject.toString());
        }
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            return JsonPathExpressionEngine.getJsonUtils().getAsNode(jsonObject.toString());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return JsonPathExpressionEngine.getJsonUtils().getAsNode(map);
        }
        return JsonPathExpressionEngine.getJsonUtils().getAsNode(object.toString());
    }

    public Object getMatchPattern(JSONObject input, String pattern, JsonPathReturnType returnType) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JSONObject)is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        if (returnType == null) {
            throw new JsonPathException("JsonPathReturnType is null");
        }
        Object risposta = null;
        switch (returnType) {
            case STRING: {
                risposta = this.getStringMatchPattern(input, pattern);
                break;
            }
            case NUMBER: {
                risposta = this.getNumberMatchPattern(input, pattern);
                break;
            }
            case BOOLEAN: {
                risposta = this.getBooleanMatchPattern(input, pattern);
                break;
            }
            case NODE: {
                risposta = this.getJsonNodeMatchPattern(input, pattern);
                break;
            }
            default: {
                try {
                    risposta = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
                    break;
                }
                catch (PathNotFoundException notFound) {
                    throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
                }
            }
        }
        if (risposta == null) {
            throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
        }
        return risposta;
    }

    public Object getMatchPattern(JsonNode input, String pattern, JsonPathReturnType returnType) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (JsonNode)is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        if (returnType == null) {
            throw new JsonPathException("JsonPathReturnType is null");
        }
        Object risposta = null;
        String inputString = JsonPathExpressionEngine.getAsString(input);
        switch (returnType) {
            case STRING: {
                risposta = this.getStringMatchPattern(inputString, pattern);
                break;
            }
            case NUMBER: {
                risposta = this.getNumberMatchPattern(inputString, pattern);
                break;
            }
            case BOOLEAN: {
                risposta = this.getBooleanMatchPattern(inputString, pattern);
                break;
            }
            case NODE: {
                risposta = this.getJsonNodeMatchPattern(inputString, pattern);
                break;
            }
            default: {
                try {
                    risposta = JsonPath.read((Object)input, (String)pattern, (Predicate[])new Predicate[0]);
                    break;
                }
                catch (PathNotFoundException notFound) {
                    throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
                }
            }
        }
        if (risposta == null) {
            throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
        }
        return risposta;
    }

    public Object getMatchPattern(InputStream input, String pattern, JsonPathReturnType returnType) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (InputStream) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        if (returnType == null) {
            throw new JsonPathException("JsonPathReturnType is null");
        }
        Object risposta = null;
        switch (returnType) {
            case STRING: {
                risposta = this.getStringMatchPattern(input, pattern);
                break;
            }
            case NUMBER: {
                risposta = this.getNumberMatchPattern(input, pattern);
                break;
            }
            case BOOLEAN: {
                risposta = this.getBooleanMatchPattern(input, pattern);
                break;
            }
            case NODE: {
                risposta = this.getJsonNodeMatchPattern(input, pattern);
                break;
            }
            default: {
                try {
                    risposta = JsonPath.read((InputStream)input, (String)pattern, (Predicate[])new Predicate[0]);
                    break;
                }
                catch (PathNotFoundException notFound) {
                    throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
                }
                catch (Exception e) {
                    throw new JsonPathException(e.getMessage(), e);
                }
            }
        }
        if (risposta == null) {
            throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
        }
        return risposta;
    }

    public Object getMatchPattern(String input, String pattern, JsonPathReturnType returnType) throws JsonPathException, JsonPathNotFoundException, JsonPathNotValidException {
        if (input == null) {
            throw new JsonPathException("Document (String) is null");
        }
        if (pattern == null) {
            throw new JsonPathException("Pattern is null");
        }
        this.validate(pattern);
        if (returnType == null) {
            throw new JsonPathException("JsonPathReturnType is null");
        }
        Object risposta = null;
        switch (returnType) {
            case STRING: {
                risposta = this.getStringMatchPattern(input, pattern);
                break;
            }
            case NUMBER: {
                risposta = this.getNumberMatchPattern(input, pattern);
                break;
            }
            case BOOLEAN: {
                risposta = this.getBooleanMatchPattern(input, pattern);
                break;
            }
            case NODE: {
                risposta = this.getJsonNodeMatchPattern(input, pattern);
                break;
            }
            default: {
                try {
                    risposta = JsonPath.read((String)input, (String)pattern, (Predicate[])new Predicate[0]);
                    break;
                }
                catch (PathNotFoundException notFound) {
                    throw new JsonPathNotFoundException(notFound.getMessage(), notFound);
                }
            }
        }
        if (risposta == null) {
            throw new PathNotFoundException("Nessun match trovato per l'espressione jsonPath [" + pattern + "]");
        }
        return risposta;
    }

    public void validate(String path) throws JsonPathNotValidException {
        try {
            JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            throw new JsonPathNotValidException("Validazione del jsonPath indicato [" + path + "] fallita: " + e.getMessage(), e);
        }
    }

    public static String extractAndConvertResultAsString(String elementJson, String pattern, Logger log) throws Exception {
        List<String> l = JsonPathExpressionEngine._extractAndConvertResultAsString(elementJson, pattern, log, false);
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public static List<String> extractAndConvertResultAsList(String elementJson, String pattern, Logger log) throws Exception {
        return JsonPathExpressionEngine._extractAndConvertResultAsString(elementJson, pattern, log, true);
    }

    private static List<String> _extractAndConvertResultAsString(String elementJson, String pattern, Logger log, boolean returnAsList) throws Exception {
        Exception exceptionNodeSet;
        JsonPathExpressionEngine engine;
        ArrayList<String> lReturn;
        block30: {
            lReturn = new ArrayList<String>();
            engine = new JsonPathExpressionEngine();
            exceptionNodeSet = null;
            try {
                List<String> l = engine.getStringMatchPattern(elementJson, pattern);
                if (l == null || l.size() <= 0) break block30;
                if (returnAsList) {
                    for (String s : l) {
                        if (s instanceof String) {
                            lReturn.add(s);
                            continue;
                        }
                        if (s instanceof Map) {
                            try {
                                Map map = (Map)((Object)s);
                                if (map.isEmpty()) continue;
                                StringBuilder sb = new StringBuilder("{");
                                for (Object keyO : map.keySet()) {
                                    if (sb.length() > 1) {
                                        sb.append(",");
                                    }
                                    String key = (String)keyO;
                                    sb.append("\"").append(key).append("\": ");
                                    Object valueO = map.get(keyO);
                                    if (valueO instanceof Boolean || valueO instanceof Short || valueO instanceof Integer || valueO instanceof Long || valueO instanceof Double || valueO instanceof Float) {
                                        sb.append(valueO);
                                        continue;
                                    }
                                    sb.append("\"").append(valueO).append("\"");
                                }
                                sb.append("}");
                                lReturn.add(sb.toString());
                            }
                            catch (Throwable t) {
                                lReturn.add(s.toString());
                            }
                            continue;
                        }
                        lReturn.add(s.toString());
                    }
                    break block30;
                }
                StringBuilder sbReturn = new StringBuilder();
                boolean first = true;
                for (String s : l) {
                    if (!first) {
                        sbReturn.append(",");
                    }
                    if (s instanceof String) {
                        sbReturn.append(s);
                    } else if (s instanceof Map) {
                        try {
                            Map map = (Map)((Object)s);
                            if (!map.isEmpty()) {
                                StringBuilder sb = new StringBuilder("{");
                                for (Object keyO : map.keySet()) {
                                    if (sb.length() > 1) {
                                        sb.append(",");
                                    }
                                    String key = (String)keyO;
                                    sb.append("\"").append(key).append("\": ");
                                    Object valueO = map.get(keyO);
                                    if (valueO instanceof Boolean || valueO instanceof Short || valueO instanceof Integer || valueO instanceof Long || valueO instanceof Double || valueO instanceof Float) {
                                        sb.append(valueO);
                                        continue;
                                    }
                                    sb.append("\"").append(valueO).append("\"");
                                }
                                sb.append("}");
                                sbReturn.append(sb.toString());
                            }
                        }
                        catch (Throwable t) {
                            sbReturn.append(s.toString());
                        }
                    } else {
                        sbReturn.append(s.toString());
                    }
                    first = false;
                }
                lReturn.add(sbReturn.toString());
            }
            catch (Exception e) {
                exceptionNodeSet = e;
            }
        }
        if (lReturn.isEmpty()) {
            JsonNode obj = engine.getJsonNodeMatchPattern(elementJson, pattern);
            String risultato = null;
            if (obj != null) {
                if (obj instanceof TextNode) {
                    TextNode text = (TextNode)obj;
                    risultato = text.asText();
                } else {
                    risultato = obj.toString();
                }
            }
            if (risultato != null && risultato.startsWith("[") && risultato.endsWith("]")) {
                risultato = risultato.substring(1, risultato.length() - 1);
            }
            if (risultato != null && !"".equals(risultato)) {
                lReturn.add(risultato);
            }
            if (exceptionNodeSet != null) {
                log.debug("Non sono stati trovati risultati tramite l'invocazione del metodo getStringMatchPattern(" + pattern + ") invocato in seguito all'errore dell'invocazione getJsonNodeMatchPattern(" + pattern + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
            }
        }
        return lReturn;
    }
}

