/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.core.jackson.mixin.MediaTypeMixin;
import io.swagger.v3.core.jackson.mixin.SchemaMixin;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.json.AbstractUtils;
import org.slf4j.Logger;

public class JSONUtils
extends AbstractUtils {
    private static JSONUtils jsonUtils = null;
    private static JSONUtils jsonUtilsPretty = null;
    private static Semaphore semaphore = new Semaphore("JSONUtils");
    private static ObjectMapper internalMapper;
    private static ObjectWriter writer;
    private static ObjectWriter writerPrettyPrint;

    private static synchronized void init(boolean prettyPrint) {
        if (prettyPrint) {
            if (jsonUtilsPretty == null) {
                jsonUtilsPretty = new JSONUtils(true);
            }
        } else if (jsonUtils == null) {
            jsonUtils = new JSONUtils(false);
        }
    }

    public static JSONUtils getInstance() {
        return JSONUtils.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONUtils getInstance(boolean prettyPrint) {
        if (prettyPrint) {
            if (jsonUtilsPretty != null) return jsonUtilsPretty;
            Class<JSONUtils> clazz = JSONUtils.class;
            synchronized (JSONUtils.class) {
                JSONUtils.init(true);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return jsonUtilsPretty;
            }
        }
        if (jsonUtils != null) return jsonUtils;
        Class<JSONUtils> clazz = JSONUtils.class;
        synchronized (JSONUtils.class) {
            JSONUtils.init(false);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return jsonUtils;
        }
    }

    private static synchronized void initSyncMapper() {
        if (internalMapper == null) {
            internalMapper = new ObjectMapper();
            internalMapper.setTimeZone(TimeZone.getDefault());
            internalMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            internalMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            internalMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            internalMapper.addMixIn(Schema.class, SchemaMixin.class);
            internalMapper.addMixIn(MediaType.class, MediaTypeMixin.class);
        }
    }

    private static void initMapper() {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("initMapper");
        try {
            if (internalMapper == null) {
                JSONUtils.initSyncMapper();
            }
        }
        finally {
            semaphore.release(lock, "initMapper");
        }
    }

    public static void setMapperTimeZone(TimeZone timeZone) {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("setMapperTimeZone");
        try {
            internalMapper.setTimeZone(timeZone);
        }
        finally {
            semaphore.release(lock, "setMapperTimeZone");
        }
    }

    public static void registerJodaModule() {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("registerJodaModule");
        try {
            internalMapper.registerModule((Module)new JodaModule());
        }
        finally {
            semaphore.release(lock, "registerJodaModule");
        }
    }

    public static void registerJavaTimeModule() {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        SemaphoreLock lock = semaphore.acquireThrowRuntime("registerJavaTimeModule");
        try {
            internalMapper.registerModule((Module)new JavaTimeModule());
        }
        finally {
            semaphore.release(lock, "registerJavaTimeModule");
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        return internalMapper;
    }

    private static synchronized void initWriter() {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        if (writer == null) {
            writer = internalMapper.writer();
        }
    }

    public static ObjectWriter getObjectWriter() {
        if (writer == null) {
            JSONUtils.initWriter();
        }
        return writer;
    }

    private static synchronized void initWriterPrettyPrint() {
        if (internalMapper == null) {
            JSONUtils.initMapper();
        }
        if (writerPrettyPrint == null) {
            writerPrettyPrint = internalMapper.writer().withDefaultPrettyPrinter();
        }
    }

    public static ObjectWriter getObjectWriterPrettyPrint() {
        if (writerPrettyPrint == null) {
            JSONUtils.initWriterPrettyPrint();
        }
        return writerPrettyPrint;
    }

    private JSONUtils(boolean prettyPrint) {
        super(prettyPrint);
    }

    @Override
    protected void _initMapper() {
        JSONUtils.initMapper();
    }

    @Override
    protected void _initWriter(boolean prettyPrint) {
        if (prettyPrint) {
            JSONUtils.initWriterPrettyPrint();
        } else {
            JSONUtils.initWriter();
        }
    }

    @Override
    protected ObjectMapper _getObjectMapper() {
        return JSONUtils.getObjectMapper();
    }

    @Override
    protected ObjectWriter _getObjectWriter(boolean prettyPrint) {
        if (prettyPrint) {
            return JSONUtils.getObjectWriterPrettyPrint();
        }
        return JSONUtils.getObjectWriter();
    }

    public boolean isJson(byte[] jsonBytes) {
        return this.isValid(jsonBytes);
    }

    public boolean isJson(String jsonString) {
        return this.isValid(jsonString);
    }

    public static boolean containsEmptySchema(String json) {
        String pattern = "(?m)\"schema\"\\s*:\\s*\\{\\s*\\}";
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(json);
            return matcher.find();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String resolveEmptySchema(String json) {
        return json.replaceAll("(?m)\"schema\"\\s*:\\s*\\{\\s*\\}", "\"schema\": {\n  \"type\": \"string\"\n}");
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, String raw) {
        return this.convertToMap(log, source, raw, null);
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, String raw, List<String> claimsToConvert) {
        if (this.isJson(raw)) {
            return super.convertToMapEngine(log, source, raw, claimsToConvert);
        }
        return new HashMap<String, Serializable>();
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, byte[] raw) {
        return this.convertToMap(log, source, raw, null);
    }

    public Map<String, Serializable> convertToMap(Logger log, String source, byte[] raw, List<String> claimsToConvert) {
        if (this.isJson(raw)) {
            return super.convertToMapEngine(log, source, raw, claimsToConvert);
        }
        return new HashMap<String, Serializable>();
    }
}

