/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.jmx.RisorseJMXException;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class GestoreRisorseJMX {
    private MBeanServer mbeanServer;
    private Object mbeanServerConnection;
    protected Logger log;
    private boolean logActive;
    private static final String MBEAN_SERVER_CONNECTION = "javax.management.MBeanServerConnection";
    private List<ObjectName> jmxNames;

    protected void logInfo(String msg) {
        if (this.log != null && this.logActive) {
            this.log.info(msg);
        }
    }

    protected void logDebug(String msg, Throwable e) {
        if (this.log != null && this.logActive) {
            this.log.debug(msg, e);
        }
    }

    protected void logError(String msg, Throwable e) {
        if (this.log != null && this.logActive) {
            this.log.error(msg, e);
        }
    }

    public boolean isLogActive() {
        return this.logActive;
    }

    public void setLogActive(boolean logActive) {
        this.logActive = logActive;
    }

    public GestoreRisorseJMX() throws RisorseJMXException {
        this(null, null, null);
    }

    public GestoreRisorseJMX(Logger logger) throws RisorseJMXException {
        this(null, null, logger);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, null, null);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext, Logger logger) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, logger, null);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, null, null, null, null, null, logger, loggerConsole);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, null, null);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password, Logger logger) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, logger, null);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, logger, loggerConsole);
    }

    private GestoreRisorseJMX(String modalita1JndiNameMBeanServer, Properties modalita1JndiContext, String modalita2TipoApplicationServer, String modalita2Factory, String modalita2ServerUrl, String modalita2Username, String modalita2Password, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        block18: {
            this.mbeanServer = null;
            this.mbeanServerConnection = null;
            this.log = null;
            this.logActive = true;
            this.jmxNames = new ArrayList<ObjectName>();
            this.log = logger == null ? LoggerWrapperFactory.getLogger(GestoreRisorseJMX.class) : logger;
            if (loggerConsole == null) {
                loggerConsole = LoggerWrapperFactory.getLogger("govway.startup");
            }
            try {
                if (modalita1JndiNameMBeanServer != null) {
                    GestoreJNDI jndi = new GestoreJNDI(modalita1JndiContext);
                    this.mbeanServer = (MBeanServer)jndi.lookup(modalita1JndiNameMBeanServer);
                    if (this.mbeanServer == null) {
                        throw new RisorseJMXException("MBeanServer [" + modalita1JndiNameMBeanServer + "] non trovato");
                    }
                    String msg = "Attivata gestione jmx attraverso MBeanServer [" + modalita1JndiNameMBeanServer + "]: " + this.mbeanServer.toString();
                    if (logger == null) {
                        loggerConsole.info(msg);
                    }
                    this.logInfo(msg);
                    break block18;
                }
                if (modalita2TipoApplicationServer != null && !"".equals(modalita2TipoApplicationServer)) {
                    if (modalita2Factory == null || "".equals(modalita2Factory)) {
                        throw new RisorseJMXException("Parametro 'factory' non fornito");
                    }
                    if (modalita2ServerUrl == null || "".equals(modalita2ServerUrl)) {
                        throw new RisorseJMXException("Parametro 'serverUrl' non fornito");
                    }
                    if (modalita2TipoApplicationServer.equals("jboss7") || modalita2TipoApplicationServer != null && modalita2TipoApplicationServer.startsWith("wildfly") || modalita2TipoApplicationServer.startsWith("tomcat")) {
                        Class<?> jmxServiceURLClass = Class.forName("javax.management.remote.JMXServiceURL");
                        Constructor<?> constructorJmxServiceURLClass = jmxServiceURLClass.getConstructor(String.class);
                        Object serviceURL = constructorJmxServiceURLClass.newInstance(modalita2ServerUrl);
                        HashMap<String, String[]> env = null;
                        if (modalita2Username != null && modalita2Password != null) {
                            String[] creds = new String[]{modalita2Username, modalita2Password};
                            env = new HashMap<String, String[]>();
                            env.put("jmx.remote.credentials", creds);
                        }
                        Class<?> jmxConnectorFactoryClass = Class.forName("javax.management.remote.JMXConnectorFactory");
                        Method connect = jmxConnectorFactoryClass.getMethod("connect", jmxServiceURLClass, Map.class);
                        Object jmxConnector = connect.invoke(null, serviceURL, env);
                        Class<?> jmxConnectorClass = Class.forName("javax.management.remote.JMXConnector");
                        Method getMBeanServerConnection = jmxConnectorClass.getMethod("getMBeanServerConnection", new Class[0]);
                        this.mbeanServerConnection = getMBeanServerConnection.invoke(jmxConnector, new Object[0]);
                    } else {
                        Properties properties = new Properties();
                        properties.put("java.naming.factory.initial", modalita2Factory);
                        properties.put("java.naming.provider.url", modalita2ServerUrl);
                        GestoreJNDI jndi = new GestoreJNDI(properties);
                        this.mbeanServerConnection = jndi.lookup("jmx/invoker/RMIAdaptor");
                        if (modalita2Username != null && modalita2Password != null) {
                            Class<?> simplePrincipalClass = Class.forName("org.jboss.security.SimplePrincipal");
                            Constructor<?> constructorPrincipalClass = simplePrincipalClass.getConstructor(String.class);
                            Object simplePrincipal = constructorPrincipalClass.newInstance(modalita2Username);
                            Class<?> securityAssociationClass = Class.forName("org.jboss.security.SecurityAssociation");
                            Method setPrincipal = securityAssociationClass.getMethod("setPrincipal", simplePrincipalClass);
                            setPrincipal.invoke(null, simplePrincipal);
                            Method setCredential = securityAssociationClass.getMethod("setCredential", String.class);
                            setCredential.invoke(null, modalita2Password);
                        }
                    }
                    break block18;
                }
                ArrayList<MBeanServer> lServer = MBeanServerFactory.findMBeanServer(null);
                if (lServer == null) {
                    throw new RisorseJMXException("Lista di MBean Server di default non trovata (MBeanServerFactory.findMBeanServer)");
                }
                if (lServer.isEmpty()) {
                    throw new RisorseJMXException("Lista di MBean Server di default vuota");
                }
                Iterator<MBeanServer> it = lServer.iterator();
                if (it.hasNext()) {
                    this.mbeanServer = it.next();
                    if (this.mbeanServer == null) {
                        throw new RisorseJMXException("MBeanServer di default non trovato");
                    }
                    String msg = "Attivata gestione jmx attraverso MBeanServer: " + this.mbeanServer.toString();
                    if (logger == null) {
                        loggerConsole.info(msg);
                    }
                    this.logInfo(msg);
                    break block18;
                }
                throw new RisorseJMXException("Lista di MBean Server di default vuota ?");
            }
            catch (Exception e) {
                this.logError("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage(), e);
                throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage(), e);
            }
        }
    }

    public void registerMBean(Class<?> c, String nome) throws RisorseJMXException {
        this.registerMBean(c, "org.openspcoop2.pdd", "type", nome, true);
    }

    public void registerMBean(Class<?> c, String dominio, String type, String nome) throws RisorseJMXException {
        this.registerMBean(c, dominio, type, nome, true);
    }

    public void registerMBean(Class<?> c, String dominio, String type, String nome, boolean throwExceptionAlreadyExists) throws RisorseJMXException {
        try {
            ObjectName jmxName = new ObjectName(dominio, type, nome);
            if (this.mbeanServer == null) {
                throw new RisorseJMXException("Operazione di registrazione permessa solo se il gestore viene inizializzato con il costruttore di default o indicando l'MBeanServer");
            }
            this.mbeanServer.registerMBean(ClassLoaderUtilities.newInstance(c), jmxName);
            this.jmxNames.add(jmxName);
        }
        catch (Exception e) {
            if (e instanceof InstanceAlreadyExistsException && !throwExceptionAlreadyExists) {
                this.logDebug("Risorsa JMX [" + nome + "] gi\u00e0 esistente: " + e.getMessage(), e);
            }
            this.logError("Riscontrato errore durante l'inizializzazione della risorsa JMX [" + nome + "]: " + e.getMessage(), e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX [" + nome + "]: " + e.getMessage(), e);
        }
    }

    public void unregisterMBeans() {
        for (int i = 0; i < this.jmxNames.size(); ++i) {
            ObjectName jmxName = this.jmxNames.get(i);
            try {
                if (this.mbeanServer == null) {
                    throw new RisorseJMXException("Operazione di cancellazione permessa solo se il gestore viene inizializzato con il costruttore di default o indicando l'MBeanServer");
                }
                this.mbeanServer.unregisterMBean(jmxName);
                this.logInfo("Unbound della risorsa JMX [" + jmxName.toString() + "]");
                continue;
            }
            catch (Exception e) {
                this.logError("Riscontrato errore durante l'unbound della risorsa JMX [" + jmxName.toString() + "]: " + e.getMessage(), e);
            }
        }
    }

    public Object getAttribute(String nomeRisorsa, String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("org.openspcoop2.pdd", "type", nomeRisorsa, nomeAttributo);
    }

    public Object getAttribute(String dominio, String tipo, String nomeRisorsa, String nomeAttributo) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName(dominio, tipo, nomeRisorsa);
            if (this.mbeanServerConnection != null) {
                Class<?> c = Class.forName(MBEAN_SERVER_CONNECTION);
                Method m = c.getMethod("getAttribute", ObjectName.class, String.class);
                return m.invoke(this.mbeanServerConnection, name, nomeAttributo);
            }
            return this.mbeanServer.getAttribute(name, nomeAttributo);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura dell'attributo [" + nomeAttributo + "] nella risorsa [" + nomeRisorsa + "]: " + e.getMessage();
            this.logError(msg, e);
            throw new RisorseJMXException(msg, e);
        }
    }

    public void setAttribute(String nomeRisorsa, String nomeAttributo, Object value) throws RisorseJMXException {
        this.setAttribute("org.openspcoop2.pdd", "type", nomeRisorsa, nomeAttributo, value);
    }

    public void setAttribute(String dominio, String tipo, String nomeRisorsa, String nomeAttributo, Object value) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName(dominio, tipo, nomeRisorsa);
            Attribute attribute = new Attribute(nomeAttributo, value);
            if (this.mbeanServerConnection != null) {
                Class<?> c = Class.forName(MBEAN_SERVER_CONNECTION);
                Method m = c.getMethod("setAttribute", ObjectName.class, Attribute.class);
                m.invoke(this.mbeanServerConnection, name, nomeAttributo);
            } else {
                this.mbeanServer.setAttribute(name, attribute);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'aggiornamento dell'attributo [" + nomeAttributo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage();
            this.logError(msg, e);
            throw new RisorseJMXException(msg, e);
        }
    }

    public Object invoke(String nomeRisorsa, String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("org.openspcoop2.pdd", "type", nomeRisorsa, nomeMetodo, params, signature);
    }

    public Object invoke(String dominio, String tipo, String nomeRisorsa, String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName(dominio, tipo, nomeRisorsa);
            if (this.mbeanServerConnection != null) {
                Class<?> c = Class.forName(MBEAN_SERVER_CONNECTION);
                Method m = c.getMethod("invoke", ObjectName.class, String.class, Object[].class, String[].class);
                return m.invoke(this.mbeanServerConnection, name, nomeMetodo, params, signature);
            }
            return this.mbeanServer.invoke(name, nomeMetodo, params, signature);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'invocazione del metodo [" + nomeMetodo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage();
            this.logError(msg, e);
            throw new RisorseJMXException(msg, e);
        }
    }
}

