/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.BinaryStreamNotSupportedException;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;

public abstract class AbstractJDBCAdapter
implements IJDBCAdapter {
    private TipiDatabase tipoDatabase;

    public AbstractJDBCAdapter(TipiDatabase tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws UtilsException, SQLException {
        return rs.getBytes(index);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        return rs.getBytes(rsName);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, byte[] data) throws UtilsException, SQLException {
        s.setBytes(index, data);
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, int index) throws UtilsException, SQLException {
        return rs.getBinaryStream(index);
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, String rsName) throws UtilsException, SQLException {
        return rs.getBinaryStream(rsName);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, InputStream is, int length) throws UtilsException, SQLException {
        s.setBinaryStream(index, is, length);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, InputStream is, boolean bufferingIfNotEnabled) throws UtilsException, SQLException, BinaryStreamNotSupportedException {
        try {
            s.setBinaryStream(index, is);
        }
        catch (Throwable e) {
            if (bufferingIfNotEnabled) {
                this.setBinaryData(s, index, Utilities.getAsByteArray(is));
            }
            throw new BinaryStreamNotSupportedException("SetBinaryStream non supportata dal tipo di database utilizzato (" + this.tipoDatabase.toString() + ") (Verifica di utilizzare un driver JDBC 4.x o superiore): " + e.getMessage(), e);
        }
    }
}

