/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxrs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jakarta.rs.xml.JacksonXMLProvider;
import java.util.TimeZone;

public class JacksonXmlProviderCustomized
extends JacksonXMLProvider {
    private static boolean failOnMissingExternalTypeIdProperty = false;

    public static boolean isFailOnMissingExternalTypeIdProperty() {
        return failOnMissingExternalTypeIdProperty;
    }

    public static void setFailOnMissingExternalTypeIdProperty(boolean failOnMissingExternalTypeIdProperty) {
        JacksonXmlProviderCustomized.failOnMissingExternalTypeIdProperty = failOnMissingExternalTypeIdProperty;
    }

    public static XmlMapper getObjectMapper(boolean prettyPrint, TimeZone timeZone) {
        XmlMapper mapper = new XmlMapper();
        mapper.setTimeZone(timeZone);
        mapper.registerModule((Module)new JodaModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        if (prettyPrint) {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, failOnMissingExternalTypeIdProperty);
        return mapper;
    }

    public JacksonXmlProviderCustomized() {
        super(JacksonXmlProviderCustomized.getObjectMapper(false, TimeZone.getDefault()));
    }

    public JacksonXmlProviderCustomized(boolean prettyPrint) {
        super(JacksonXmlProviderCustomized.getObjectMapper(prettyPrint, TimeZone.getDefault()));
    }

    public JacksonXmlProviderCustomized(String timeZoneId) {
        super(JacksonXmlProviderCustomized.getObjectMapper(false, TimeZone.getTimeZone(timeZoneId)));
    }

    public JacksonXmlProviderCustomized(String timeZoneId, boolean prettyPrint) {
        super(JacksonXmlProviderCustomized.getObjectMapper(prettyPrint, TimeZone.getTimeZone(timeZoneId)));
    }
}

