/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.slf4j.Logger;

public class PipedBytesStream
extends IPipedUnblockedStream {
    private static final int MAX_QUEUE = 2;
    private static final String NO_BYTES_AVAILABLE_READ = "Timeout, no bytes available for read: ";
    private static final String STREAM_ALREADY_CLOSED = "Stream already closed";
    protected Logger log = null;
    private long sizeBuffer;
    private int timeoutMs;
    private final Semaphore lockPIPE = new Semaphore("PipedBytesStream");
    private byte[] bytesReading = null;
    private int indexNextByteReceivedForWrite = 0;
    private List<byte[]> chunkList = new ArrayList<byte[]>();
    private byte[] bytesReceived = null;
    private int indexNextByteReceivedForRead = -1;
    private boolean stop = false;
    private boolean useThreadSleep = false;
    private static final int ITERAZIONI_WAIT = 128;
    private CompletableFuture<Boolean> asyncReadTask = null;
    private CompletableFuture<Boolean> asyncWriteTask = null;
    private String source = null;

    @Override
    public void init(Logger log, long sizeBuffer, int timeoutMs, String source) {
        this.log = log;
        if (sizeBuffer <= 0L) {
            sizeBuffer = 65536L;
        }
        this.sizeBuffer = sizeBuffer / 2L;
        this.timeoutMs = timeoutMs;
        this.source = source;
        this.initReadingBuffer();
    }

    @Override
    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    private void initReadingBuffer() {
        this.bytesReading = new byte[(int)this.sizeBuffer];
        this.indexNextByteReceivedForWrite = 0;
    }

    public String getPrefixSource() {
        return this.source != null ? "[" + this.source + "] " : "";
    }

    private boolean readBytesPending() {
        return this.indexNextByteReceivedForWrite > 0 || !this.chunkList.isEmpty();
    }

    private void readWaitBytes() throws IOException {
        block12: {
            try {
                if (this.useThreadSleep) {
                    int i;
                    for (i = 0; !this.stop && !this.readBytesPending() && i < 128; i += i) {
                        Utilities.sleep(i + 1);
                    }
                    if (i >= 128) {
                        throw new IOException(this.getPrefixSource() + "Timeout, no bytes available for read");
                    }
                    break block12;
                }
                boolean wait = false;
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("readWaitBytes");
                try {
                    if (!this.stop && !this.readBytesPending()) {
                        this.asyncReadTask = new CompletableFuture();
                        wait = true;
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "readWaitBytes");
                }
                if (wait) {
                    this.asyncReadGet();
                }
            }
            catch (IOException io) {
                throw io;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException(t.getMessage(), t);
            }
        }
    }

    private void asyncReadGet() throws IOException {
        try {
            if (this.timeoutMs > 0) {
                this.asyncReadTask.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            } else {
                this.asyncReadTask.get();
            }
        }
        catch (InterruptedException timeout) {
            Thread.currentThread().interrupt();
            throw new IOException(this.getPrefixSource() + NO_BYTES_AVAILABLE_READ + timeout.getMessage(), timeout);
        }
        catch (Exception timeout) {
            throw new IOException(this.getPrefixSource() + NO_BYTES_AVAILABLE_READ + timeout.getMessage(), timeout);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            if (this.bytesReceived == null) {
                if (this.stop) {
                    if (!this.readBytesPending()) {
                        if (this.asyncWriteTask != null) {
                            this.asyncWriteTask.complete(true);
                        }
                        return -1;
                    }
                } else if (!this.readBytesPending()) {
                    this.readWaitBytes();
                    if (!this.readBytesPending()) {
                        if (this.asyncWriteTask != null) {
                            this.asyncWriteTask.complete(true);
                        }
                        return -1;
                    }
                }
            }
            if (this.bytesReceived == null && this.stop && !this.readBytesPending()) {
                if (this.asyncWriteTask != null) {
                    this.asyncWriteTask.complete(true);
                }
                return -1;
            }
            if (this.bytesReceived == null) {
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("read");
                try {
                    if (!this.chunkList.isEmpty()) {
                        this.bytesReceived = this.chunkList.remove(0);
                    } else if (this.indexNextByteReceivedForWrite > 0) {
                        this.bytesReceived = new byte[this.indexNextByteReceivedForWrite];
                        System.arraycopy(this.bytesReading, 0, this.bytesReceived, 0, this.indexNextByteReceivedForWrite);
                        this.indexNextByteReceivedForWrite = 0;
                    }
                    this.indexNextByteReceivedForRead = 0;
                    if (this.asyncWriteTask != null) {
                        this.asyncWriteTask.complete(true);
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "read");
                }
            }
            if (this.bytesReceived == null) {
                return -1;
            }
            int bytesAvailableForRead = this.bytesReceived.length - this.indexNextByteReceivedForRead;
            if (bytesAvailableForRead == len) {
                System.arraycopy(this.bytesReceived, this.indexNextByteReceivedForRead, b, off, bytesAvailableForRead);
                this.bytesReceived = null;
                this.indexNextByteReceivedForRead = -1;
                return len;
            }
            if (bytesAvailableForRead > len) {
                System.arraycopy(this.bytesReceived, this.indexNextByteReceivedForRead, b, off, len);
                this.indexNextByteReceivedForRead += len;
                return len;
            }
            System.arraycopy(this.bytesReceived, this.indexNextByteReceivedForRead, b, off, bytesAvailableForRead);
            this.bytesReceived = null;
            this.indexNextByteReceivedForRead = -1;
            return bytesAvailableForRead;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b);
        if (len == 1) {
            return b[0] & 0xFF;
        }
        if (len == -1) {
            return -1;
        }
        throw new IOException("Cannot read single byte");
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.stop) {
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("close");
                try {
                    if (this.indexNextByteReceivedForWrite > 0) {
                        byte[] lastChunk = new byte[this.indexNextByteReceivedForWrite];
                        System.arraycopy(this.bytesReading, 0, lastChunk, 0, this.indexNextByteReceivedForWrite);
                        this.chunkList.add(lastChunk);
                        this.indexNextByteReceivedForWrite = 0;
                    }
                    this.bytesReading = null;
                    this.stop = true;
                }
                finally {
                    this.lockPIPE.release(lock, "close");
                }
            }
            if (this.asyncWriteTask != null) {
                this.asyncWriteTask.complete(true);
            }
            if (this.asyncReadTask != null) {
                this.asyncReadTask.complete(true);
            }
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    private void writeWaitEmptyBuffer() throws IOException {
        block13: {
            try {
                if (this.useThreadSleep) {
                    if (this.readBytesPending() && this.chunkList.size() >= 2) {
                        int i;
                        for (i = 0; !this.stop && i < 128; i += i) {
                            Utilities.sleep(i + 1);
                        }
                        if (i >= 128) {
                            throw new IOException(this.getPrefixSource() + "Timeout, no buffer available for write");
                        }
                    }
                    break block13;
                }
                boolean wait = false;
                SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("writeWaitEmptyBuffer");
                try {
                    if (this.readBytesPending() && this.chunkList.size() >= 2 && !this.stop) {
                        this.asyncWriteTask = new CompletableFuture();
                        wait = true;
                    }
                }
                finally {
                    this.lockPIPE.release(lock, "writeWaitEmptyBuffer");
                }
                if (wait) {
                    this.asyncWriteGet();
                }
            }
            catch (IOException io) {
                throw io;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException(t.getMessage(), t);
            }
        }
    }

    private void asyncWriteGet() throws IOException {
        try {
            if (this.timeoutMs > 0) {
                this.asyncWriteTask.get(this.timeoutMs, TimeUnit.MILLISECONDS);
            } else {
                this.asyncWriteTask.get();
            }
        }
        catch (InterruptedException timeout) {
            Thread.currentThread().interrupt();
            throw new IOException(this.getPrefixSource() + NO_BYTES_AVAILABLE_READ + timeout.getMessage(), timeout);
        }
        catch (Exception timeout) {
            throw new IOException(this.getPrefixSource() + NO_BYTES_AVAILABLE_READ + timeout.getMessage(), timeout);
        }
    }

    @Override
    public void write(byte b) throws IOException {
        try {
            if (this.bytesReading == null) {
                throw new IOException(this.getPrefixSource() + STREAM_ALREADY_CLOSED);
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b)");
            try {
                this.bytesReading[this.indexNextByteReceivedForWrite++] = b;
                if (this.indexNextByteReceivedForWrite == this.bytesReading.length) {
                    this.chunkList.add(this.bytesReading);
                    this.initReadingBuffer();
                }
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b)");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        try {
            if (this.bytesReading == null) {
                throw new IOException(this.getPrefixSource() + STREAM_ALREADY_CLOSED);
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b[])");
            try {
                int offset = 0;
                int bytesNum = b.length;
                while (bytesNum > 0) {
                    int freeSpace = this.bytesReading.length - this.indexNextByteReceivedForWrite;
                    int chunkLen = bytesNum <= freeSpace ? bytesNum : freeSpace;
                    System.arraycopy(b, offset, this.bytesReading, this.indexNextByteReceivedForWrite, chunkLen);
                    this.indexNextByteReceivedForWrite += chunkLen;
                    if (this.indexNextByteReceivedForWrite == this.bytesReading.length) {
                        this.chunkList.add(this.bytesReading);
                        this.initReadingBuffer();
                    }
                    bytesNum -= chunkLen;
                    offset += chunkLen;
                }
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b[])");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (this.bytesReading == null) {
                throw new IOException(this.getPrefixSource() + STREAM_ALREADY_CLOSED);
            }
            this.writeWaitEmptyBuffer();
            SemaphoreLock lock = this.lockPIPE.acquireThrowRuntime("write(b[],off,len)");
            try {
                int offset = off;
                int bytesNum = len;
                while (bytesNum > 0) {
                    int freeSpace = this.bytesReading.length - this.indexNextByteReceivedForWrite;
                    int chunkLen = bytesNum <= freeSpace ? bytesNum : freeSpace;
                    System.arraycopy(b, offset, this.bytesReading, this.indexNextByteReceivedForWrite, chunkLen);
                    this.indexNextByteReceivedForWrite += chunkLen;
                    if (this.indexNextByteReceivedForWrite == this.bytesReading.length) {
                        this.chunkList.add(this.bytesReading);
                        this.initReadingBuffer();
                    }
                    bytesNum -= chunkLen;
                    offset += chunkLen;
                }
                if (this.asyncReadTask != null) {
                    this.asyncReadTask.complete(true);
                }
            }
            finally {
                this.lockPIPE.release(lock, "write(b[],off,len)");
            }
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
    }
}

