/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Entry;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class ZipUtilities {
    public static byte[] zip(byte[] content, String name) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(bout);
            ByteArrayInputStream bin = new ByteArrayInputStream(content);
            ZipEntry zipEntry = new ZipEntry(name);
            zipOut.putNextEntry(zipEntry);
            zipOut.write(content);
            zipOut.flush();
            zipOut.close();
            bin.close();
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la scrittura dello zip: " + e.getMessage(), e);
        }
    }

    public static byte[] zip(List<Entry> entries) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(bout);
            for (Entry entry : entries) {
                String name = entry.getName();
                ZipEntry zipEntry = new ZipEntry(name);
                zipOut.putNextEntry(zipEntry);
                zipOut.write(entry.getContent());
            }
            zipOut.flush();
            zipOut.close();
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la scrittura dello zip: " + e.getMessage(), e);
        }
    }

    public static byte[] unzip(byte[] zipContent) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ByteArrayInputStream bin = new ByteArrayInputStream(zipContent);
            ZipInputStream zis = new ZipInputStream(bin);
            int count = 0;
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                int len;
                if (++count > 1) {
                    throw new UtilsException("Errore, il metodo supporta solamente archivi zip contenente un file");
                }
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > 0) {
                    bout.write(buffer, 0, len);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            bout.flush();
            bout.close();
            bin.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la lettura dello zip: " + e.getMessage(), e);
        }
    }

    public static List<Entry> read(byte[] zipContent) throws UtilsException {
        try {
            ZipEntry entry;
            ArrayList<Entry> list = new ArrayList<Entry>();
            ByteArrayInputStream in = new ByteArrayInputStream(zipContent);
            ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                String name = entry.getName();
                if (name != null && !name.endsWith("/") && !name.endsWith("\\")) {
                    int direct;
                    Entry zentry = new Entry();
                    zentry.setName(name);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] contents = new byte[4096];
                    while ((direct = zipIn.read(contents, 0, contents.length)) >= 0) {
                        bout.write(contents, 0, direct);
                    }
                    bout.flush();
                    bout.close();
                    zentry.setContent(bout.toByteArray());
                    list.add(zentry);
                }
                zipIn.closeEntry();
            }
            zipIn.close();
            in.close();
            return list;
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la lettura dello zip: " + e.getMessage(), e);
        }
    }

    public static String getRootDir(String entry) throws UtilsException {
        try {
            String rootDir = null;
            String dir = entry;
            int indexOf = dir.indexOf(File.separatorChar);
            if (indexOf <= 0) {
                throw new UtilsException("Errore durante l'identificazione della directory radice presente all'interno dello zip (" + indexOf + ")");
            }
            if ((dir = dir.substring(0, indexOf)) == null || "".equals(dir)) {
                throw new UtilsException("Errore durante l'identificazione della directory radice presente all'interno dello zip (" + dir + ")");
            }
            rootDir = dir + File.separatorChar;
            return rootDir;
        }
        catch (UtilsException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante l'identificazione della directory radice presente all'interno dello zip: " + e.getMessage(), e);
        }
    }

    public static String getBaseName(String file) throws UtilsException {
        try {
            return new File(file).getName();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante l'identificazione del base name per il file [" + file + "]: " + e.getMessage(), e);
        }
    }

    public static String operativeSystemConversion(String entryName) {
        char separatorCharWindows = '\\';
        char separatorCharLinux = '/';
        boolean isWindows = File.separatorChar == separatorCharWindows;
        StringBuilder fixed = new StringBuilder(entryName);
        for (int i = 0; i < fixed.length(); ++i) {
            if (isWindows) {
                if (fixed.charAt(i) != separatorCharLinux) continue;
                fixed.setCharAt(i, File.separatorChar);
                continue;
            }
            if (fixed.charAt(i) != separatorCharWindows) continue;
            fixed.setCharAt(i, File.separatorChar);
        }
        return fixed.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(String zipFile, String dest) throws UtilsException {
        try {
            File destFile = new File(dest);
            if (!destFile.exists()) {
                if (!destFile.mkdir()) {
                    throw new Exception("Destinazione [" + dest + "] non esistente e creazione non riuscita");
                }
            } else {
                if (!destFile.isDirectory()) {
                    throw new Exception("Destinazione [" + dest + "] non e' una directory");
                }
                if (!destFile.canWrite()) {
                    throw new Exception("Destinazione [" + dest + "] non accessibile in scrittura ");
                }
            }
            OutputStream out = null;
            InputStream iZip = null;
            ZipFile zf = null;
            try {
                zf = new ZipFile(zipFile);
                Enumeration<? extends ZipEntry> em = zf.entries();
                while (em.hasMoreElements()) {
                    int len;
                    ZipEntry ze = em.nextElement();
                    String targetfile = destFile.getAbsolutePath() + File.separatorChar + ze.getName();
                    FileSystemUtilities.mkdirParentDirectory(targetfile);
                    if (ze.getName() != null && (ze.getName().endsWith("/") || ze.getName().endsWith("\\"))) {
                        File fDir = new File(targetfile);
                        if (fDir.mkdir()) continue;
                        try {
                            throw new Exception("Creazione directory [" + fDir.getAbsolutePath() + "] per entry [" + ze.getName() + "] non riuscita");
                        }
                        catch (Throwable throwable) {
                            try {
                                if (zf != null) {
                                    zf.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    iZip = zf.getInputStream(ze);
                    out = new FileOutputStream(targetfile);
                    byte[] buf = new byte[1024];
                    while ((len = iZip.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    iZip.close();
                    iZip = null;
                    out.flush();
                    out.close();
                    out = null;
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (iZip != null) {
                        iZip.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (zf != null) {
                        zf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new UtilsException("Unzip non riuscito: " + e.getMessage(), e);
        }
    }

    public static Iterator<ZipEntry> entries(ZipFile zip, boolean ascOrder) {
        ArrayList<String> entryNames = new ArrayList<String>();
        HashMap<String, ZipEntry> map = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            String entryName = zipEntry.getName();
            entryNames.add(entryName);
            map.put(entryName, zipEntry);
        }
        if (ascOrder) {
            Collections.sort(entryNames);
        } else {
            Collections.sort(entryNames, Collections.reverseOrder());
        }
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        for (String entry : entryNames) {
            zipEntries.add((ZipEntry)map.remove(entry));
        }
        return zipEntries.iterator();
    }
}

