/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.openspcoop2.utils.UtilsException;

public class DeflateUtilities {
    private static final int BUFFER_SIZE = 1024;

    public static byte[] decode(String data) throws UtilsException {
        return DeflateUtilities.decode(data.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(byte[] data) throws UtilsException {
        OutputStream baos = null;
        try {
            Deflater d = new Deflater(9);
            d.setInput(data);
            d.finish();
            byte[] bytesCompressed = new byte[1024];
            int deflate = d.deflate(bytesCompressed);
            baos = new ByteArrayOutputStream();
            while (deflate > 0) {
                ((ByteArrayOutputStream)baos).write(bytesCompressed, 0, deflate);
                deflate = d.deflate(bytesCompressed);
            }
            byte[] byArray = ((ByteArrayOutputStream)baos).toByteArray();
            return byArray;
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                }
                catch (Exception exception) {}
                try {
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] encode(byte[] data) throws UtilsException {
        OutputStream baos = null;
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(data);
            byte[] result = new byte[1024];
            int inflate = inflater.inflate(result);
            baos = new ByteArrayOutputStream();
            while (inflate > 0) {
                ((ByteArrayOutputStream)baos).write(result, 0, inflate);
                inflate = inflater.inflate(result);
            }
            inflater.end();
            byte[] byArray = ((ByteArrayOutputStream)baos).toByteArray();
            return byArray;
        }
        catch (DataFormatException e) {
            throw new UtilsException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.flush();
                }
                catch (Exception exception) {}
                try {
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String encodeAsString(byte[] data) throws UtilsException {
        return new String(DeflateUtilities.encode(data));
    }
}

