/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.apache.serial;

import org.openspcoop2.utils.id.apache.serial.AlphanumericGenerator;
import org.openspcoop2.utils.id.apache.serial.MaxReachedException;

public class PrefixedAlphanumericGenerator
extends AlphanumericGenerator {
    private static final long serialVersionUID = 1L;
    private final String prefix;

    private static int _getSize(String prefix, int size) {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        return size - prefix.length();
    }

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap) {
        super(wrap, PrefixedAlphanumericGenerator._getSize(prefix, 15));
        if (15 <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap, int size) {
        super(wrap, PrefixedAlphanumericGenerator._getSize(prefix, size));
        if (size <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    private static String _getInitialValue(String prefix, String initialValue) {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        return initialValue.substring(prefix.length());
    }

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap, String initialValue) {
        super(wrap, PrefixedAlphanumericGenerator._getInitialValue(prefix, initialValue));
        if (initialValue.length() <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public long maxLength() {
        return super.maxLength() + (long)this.prefix.length();
    }

    @Override
    public long minLength() {
        return super.minLength() + (long)this.prefix.length();
    }

    @Override
    public int getSize() {
        return super.getSize() + this.prefix.length();
    }

    @Override
    public synchronized String nextStringIdentifier() throws MaxReachedException {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append(super.nextStringIdentifier());
        return sb.toString();
    }
}

