/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;
import org.openspcoop2.utils.id.AbstractUniversallyUniqueIdentifierGenerator;
import org.openspcoop2.utils.id.UniqueIdentifierException;

public class UniversallyUniqueIdentifierV1Generator
extends AbstractUniversallyUniqueIdentifierGenerator {
    private TimeBasedGenerator uuidv1 = Generators.timeBasedGenerator();

    @Override
    public void init(Object ... o) throws UniqueIdentifierException {
        if (o != null && o.length > 0 && o[0] != null) {
            EthernetAddress ethAddr = null;
            if (o[0] instanceof EthernetAddress) {
                ethAddr = (EthernetAddress)o[0];
            } else if (o[0] instanceof String) {
                String macAddress = (String)o[0];
                ethAddr = new EthernetAddress(macAddress);
            } else {
                throw new UniqueIdentifierException("Unknown mac address type (" + o[0].getClass().getName() + ")");
            }
            this.uuidv1 = Generators.timeBasedGenerator((EthernetAddress)ethAddr);
        } else {
            try {
                EthernetAddress ethAddrFounded = null;
                Enumeration<NetworkInterface> enumNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (enumNetworkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = enumNetworkInterfaces.nextElement();
                    if (networkInterface.getHardwareAddress() == null) continue;
                    EthernetAddress ethAddr = new EthernetAddress(networkInterface.getHardwareAddress());
                    if (ethAddrFounded != null) continue;
                    ethAddrFounded = ethAddr;
                }
                if (ethAddrFounded == null) {
                    throw new Exception("NetworkInterface with mac address not found");
                }
                this.uuidv1 = Generators.timeBasedGenerator(ethAddrFounded);
            }
            catch (Throwable e) {
                throw new UniqueIdentifierException("MacAddress identification failed: " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected UUID generateUUID() {
        return this.uuidv1.generate();
    }
}

