/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import java.util.UUID;
import org.openspcoop2.utils.id.IUniqueIdentifier;
import org.openspcoop2.utils.id.IUniqueIdentifierGenerator;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifier;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifierProducer;

public abstract class AbstractUniversallyUniqueIdentifierGenerator
implements IUniqueIdentifierGenerator {
    @Override
    public IUniqueIdentifier convertFromString(String value) throws UniqueIdentifierException {
        UniversallyUniqueIdentifier uuidOpenSPCoop = new UniversallyUniqueIdentifier();
        uuidOpenSPCoop.setUuid(UUID.fromString(value));
        return uuidOpenSPCoop;
    }

    @Override
    public void init(Object ... o) throws UniqueIdentifierException {
    }

    @Override
    public boolean isBufferSupperted() {
        return true;
    }

    @Override
    public final IUniqueIdentifier newID() throws UniqueIdentifierException {
        return this.newID(true);
    }

    @Override
    public final IUniqueIdentifier newID(boolean useBuffer) throws UniqueIdentifierException {
        UniversallyUniqueIdentifierProducer uuidProducer;
        UniversallyUniqueIdentifier uuidOpenSPCoop = null;
        UniversallyUniqueIdentifierProducer universallyUniqueIdentifierProducer = uuidProducer = useBuffer ? UniversallyUniqueIdentifierProducer.getInstance() : null;
        if (uuidProducer != null) {
            uuidOpenSPCoop = (UniversallyUniqueIdentifier)uuidProducer.newUniqueIdentifier();
        } else {
            uuidOpenSPCoop = new UniversallyUniqueIdentifier();
            uuidOpenSPCoop.setUuid(this.generateUUID());
        }
        return uuidOpenSPCoop;
    }

    protected abstract UUID generateUUID();
}

