/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.crypt.SpringType;
import org.slf4j.Logger;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public class SpringCrypt
implements ICrypt {
    private Logger log;
    private SpringType type;

    public SpringCrypt(SpringType type) {
        this.type = type;
        if (this.type == null) {
            this.type = SpringType.B_CRYPT;
        }
    }

    @Override
    public void init(Logger log, CryptConfig config) {
        this.log = log;
    }

    @Override
    public String crypt(String password) throws UtilsException {
        switch (this.type) {
            case B_CRYPT: {
                BCryptPasswordEncoder b = new BCryptPasswordEncoder();
                return b.encode((CharSequence)password);
            }
            case S_CRYPT: {
                SCryptPasswordEncoder s = SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8();
                return s.encode((CharSequence)password);
            }
        }
        throw new UtilsException("Unsupported type '" + String.valueOf((Object)this.type) + "'");
    }

    @Override
    public boolean check(String password, String pwcrypt) {
        try {
            switch (this.type) {
                case B_CRYPT: {
                    BCryptPasswordEncoder b = new BCryptPasswordEncoder();
                    return b.matches((CharSequence)password, pwcrypt);
                }
                case S_CRYPT: {
                    SCryptPasswordEncoder s = SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8();
                    return s.matches((CharSequence)password, pwcrypt);
                }
            }
            throw new UtilsException("Unsupported type '" + String.valueOf((Object)this.type) + "'");
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.error("Verifica password '" + pwcrypt + "' fallita: " + e.getMessage(), e);
            }
            return false;
        }
    }
}

