/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.CryptType;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.utils.resources.Charset;

public class CryptConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String CRYPT_SPECIAL_PATH_PLAIN = "PLAIN";
    protected static final String CRYPT_TYPE = "passwordEncrypt.type";
    protected static final String CRYPT_CUSTOM_TYPE = "passwordEncrypt.customType";
    private static final String CRYPT_CHARSET_NAME = "passwordEncrypt.charsetName";
    private static final String CRYPT_SALT_LENGTH = "passwordEncrypt.salt.length";
    private static final String CRYPT_SALT_SECURE_RANDOM = "passwordEncrypt.salt.secureRandom";
    private static final String CRYPT_SALT_SECURE_RANDOM_ALGORITHM = "passwordEncrypt.salt.secureRandomAlgorithm";
    private static final String CRYPT_DIGEST_ALGORITHM = "passwordEncrypt.digestAlgorithm";
    private static final String CRYPT_ITERATION = "passwordEncrypt.iteration";
    private static final String CRYPT_BASE64_ENCODING = "passwordEncrypt.base64Encoding";
    private static final String CRYPT_BACKWARD_COMPATIBILITY = "passwordEncrypt.backwardCompatibility";
    private CryptType cryptType;
    private String cryptCustomType;
    private String digestAlgorithm;
    private String charsetName;
    private Integer iteration;
    private Integer saltLength;
    private boolean useSecureRandom;
    private String algorithmSecureRandom;
    private boolean useBase64Encoding;
    private boolean backwardCompatibility;

    public CryptConfig() {
        this.cryptType = null;
        this.cryptCustomType = null;
        this.digestAlgorithm = null;
        this.charsetName = Charset.UTF_8.getValue();
        this.iteration = null;
        this.saltLength = null;
        this.useSecureRandom = true;
        this.algorithmSecureRandom = null;
        this.useBase64Encoding = true;
        this.backwardCompatibility = false;
    }

    public CryptConfig(String resource) throws UtilsException {
        this(resource, true);
    }

    public CryptConfig(String resource, boolean useDefaultIfNotFound) throws UtilsException {
        block13: {
            this.cryptType = null;
            this.cryptCustomType = null;
            this.digestAlgorithm = null;
            this.charsetName = Charset.UTF_8.getValue();
            this.iteration = null;
            this.saltLength = null;
            this.useSecureRandom = true;
            this.algorithmSecureRandom = null;
            this.useBase64Encoding = true;
            this.backwardCompatibility = false;
            if (CRYPT_SPECIAL_PATH_PLAIN.equals(resource)) {
                this.cryptType = CryptType.PLAIN;
                return;
            }
            InputStream is = null;
            try {
                File f = new File(resource);
                is = f.exists() ? new FileInputStream(f) : PasswordVerifier.class.getResourceAsStream(resource);
                if (is == null) {
                    is = PasswordVerifier.class.getResourceAsStream("/org/openspcoop2/utils/crypt/consolePassword.properties");
                }
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    this._init(p);
                    break block13;
                }
                throw new Exception("Resource [" + resource + "] not found");
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public CryptConfig(InputStream is) throws UtilsException {
        this.cryptType = null;
        this.cryptCustomType = null;
        this.digestAlgorithm = null;
        this.charsetName = Charset.UTF_8.getValue();
        this.iteration = null;
        this.saltLength = null;
        this.useSecureRandom = true;
        this.algorithmSecureRandom = null;
        this.useBase64Encoding = true;
        this.backwardCompatibility = false;
        try {
            Properties p = new Properties();
            p.load(is);
            this._init(p);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public CryptConfig(Properties p) throws UtilsException {
        this.cryptType = null;
        this.cryptCustomType = null;
        this.digestAlgorithm = null;
        this.charsetName = Charset.UTF_8.getValue();
        this.iteration = null;
        this.saltLength = null;
        this.useSecureRandom = true;
        this.algorithmSecureRandom = null;
        this.useBase64Encoding = true;
        this.backwardCompatibility = false;
        this._init(p);
    }

    private void _init(Properties p) throws UtilsException {
        String back;
        String base64;
        String iteration;
        String digest;
        String secureRandomAlgo;
        String secureRandom;
        String saltLength;
        String tipo = CryptConfig.getProperty(p, CRYPT_TYPE, false);
        if (StringUtils.isNotEmpty((CharSequence)tipo)) {
            CryptType cryptType = null;
            try {
                cryptType = CryptType.valueOf(tipo);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.type' value '" + tipo + "' uncorrect: " + e.getMessage(), e);
            }
            this.cryptType = cryptType;
        } else {
            String className = CryptConfig.getProperty(p, CRYPT_CUSTOM_TYPE, false);
            if (StringUtils.isEmpty((CharSequence)className)) {
                throw new UtilsException("Property 'passwordEncrypt.type' or 'passwordEncrypt.customType' are required");
            }
            this.cryptCustomType = className;
        }
        String charset = CryptConfig.getProperty(p, CRYPT_CHARSET_NAME, false);
        if (StringUtils.isNotEmpty((CharSequence)charset)) {
            this.charsetName = charset;
        }
        if (StringUtils.isNotEmpty((CharSequence)(saltLength = CryptConfig.getProperty(p, CRYPT_SALT_LENGTH, false)))) {
            try {
                this.saltLength = Integer.valueOf(saltLength);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.salt.length' value '" + saltLength + "' uncorrect: " + e.getMessage(), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(secureRandom = CryptConfig.getProperty(p, CRYPT_SALT_SECURE_RANDOM, false)))) {
            try {
                this.useSecureRandom = Boolean.valueOf(secureRandom);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.salt.secureRandom' value '" + secureRandom + "' uncorrect: " + e.getMessage(), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(secureRandomAlgo = CryptConfig.getProperty(p, CRYPT_SALT_SECURE_RANDOM_ALGORITHM, false)))) {
            this.algorithmSecureRandom = secureRandomAlgo;
        }
        if (StringUtils.isNotEmpty((CharSequence)(digest = CryptConfig.getProperty(p, CRYPT_DIGEST_ALGORITHM, false)))) {
            this.digestAlgorithm = digest;
        }
        if (StringUtils.isNotEmpty((CharSequence)(iteration = CryptConfig.getProperty(p, CRYPT_ITERATION, false)))) {
            try {
                this.iteration = Integer.valueOf(iteration);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.iteration' value '" + iteration + "' uncorrect: " + e.getMessage(), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(base64 = CryptConfig.getProperty(p, CRYPT_BASE64_ENCODING, false)))) {
            try {
                this.useBase64Encoding = Boolean.valueOf(base64);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.base64Encoding' value '" + base64 + "' uncorrect: " + e.getMessage(), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(back = CryptConfig.getProperty(p, CRYPT_BACKWARD_COMPATIBILITY, false)))) {
            try {
                this.backwardCompatibility = Boolean.valueOf(back);
            }
            catch (Throwable e) {
                throw new UtilsException("Property 'passwordEncrypt.backwardCompatibility' value '" + back + "' uncorrect: " + e.getMessage(), e);
            }
        }
    }

    protected static String getProperty(Properties p, String name, boolean required) throws UtilsException {
        String pValue = p.getProperty(name);
        if (pValue == null) {
            if (required) {
                throw new UtilsException("Property '" + name + "' not found");
            }
            return null;
        }
        return pValue.trim();
    }

    public CryptType getCryptType() {
        return this.cryptType;
    }

    public void setCryptType(CryptType cryptType) {
        this.cryptType = cryptType;
    }

    public String getCryptCustomType() {
        return this.cryptCustomType;
    }

    public void setCryptCustomType(String cryptCustomType) {
        this.cryptCustomType = cryptCustomType;
    }

    public boolean isUseBase64Encoding() {
        return this.useBase64Encoding;
    }

    public void setUseBase64Encoding(boolean useBase64Encoding) {
        this.useBase64Encoding = useBase64Encoding;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Integer getIteration() {
        return this.iteration;
    }

    public void setIteration(Integer iteration) {
        this.iteration = iteration;
    }

    public Integer getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(Integer saltLength) {
        this.saltLength = saltLength;
    }

    public boolean isUseSecureRandom() {
        return this.useSecureRandom;
    }

    public void setUseSecureRandom(boolean useSecureRandom) {
        this.useSecureRandom = useSecureRandom;
    }

    public String getAlgorithmSecureRandom() {
        return this.algorithmSecureRandom;
    }

    public void setAlgorithmSecureRandom(String algorithmSecureRandom) {
        this.algorithmSecureRandom = algorithmSecureRandom;
    }

    public boolean isBackwardCompatibility() {
        return this.backwardCompatibility;
    }

    public void setBackwardCompatibility(boolean backwardCompatibility) {
        this.backwardCompatibility = backwardCompatibility;
    }
}

