/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.ocsp.test.OCSPTest;
import org.openspcoop2.utils.resources.AbstractBaseThread;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class OpenSSLThread
extends AbstractBaseThread {
    private Process process;
    private File fCert;
    private File fKey;
    private File fCA;
    private File fIndex;
    private File fScript;
    private InputStream isDebug;
    private InputStream isError;
    public static final int PORT_CASE2 = 64900;
    public static final int PORT_CASE3 = 64901;
    public static final int PORT_CASE2_DIFFERENT_NONCE = 64902;

    public OpenSSLThread(String command, int port, String fCert, String fKey, String fCA, String fIndex, boolean forceWrongNonceResponseValue) throws Exception {
        byte[] content;
        try (InputStream is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/" + fCert);){
            content = Utilities.getAsByteArray(is);
            this.fCert = File.createTempFile("cert", ".pem");
            FileSystemUtilities.writeFile(this.fCert, content);
        }
        is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/" + fKey);
        try {
            content = Utilities.getAsByteArray(is);
            this.fKey = File.createTempFile("cert", ".key");
            FileSystemUtilities.writeFile(this.fKey, content);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/" + fCA);
        try {
            content = Utilities.getAsByteArray(is);
            this.fCA = File.createTempFile("certificateAuthority", ".pem");
            FileSystemUtilities.writeFile(this.fCA, content);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = OCSPTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/test/" + fIndex);
        try {
            content = Utilities.getAsByteArray(is);
            this.fIndex = File.createTempFile("index", ".txt");
            FileSystemUtilities.writeFile(this.fIndex, content);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String com = "/usr/bin/openssl";
        if (command != null) {
            com = command;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash\n\n").append(com);
        sb.append(" ocsp");
        sb.append(" -index ").append(this.fIndex.getAbsolutePath());
        sb.append(" -port ").append("" + port);
        sb.append(" -rsigner ").append(this.fCert.getAbsolutePath());
        sb.append(" -rkey ").append(this.fKey.getAbsolutePath());
        sb.append(" -CA ").append(this.fCA.getAbsolutePath());
        sb.append(" -text ");
        sb.append(" -out /tmp/ocsp.log");
        if (forceWrongNonceResponseValue) {
            sb.append(" -nonce ");
        }
        this.fScript = File.createTempFile("startOCSPResponder", ".sh");
        FileSystemUtilities.writeFile(this.fScript, sb.toString().getBytes());
        this.fScript.setExecutable(true);
    }

    @Override
    protected void process() {
        if (this.process == null) {
            try {
                String command = FileSystemUtilities.readFile(this.fScript);
                System.out.println("INVOKE from file '" + this.fScript.getAbsolutePath() + "':\n\t '" + command + "'");
                this.process = Runtime.getRuntime().exec(new String[]{this.fScript.getAbsolutePath()});
                System.out.println("PROCESS FINISH");
                this.isDebug = this.process.getInputStream();
                this.isError = this.process.getErrorStream();
            }
            catch (Throwable t) {
                System.out.println("INVOKE ERROR");
                t.printStackTrace(System.out);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.process != null) {
            this.process.descendants().forEach(ph -> ph.destroy());
            this.process.destroy();
            boolean terminated = false;
            while (!terminated) {
                try {
                    Utilities.sleep(500L);
                    this.process.exitValue();
                    terminated = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            this.debugMsg(true);
            this.process = null;
        }
        if (this.isDebug != null) {
            try {
                this.isDebug.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.isDebug = null;
        }
        if (this.isError != null) {
            try {
                this.isError.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.isError = null;
        }
        if (this.fCert != null) {
            this.fCert.delete();
            this.fCert = null;
        }
        if (this.fKey != null) {
            this.fKey.delete();
            this.fKey = null;
        }
        if (this.fCA != null) {
            this.fCA.delete();
            this.fCA = null;
        }
        if (this.fIndex != null) {
            this.fIndex.delete();
            this.fIndex = null;
        }
        if (this.fScript != null) {
            this.fScript.delete();
            this.fScript = null;
        }
    }

    public boolean debugMsg(boolean waitStop) {
        int read;
        if (this.process == null) {
            System.out.println("Process unitialized");
            return false;
        }
        boolean terminated = false;
        int exitValue = -1;
        if (waitStop) {
            while (!terminated) {
                try {
                    Utilities.sleep(500L);
                    this.process.exitValue();
                    terminated = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
        } else {
            try {
                exitValue = this.process.exitValue();
                terminated = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        if (!terminated) {
            System.out.println("Process running");
            return true;
        }
        System.out.println("Process terminated with code: " + exitValue);
        try (BufferedInputStream berror = new BufferedInputStream(this.isError);){
            StringBuilder stampaError = new StringBuilder();
            read = 0;
            while ((read = berror.read()) != -1) {
                stampaError.append((char)read);
            }
            if (stampaError.length() > 0) {
                System.out.println("ERROR stream: " + stampaError.toString());
            }
        }
        catch (Throwable t) {
            System.out.println("Reading error stream failed: " + t.getMessage());
        }
        try (BufferedInputStream bin = new BufferedInputStream(this.isDebug);){
            StringBuilder stampa = new StringBuilder();
            read = 0;
            while ((read = bin.read()) != -1) {
                stampa.append((char)read);
            }
            if (stampa.length() > 0) {
                System.out.println("DEBUG stream: " + stampa.toString());
            }
        }
        catch (Throwable t) {
            System.out.println("Reading stream failed: " + t.getMessage());
        }
        return false;
    }

    public static OpenSSLThread newOpenSSLThread_case2(String opensslCommand, int waitStartupServer) throws Exception {
        return OpenSSLThread.newOpenSSLThread(opensslCommand, waitStartupServer, 64900, false);
    }

    public static OpenSSLThread newOpenSSLThread_case2_differentNonce(String opensslCommand, int waitStartupServer) throws Exception {
        return OpenSSLThread.newOpenSSLThread(opensslCommand, waitStartupServer, 64902, true);
    }

    public static OpenSSLThread newOpenSSLThread_case3(String opensslCommand, int waitStartupServer) throws Exception {
        return OpenSSLThread.newOpenSSLThread(opensslCommand, waitStartupServer, 64901, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenSSLThread newOpenSSLThread(String opensslCommand, int waitStartupServer, int port, boolean forceWrongNonceResponseValue) throws Exception {
        String fCert = "ocsp/ocsp_TEST.cert.pem";
        String fKey = "ocsp/ocsp_TEST.key.pem";
        if (port == 64901) {
            fCert = "crl/ExampleClient1.crt";
            fKey = "crl/ExampleClient1.key";
        }
        boolean started = false;
        int index = 0;
        OpenSSLThread sslThread = null;
        int tentativi = 30;
        while (!started && index < tentativi) {
            sslThread = new OpenSSLThread(opensslCommand, port, fCert, fKey, "ocsp/ca_TEST.cert.pem", "ocsp/index.txt", forceWrongNonceResponseValue);
            try {
                try {
                    sslThread.start();
                    System.out.println("START, sleep ...");
                    Utilities.sleep(waitStartupServer);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                started = sslThread.debugMsg(false);
            }
            finally {
                if (started) continue;
                System.out.println("NOT STARTED (iteration: " + ++index + ")");
                sslThread.setStop(true);
                sslThread.waitShutdown(200, 10000);
                sslThread.close();
            }
        }
        System.out.println("STARTED");
        return sslThread;
    }

    public static void stopOpenSSLThread(OpenSSLThread sslThread, int waitStopServer) throws Exception {
        sslThread.setStop(true);
        sslThread.waitShutdown(200, 10000);
        sslThread.close();
        try {
            System.out.println("STOP, sleep ...");
            Utilities.sleep(waitStopServer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("STOP");
    }
}

