/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.security.cert.X509Certificate;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.CertificateStatus;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.certificate.ocsp.OCSPRequestParams;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidator;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;

public class OCSPValidatorImpl
implements IOCSPValidator {
    private LoggerBuffer log;
    private KeyStore trustStore;
    private String crlInput;
    private String configType;
    private OCSPConfig ocspConfig;
    private IOCSPResourceReader ocspResourceReader;
    private OCSPTrustManager ocspTrustManager;

    public OCSPValidatorImpl(LoggerBuffer log, String crlInput, String configType, IOCSPResourceReader ocspResourceReader) throws UtilsException {
        this(log, null, crlInput, configType, ocspResourceReader);
    }

    public OCSPValidatorImpl(LoggerBuffer log, KeyStore trustStore, String crlInput, String configType, IOCSPResourceReader ocspResourceReader) throws UtilsException {
        this.log = log;
        this.trustStore = trustStore;
        this.crlInput = crlInput;
        this.configType = configType;
        OCSPManager ocspManager = OCSPManager.getInstance();
        this.ocspConfig = ocspManager.getOCSPConfig(this.configType);
        this.ocspResourceReader = ocspResourceReader;
    }

    @Override
    public void valid(X509Certificate cert) throws UtilsException {
        OCSPRequestParams params = OCSPRequestParams.build(this.log, cert, this.trustStore, this.ocspConfig, this.ocspResourceReader);
        CertificateStatus certificatePrincipalStatus = OCSPValidator.check(this.log, params, this.crlInput);
        certificatePrincipalStatus.checkValid();
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    @Override
    public void setTrustStore(KeyStore truststore) {
        this.trustStore = truststore;
    }

    @Override
    public OCSPTrustManager getOCSPTrustManager() {
        return this.ocspTrustManager;
    }

    @Override
    public void setOCSPTrustManager(OCSPTrustManager trustManager) {
        this.ocspTrustManager = trustManager;
    }

    public OCSPConfig getOcspConfig() {
        return this.ocspConfig;
    }
}

