/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.slf4j.Logger;

public class OCSPManager {
    private static OCSPManager staticInstance;
    private HashMap<String, OCSPConfig> hsmOCSPConfigMapIDtoConfig = new HashMap();
    private HashMap<String, String> hsmOCSPConfigMapTypeToID = new HashMap();
    private HashMap<String, String> hsmOCSPConfigMapLabelToID = new HashMap();
    private SortedMap<String> hsmOCSPConfigSortedMapTypeLabel = new SortedMap();

    public static synchronized void init(File f, boolean throwNotExists, boolean loadDefault, Logger log) throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new OCSPManager(f, throwNotExists, loadDefault, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OCSPManager getInstance() {
        if (staticInstance != null) return staticInstance;
        Class<OCSPManager> clazz = OCSPManager.class;
        synchronized (OCSPManager.class) {
            if (staticInstance != null) return staticInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OCSPManager(File f, boolean throwNotExists, boolean loadDefault, Logger log) throws UtilsException {
        if (!f.exists()) {
            if (throwNotExists) {
                throw new UtilsException("File '" + f.getAbsolutePath() + "' not exists");
            }
            if (!loadDefault) return;
            try (InputStream isDefault = OCSPManager.class.getResourceAsStream("/org/openspcoop2/utils/certificate/ocsp/default.properties");){
                if (isDefault == null) return;
                Properties p = new Properties();
                try {
                    p.load(isDefault);
                }
                catch (Exception t) {
                    throw new UtilsException("File '" + f.getAbsolutePath() + "'; initialize error: " + t.getMessage(), t);
                }
                this.init(p, log);
                return;
            }
            catch (Exception t) {
                throw new UtilsException("Default configuration; initialize error: " + t.getMessage(), t);
            }
        }
        if (!f.canRead()) {
            throw new UtilsException("File '" + f.getAbsolutePath() + "' cannot read");
        }
        Properties p = new Properties();
        try (FileInputStream fin = new FileInputStream(f);){
            p.load(fin);
        }
        catch (Exception t) {
            throw new UtilsException("File '" + f.getAbsolutePath() + "'; initialize error: " + t.getMessage(), t);
        }
        this.init(p, log);
    }

    private void init(Properties p, Logger log) throws UtilsException {
        ArrayList<String> idKeystore = new ArrayList<String>();
        if (p != null && !p.isEmpty()) {
            Enumeration<Object> enKeys = p.keys();
            while (enKeys.hasMoreElements()) {
                String idK;
                int indeoOf;
                String tmp;
                Object key;
                Object object = enKeys.nextElement();
                if (!(object instanceof String) || !((String)(key = (String)object)).startsWith("ocsp.") || ((String)key).length() <= "ocsp.".length() || (tmp = ((String)key).substring("ocsp.".length())) == null || !tmp.contains(".") || (indeoOf = tmp.indexOf(".")) <= 0 || idKeystore.contains(idK = tmp.substring(0, indeoOf))) continue;
                idKeystore.add(idK);
            }
        }
        if (!idKeystore.isEmpty()) {
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            for (String idK : idKeystore) {
                String prefix = "ocsp." + idK + ".";
                PropertiesReader pReader = new PropertiesReader(p, true);
                Properties pKeystore = pReader.readProperties_convertEnvProperties(prefix);
                OCSPConfig ocspConfig = new OCSPConfig(idK, pKeystore, log);
                boolean alreadyExists = false;
                for (String type : this.hsmOCSPConfigMapTypeToID.keySet()) {
                    if (!ocspConfig.getType().equalsIgnoreCase(type)) continue;
                    alreadyExists = true;
                }
                if (alreadyExists) {
                    throw new UtilsException("Same ocsp type found for responder '" + this.hsmOCSPConfigMapTypeToID.get(ocspConfig.getType()) + "' e '" + idK + "'");
                }
                this.hsmOCSPConfigMapTypeToID.put(ocspConfig.getType(), idK);
                alreadyExists = false;
                for (String label : this.hsmOCSPConfigMapLabelToID.keySet()) {
                    if (!ocspConfig.getLabel().equalsIgnoreCase(label)) continue;
                    alreadyExists = true;
                }
                if (alreadyExists) {
                    throw new UtilsException("Same ocsp label found for responder '" + this.hsmOCSPConfigMapLabelToID.get(ocspConfig.getLabel()) + "' e '" + idK + "'");
                }
                this.hsmOCSPConfigMapLabelToID.put(ocspConfig.getLabel(), idK);
                this.hsmOCSPConfigMapIDtoConfig.put(idK, ocspConfig);
                String msg = "OCSP config " + idK + " registrato (OCSP Type:" + ocspConfig.getType() + ")";
                log.info(msg);
                types.add(ocspConfig.getType());
                labels.add(ocspConfig.getLabel());
            }
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < types.size(); ++i) {
                String type = (String)types.get(i);
                String label = (String)labels.get(i);
                m.put(label, type);
            }
            Collections.sort(labels);
            for (String l : labels) {
                this.hsmOCSPConfigSortedMapTypeLabel.add((String)m.get(l), l);
            }
        } else {
            log.warn("La configurazione fornita per HSM non contiene alcun keystore");
        }
    }

    public OCSPConfig getOCSPConfig(String ocspConfigType) throws UtilsException {
        if (!this.hsmOCSPConfigMapTypeToID.containsKey(ocspConfigType)) {
            throw new UtilsException("OCSP config type '" + ocspConfigType + "' unknown");
        }
        String idK = this.hsmOCSPConfigMapTypeToID.get(ocspConfigType);
        if (!this.hsmOCSPConfigMapIDtoConfig.containsKey(idK)) {
            throw new UtilsException("OCSP config type '" + ocspConfigType + "' unknown ? (id:" + idK + ")");
        }
        return this.hsmOCSPConfigMapIDtoConfig.get(idK);
    }

    public List<String> getOCSPConfigTypes() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.hsmOCSPConfigMapTypeToID.isEmpty()) {
            for (String type : this.hsmOCSPConfigMapTypeToID.keySet()) {
                l.add(type);
            }
        }
        return l;
    }

    public List<String> getOCSPConfigLabels() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.hsmOCSPConfigMapLabelToID.isEmpty()) {
            for (String label : this.hsmOCSPConfigMapLabelToID.keySet()) {
                l.add(label);
            }
        }
        return l;
    }

    public SortedMap<String> getOCSPConfigTypesLabels() {
        return this.hsmOCSPConfigSortedMapTypeLabel;
    }

    public boolean existsOCSPConfig(String ocspConfigType) {
        if (ocspConfigType == null) {
            return false;
        }
        for (String type : this.hsmOCSPConfigMapTypeToID.keySet()) {
            if (!ocspConfigType.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }
}

