/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.hsm;

import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.hsm.HSMManager;

public class HSMUtils {
    public static final String KEYSTORE_HSM_PREFIX = "HSM-";
    public static final String KEYSTORE_HSM_STORE_PASSWORD_UNDEFINED = "-";
    public static final String KEYSTORE_HSM_PRIVATE_KEY_PASSWORD_UNDEFINED = "-";
    private static boolean hsmConfigurableKeyPassword = false;

    private HSMUtils() {
    }

    public static boolean isHsmConfigurableKeyPassword() {
        return hsmConfigurableKeyPassword;
    }

    public static void setHsmConfigurableKeyPassword(boolean hsmConfigurableKeyPassword) {
        HSMUtils.hsmConfigurableKeyPassword = hsmConfigurableKeyPassword;
    }

    public static void fillTipologieKeystore(boolean trustStore, boolean secretKeyStore, List<String> l) {
        List<String> typeHsm;
        HSMManager hsmManager = HSMManager.getInstance();
        if (hsmManager != null && (typeHsm = hsmManager.getKeystoreTypes()) != null && !typeHsm.isEmpty()) {
            if (secretKeyStore) {
                HSMUtils.initSecretKeyStore(typeHsm, hsmManager, l);
            } else if (trustStore) {
                HSMUtils.initTrustStore(typeHsm, hsmManager, l);
            } else {
                l.addAll(typeHsm);
            }
        }
    }

    private static void initSecretKeyStore(List<String> typeHsm, HSMManager hsmManager, List<String> l) {
        for (String type : typeHsm) {
            try {
                if (!hsmManager.isUsableAsSecretKeyStore(type)) continue;
                l.add(type);
            }
            catch (Exception exception) {}
        }
    }

    private static void initTrustStore(List<String> typeHsm, HSMManager hsmManager, List<String> l) {
        for (String type : typeHsm) {
            try {
                if (!hsmManager.isUsableAsTrustStore(type)) continue;
                l.add(type);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsTipologieKeystoreHSM(boolean trustStore, boolean secretKeyStore) {
        List<String> typeHsm;
        HSMManager hsmManager = HSMManager.getInstance();
        return hsmManager != null && HSMUtils.existsTipologieKeystoreHSM(typeHsm = hsmManager.getKeystoreTypes(), hsmManager, trustStore, secretKeyStore);
    }

    private static boolean existsTipologieKeystoreHSM(List<String> typeHsm, HSMManager hsmManager, boolean trustStore, boolean secretKeyStore) {
        if (typeHsm != null && !typeHsm.isEmpty()) {
            if (secretKeyStore) {
                if (HSMUtils.existsSecretKeyStore(typeHsm, hsmManager)) {
                    return true;
                }
            } else if (trustStore) {
                if (HSMUtils.existsTrustStore(typeHsm, hsmManager)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static boolean existsSecretKeyStore(List<String> typeHsm, HSMManager hsmManager) {
        for (String type : typeHsm) {
            try {
                if (!hsmManager.isUsableAsSecretKeyStore(type)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private static boolean existsTrustStore(List<String> typeHsm, HSMManager hsmManager) {
        for (String type : typeHsm) {
            try {
                if (!hsmManager.isUsableAsTrustStore(type)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static boolean isKeystoreHSM(String tipo) {
        if (HSMManager.getInstance() != null) {
            return HSMManager.getInstance().existsKeystoreType(tipo);
        }
        return false;
    }

    public static KeyStore getKeystoreHSM(String tipo) throws UtilsException {
        if (HSMManager.getInstance() != null) {
            return HSMManager.getInstance().getKeystore(tipo);
        }
        return null;
    }
}

