/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.hsm;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.hsm.HSMKeystore;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.slf4j.Logger;

public class HSMManager {
    private static HSMManager staticInstance;
    private HashMap<String, HSMKeystore> hsmKeystoreMapIDtoConfig = new HashMap();
    private HashMap<String, String> hsmKeystoreMapKeystoreTypeLabelToID = new HashMap();

    public static synchronized void init(File f, boolean throwNotExists, Logger log, boolean accessKeystore) throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new HSMManager(f, throwNotExists, log, accessKeystore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HSMManager getInstance() {
        if (staticInstance != null) return staticInstance;
        Class<HSMManager> clazz = HSMManager.class;
        synchronized (HSMManager.class) {
            if (staticInstance != null) return staticInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    private HSMManager(File f, boolean throwNotExists, Logger log, boolean accessKeystore) throws UtilsException {
        String prefixFile = "File '" + f.getAbsolutePath() + "'";
        if (!f.exists()) {
            if (throwNotExists) {
                throw new UtilsException(prefixFile + " not exists");
            }
        } else {
            if (!f.canRead()) {
                throw new UtilsException(prefixFile + " cannot read");
            }
            Properties p = new Properties();
            try (FileInputStream fin = new FileInputStream(f);){
                p.load(fin);
            }
            catch (Exception t) {
                throw new UtilsException(prefixFile + "; initialize error: " + t.getMessage(), t);
            }
            this.init(p, log, accessKeystore);
        }
    }

    private void init(Properties p, Logger log, boolean accessKeystore) throws UtilsException {
        ArrayList<String> idKeystore = new ArrayList<String>();
        if (p != null && !p.isEmpty()) {
            this.init(p, idKeystore);
        }
        if (!idKeystore.isEmpty()) {
            for (String idK : idKeystore) {
                this.init(p, log, accessKeystore, idK);
            }
        } else {
            log.warn("La configurazione fornita per HSM non contiene alcun keystore");
        }
    }

    private void init(Properties p, List<String> idKeystore) {
        Enumeration<Object> enKeys = p.keys();
        while (enKeys.hasMoreElements()) {
            Object object = enKeys.nextElement();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            this.init(key, idKeystore);
        }
    }

    private void init(String key, List<String> idKeystore) {
        String idK;
        int indeoOf;
        String tmp;
        if (key.startsWith("hsm.") && key.length() > "hsm.".length() && (tmp = key.substring("hsm.".length())) != null && tmp.contains(".") && (indeoOf = tmp.indexOf(".")) > 0 && !idKeystore.contains(idK = tmp.substring(0, indeoOf))) {
            idKeystore.add(idK);
        }
    }

    private void init(Properties p, Logger log, boolean accessKeystore, String idK) throws UtilsException {
        String prefix = "hsm." + idK + ".";
        PropertiesReader pReader = new PropertiesReader(p, true);
        Properties pKeystore = pReader.readProperties_convertEnvProperties(prefix);
        HSMKeystore hsmKeystore = new HSMKeystore(idK, pKeystore, log, accessKeystore);
        boolean alreadyExists = false;
        for (String type : this.hsmKeystoreMapKeystoreTypeLabelToID.keySet()) {
            if (!hsmKeystore.getKeystoreTypeLabel().equalsIgnoreCase(type)) continue;
            alreadyExists = true;
        }
        if (alreadyExists) {
            throw new UtilsException("Same keystore type label found for keystore '" + this.hsmKeystoreMapKeystoreTypeLabelToID.get(hsmKeystore.getKeystoreTypeLabel()) + "' e '" + idK + "'");
        }
        this.hsmKeystoreMapKeystoreTypeLabelToID.put(hsmKeystore.getKeystoreTypeLabel(), idK);
        this.hsmKeystoreMapIDtoConfig.put(idK, hsmKeystore);
        String d = "HSMKeystore " + idK + " registrato (keystoreType:" + hsmKeystore.getKeystoreTypeLabel() + ")";
        log.info(d);
    }

    public void providerInit(Logger log, boolean uniqueProviderInstance) throws UtilsException {
        if (this.hsmKeystoreMapIDtoConfig != null && !this.hsmKeystoreMapIDtoConfig.isEmpty()) {
            for (Map.Entry<String, HSMKeystore> entry : this.hsmKeystoreMapIDtoConfig.entrySet()) {
                String idK = entry.getKey();
                HSMKeystore hsmKeystore = this.hsmKeystoreMapIDtoConfig.get(idK);
                hsmKeystore.init(log, uniqueProviderInstance);
            }
        }
    }

    private HSMKeystore getHSMKeystore(String keystoreTypeLabel) throws UtilsException {
        if (!this.hsmKeystoreMapKeystoreTypeLabelToID.containsKey(keystoreTypeLabel)) {
            throw new UtilsException("Keystore type '" + keystoreTypeLabel + "' unknown");
        }
        String idK = this.hsmKeystoreMapKeystoreTypeLabelToID.get(keystoreTypeLabel);
        if (!this.hsmKeystoreMapIDtoConfig.containsKey(idK)) {
            throw new UtilsException("Keystore config for type '" + keystoreTypeLabel + "' unknown ? (id:" + idK + ")");
        }
        return this.hsmKeystoreMapIDtoConfig.get(idK);
    }

    public KeyStore getKeystore(String keystoreTypeLabel) throws UtilsException {
        HSMKeystore hsmKeystore = this.getHSMKeystore(keystoreTypeLabel);
        return hsmKeystore.getInstance();
    }

    public boolean isUsableAsTrustStore(String keystoreTypeLabel) throws UtilsException {
        HSMKeystore hsmKeystore = this.getHSMKeystore(keystoreTypeLabel);
        return hsmKeystore.isUsableAsTrustStore();
    }

    public boolean isUsableAsSecretKeyStore(String keystoreTypeLabel) throws UtilsException {
        HSMKeystore hsmKeystore = this.getHSMKeystore(keystoreTypeLabel);
        return hsmKeystore.isUsableAsSecretKeyStore();
    }

    public List<String> getKeystoreTypes() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.hsmKeystoreMapKeystoreTypeLabelToID.isEmpty()) {
            for (String type : this.hsmKeystoreMapKeystoreTypeLabelToID.keySet()) {
                l.add(type);
            }
        }
        return l;
    }

    public boolean existsKeystoreType(String keystoreTypeLabel) {
        if (keystoreTypeLabel == null) {
            return false;
        }
        for (String type : this.hsmKeystoreMapKeystoreTypeLabelToID.keySet()) {
            if (!keystoreTypeLabel.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }
}

