/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

public enum KeystoreType {
    JKS("jks", "JKS"),
    PKCS12("pkcs12", "PKCS12"),
    PKCS11("pkcs11", "PKCS11"),
    PKCS8("pkcs8", "PKCS8"),
    PKCS1("pkcs1", "PKCS1"),
    JCEKS("jceks", "JCEKS"),
    JWK_SET("jwk", "JWK Set"),
    PUBLIC_KEY("public", "Public Key"),
    KEY_PAIR("keys", "Key Pair"),
    SYMMETRIC_KEY("symm", "Symmetric Key"),
    PASSWORD_KEY_DERIVATION("pass", "Password Key Derivation");

    private final String nome;
    private final String label;

    private KeystoreType(String nome, String label) {
        this.nome = nome;
        this.label = label;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.nome;
    }

    public String toString() {
        return this.nome;
    }

    public boolean isType(String value) {
        return this.nome.equalsIgnoreCase(value);
    }

    public static KeystoreType toEnumFromName(String name) {
        KeystoreType[] tipi = KeystoreType.values();
        for (int i = 0; i < tipi.length; ++i) {
            KeystoreType tipo = tipi[i];
            if (!tipo.getNome().equals(name)) continue;
            return tipo;
        }
        return null;
    }

    public static KeystoreType toEnumFromLabel(String label) {
        KeystoreType[] tipi = KeystoreType.values();
        for (int i = 0; i < tipi.length; ++i) {
            KeystoreType tipo = tipi[i];
            if (!tipo.getLabel().equals(label)) continue;
            return tipo;
        }
        return null;
    }
}

