/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.Extensions;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;

public enum KeyUsage {
    DIGITAL_SIGNATURE(0, 128),
    NON_REPUDIATION(1, 64),
    KEY_ENCIPHERMENT(2, 32),
    DATA_ENCIPHERMENT(3, 16),
    KEY_AGREEMENT(4, 8),
    KEY_CERT_SIGN(5, 4),
    CRL_SIGN(6, 2),
    ENCIPHER_ONLY(7, 1),
    DECIPHER_ONLY(8, 32768);

    private int arrayBooleanPosition;
    private int bouncyValue;

    private KeyUsage(int arrayBooleanPosition, int bouncyValue) {
        this.arrayBooleanPosition = arrayBooleanPosition;
        this.bouncyValue = bouncyValue;
    }

    public int getX509CertificatePosition() {
        return this.arrayBooleanPosition;
    }

    public int getBouncyCastleCode() {
        return this.bouncyValue;
    }

    public boolean hasKeyUsage(Certificate x509) {
        if (x509.getCertificate() != null) {
            return this.hasKeyUsage(x509.getCertificate());
        }
        return false;
    }

    public boolean hasKeyUsage(CertificateInfo x509) {
        return this.hasKeyUsage(x509.getCertificate());
    }

    public boolean hasKeyUsage(X509Certificate x509) {
        return KeyUsage.existsKeyUsageByArrayBooleanPosition(x509, this.arrayBooleanPosition);
    }

    public static boolean existsKeyUsageByArrayBooleanPosition(X509Certificate x509, int arrayBooleanPosition) {
        if (x509.getKeyUsage() != null && x509.getKeyUsage().length > arrayBooleanPosition) {
            return x509.getKeyUsage()[arrayBooleanPosition];
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printArrayPosition) {
        if (printArrayPosition) {
            return this.name() + " (" + this.arrayBooleanPosition + ")";
        }
        return this.name();
    }

    public boolean hasKeyUsage(byte[] encoded) {
        return KeyUsage.existsKeyUsageByBouncycastleCode(encoded, this.bouncyValue);
    }

    public static boolean existsKeyUsageByBouncycastleCode(byte[] encoded, int bouncyValue) {
        org.bouncycastle.asn1.x509.KeyUsage ku;
        org.bouncycastle.asn1.x509.Certificate c = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ku = org.bouncycastle.asn1.x509.KeyUsage.fromExtensions((Extensions)exts)) != null) {
            return ku.hasUsages(bouncyValue);
        }
        return false;
    }

    public static List<KeyUsage> getKeyUsage(Certificate x509) {
        if (x509.getCertificate() != null) {
            return KeyUsage.getKeyUsage(x509.getCertificate());
        }
        return new ArrayList<KeyUsage>();
    }

    public static List<KeyUsage> getKeyUsage(CertificateInfo x509) {
        return KeyUsage.getKeyUsage(x509.getCertificate());
    }

    public static List<KeyUsage> getKeyUsage(X509Certificate x509) {
        KeyUsage[] values;
        ArrayList<KeyUsage> l = new ArrayList<KeyUsage>();
        for (KeyUsage keyUsage : values = KeyUsage.values()) {
            if (!keyUsage.hasKeyUsage(x509)) continue;
            l.add(keyUsage);
        }
        return l;
    }

    public static List<KeyUsage> getKeyUsage(byte[] encoded) {
        KeyUsage[] values;
        ArrayList<KeyUsage> l = new ArrayList<KeyUsage>();
        for (KeyUsage keyUsage : values = KeyUsage.values()) {
            if (!keyUsage.hasKeyUsage(encoded)) continue;
            l.add(keyUsage);
        }
        return l;
    }
}

