/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertificateHolderSelector;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.OID;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class CertificatePrincipal {
    private X500Principal principal;
    private PrincipalType type;
    private X500Name x500name;
    public static final String CN_EMPTY = "__undefined__";

    public CertificatePrincipal(X500Principal principal, PrincipalType type) {
        this.principal = principal;
        this.type = type;
    }

    public String toString() {
        return this.principal.toString();
    }

    public String toString(String regexp) throws UtilsException {
        String dn = this.toString();
        return this.getRegexpValue(dn, regexp);
    }

    public String getName() {
        return this.principal.getName();
    }

    public String getNameByRegExp(String regexp) throws UtilsException {
        String dn = this.getName();
        return this.getRegexpValue(dn, regexp);
    }

    public String getName(String format) {
        return this.principal.getName(format);
    }

    public String getName(String format, String regexp) throws UtilsException {
        String dn = this.getName(format);
        return this.getRegexpValue(dn, regexp);
    }

    public String getCanonicalName() {
        return this.principal.getName("CANONICAL");
    }

    public String getCanonicalName(String regexp) throws UtilsException {
        String dn = this.getCanonicalName();
        return this.getRegexpValue(dn, regexp);
    }

    public String getRFC1779Name() {
        return this.principal.getName("RFC1779");
    }

    public String getRFC1779Name(String regexp) throws UtilsException {
        String dn = this.getRFC1779Name();
        return this.getRegexpValue(dn, regexp);
    }

    public String getRFC2253Name() {
        return this.principal.getName("RFC2253");
    }

    public String getRFC2253Name(String regexp) throws UtilsException {
        String dn = this.getRFC2253Name();
        return this.getRegexpValue(dn, regexp);
    }

    public String getNameNormalized() throws UtilsException {
        return CertificateUtils.formatPrincipal(this.toString(), this.type);
    }

    public Map<String, List<String>> toMap() throws UtilsException {
        return CertificateUtils.getPrincipalIntoMap(this.toString(), this.type);
    }

    public Map<String, String> toSimpleMap() throws UtilsException {
        return CertificateUtils.formatPrincipalToMap(this.toString(), this.type);
    }

    public String getNameNormalized(String regexp) throws UtilsException {
        String dn = this.getNameNormalized();
        return this.getRegexpValue(dn, regexp);
    }

    private synchronized void initX500Name() {
        if (this.x500name == null) {
            this.x500name = new JcaX509CertificateHolderSelector(this.principal, null).getIssuer();
        }
    }

    public String getCN() {
        return this.getInfoByOID(BCStyle.CN, CN_EMPTY);
    }

    public String getCN(String regexp) throws UtilsException {
        String cn = this.getCN();
        return this.getRegexpValue(cn, regexp);
    }

    private String getRegexpValue(String value, String regexp) throws UtilsException {
        try {
            return RegularExpressionEngine.getStringMatchPattern(value, regexp);
        }
        catch (RegExpNotFoundException notFound) {
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public List<OID> getOID() {
        RDN[] rdnArray;
        ArrayList<OID> l = new ArrayList<OID>();
        if (this.x500name == null) {
            this.initX500Name();
        }
        if ((rdnArray = this.x500name.getRDNs()) != null && rdnArray.length > 0) {
            for (RDN rdn : rdnArray) {
                OID oid;
                if (rdn == null || (oid = OID.toOID(rdn.getFirst().getType())) == null) continue;
                l.add(oid);
            }
        }
        return l;
    }

    public String getInfo(String oid) {
        return this.getInfoByOID(OID.valueOf(oid.toUpperCase()));
    }

    public String getInfo(String oid, String defaultEmptyValue) {
        return this.getInfoByOID(OID.valueOf(oid.toUpperCase()), defaultEmptyValue);
    }

    public String getInfoByOID(String oid) {
        return this.getInfoByOID(new ASN1ObjectIdentifier(oid));
    }

    public String getInfoByOID(String oid, String defaultEmptyValue) {
        return this.getInfoByOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue);
    }

    public String getInfoByOID(OID oid) {
        return this.getInfoByOID(oid.getOID());
    }

    public String getInfoByOID(OID oid, String defaultEmptyValue) {
        return this.getInfoByOID(oid.getOID(), defaultEmptyValue);
    }

    public String getInfoByOID(ASN1ObjectIdentifier oid) {
        return this.getInfoByOID(oid, null);
    }

    public String getInfoByOID(ASN1ObjectIdentifier oid, String defaultEmptyValue) {
        RDN[] rdnArray;
        if (this.x500name == null) {
            this.initX500Name();
        }
        if ((rdnArray = this.x500name.getRDNs(oid)) != null && rdnArray.length > 0 && rdnArray[0] != null) {
            RDN rdn = rdnArray[0];
            if (rdn.getFirst() != null && rdn.getFirst().getValue() != null) {
                return rdn.getFirst().getValue().toString();
            }
            return defaultEmptyValue;
        }
        return defaultEmptyValue;
    }

    public String getInfo(String oid, int position) {
        return this.getInfoByOID(OID.valueOf(oid.toUpperCase()), position);
    }

    public String getInfo(String oid, String defaultEmptyValue, int position) {
        return this.getInfoByOID(OID.valueOf(oid.toUpperCase()), defaultEmptyValue, position);
    }

    public String getInfoByOID(String oid, int position) {
        return this.getInfoByOID(new ASN1ObjectIdentifier(oid), position);
    }

    public String getInfoByOID(String oid, String defaultEmptyValue, int position) {
        return this.getInfoByOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue, position);
    }

    public String getInfoByOID(OID oid, int position) {
        return this.getInfoByOID(oid.getOID(), position);
    }

    public String getInfoByOID(OID oid, String defaultEmptyValue, int position) {
        return this.getInfoByOID(oid.getOID(), defaultEmptyValue, position);
    }

    public String getInfoByOID(ASN1ObjectIdentifier oid, int position) {
        return this.getInfoByOID(oid, null, position);
    }

    public String getInfoByOID(ASN1ObjectIdentifier oid, String defaultEmptyValue, int position) {
        List<String> l = this.getInfosByOID(oid, defaultEmptyValue);
        if (l != null && l.size() > position) {
            return l.get(position);
        }
        return defaultEmptyValue;
    }

    public List<String> getInfos(String oid) {
        return this.getInfosByOID(OID.valueOf(oid.toUpperCase()));
    }

    public List<String> getInfos(String oid, String defaultEmptyValue) {
        return this.getInfosByOID(OID.valueOf(oid.toUpperCase()), defaultEmptyValue);
    }

    public List<String> getInfosByOID(String oid) {
        return this.getInfosByOID(new ASN1ObjectIdentifier(oid));
    }

    public List<String> getInfosByOID(String oid, String defaultEmptyValue) {
        return this.getInfosByOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue);
    }

    public List<String> getInfosByOID(OID oid) {
        return this.getInfosByOID(oid.getOID());
    }

    public List<String> getInfosByOID(OID oid, String defaultEmptyValue) {
        return this.getInfosByOID(oid.getOID(), defaultEmptyValue);
    }

    public List<String> getInfosByOID(ASN1ObjectIdentifier oid) {
        return this.getInfosByOID(oid, null);
    }

    public List<String> getInfosByOID(ASN1ObjectIdentifier oid, String defaultEmptyValue) {
        if (this.x500name == null) {
            this.initX500Name();
        }
        RDN[] rdnArray = this.x500name.getRDNs(oid);
        ArrayList<String> l = null;
        if (rdnArray != null && rdnArray.length > 0) {
            for (RDN rdn : rdnArray) {
                if (rdn == null || rdn.getFirst() == null || rdn.getFirst().getValue() == null) continue;
                if (l == null) {
                    l = new ArrayList();
                }
                l.add(rdn.getFirst().getValue().toString());
            }
        }
        if (l == null && defaultEmptyValue != null) {
            l = new ArrayList<String>();
            l.add(defaultEmptyValue);
        }
        return l;
    }

    public List<String> getIdOID() {
        RDN[] rdnArray;
        ArrayList<String> l = new ArrayList<String>();
        if (this.x500name == null) {
            this.initX500Name();
        }
        if ((rdnArray = this.x500name.getRDNs()) != null && rdnArray.length > 0) {
            for (RDN rdn : rdnArray) {
                if (rdn == null) continue;
                l.add(rdn.getFirst().getType().getId());
            }
        }
        return l;
    }

    public String getInfoByIdOID(String oid) {
        return this.getInfoByIdOID(new ASN1ObjectIdentifier(oid));
    }

    public String getInfoByIdOID(String oid, String defaultEmptyValue) {
        return this.getInfoByIdOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue);
    }

    public String getInfoByIdOID(ASN1ObjectIdentifier oid) {
        return this.getInfoByIdOID(oid, null);
    }

    public String getInfoByIdOID(ASN1ObjectIdentifier idOID, String defaultEmptyValue) {
        RDN[] rdnArray;
        if (this.x500name == null) {
            this.initX500Name();
        }
        if ((rdnArray = this.x500name.getRDNs(idOID)) != null && rdnArray.length > 0 && rdnArray[0] != null) {
            RDN rdn = rdnArray[0];
            if (rdn.getFirst() != null && rdn.getFirst().getValue() != null) {
                return rdn.getFirst().getValue().toString();
            }
            return defaultEmptyValue;
        }
        return defaultEmptyValue;
    }

    public String getInfoByIdOID(String oid, int position) {
        return this.getInfoByIdOID(new ASN1ObjectIdentifier(oid), position);
    }

    public String getInfoByIdOID(String oid, String defaultEmptyValue, int position) {
        return this.getInfoByIdOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue, position);
    }

    public String getInfoByIdOID(ASN1ObjectIdentifier oid, int position) {
        return this.getInfoByIdOID(oid, null, position);
    }

    public String getInfoByIdOID(ASN1ObjectIdentifier oid, String defaultEmptyValue, int position) {
        List<String> l = this.getInfosByIdOID(oid, defaultEmptyValue);
        if (l != null && l.size() > position) {
            return l.get(position);
        }
        return defaultEmptyValue;
    }

    public List<String> getInfosByIdOID(String oid) {
        return this.getInfosByIdOID(new ASN1ObjectIdentifier(oid));
    }

    public List<String> getInfosByIdOID(String oid, String defaultEmptyValue) {
        return this.getInfosByIdOID(new ASN1ObjectIdentifier(oid), defaultEmptyValue);
    }

    public List<String> getInfosByIdOID(ASN1ObjectIdentifier oid) {
        return this.getInfosByIdOID(oid, null);
    }

    public List<String> getInfosByIdOID(ASN1ObjectIdentifier oid, String defaultEmptyValue) {
        return this.getInfosByOID(oid, defaultEmptyValue);
    }
}

