/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache.test;

import java.io.Serializable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheType;
import org.slf4j.Logger;

public class PerformanceTest {
    private static int loops = 20;
    private static int tries = 50000;

    private static boolean isJenkins() {
        String j = System.getProperty("jenkins");
        if (j != null) {
            return "true".equalsIgnoreCase(j);
        }
        j = System.getenv("jenkins");
        if (j != null) {
            return "true".equalsIgnoreCase(j);
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        PerformanceTest.test(false);
    }

    public static void test(boolean allTestExecution) throws Exception {
        System.out.println("Jenkins ENV: " + PerformanceTest.isJenkins());
        System.out.println("allTestExecution: " + allTestExecution);
        boolean ambienteTestNonPerformante = PerformanceTest.isJenkins() || allTestExecution;
        System.out.println("ambienteTestPerformante: " + !ambienteTestNonPerformante);
        int maxSize = 50000;
        int lifeTime = 500;
        Cache eh = new Cache(CacheType.EH, "configEH");
        eh.setCacheSize(maxSize);
        eh.setItemLifeTime(lifeTime);
        eh.build();
        Logger log = LoggerWrapperFactory.getLogger(PerformanceTest.class);
        Cache.initialize(log, log, "org/openspcoop2/utils/cache/test/cache.ccf", null, null, "GOVWAY_HOME", "OPENSPCOOP2_CACHE_PROPERTIES", "OPENSPCOOP2_CONFIG_PROPERTIES");
        Cache jcs = new Cache(CacheType.JCS, "config");
        jcs.setCacheSize(maxSize);
        jcs.setItemLifeTime(lifeTime);
        jcs.build();
        Cache limitedHashMap = new Cache(CacheType.LimitedHashMap, "configLHASH");
        limitedHashMap.setCacheSize(maxSize);
        limitedHashMap.setItemLifeTime(lifeTime);
        limitedHashMap.build();
        long start = 0L;
        long end = 0L;
        long time = 0L;
        float tPer = 0.0f;
        long putTotalJCS = 0L;
        long getTotalJCS = 0L;
        long putTotalEHCache = 0L;
        long getTotalEHCache = 0L;
        long putTotalLimitedCache = 0L;
        long getTotalLimitedCache = 0L;
        String jcsDisplayName = "JCS";
        String ehCacheDisplayName = "";
        String limitedCacheDisplayName = "";
        try {
            for (int j = 0; j < loops; ++j) {
                int i;
                jcsDisplayName = "JCS      ";
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    jcs.put("key:" + i, (Serializable)((Object)("data" + i)));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(jcsDisplayName + " put time for " + tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    jcs.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(jcsDisplayName + " get time for " + tries + " = " + time + "; millis per = " + tPer);
                System.out.println("size: " + jcs.getItemCount());
                ehCacheDisplayName = "EHCache  ";
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    eh.put("key:" + i, (Serializable)((Object)("data" + i)));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalEHCache += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(ehCacheDisplayName + " put time for " + tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    eh.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalEHCache += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(ehCacheDisplayName + " get time for " + tries + " = " + time + "; millis per = " + tPer);
                System.out.println("size: " + eh.getItemCount());
                limitedCacheDisplayName = "LimitedHashMap  ";
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    limitedHashMap.put("key:" + i, (Serializable)((Object)("data" + i)));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalLimitedCache += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(limitedCacheDisplayName + " put time for " + tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < tries; ++i) {
                    limitedHashMap.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalLimitedCache += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(tries);
                System.out.println(limitedCacheDisplayName + " get time for " + tries + " = " + time + "; millis per = " + tPer);
                System.out.println("size: " + limitedHashMap.getItemCount());
                System.out.println("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e);
        }
        System.out.println("\n");
        Cache.printStatistics(System.out, "\n", "\n===========\n");
        long putAvJCS = putTotalJCS / (long)loops;
        long getAvJCS = getTotalJCS / (long)loops;
        long putAvEH = putTotalEHCache / (long)loops;
        long getAvEH = getTotalEHCache / (long)loops;
        long putAvLimited = putTotalLimitedCache / (long)loops;
        long getAvLimited = getTotalLimitedCache / (long)loops;
        System.out.println("Finished " + loops + " loops of " + tries + " gets and puts");
        System.out.println("\n");
        System.out.println("Put average for " + jcsDisplayName + "  = " + putAvJCS);
        System.out.println("Put average for " + ehCacheDisplayName + " = " + putAvEH);
        System.out.println("Put average for " + limitedCacheDisplayName + " = " + putAvLimited);
        float ratioPut = Float.intBitsToFloat((int)putAvLimited) / Float.intBitsToFloat((int)putAvJCS);
        float targetPut = 0.85f;
        String msg = limitedCacheDisplayName + " puts took " + ratioPut + " times the " + jcsDisplayName + ", the goal is <" + targetPut + "x";
        System.out.println(msg);
        if (ratioPut > targetPut) {
            if (ambienteTestNonPerformante) {
                System.out.println("WARNING!");
            } else {
                throw new Exception(msg);
            }
        }
        ratioPut = Float.intBitsToFloat((int)putAvLimited) / Float.intBitsToFloat((int)putAvEH);
        msg = limitedCacheDisplayName + " puts took " + ratioPut + " times the " + ehCacheDisplayName + ", the goal is <" + targetPut + "x";
        System.out.println(msg);
        if (ratioPut > targetPut) {
            if (ambienteTestNonPerformante) {
                System.out.println("WARNING!");
            } else {
                throw new Exception(msg);
            }
        }
        System.out.println("\n");
        System.out.println("Get average for  " + jcsDisplayName + "  = " + getAvJCS);
        System.out.println("Get average for " + ehCacheDisplayName + " = " + getAvEH);
        System.out.println("Get average for " + limitedCacheDisplayName + " = " + getAvLimited);
        float ratioGet = Float.intBitsToFloat((int)getAvLimited) / Float.intBitsToFloat((int)getAvJCS);
        float targetGet = 0.75f;
        msg = limitedCacheDisplayName + " gets took " + ratioGet + " times the " + jcsDisplayName + ", the goal is <" + targetGet + "x";
        System.out.println(msg);
        if (ratioGet > targetGet) {
            if (ambienteTestNonPerformante) {
                System.out.println("WARNING!");
            } else {
                throw new Exception(msg);
            }
        }
        ratioGet = Float.intBitsToFloat((int)getAvLimited) / Float.intBitsToFloat((int)getAvEH);
        msg = limitedCacheDisplayName + " gets took " + ratioGet + " times the " + ehCacheDisplayName + ", the goal is <" + targetGet + "x";
        System.out.println(msg);
        if (ratioGet > targetGet) {
            if (ambienteTestNonPerformante) {
                System.out.println("WARNING!");
            } else {
                throw new Exception(msg);
            }
        }
    }
}

