/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.date.DateManager;

public class LimitedHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int maxSize = -1;
    private int maxLifeTime = -1;
    private ElementDateInfo<K>[] elementInfos = null;
    private int startIx = -1;
    private int insIx = -1;
    private Semaphore semaphore = null;

    public LimitedHashMap(String cacheName, int maxSize, int maxLifeTime) {
        this.initElementInfos(cacheName, maxSize, maxLifeTime);
    }

    public LimitedHashMap(String cacheName, int maxSize, int maxLifeTime, int initialCapacity) {
        super(initialCapacity);
        this.initElementInfos(cacheName, maxSize, maxLifeTime);
    }

    public LimitedHashMap(String cacheName, int maxSize, int maxLifeTime, Map<? extends K, ? extends V> m) {
        super(m);
        this.initElementInfos(cacheName, maxSize, maxLifeTime);
    }

    public LimitedHashMap(String cacheName, int maxSize, int maxLifeTime, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.initElementInfos(cacheName, maxSize, maxLifeTime);
    }

    public LimitedHashMap(String cacheName, int maxSize, int maxLifeTime, int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
        this.initElementInfos(cacheName, maxSize, maxLifeTime);
    }

    private void initElementInfos(String cacheName, int maxSize, int maxLifeTime) {
        if (maxSize <= 0 && maxLifeTime > 0) {
            throw new IllegalArgumentException("Cannot use maxLifeTime without maxSize");
        }
        this.maxSize = maxSize;
        this.maxLifeTime = maxLifeTime;
        if (maxSize > 0) {
            this.elementInfos = new ElementDateInfo[maxSize];
            this.startIx = 0;
            this.insIx = 0;
        }
        this.semaphore = new Semaphore((String)(cacheName != null ? "LimitedHashMap_" + cacheName : "LimitedHashMap"));
    }

    private int previousCircular(int ix) {
        if (ix == 0) {
            return this.maxSize - 1;
        }
        return ix - 1;
    }

    private int nextCircular(int ix) {
        if (ix == this.maxSize - 1) {
            return 0;
        }
        return ix + 1;
    }

    private void decrementInsIx() {
        this.insIx = this.previousCircular(this.insIx);
    }

    private void incrementStartIx() {
        this.startIx = this.nextCircular(this.startIx);
    }

    private int posSize() {
        if (this.insIx < 0) {
            return 0;
        }
        if (this.startIx == this.insIx) {
            return this.elementInfos[this.startIx] != null ? this.maxSize : 0;
        }
        if (this.startIx < this.insIx) {
            return this.insIx - this.startIx;
        }
        return this.maxSize + this.insIx - this.startIx;
    }

    private void cleanUpExtraTime() {
        ElementDateInfo<K> oldestInfo;
        if (this.insIx < 0 || this.startIx < 0) {
            return;
        }
        long timeMillis = DateManager.getTimeMillis() - (long)(this.maxLifeTime * 1000);
        while (this.posSize() > 0 && (oldestInfo = this.elementInfos[this.startIx]).getTimeMillis() <= timeMillis) {
            K curKey = oldestInfo.getKey();
            Object removedValue = super.remove(curKey);
            if (removedValue == null) {
                throw new RuntimeException("fail to remove by cleanUp: " + String.valueOf(curKey));
            }
            this.removeElementInfo(curKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCleanUpExtraTime() {
        if (this.insIx < 0) {
            return;
        }
        if (this.posSize() <= 0) {
            return;
        }
        long timeMillis = DateManager.getTimeMillis() - (long)(this.maxLifeTime * 1000);
        ElementDateInfo<K> oldestInfo = this.elementInfos[this.startIx];
        if (oldestInfo != null && oldestInfo.getTimeMillis() <= timeMillis) {
            SemaphoreLock lock = this.semaphore.acquireThrowRuntime("cleanUpExtraTime");
            try {
                this.cleanUpExtraTime();
            }
            finally {
                this.semaphore.release(lock, "cleanUpExtraTime");
            }
        }
    }

    private void addElementInfo(K key) {
        ElementDateInfo<K> elInfo = new ElementDateInfo<K>(DateManager.getTimeMillis(), key);
        if (this.insIx >= 0) {
            int posIx = this.insIx;
            this.insIx = (this.insIx + 1) % this.maxSize;
            ElementDateInfo<K> startElInfo = this.elementInfos[this.startIx];
            if (posIx == this.startIx && startElInfo != null) {
                Object removedValue = super.remove(startElInfo.getKey());
                if (removedValue == null) {
                    throw new RuntimeException("fail to remove by add: " + String.valueOf(startElInfo.getKey()) + " adding " + String.valueOf(key));
                }
                this.incrementStartIx();
            }
        } else {
            throw new RuntimeException("Invalid insIx: not initialized");
        }
        this.elementInfos[posIx] = elInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeElementInfo(K key) {
        int posIx = -1;
        int size = this.posSize();
        int ix = this.startIx;
        for (int jx = 0; posIx < 0 && jx < size; ++jx) {
            if (this.elementInfos[ix] != null && this.elementInfos[ix].getKey().equals(key)) {
                posIx = ix;
            }
            ix = this.nextCircular(ix);
        }
        if (posIx < 0) {
            return;
        }
        int prevInsIx = this.previousCircular(this.insIx);
        if (posIx == prevInsIx) {
            this.elementInfos[prevInsIx] = null;
            this.decrementInsIx();
            return;
        } else if (posIx == this.startIx) {
            this.elementInfos[posIx] = null;
            this.incrementStartIx();
            return;
        } else if (posIx < this.startIx) {
            if (posIx >= prevInsIx) throw new RuntimeException("Invalid index position: " + posIx + " (startIx: " + this.startIx + ") (insIx: " + this.insIx);
            System.arraycopy(this.elementInfos, posIx + 1, this.elementInfos, posIx, prevInsIx - posIx);
            this.elementInfos[prevInsIx] = null;
            this.decrementInsIx();
            return;
        } else if (posIx < this.insIx) {
            if (this.startIx >= this.insIx) throw new RuntimeException("Invalid index position: " + posIx + " (startIx: " + this.startIx + ") (insIx: " + this.insIx);
            System.arraycopy(this.elementInfos, posIx + 1, this.elementInfos, posIx, prevInsIx - posIx);
            this.elementInfos[prevInsIx] = null;
            this.decrementInsIx();
            return;
        } else {
            System.arraycopy(this.elementInfos, posIx + 1, this.elementInfos, posIx, this.maxSize - 1 - posIx);
            if (this.insIx > 0) {
                this.elementInfos[this.maxSize - 1] = this.elementInfos[0];
                if (prevInsIx > 0) {
                    System.arraycopy(this.elementInfos, 1, this.elementInfos, 0, prevInsIx);
                }
            }
            this.elementInfos[prevInsIx] = null;
            this.decrementInsIx();
        }
    }

    private void updateElementInfo(K key) {
        this.removeElementInfo(key);
        this.addElementInfo(key);
    }

    @Override
    public V get(Object key) {
        if (this.maxLifeTime > 0) {
            this.syncCleanUpExtraTime();
        }
        return super.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("put");
        try {
            if (this.maxLifeTime > 0) {
                this.cleanUpExtraTime();
            }
            V res = super.put(key, value);
            if (this.maxSize > 0) {
                if (res == null) {
                    this.addElementInfo(key);
                } else {
                    this.updateElementInfo(key);
                }
            }
            V v = res;
            return v;
        }
        finally {
            this.semaphore.release(lock, "put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("remove");
        try {
            Object res;
            if (this.maxLifeTime > 0) {
                this.cleanUpExtraTime();
            }
            if ((res = super.remove(key)) != null) {
                this.removeElementInfo(key);
            }
            Object v = res;
            return v;
        }
        finally {
            this.semaphore.release(lock, "remove");
        }
    }

    private static class ElementDateInfo<K> {
        private final long timeMillis;
        private final K key;

        ElementDateInfo(long timeMillis, K key) {
            this.timeMillis = timeMillis;
            this.key = key;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public K getKey() {
            return this.key;
        }
    }
}

