/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openspcoop2.utils.ITimeoutNotifier;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.TimeoutInputStreamEngine;

public class TimeoutInputStream
extends FilterInputStream {
    public static final MapKey<String> EXCEPTION_KEY = Map.newMapKey("TimeoutIOException");
    public static final MapKey<String> ERROR_MSG_KEY = Map.newMapKey("TimeoutInputStream");
    public static final String ERROR_MSG = "Read timed out";

    public TimeoutInputStream(InputStream is, int timeoutMs) throws IOException {
        this(is, timeoutMs, null, null);
    }

    public TimeoutInputStream(InputStream is, int timeoutMs, Map<Object> ctx, ITimeoutNotifier notifier) throws IOException {
        this(is, timeoutMs, null, ctx, notifier);
    }

    public TimeoutInputStream(InputStream is, int timeoutMs, String prefixError, Map<Object> ctx, ITimeoutNotifier notifier) throws IOException {
        super(new TimeoutInputStreamEngine(is, timeoutMs, prefixError, ctx, notifier));
    }

    public InputStream getIsWrapped() {
        InputStream is = this.in;
        if (is instanceof TimeoutInputStreamEngine) {
            return ((TimeoutInputStreamEngine)is).getIsWrapped();
        }
        return is;
    }

    public void disableCheckTimeout() {
        InputStream is = this.in;
        if (is instanceof TimeoutInputStreamEngine) {
            ((TimeoutInputStreamEngine)is).disableCheckTimeout();
        }
    }

    public void updateThreshold(int timeoutMs) throws IOException {
        InputStream is = this.in;
        if (is instanceof TimeoutInputStreamEngine) {
            ((TimeoutInputStreamEngine)is).updateThreshold(timeoutMs);
        }
    }

    public void updateContext(Map<Object> ctx) {
        InputStream is = this.in;
        if (is instanceof TimeoutInputStreamEngine) {
            ((TimeoutInputStreamEngine)is).updateContext(ctx);
        }
    }

    public void updateNotifier(ITimeoutNotifier notifier) {
        InputStream is = this.in;
        if (is instanceof TimeoutInputStreamEngine) {
            ((TimeoutInputStreamEngine)is).updateNotifier(notifier);
        }
    }
}

