/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.utils.xml;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.herasaf.xacml.core.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaLoader {
    private static final Logger logger = LoggerFactory.getLogger(SchemaLoader.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    private static final String URL_PREFIX = "url:";

    public Schema loadSchemas(String[] schemaPaths) throws MalformedURLException, SAXException {
        Source[] schemaSources = new StreamSource[schemaPaths.length];
        for (int i = 0; i < schemaPaths.length; ++i) {
            String schemaPath = schemaPaths[i].trim();
            schemaSources[i] = this.loadSource(schemaPath);
        }
        return this.createSchema(schemaSources);
    }

    private Source loadSource(String schemaPath) throws MalformedURLException {
        Source schemaSource;
        if (this.isUrlPath(schemaPath)) {
            schemaSource = this.loadUrlSource(schemaPath);
        } else if (this.isFilePath(schemaPath)) {
            schemaSource = this.loadFileSource(schemaPath);
        } else if (this.isClassPath(schemaPath)) {
            schemaSource = this.loadClasspathSource(schemaPath);
        } else {
            logger.warn("No prefix (file: || url: || classpath:) given for schema for JAXB validation. Falling back to classpath:{}", (Object)this.ensureLeadingSlash(schemaPath));
            schemaSource = this.loadClasspathSource(schemaPath);
        }
        return schemaSource;
    }

    private boolean isClassPath(String schemaPath) {
        return schemaPath.regionMatches(true, 0, CLASSPATH_PREFIX, 0, CLASSPATH_PREFIX.length());
    }

    private Source loadClasspathSource(String schemaPath) {
        InputStream schemaInput = JAXBMarshallerConfiguration.class.getResourceAsStream(this.ensureLeadingSlash(schemaPath = this.removePrefix(schemaPath, CLASSPATH_PREFIX)));
        if (schemaInput == null) {
            throw new IllegalArgumentException(schemaPath);
        }
        return new StreamSource(schemaInput);
    }

    private boolean isFilePath(String schemaPath) {
        return schemaPath.regionMatches(true, 0, FILE_PREFIX, 0, FILE_PREFIX.length());
    }

    private Source loadFileSource(String schemaPath) {
        File file = new File(this.removePrefix(schemaPath, FILE_PREFIX));
        StreamSource schemaSource = new StreamSource(file);
        return schemaSource;
    }

    private boolean isUrlPath(String schema) {
        return schema.regionMatches(true, 0, URL_PREFIX, 0, URL_PREFIX.length());
    }

    private Source loadUrlSource(String schemaPath) throws MalformedURLException {
        URL url = new URL(this.removePrefix(schemaPath, URL_PREFIX));
        StreamSource schemaSource = new StreamSource(url.toExternalForm());
        return schemaSource;
    }

    private String removePrefix(String schemaPath, String prefix) {
        if (schemaPath.contains(schemaPath)) {
            schemaPath = schemaPath.substring(prefix.length());
        }
        return schemaPath;
    }

    private String ensureLeadingSlash(String input) {
        return input.startsWith("/") ? input : "/" + input;
    }

    private Schema createSchema(Source ... source) throws SAXException {
        if (ValidationUtils.isEmpty(source)) {
            throw new IllegalArgumentException("The parameter source must contain at least one value");
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return sf.newSchema(source);
    }
}

