/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.utils;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.validation.Schema;
import org.herasaf.xacml.core.utils.ValidationUtils;
import org.herasaf.xacml.core.utils.xml.SchemaLoader;
import org.xml.sax.SAXException;

public class SchemaConfiguration {
    private List<String> schemaLocation = new ArrayList<String>();
    private List<String> schemaPaths = new ArrayList<String>();
    private Schema schema;

    public void setSchemaLocation(List<String> schemaLocation) {
        this.schemaLocation = new ArrayList<String>();
        for (String str : schemaLocation) {
            this.schemaLocation.add(str.trim());
        }
    }

    public String getSchemaLocationAsString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.schemaLocation) {
            sb.append(str);
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setSchemaByPath(String ... schemaPaths) throws SAXException, MalformedURLException {
        if (ValidationUtils.isEmpty(schemaPaths)) {
            throw new IllegalArgumentException("The parameter SchemaPaths must contain at least one path.");
        }
        this.schemaPaths = Arrays.asList(schemaPaths);
        this.schema = new SchemaLoader().loadSchemas(schemaPaths);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SchemaConfiguration [");
        builder.append("schema = ");
        builder.append(this.schemaPaths.toString());
        builder.append(", ");
        builder.append("schemaLocation = ");
        builder.append(this.getSchemaLocationAsString());
        builder.append("]");
        return builder.toString();
    }
}

