/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.herasaf.xacml.core.types.IPAddress;
import org.herasaf.xacml.core.types.PortRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4Address
extends IPAddress {
    private static final Logger logger = LoggerFactory.getLogger(IPv4Address.class);
    private static String hostPart = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static String networkPart = "/(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static String possiblePortNumber = "6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0";
    private static String portPart = ":((" + possiblePortNumber + ")?[-]?(" + possiblePortNumber + ")?)";
    private static final String REGEX = "^" + hostPart + "(" + networkPart + ")?(" + portPart + ")?$";
    private InetAddress ip;
    private InetAddress mask;
    private PortRange portRange;

    public IPv4Address(String value) {
        if (!value.matches(REGEX)) {
            IllegalArgumentException e = new IllegalArgumentException(value + " is not a valid IP Address.");
            logger.warn(e.getMessage());
            throw e;
        }
        try {
            int slashPosition = value.indexOf("/");
            int colonPosition = value.indexOf(":");
            if (slashPosition != -1 && colonPosition != -1) {
                this.ip = Inet4Address.getByName(value.substring(0, slashPosition));
                this.mask = Inet4Address.getByName(value.substring(slashPosition + 1, colonPosition));
                this.portRange = new PortRange(value.substring(colonPosition + 1, value.length()));
            } else if (slashPosition != -1) {
                this.ip = Inet4Address.getByName(value.substring(0, slashPosition));
                this.mask = Inet4Address.getByName(value.substring(slashPosition + 1, value.length()));
            } else if (colonPosition != -1) {
                this.ip = Inet4Address.getByName(value.substring(0, colonPosition));
                this.portRange = new PortRange(value.substring(colonPosition + 1, value.length()));
            } else {
                this.ip = Inet4Address.getByName(value.substring(0, value.length()));
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ip.getHostAddress());
        if (this.mask != null) {
            builder.append("/");
            builder.append(this.mask.getHostAddress());
        }
        if (this.portRange != null) {
            builder.append(":");
            builder.append(this.portRange.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

