/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.targetMatcher.impl;

import java.util.List;
import org.herasaf.xacml.core.ProcessingException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.function.Function;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.ActionType;
import org.herasaf.xacml.core.policy.impl.ActionsType;
import org.herasaf.xacml.core.policy.impl.AttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.AttributeValueType;
import org.herasaf.xacml.core.policy.impl.EnvironmentType;
import org.herasaf.xacml.core.policy.impl.EnvironmentsType;
import org.herasaf.xacml.core.policy.impl.Match;
import org.herasaf.xacml.core.policy.impl.ResourceType;
import org.herasaf.xacml.core.policy.impl.ResourcesType;
import org.herasaf.xacml.core.policy.impl.SubjectType;
import org.herasaf.xacml.core.policy.impl.SubjectsType;
import org.herasaf.xacml.core.policy.impl.TargetType;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetMatcherImpl
implements TargetMatcher {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TargetMatcherImpl.class);

    @Override
    public TargetMatchingResult match(RequestType request, TargetType target, EvaluationContext evaluationContext) throws SyntaxException, ProcessingException, MissingAttributeException {
        if (target != null) {
            logger.debug("Starting subjects match.");
            boolean subjectsMatches = this.subjectsMatch(target.getSubjects(), request, evaluationContext);
            logger.debug("Subjects match resulted in: {}", (Object)subjectsMatches);
            if (!subjectsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            logger.debug("Starting recources match.");
            boolean resourcesMatches = this.resourcesMatch(target.getResources(), request, evaluationContext);
            logger.debug("Resources match resulted in: {}", (Object)resourcesMatches);
            if (!resourcesMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            logger.debug("Starting actions match.");
            boolean actionsMatches = this.actionMatch(target.getActions(), request, evaluationContext);
            logger.debug("Actions match resulted in: {}", (Object)actionsMatches);
            if (!actionsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            logger.debug("Starting environments match.");
            boolean environmentsMatches = this.environmentMatch(target.getEnvironments(), request, evaluationContext);
            logger.debug("Environments match resulted in: {}", (Object)environmentsMatches);
            if (!environmentsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
        }
        return TargetMatchingResult.MATCH;
    }

    private boolean subjectsMatch(SubjectsType subjects, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (subjects == null) {
            logger.debug("No subjects present.");
            return true;
        }
        for (int i = 0; i < subjects.getSubjects().size(); ++i) {
            SubjectType targetSubject = subjects.getSubjects().get(i);
            logger.debug("Starting subject match. (id:{})", (Object)targetSubject);
            boolean matches = this.match(targetSubject.getSubjectMatches(), request, evaluationContext);
            if (!matches) continue;
            logger.debug("Subject match resulted in: {}", (Object)matches);
            return true;
        }
        return false;
    }

    private boolean resourcesMatch(ResourcesType resources, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (resources == null) {
            logger.debug("No resources present.");
            return true;
        }
        for (int i = 0; i < resources.getResources().size(); ++i) {
            ResourceType targetResource = resources.getResources().get(i);
            logger.debug("Starting resource match. (id:{})", (Object)targetResource);
            boolean matches = this.match(targetResource.getResourceMatches(), request, evaluationContext);
            if (!matches) continue;
            logger.debug("Resource match resulted in: {}", (Object)matches);
            return true;
        }
        return false;
    }

    private boolean actionMatch(ActionsType actions, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (actions == null) {
            logger.debug("No actions present.");
            return true;
        }
        for (int i = 0; i < actions.getActions().size(); ++i) {
            ActionType targetAction = actions.getActions().get(i);
            logger.debug("Starting action match. (id:{})", (Object)targetAction);
            boolean matches = this.match(targetAction.getActionMatches(), request, evaluationContext);
            if (!matches) continue;
            logger.debug("Action match resulted in: {}", (Object)matches);
            return true;
        }
        return false;
    }

    private boolean environmentMatch(EnvironmentsType environments, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (environments == null) {
            logger.debug("No environments present.");
            return true;
        }
        for (int i = 0; i < environments.getEnvironments().size(); ++i) {
            EnvironmentType targetEnvironment = environments.getEnvironments().get(i);
            logger.debug("Starting environment match. (id:{})", (Object)targetEnvironment);
            boolean matches = this.match(targetEnvironment.getEnvironmentMatches(), request, evaluationContext);
            if (!matches) continue;
            logger.debug("Environment match resulted in: {}", (Object)matches);
            return true;
        }
        return false;
    }

    private boolean match(List<? extends Match> matches, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        for (int i = 0; i < matches.size(); ++i) {
            Match match = matches.get(i);
            Function matchFunction = match.getMatchFunction();
            logger.debug("Matching with function: {}", (Object)matchFunction);
            if (matchFunction == null) {
                String message = "Match function cannot be retrieved.";
                logger.error(message);
                throw new SyntaxException(message);
            }
            AttributeDesignatorType designator = match.getAttributeDesignator();
            List requestAttributeValues = (List)designator.handle(request, evaluationContext);
            if (requestAttributeValues.size() == 0) {
                logger.debug("Request did not contain the required attributes.");
                return false;
            }
            boolean matchMatches = false;
            for (int k = 0; k < requestAttributeValues.size(); ++k) {
                Object requestAttributeValue = requestAttributeValues.get(k);
                AttributeValueType policyAttributeValue = match.getAttributeValue();
                matchMatches = (Boolean)matchFunction.handle(policyAttributeValue.getDataType().convertTo(policyAttributeValue.getContent()), requestAttributeValue);
                logger.debug("Match function resulted in {} with policy attribute datatype:{} value:{} and request attribute value:{}", new Object[]{matchMatches, policyAttributeValue.getDataType(), policyAttributeValue.getContent().get(0), requestAttributeValue});
                if (matchMatches) break;
            }
            if (matchMatches) continue;
            return false;
        }
        return true;
    }
}

