/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP.initializers.jaxb.typeadapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.InitializationException;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJaxbTypeAdapterInitializer<T>
implements Initializer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJaxbTypeAdapterInitializer.class);

    @Override
    public final void run(SimplePDPConfiguration configuration) {
        Map<String, T> instancesMap = this.createTypeInstances();
        this.setInstancesIntoTypeAdapter(instancesMap);
    }

    protected final List<T> createInstances(Class<?> ... types) {
        Class<T>[] concreteTypes;
        ArrayList<T> instances = new ArrayList<T>();
        for (Class<T> type : concreteTypes = this.createTypedArray(types)) {
            T instance = this.createInstance(type);
            instances.add(instance);
        }
        return instances;
    }

    private Class<T>[] createTypedArray(Class<?> ... types) {
        Class<?>[] concreteTypes;
        try {
            Class<?>[] concreteTypesTmp;
            concreteTypes = concreteTypesTmp = types;
        }
        catch (ClassCastException e) {
            String message = "The given types do not match the intented type of the concrete JaxbTypeAdapterInitializer.";
            logger.error(message, (Throwable)e);
            throw new InitializationException(message, e);
        }
        return concreteTypes;
    }

    protected abstract void setInstancesIntoTypeAdapter(Map<String, T> var1);

    protected abstract Map<String, T> createTypeInstances();

    private T createInstance(Class<T> type) {
        T instance;
        try {
            instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Unable to instantiate object of type [%s]", type.getName());
            logger.error(message);
            throw new InitializationException(message, e);
        }
        return instance;
    }
}

