/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP.initializers;

import java.util.HashSet;
import java.util.Set;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.herasaf.xacml.core.simplePDP.initializers.jaxb.JaxbContextInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.jaxb.typeadapter.xacml20.datatypes.Xacml20DefaultDataTypesJaxbInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.jaxb.typeadapter.xacml20.functions.Xacml20DefaultFunctionsJaxbInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.jaxb.typeadapter.xacml20.policycombiningalgorithms.Xacml20DefaultPolicyCombiningAlgorithmsJaxbInitializer;
import org.herasaf.xacml.core.simplePDP.initializers.jaxb.typeadapter.xacml20.rulecombiningalgorithms.Xacml20DefaultRuleCombiningAlgorithmsJaxbInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializerExecutor {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InitializerExecutor.class);
    private static Set<Initializer> initializers;
    private static boolean initializersDidRun;

    private InitializerExecutor() {
    }

    public static void runInitializers() {
        InitializerExecutor.runInitializers(null);
    }

    public static synchronized void runInitializers(SimplePDPConfiguration configuration) {
        if (!initializersDidRun) {
            Set<Initializer> initializers = InitializerExecutor.getInitializers();
            InitializerExecutor.initialize(configuration, initializers);
            initializersDidRun = true;
        }
    }

    public static Set<Initializer> getDefaultInitializers() {
        HashSet<Initializer> initializers = new HashSet<Initializer>();
        initializers.add(new Xacml20DefaultFunctionsJaxbInitializer());
        initializers.add(new Xacml20DefaultDataTypesJaxbInitializer());
        initializers.add(new Xacml20DefaultRuleCombiningAlgorithmsJaxbInitializer());
        initializers.add(new Xacml20DefaultPolicyCombiningAlgorithmsJaxbInitializer());
        initializers.add(new JaxbContextInitializer());
        return initializers;
    }

    public static synchronized void setInitalizers(Set<Initializer> initalizers) {
        LOGGER.info("Custom initializers are in use.");
        if (initalizers != initializers) {
            initializers = initalizers;
            initializersDidRun = false;
        }
    }

    public static synchronized void resetInitializers() {
        initializers = null;
        initializersDidRun = false;
    }

    private static Set<Initializer> getInitializers() {
        Set<Initializer> initializersToReturn = initializers == null ? InitializerExecutor.getDefaultInitializers() : initializers;
        return initializersToReturn;
    }

    private static void initialize(SimplePDPConfiguration configuration, Set<Initializer> initializers) {
        for (Initializer initializer : initializers) {
            initializer.run(configuration);
        }
    }

    static {
        initializersDidRun = false;
    }
}

