/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.proxy;

import java.util.Date;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class TimerSvecchiamentoOperazioniRemoteLib {
    private static TimerState state = TimerState.OFF;
    private OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
    private String tipoDatabase = this.op2Properties.getDatabaseType();
    private Logger logCore = null;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private Date oldest;
    private IProxyOperationService proxyOperationService;

    public static TimerState getState() {
        return state;
    }

    public static void setState(TimerState stateParam) {
        state = stateParam;
    }

    private void logCoreInfo(String msg) {
        if (this.logCore != null) {
            this.logCore.info(msg);
        }
    }

    private void logTimerError(String msgErrore, Throwable e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, e);
        }
    }

    private void logTimerError(String msgErrore) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore);
        }
    }

    private void logTimerInfo(String msg) {
        if (this.logTimer != null) {
            this.logTimer.info(msg);
        }
    }

    public TimerSvecchiamentoOperazioniRemoteLib(Logger logTimer, MsgDiagnostico msgDiag, IProxyOperationService proxyOperationService, Date oldest) throws TimerException {
        if (this.tipoDatabase == null) {
            throw new TimerException("Tipo Database non definito");
        }
        boolean debug = this.op2Properties.isProxyReadJMXResourcesAsyncProcessByTimerDebug();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopGestoreOperazioniRemote(debug);
        this.logTimer = logTimer;
        this.msgDiag = msgDiag;
        this.oldest = oldest;
        this.proxyOperationService = proxyOperationService;
    }

    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimerError("[TimerSvecchiamentoOperazioniRemote] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimerError(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimerError("[TimerSvecchiamentoOperazioniRemote] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimerError("[TimerSvecchiamentoOperazioniRemote] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        boolean enabled = TimerState.ENABLED.equals((Object)state);
        if (!enabled) {
            this.emitDiagnosticLog("disabilitato");
            return;
        }
        long startControlloTimer = DateManager.getTimeMillis();
        try {
            this.process();
            long endControlloTimer = DateManager.getTimeMillis();
            long diff = endControlloTimer - startControlloTimer;
            this.logTimerInfo("Svecchiamento operazioni remote terminata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerSvecchiamentoOperazioniRemoteLib");
            this.logTimerError("Riscontrato errore durante lo svecchiamento delle operazioni remote: " + e.getMessage(), e);
        }
    }

    private void process() throws CoreException {
        try {
            long startGenerazione = DateManager.getTimeMillis();
            this.emitDiagnosticLog("svecchiamento.inCorso");
            int eliminate = this.proxyOperationService.clear(this.oldest);
            this.msgDiag.addKeyword("@NUMERO_OPERAZIONI@", "" + eliminate);
            long endGenerazione = DateManager.getTimeMillis();
            String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startGenerazione), (boolean)true);
            this.msgDiag.addKeyword("@TEMPO_GESTIONE@", tempoImpiegato);
            this.emitDiagnosticLog("svecchiamento.effettuata");
        }
        catch (Exception e) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
            this.emitDiagnosticLog("svecchiamento.fallita");
        }
    }

    private void emitDiagnosticLog(String code) {
        this.msgDiag.logPersonalizzato(code);
        String msg = this.msgDiag.getMessaggio_replaceKeywords(code);
        this.emitLog(msg);
    }

    private void emitLog(String msg) {
        this.logCoreInfo(msg);
        this.logTimerInfo(msg);
    }
}

