/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.proxy;

import java.util.Date;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperationServiceFactory;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.proxy.TimerSvecchiamentoOperazioniRemoteLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerSvecchiamentoOperazioniRemote
extends BaseThread {
    public static final String ID_MODULO = "TimerSvecchiamentoOperazioniRemote";
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private OpenSPCoop2Properties op2Properties = null;
    private int olderThanMinutes;
    private IProxyOperationService proxyOperationService = null;

    private void logError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }

    public TimerSvecchiamentoOperazioniRemote(long timeout) throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerSvecchiamentoOperazioniAsincrone.");
            this.msgDiag.addKeyword("@ID_TIMER@", ID_MODULO);
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.op2Properties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        String className = this.op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerServiceImplClass();
        try {
            this.proxyOperationService = ProxyOperationServiceFactory.newInstance(className, this.logTimer);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer-ProxyOperationService");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del ProxyOperationService: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.olderThanMinutes = this.op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerCheckOldRecordDeleteOlderThanMinutes();
        this.setTimeout((int)timeout);
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            long oldestMs = DateManager.getTimeMillis() - (long)(this.olderThanMinutes * 60 * 1000);
            Date oldest = new Date(oldestMs);
            this.msgDiag.addKeyword("@DATA_AGGIORNAMENTO@", DateUtils.getSimpleDateFormatMs().format(oldest));
            TimerSvecchiamentoOperazioniRemoteLib timer = new TimerSvecchiamentoOperazioniRemoteLib(this.logTimer, this.msgDiag, this.proxyOperationService, oldest);
            timer.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerSvecchiamentoOperazioniRemote.check()");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }
}

