/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.pdnd;

import java.util.List;
import org.openspcoop2.pdd.config.PDNDConfig;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreCacheChiaviPDNDLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestoreCacheChiaviPDND
extends BaseThread {
    public static final String ID_MODULO = "TimerGestoreCacheChiaviPDND";
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private List<PDNDConfig> remoteStores;

    private void logError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }

    public TimerGestoreCacheChiaviPDND(long timeout, List<PDNDConfig> remoteStores) throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreChiaviPDND.");
            this.msgDiag.addKeyword("@ID_TIMER@", ID_MODULO);
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        this.remoteStores = remoteStores;
        this.setTimeout((int)timeout);
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            if (this.remoteStores != null && !this.remoteStores.isEmpty()) {
                for (PDNDConfig remoteStore : this.remoteStores) {
                    String remoteStoreName = remoteStore.getRemoteStoreConfig().getStoreName();
                    this.msgDiag.addKeyword("@ID_REMOTE_STORE@", remoteStoreName);
                    this.process(remoteStoreName, remoteStore);
                }
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreCacheChiaviPDNDLib.check()");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }

    private void process(String remoteStoreName, PDNDConfig remoteStore) {
        try {
            TimerGestoreCacheChiaviPDNDLib timer = new TimerGestoreCacheChiaviPDNDLib(this.logTimer, this.msgDiag, remoteStore.getRemoteStoreConfig(), remoteStore.getRemoteKeyType());
            timer.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreCacheChiaviPDNDLib.check(" + remoteStoreName + ")");
            this.logError("Errore generale (" + remoteStoreName + "): " + e.getMessage(), e);
        }
    }
}

