/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerGestoreRepositoryBusteLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestoreRepositoryBusteThread
extends BaseThread {
    private long scadenzaMessaggio = 7200L;
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;

    public TimerGestoreRepositoryBusteThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance("GestoreRepositoryBuste");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryBuste.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_BUSTE@", "GestoreRepositoryBuste");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.setTimeout((int)this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi());
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        String s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreRepositoryBusteAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestoreRepositoryBusteAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestoreRepositoryBusteLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            TimerGestoreRepositoryBusteLib gestoreMessaggiLib = new TimerGestoreRepositoryBusteLib(this.msgDiag, this.logTimer, this.propertiesReader, this.logQuery, this.limit, this.orderByQuery);
            gestoreMessaggiLib.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreRepositoryBusteLib.check()");
            this.logTimer.error("Errore generale: " + e.getMessage(), (Throwable)e);
        }
    }
}

