/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.service;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.soap.SOAPFault;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInAcceptRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamento;
import org.openspcoop2.pdd.services.DumpRaw;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherInfo;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorOutMessage;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiServiceUtils;
import org.openspcoop2.pdd.services.service.RicezionePropertiesConfig;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerException;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerMessage;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerUtility;
import org.openspcoop2.pdd.services.skeleton.ProtocolHeaderInfo;
import org.openspcoop2.protocol.basic.registry.ServiceIdentificationReader;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativiIntegrationManagerService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntegrationManagerMessage process(String tipoOperazione, String portaDelegata, IntegrationManagerMessage msg, String idInvocazionePerRiferimento, Logger logCore, HttpServletRequest req, HttpServletResponse res, IProtocolFactory<?> protocolFactory, Date dataAccettazioneRichiesta, Date dataIngressoRichiesta) throws IntegrationManagerException {
        IntegrationManagerMessage integrationManagerMessage;
        String idModulo = "RicezioneContenutiApplicativi" + IntegrationManager.ID_MODULO;
        ErroriProperties erroriProperties = null;
        try {
            erroriProperties = ErroriProperties.getInstance((Logger)logCore);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OpenSPCoop2Properties openSPCoopProperties = OpenSPCoop2Properties.getInstance();
        if (openSPCoopProperties == null) {
            String msgError = "Inizializzazione di GovWay non correttamente effettuata: OpenSPCoopProperties";
            logCore.error(msgError);
            try {
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, erroriProperties);
            }
            catch (Throwable eError) {
                logCore.error("Errore generazione SOAPFault", eError);
                throw new RuntimeException(eError);
            }
        }
        RequestInfo requestInfo = null;
        try {
            URLProtocolContextImpl urlProtocolContext = new URLProtocolContextImpl(req, logCore, true, true, openSPCoopProperties.getCustomContexts());
            urlProtocolContext.setInterfaceName(portaDelegata);
            if (protocolFactory == null) {
                throw new Exception("ProtocolFactory is null");
            }
            requestInfo = ConnectorUtils.getRequestInfo(protocolFactory, (URLProtocolContext)urlProtocolContext);
            if (requestInfo == null) {
                throw new Exception("RequestInfo is null");
            }
        }
        catch (Exception e) {
            String msgError = "Lettura RequestInfo non riuscita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msgError);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
        }
        PreInAcceptRequestContext preInAcceptRequestContext = new PreInAcceptRequestContext();
        preInAcceptRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        preInAcceptRequestContext.setIdModulo(idModulo);
        preInAcceptRequestContext.setRequestInfo(requestInfo);
        preInAcceptRequestContext.setLogCore(logCore);
        preInAcceptRequestContext.setReq(null);
        GestoreHandlers.preInRequest(preInAcceptRequestContext, logCore, logCore);
        ConfigurazionePdDManager configPdDManager = null;
        try {
            configPdDManager = ConfigurazionePdDManager.getInstance();
            if (configPdDManager == null || !configPdDManager.isInitializedConfigurazionePdDReader()) {
                throw new Exception("ConfigurazionePdDManager not initialized");
            }
        }
        catch (Throwable e) {
            String msgError = "Inizializzazione di GovWay non correttamente effettuata: ConfigurazionePdDManager";
            logCore.error(msgError, e);
            try {
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, erroriProperties);
            }
            catch (Throwable eError) {
                logCore.error("Errore generazione SOAPFault", eError);
                throw new RuntimeException(eError);
            }
        }
        ServiceIdentificationReader serviceIdentificationReader = null;
        try {
            serviceIdentificationReader = ServicesUtils.getServiceIdentificationReader(logCore, requestInfo, configPdDManager.getRegistroServiziManager(), configPdDManager);
        }
        catch (Exception e) {
            String msgError = "Inizializzazione RegistryReader fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msgError, (Throwable)e);
            try {
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, erroriProperties);
            }
            catch (Throwable eError) {
                logCore.error("Errore generazione SOAPFault", eError);
                throw new RuntimeException(eError);
            }
        }
        RicezioneContenutiApplicativiContext context = null;
        try {
            context = new RicezioneContenutiApplicativiContext(IDService.PORTA_DELEGATA_INTEGRATION_MANAGER, dataAccettazioneRichiesta, requestInfo);
            String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
            if (openSPCoopProperties.isTransazioniEnabled()) {
                TransactionContext.createTransaction(idTransazione, "RicezioneContenutiApplicativiIM.1");
            }
            requestInfo.setIdTransazione(idTransazione);
        }
        catch (Throwable e) {
            context = null;
        }
        String nomePorta = portaDelegata;
        MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.DELEGATA, IntegrationManager.ID_MODULO, nomePorta, requestInfo, configPdDManager);
        msgDiag.setPrefixMsgPersonalizzati("integrationManager.");
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (context != null) {
            msgDiag.setPddContext(context.getPddContext(), protocolFactory);
        }
        try {
            msgDiag.logPersonalizzato("ricezioneRichiesta.firstLog");
        }
        catch (Exception e) {
            logCore.error("Errore generazione diagnostico di ingresso", (Throwable)e);
        }
        GestoreHandlers.emitDiagnostic(msgDiag, preInAcceptRequestContext, context != null ? context.getPddContext() : null, logCore, logCore);
        RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(logCore, idModulo, requestInfo);
        }
        catch (Exception e) {
            String msgError = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            msgDiag.logErroreGenerico(e, "Inizializzazione Generatore Errore");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, erroriProperties);
        }
        try {
            msgDiag.mediumDebug("Accesso configurazione della richiesta in corso...");
        }
        catch (Exception e) {
            logCore.error("Errore generazione diagnostico", (Throwable)e);
        }
        ConnectorDispatcherInfo cInfo = null;
        try {
            cInfo = RicezioneContenutiApplicativiServiceUtils.updatePortaDelegataRequestInfo(requestInfo, logCore, null, null, generatoreErrore, serviceIdentificationReader, msgDiag, context != null ? context.getPddContext() : null);
            if (cInfo != null) {
                try {
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
                }
                catch (Throwable eError) {
                    logCore.error("Errore generazione SOAPFault", eError);
                    throw new RuntimeException(eError);
                }
            }
        }
        catch (Exception e) {
            String msgError = "Aggiornamento RequestInfo fallito: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msgError, (Throwable)e);
            try {
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
            }
            catch (Throwable eError) {
                logCore.error("Errore generazione SOAPFault", eError);
                throw new RuntimeException(eError);
            }
        }
        finally {
            if (cInfo != null) {
                RicezioneContenutiApplicativiServiceUtils.emitTransaction(context, logCore, idModulo, IDService.PORTA_DELEGATA_INTEGRATION_MANAGER, protocolFactory, requestInfo, null, dataAccettazioneRichiesta, cInfo);
            }
        }
        DumpRaw dumpRaw = null;
        try {
            try {
                msgDiag.mediumDebug("Lettura configurazione dump binario ...");
            }
            catch (Exception e) {
                logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            boolean dumpBinario = configPdDManager.dumpBinarioPD();
            PortaDelegata pd = null;
            if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(requestInfo.getProtocolContext().getInterfaceName());
                pd = configPdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
            }
            try {
                msgDiag.mediumDebug("Lettura configurazione dump ...");
            }
            catch (Exception e) {
                logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            DumpConfigurazione dumpConfigurazione = configPdDManager.getDumpConfigurazione(pd);
            ConfigurazioneTracciamento configurazioneTracciamento = new ConfigurazioneTracciamento(logCore, configPdDManager, pd);
            boolean fileTraceHeaders = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioHeaderEnabled();
            boolean fileTracePayload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioPayloadEnabled();
            dumpRaw = new DumpRaw(logCore, requestInfo.getIdentitaPdD(), idModulo, TipoPdD.DELEGATA, dumpBinario, dumpConfigurazione, fileTraceHeaders, fileTracePayload);
        }
        catch (Throwable e) {
            String msgError = "Inizializzazione di GovWay non correttamente effettuata: DumpRaw";
            logCore.error(msgError, e);
            try {
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgError, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, erroriProperties);
            }
            catch (Throwable eError) {
                logCore.error("Errore generazione SOAPFault", eError);
                throw new RuntimeException(eError);
            }
        }
        OpenSPCoopState stato = null;
        try {
            try {
                msgDiag.mediumDebug("Creazione contesto ...");
            }
            catch (Exception e) {
                logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            if (context == null) {
                context = new RicezioneContenutiApplicativiContext(IDService.PORTA_DELEGATA_INTEGRATION_MANAGER, dataAccettazioneRichiesta, requestInfo);
            }
            if (preInAcceptRequestContext != null && preInAcceptRequestContext.getPreContext() != null && !preInAcceptRequestContext.getPreContext().isEmpty()) {
                context.getPddContext().addAll((org.openspcoop2.utils.Map)preInAcceptRequestContext.getPreContext(), false);
            }
            context.setDataIngressoRichiesta(dataIngressoRichiesta);
            context.getPddContext().addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
            context.getPddContext().addObject(Costanti.REQUEST_INFO, requestInfo);
            RicezionePropertiesConfig rConfig = RicezioneContenutiApplicativiServiceUtils.readPropertiesConfig(requestInfo, logCore, null);
            if (rConfig != null) {
                if (rConfig.getApiImplementation() != null && !rConfig.getApiImplementation().isEmpty()) {
                    context.getPddContext().addObject(Costanti.PROPRIETA_CONFIGURAZIONE, rConfig.getApiImplementation());
                }
                if (rConfig.getSoggettoFruitore() != null && !rConfig.getSoggettoFruitore().isEmpty()) {
                    context.getPddContext().addObject(Costanti.PROPRIETA_SOGGETTO_FRUITORE, rConfig.getSoggettoFruitore());
                }
                if (rConfig.getSoggettoErogatore() != null && !rConfig.getSoggettoErogatore().isEmpty()) {
                    context.getPddContext().addObject(Costanti.PROPRIETA_SOGGETTO_EROGATORE, rConfig.getSoggettoErogatore());
                }
            }
            context.getPddContext().addObject(CostantiPdD.TIPO_OPERAZIONE_IM, tipoOperazione);
            context.setTipoPorta(TipoPdD.DELEGATA);
            msgDiag.setPddContext(context.getPddContext(), protocolFactory);
            if (dumpRaw != null && dumpRaw.isActiveDump()) {
                dumpRaw.setPddContext(msgDiag.getPorta(), context.getPddContext());
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "invocaPortaDelegata_engine(" + tipoOperazione + ").newRicezioneContenutiApplicativiContext()");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
        }
        try {
            if (openSPCoopProperties.isTransazioniEnabled()) {
                TransactionContext.createTransaction((String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE), "RicezioneContenutiApplicativiIM.2");
            }
        }
        catch (Exception e) {
            logCore.error("Errore durante la creazione della transazione", (Throwable)e);
        }
        try {
            msgDiag.logPersonalizzato("ricezioneRichiesta.firstAccessRequestStream");
        }
        catch (Exception e) {
            logCore.error("Errore generazione diagnostico di ingresso (stream access)", (Throwable)e);
        }
        if (dumpRaw != null && dumpRaw.isActiveDump()) {
            dumpRaw.serializeContext(context, protocolFactory.getProtocol());
        }
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, context.getPddContext());
        context.getPddContext().addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        context.getPddContext().addObject(Costanti.TIPO_OPERAZIONE_IM, tipoOperazione.toString());
        context.getPddContext().addObject(Costanti.ID_MESSAGGIO, idInvocazionePerRiferimento);
        context.getPddContext().addObject(Costanti.PORTA_DELEGATA, portaDelegata);
        context.getPddContext().addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
        EsitoTransazione esito = null;
        String errore = null;
        OpenSPCoop2Message msgRequest = null;
        OpenSPCoop2Message msgResponse = null;
        IntegrationManagerMessage msgReturn = null;
        Object descrizioneSoapFault = "";
        URLProtocolContextImpl urlProtocolContext = null;
        try {
            PreInRequestContext preInRequestContext = new PreInRequestContext(context.getPddContext());
            preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
            preInRequestContext.setIdModulo(idModulo);
            preInRequestContext.setProtocolFactory(protocolFactory);
            preInRequestContext.setRequestInfo(requestInfo);
            HashMap<String, Object> transportContext = new HashMap<String, Object>();
            HttpServletConnectorInMessage httpIn = null;
            try {
                httpIn = new HttpServletConnectorInMessage(requestInfo, req, IntegrationManager.ID_SERVICE, IntegrationManager.ID_MODULO);
                transportContext.put("SERVLET_REQUEST", httpIn);
            }
            catch (Exception e) {
                ConnectorUtils.getErrorLog().error("HttpServletConnectorInMessage init error: " + e.getMessage(), (Throwable)e);
            }
            HttpServletConnectorOutMessage httpOut = null;
            try {
                httpOut = new HttpServletConnectorOutMessage(requestInfo, protocolFactory, res, IntegrationManager.ID_SERVICE, IntegrationManager.ID_MODULO);
                transportContext.put("SERVLET_RESPONSE", httpOut);
            }
            catch (Exception e) {
                ConnectorUtils.getErrorLog().error("HttpServletConnectorOutMessage init error: " + e.getMessage(), (Throwable)e);
            }
            preInRequestContext.setTransportContext(transportContext);
            preInRequestContext.setLogCore(logCore);
            GestoreHandlers.preInRequest(preInRequestContext, msgDiag, logCore);
            context.getPddContext().addAll((org.openspcoop2.utils.Map)preInRequestContext.getPddContext(), false);
            NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
            context.setNotifierInputStreamParams(notifierInputStreamParams);
            msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio");
            if ("invocaPortaDelegata".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.BAD_REQUEST, erroriProperties);
                }
            } else if ("invocaPortaDelegataPerRiferimento".equals(tipoOperazione)) {
                if (idInvocazionePerRiferimento == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.BAD_REQUEST, erroriProperties);
                }
            } else if ("sendRispostaAsincronaSimmetrica".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.BAD_REQUEST, erroriProperties);
                }
                if (msg.getProtocolHeaderInfo() == null || msg.getProtocolHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND, erroriProperties);
                }
            } else {
                if (!"sendRichiestaStatoAsincronaAsimmetrica".equals(tipoOperazione)) {
                    throw new Exception("Tipo operazione [" + tipoOperazione + "] non gestita");
                }
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.BAD_REQUEST, erroriProperties);
                }
                if (msg.getProtocolHeaderInfo() == null || msg.getProtocolHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND, erroriProperties);
                }
            }
            Credenziali credenziali = new Credenziali(requestInfo.getProtocolContext().getCredential());
            String credenzialiFornite = "";
            if (credenziali != null) {
                credenzialiFornite = credenziali.toString();
                msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
            }
            Object invPerRiferimento = "";
            if (idInvocazionePerRiferimento != null) {
                invPerRiferimento = " idInvocazionePerRiferimento[" + idInvocazionePerRiferimento + "]";
            }
            Object riferimentoMessaggio = "";
            if (msg.getProtocolHeaderInfo() != null && msg.getProtocolHeaderInfo().getRiferimentoMessaggio() != null) {
                riferimentoMessaggio = " riferimentoMessaggio[" + msg.getProtocolHeaderInfo().getRiferimentoMessaggio() + "]";
            }
            String param = "PD[" + portaDelegata + "]" + credenzialiFornite + (String)invPerRiferimento + (String)riferimentoMessaggio;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            HashMap headerTrasporto = null;
            if (openSPCoopProperties.integrationManager_readInformazioniTrasporto()) {
                headerTrasporto = new HashMap();
                Enumeration enTrasporto = req.getHeaderNames();
                while (enTrasporto.hasMoreElements()) {
                    String nomeHeader = (String)enTrasporto.nextElement();
                    Enumeration enValues = req.getHeaders(nomeHeader);
                    ArrayList<String> values = new ArrayList<String>();
                    if (enValues != null) {
                        int i = 0;
                        while (enValues.hasMoreElements()) {
                            String value = (String)enValues.nextElement();
                            values.add(value);
                            ++i;
                        }
                    }
                    if (values.isEmpty()) {
                        values.add(req.getHeader(nomeHeader));
                    }
                    headerTrasporto.put(nomeHeader, values);
                }
            }
            urlProtocolContext = new URLProtocolContextImpl(logCore);
            urlProtocolContext.setInterfaceName(portaDelegata);
            urlProtocolContext.setFunctionParameters(portaDelegata);
            urlProtocolContext.setRequestURI(portaDelegata);
            urlProtocolContext.setFunction("IntegrationManager");
            urlProtocolContext.setProtocol(protocolFactory.getProtocol(), requestInfo.getProtocolContext().getProtocolWebContext());
            if (openSPCoopProperties.integrationManager_readInformazioniTrasporto()) {
                urlProtocolContext.setHeaders(headerTrasporto);
            }
            msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.inCorso");
            Utilities.printFreeMemory((String)"IntegrationManager - Pre costruzione richiesta");
            if (idInvocazionePerRiferimento != null) {
                if (dumpRaw != null && dumpRaw.isActiveDump()) {
                    contentTypeRichiesta = null;
                    contentLengthRichiesta = null;
                    rawMessage = idInvocazionePerRiferimento;
                    dumpRaw.serializeRequest(contentTypeRichiesta, contentLengthRichiesta, requestInfo.getProtocolContext().getCredential(), (URLProtocolContext)urlProtocolContext, rawMessage, null);
                }
                stato = new OpenSPCoopStateful();
                stato.initResource(openSPCoopProperties.getIdentitaPortaDefault(protocolFactory.getProtocol(), requestInfo), IntegrationManager.ID_MODULO, idTransazione);
                configPdDManager = configPdDManager.refreshState(stato.getStatoRichiesta(), stato.getStatoRisposta());
                msgDiag.updateState(configPdDManager);
                try {
                    GestoreMessaggi gestoreMessaggio = new GestoreMessaggi(stato, true, idInvocazionePerRiferimento, "INBOX", msgDiag, context.getPddContext());
                    msgRequest = gestoreMessaggio.getMessage();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggio.getMessagePerRiferimento(" + idInvocazionePerRiferimento + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
                }
                stato.releaseResource();
                stato = null;
            } else {
                if (dumpRaw != null && dumpRaw.isActiveDump()) {
                    contentTypeRichiesta = "text/xml";
                    contentLengthRichiesta = null;
                    rawMessage = null;
                    if (msg.getMessage() != null) {
                        try {
                            contentLengthRichiesta = msg.getMessage().length;
                            rawMessage = new String(msg.getMessage());
                        }
                        catch (Throwable t) {
                            logCore.error("Dump error: " + t.getMessage(), t);
                        }
                    }
                    dumpRaw.serializeRequest(contentTypeRichiesta, contentLengthRichiesta, requestInfo.getProtocolContext().getCredential(), (URLProtocolContext)urlProtocolContext, rawMessage, null);
                }
                try {
                    MessageType messageType = MessageType.SOAP_11;
                    String contentType = MessageUtilities.getDefaultContentType((MessageType)messageType);
                    String soapAction = "OpenSPCoop";
                    ByteArrayInputStream bin = new ByteArrayInputStream(msg.getMessage());
                    OpenSPCoop2MessageParseResult pr = null;
                    OpenSPCoop2MessageFactory factory = org.openspcoop2.pdd.core.Utilities.getOpenspcoop2MessageFactory(logCore, requestInfo, MessageRole.REQUEST);
                    pr = msg.getImbustamento() ? factory.envelopingMessage(messageType, MessageRole.REQUEST, contentType, soapAction, (InputStream)bin, notifierInputStreamParams, openSPCoopProperties.getAttachmentsProcessingMode(), openSPCoopProperties.isDeleteInstructionTargetMachineXml(), openSPCoopProperties.useSoapMessageReader(), openSPCoopProperties.getSoapMessageReaderBufferThresholdKb()) : factory.createMessage(messageType, MessageRole.REQUEST, contentType, (InputStream)bin, notifierInputStreamParams, openSPCoopProperties.getAttachmentsProcessingMode());
                    if (pr.getParseException() != null) {
                        context.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                    }
                    msgRequest = pr.getMessage_throwParseException();
                    msgRequest.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
                }
                catch (Exception e) {
                    String msgErrore;
                    Throwable tParsing = null;
                    ParseException parseException = null;
                    if (context.getPddContext().containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION) && (parseException = (ParseException)context.getPddContext().removeObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null) {
                        tParsing = parseException.getParseException();
                    }
                    if (tParsing == null) {
                        tParsing = ParseExceptionUtils.getParseException((Throwable)e);
                    }
                    if (tParsing == null) {
                        tParsing = e;
                    }
                    if ((msgErrore = tParsing.getMessage()) == null) {
                        msgErrore = tParsing.toString();
                    }
                    context.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                    DumpConfigurazione dumpConfig = null;
                    if (portaDelegata != null) {
                        IDPortaDelegata identificativoPortaDelegata = new IDPortaDelegata();
                        identificativoPortaDelegata.setNome(portaDelegata);
                        PortaDelegata portaDelegataObject = configurazionePdDReader.getPortaDelegataSafeMethod(identificativoPortaDelegata, requestInfo);
                        if (portaDelegataObject != null) {
                            dumpConfig = configurazionePdDReader.getDumpConfigurazione(portaDelegataObject);
                        }
                    }
                    if (dumpConfig == null) {
                        dumpConfig = ConfigurazionePdDManager.getInstance().getDumpConfigurazionePortaDelegata();
                    }
                    Dump dumpApplicativo = new Dump(openSPCoopProperties.getIdentitaPortaDefault(protocolFactory.getProtocol(), requestInfo), IntegrationManager.ID_MODULO, TipoPdD.DELEGATA, portaDelegata, context.getPddContext(), null, null, dumpConfig);
                    dumpApplicativo.dumpRichiestaIngressoByIntegrationManagerError(msg.getMessage(), (URLProtocolContext)urlProtocolContext);
                    IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                    if (parseException != null && parseException.getSourceException() != null && TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) {
                        integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                    } else if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                        integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                    }
                    if (!msg.getImbustamento()) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                        msgDiag.logPersonalizzato("buildMsg.nonRiuscito");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_421_MSG_SOAP_NON_COSTRUIBILE_TRAMITE_RICHIESTA_APPLICATIVA.getErrore421_MessaggioSOAPNonGenerabile(msgErrore), integrationFunctionError, erroriProperties);
                    }
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                    msgDiag.logPersonalizzato("buildMsg.imbustamentoSOAP.nonRiuscito");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_422_IMBUSTAMENTO_SOAP_NON_RIUSCITO_RICHIESTA_APPLICATIVA.getErrore422_MessaggioSOAPNonGenerabileTramiteImbustamentoSOAP(msgErrore), integrationFunctionError, erroriProperties);
                }
            }
            Utilities.printFreeMemory((String)"IntegrationManager - Post costruzione richiesta");
            if (msgRequest != null) {
                msgRequest.setProtocolName(protocolFactory.getProtocol());
                msgRequest.setTransactionId(idTransazione);
                Object nomePortaInvocataObject = context.getPddContext().getObject(CostantiPdD.NOME_PORTA_INVOCATA);
                if (nomePortaInvocataObject != null && nomePortaInvocataObject instanceof String) {
                    msgRequest.addContextProperty(CostantiPdD.NOME_PORTA_INVOCATA, (Object)((String)nomePortaInvocataObject));
                }
            }
            HeaderIntegrazione headerIntegrazioneRichiesta = new HeaderIntegrazione(idTransazione);
            ProtocolHeaderInfo protocolHeaderInfo = msg.getProtocolHeaderInfo();
            if (protocolHeaderInfo != null) {
                if (protocolHeaderInfo.getTipoMittente() != null && !"".equals(protocolHeaderInfo.getTipoMittente())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoMittente(protocolHeaderInfo.getTipoMittente());
                }
                if (protocolHeaderInfo.getMittente() != null && !"".equals(protocolHeaderInfo.getMittente())) {
                    headerIntegrazioneRichiesta.getBusta().setMittente(protocolHeaderInfo.getMittente());
                }
                if (protocolHeaderInfo.getTipoDestinatario() != null && !"".equals(protocolHeaderInfo.getTipoDestinatario())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoDestinatario(protocolHeaderInfo.getTipoDestinatario());
                }
                if (protocolHeaderInfo.getDestinatario() != null && !"".equals(protocolHeaderInfo.getDestinatario())) {
                    headerIntegrazioneRichiesta.getBusta().setDestinatario(protocolHeaderInfo.getDestinatario());
                }
                if (protocolHeaderInfo.getTipoServizio() != null && !"".equals(protocolHeaderInfo.getTipoServizio())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoServizio(protocolHeaderInfo.getTipoServizio());
                }
                if (protocolHeaderInfo.getServizio() != null && !"".equals(protocolHeaderInfo.getServizio())) {
                    headerIntegrazioneRichiesta.getBusta().setServizio(protocolHeaderInfo.getServizio());
                }
                if (protocolHeaderInfo.getAzione() != null && !"".equals(protocolHeaderInfo.getAzione())) {
                    headerIntegrazioneRichiesta.getBusta().setAzione(protocolHeaderInfo.getAzione());
                }
                if (protocolHeaderInfo.getID() != null && !"".equals(protocolHeaderInfo.getID())) {
                    headerIntegrazioneRichiesta.getBusta().setID(protocolHeaderInfo.getID());
                }
                if (protocolHeaderInfo.getIdCollaborazione() != null && !"".equals(protocolHeaderInfo.getIdCollaborazione())) {
                    headerIntegrazioneRichiesta.getBusta().setIdCollaborazione(protocolHeaderInfo.getIdCollaborazione());
                }
                if (protocolHeaderInfo.getRiferimentoMessaggio() != null && !"".equals(protocolHeaderInfo.getRiferimentoMessaggio())) {
                    headerIntegrazioneRichiesta.getBusta().setRiferimentoMessaggio(protocolHeaderInfo.getRiferimentoMessaggio());
                }
            }
            if (msg.getIdApplicativo() != null && !"".equals(msg.getIdApplicativo())) {
                headerIntegrazioneRichiesta.setIdApplicativo(msg.getIdApplicativo());
            }
            if (msg.getServizioApplicativo() != null && !"".equals(msg.getServizioApplicativo())) {
                headerIntegrazioneRichiesta.setServizioApplicativo(msg.getServizioApplicativo());
            }
            context.setTipoPorta(TipoPdD.DELEGATA);
            context.setCredenziali(credenziali);
            context.setIdModulo(idModulo);
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(idInvocazionePerRiferimento != null);
            context.setIdInvocazionePDPerRiferimento(idInvocazionePerRiferimento);
            context.setMessageRequest(msgRequest);
            context.setUrlProtocolContext((URLProtocolContext)urlProtocolContext);
            context.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
            context.getPddContext().addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
            context.getPddContext().addObject(Costanti.REQUEST_INFO, requestInfo);
            context.setProprietaErroreAppl(generatoreErrore.getProprietaErroreAppl());
            if (context.getMsgDiagnostico() == null) {
                context.setMsgDiagnostico(msgDiag);
            }
            try {
                if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getCredential() != null && requestInfo.getProtocolContext().getCredential().getCertificate() != null && requestInfo.getProtocolContext().getCredential().getCertificate().getCertificate() != null) {
                    SecurityTokenUtilities.newSecurityToken((Context)context.getPddContext());
                }
            }
            catch (Exception e) {
                logCore.error("Costruzione SecurityToken non riuscito: " + e.getMessage(), (Throwable)e);
            }
            msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.completata");
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context, generatoreErrore, null);
            gestoreRichiesta.process(req);
            msgResponse = context.getMessageResponse();
            if (context.getMsgDiagnostico() != null) {
                msgDiag = context.getMsgDiagnostico();
                msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
            }
            if (msgRequest != null && msgRequest.getParseException() != null || context.getPddContext().containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) {
                try {
                    esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)urlProtocolContext, EsitoTransazioneName.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO);
                }
                catch (Exception eBuildError) {
                    esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                }
                context.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                ParseException parseException = null;
                parseException = msgRequest != null && msgRequest.getParseException() != null ? msgRequest.getParseException() : (ParseException)context.getPddContext().getObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                String msgErrore = null;
                if (parseException != null && parseException.getParseException() != null && (msgErrore = parseException.getParseException().getMessage()) == null) {
                    msgErrore = parseException.getParseException().toString();
                }
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                if (parseException != null) {
                    logCore.error("parsingExceptionRichiesta", parseException.getSourceException());
                }
                IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                if (parseException != null && parseException.getSourceException() != null && TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                } else if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                }
                msgDiag.logPersonalizzato("integrationManager.", "buildMsg.nonRiuscito");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_421_MSG_SOAP_NON_COSTRUIBILE_TRAMITE_RICHIESTA_APPLICATIVA.getErrore421_MessaggioSOAPNonGenerabile(msgErrore), integrationFunctionError, erroriProperties);
            }
            Map<String, List<String>> headerIntegrazioneRisposta = context.getResponseHeaders();
            ProtocolHeaderInfo protocolHeaderInfoResponse = null;
            if (headerIntegrazioneRisposta != null) {
                Map<MapKey<String>, String> keyValue = openSPCoopProperties.getKeyValue_HeaderIntegrazioneTrasporto();
                protocolHeaderInfoResponse = new ProtocolHeaderInfo();
                protocolHeaderInfoResponse.setID(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_ID_MESSAGGIO)));
                protocolHeaderInfoResponse.setRiferimentoMessaggio(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO)));
                protocolHeaderInfoResponse.setIdCollaborazione(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_COLLABORAZIONE)));
                protocolHeaderInfoResponse.setMittente(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_MITTENTE)));
                protocolHeaderInfoResponse.setTipoMittente(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_MITTENTE)));
                protocolHeaderInfoResponse.setDestinatario(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_DESTINATARIO)));
                protocolHeaderInfoResponse.setTipoDestinatario(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_DESTINATARIO)));
                protocolHeaderInfoResponse.setServizio(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_SERVIZIO)));
                protocolHeaderInfoResponse.setTipoServizio(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_TIPO_SERVIZIO)));
                protocolHeaderInfoResponse.setAzione(TransportUtils.getFirstValue(headerIntegrazioneRisposta, (String)keyValue.get(CostantiPdD.HEADER_INTEGRAZIONE_AZIONE)));
            }
            InformazioniErroriInfrastrutturali informazioniErrori = ServicesUtils.readInformazioniErroriInfrastrutturali(context.getPddContext());
            if (msgResponse != null) {
                IntegrationManagerException exc;
                block218: {
                    esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)urlProtocolContext, 200, requestInfo.getIntegrationServiceBinding(), msgResponse, context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)(context.getPddContext() != null ? context.getPddContext() : null));
                    exc = null;
                    try {
                        OpenSPCoop2SoapMessage soapMessage;
                        if (!ServiceBinding.SOAP.equals((Object)msgResponse.getServiceBinding()) || !(soapMessage = msgResponse.castAsSoap()).hasSOAPFault()) break block218;
                        descrizioneSoapFault = " (" + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMessage.getFactory(), (SOAPFault)soapMessage.getSOAPBody().getFault(), (boolean)false, (Logger)logCore) + ")";
                        SOAPFault fault = soapMessage.getSOAPBody().getFault();
                        ProprietaErroreApplicativo pea = context.getProprietaErroreAppl();
                        if (pea != null && fault.getFaultActor() != null && fault.getFaultActor().equals(pea.getFaultActor())) {
                            String prefix = "GOVWAY-";
                            if (context.getProprietaErroreAppl().getFaultPrefixCode() != null) {
                                prefix = context.getProprietaErroreAppl().getFaultPrefixCode();
                            }
                            String faultCode = null;
                            faultCode = fault.getFaultCodeAsQName() != null ? fault.getFaultCodeAsQName().getLocalPart() : fault.getFaultCode();
                            exc = IntegrationManagerUtility.mapMessageIntoProtocolException(soapMessage, faultCode, fault.getFaultString(), requestInfo.getIdentitaPdD(), idModulo);
                            if (exc == null) {
                                exc = openSPCoopProperties.isErroreApplicativoIntoDetails() && fault.getDetail() != null ? IntegrationManagerUtility.mapXMLIntoProtocolException(protocolFactory, fault.getDetail().getFirstChild(), prefix, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties) : IntegrationManagerUtility.mapXMLIntoProtocolException(protocolFactory, fault.getFaultString(), prefix, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
                            }
                            if (exc == null) {
                                throw new Exception("Costruzione Eccezione fallita: null");
                            }
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (!(msgResponse != null && msgResponse.getParseException() != null || context.getPddContext().containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION))) {
                                msgDiag.logErroreGenerico(e, "buildProtocolException(" + tipoOperazione + ")");
                                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_524_CREAZIONE_PROTOCOL_EXCEPTION), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
                            }
                            informazioniErrori.setContenutoRispostaNonRiconosciuto(true);
                            ParseException parseException = null;
                            parseException = msgResponse != null && msgResponse.getParseException() != null ? msgResponse.getParseException() : (ParseException)context.getPddContext().getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                            String msgErrore = parseException.getParseException().getMessage();
                            if (msgErrore == null) {
                                msgErrore = parseException.getParseException().toString();
                            }
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                            logCore.error("parsingExceptionRisposta", parseException.getSourceException());
                            msgDiag.logPersonalizzato("parsingExceptionRisposta");
                            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato(parseException.getParseException()), IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT, erroriProperties);
                        }
                        catch (Throwable throwable) {
                            esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)urlProtocolContext, 500, requestInfo.getIntegrationServiceBinding(), msgResponse, context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)(context.getPddContext() != null ? context.getPddContext() : null));
                            throw throwable;
                        }
                    }
                }
                if (exc != null) {
                    throw exc;
                }
                try {
                    msgReturn = new IntegrationManagerMessage(msgResponse, false);
                }
                catch (Exception e) {
                    try {
                        if (!(msgResponse != null && msgResponse.getParseException() != null || context.getPddContext().containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION))) {
                            msgDiag.logErroreGenerico(e, "buildMessage_response(" + tipoOperazione + ")");
                            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_523_CREAZIONE_PROTOCOL_MESSAGE), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
                        }
                        informazioniErrori.setContenutoRispostaNonRiconosciuto(true);
                        ParseException parseException = null;
                        parseException = msgResponse != null && msgResponse.getParseException() != null ? msgResponse.getParseException() : (ParseException)context.getPddContext().getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                        String msgErrore = parseException.getParseException().getMessage();
                        if (msgErrore == null) {
                            msgErrore = parseException.getParseException().toString();
                        }
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                        logCore.error("parsingExceptionRisposta", parseException.getSourceException());
                        msgDiag.logPersonalizzato("parsingExceptionRisposta");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato(parseException.getParseException()), IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT, erroriProperties);
                    }
                    catch (Throwable throwable) {
                        esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)urlProtocolContext, 500, requestInfo.getIntegrationServiceBinding(), msgResponse, context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)(context.getPddContext() != null ? context.getPddContext() : null));
                        throw throwable;
                    }
                }
                msgDiag.addKeyword("@SOAP_FAULT@", (String)descrizioneSoapFault);
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaEffettuata");
            } else {
                msgReturn = new IntegrationManagerMessage();
                esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)urlProtocolContext, 200, requestInfo.getIntegrationServiceBinding(), msgResponse, context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)(context.getPddContext() != null ? context.getPddContext() : null));
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaVuota");
            }
            msgReturn.setProtocolHeaderInfo(protocolHeaderInfoResponse);
            if (dumpRaw != null && dumpRaw.isActiveDump()) {
                String contentTypeRisposta = "text/xml";
                String rawMessage = null;
                Integer contentLengthRisposta = null;
                if (msgReturn.getMessage() != null) {
                    try {
                        contentLengthRisposta = msgReturn.getMessage().length;
                        rawMessage = new String(msgReturn.getMessage());
                    }
                    catch (Throwable t) {
                        logCore.error("Dump error: " + t.getMessage(), t);
                    }
                }
                dumpRaw.serializeResponse(rawMessage, null, null, contentLengthRisposta, contentTypeRisposta, 200);
            }
            integrationManagerMessage = msgReturn;
        }
        catch (Exception e) {
            try {
                if (dumpRaw != null && dumpRaw.isActiveDump()) {
                    String contentTypeRisposta = "text/xml";
                    String rawMessage = "[Exception " + e.getClass().getName() + "]: " + e.getMessage();
                    Integer contentLengthRisposta = null;
                    dumpRaw.serializeResponse(rawMessage, null, null, contentLengthRisposta, contentTypeRisposta, 500);
                }
                errore = e.getMessage();
                msgDiag.addKeyword("@SOAP_FAULT@", (String)descrizioneSoapFault);
                if (e instanceof IntegrationManagerException) {
                    if (esito == null) {
                        try {
                            esito = protocolFactory.createEsitoBuilder().getEsito(urlProtocolContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                        }
                        catch (Exception eBuildError) {
                            esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                        }
                    }
                    IntegrationManagerException eSPC = (IntegrationManagerException)e;
                    if (descrizioneSoapFault != null && !"".equals(descrizioneSoapFault)) {
                        msgDiag.addKeyword("@ERRORE_CONSEGNA@", "ProtocolException/" + eSPC.getCodiceEccezione());
                    } else {
                        msgDiag.addKeyword("@ERRORE_CONSEGNA@", "ProtocolException/" + eSPC.getCodiceEccezione() + " " + eSPC.getDescrizioneEccezione());
                    }
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaFallita");
                    throw eSPC;
                }
                msgDiag.logErroreGenerico(e, "invocaPortaDelegata(" + tipoOperazione + ")");
                try {
                    esito = protocolFactory.createEsitoBuilder().getEsito(urlProtocolContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                }
                catch (Exception eBuildError) {
                    esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                }
                msgDiag.addKeyword("@ERRORE_CONSEGNA@", errore);
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaFallita");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, erroriProperties);
            }
            catch (Throwable throwable) {
                try {
                    if (stato != null) {
                        stato.releaseResource();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String location2 = "...";
                try {
                    IConnettore c = null;
                    if (idTransazione != null) {
                        c = RepositoryConnettori.removeConnettorePD(idTransazione);
                    }
                    if (c != null) {
                        location2 = c.getLocation();
                        c.disconnect();
                    }
                }
                catch (Exception e2) {
                    msgDiag.logDisconnectError(e2, location2);
                }
                PostOutResponseContext postOutResponseContext2 = new PostOutResponseContext(logCore, protocolFactory);
                try {
                    context.getPddContext().addObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA, dataAccettazioneRichiesta);
                    if (dataIngressoRichiesta != null) {
                        context.getPddContext().addObject(CostantiPdD.DATA_INGRESSO_RICHIESTA, dataIngressoRichiesta);
                    }
                    postOutResponseContext2.setPddContext(context.getPddContext());
                    postOutResponseContext2.setDataElaborazioneMessaggio(DateManager.getDate());
                    postOutResponseContext2.setDataPrimaSpedizioneRisposta(DateManager.getDate());
                    postOutResponseContext2.setDataRispostaSpedita(DateManager.getDate());
                    postOutResponseContext2.setEsito(esito);
                    postOutResponseContext2.setMessaggio(msgResponse);
                    if (msgRequest != null) {
                        postOutResponseContext2.setInputRequestMessageSize(msgRequest.getIncomingMessageContentLength());
                        postOutResponseContext2.setOutputRequestMessageSize(msgRequest.getOutgoingMessageContentLength());
                    } else if (msg != null && msg.getMessage() != null) {
                        postOutResponseContext2.setInputRequestMessageSize(Long.valueOf(msg.getMessage().length));
                    }
                    if (msgResponse != null) {
                        postOutResponseContext2.setInputResponseMessageSize(msgResponse.getIncomingMessageContentLength());
                        if (msgReturn != null && msgReturn.getMessage() != null) {
                            postOutResponseContext2.setOutputResponseMessageSize(Long.valueOf(msgReturn.getMessage().length));
                        }
                    }
                    if (errore != null) {
                        postOutResponseContext2.setReturnCode(500);
                    } else {
                        postOutResponseContext2.setReturnCode(200);
                    }
                    if (context.getTipoPorta() != null) {
                        postOutResponseContext2.setTipoPorta(context.getTipoPorta());
                    } else {
                        postOutResponseContext2.setTipoPorta(TipoPdD.DELEGATA);
                    }
                    postOutResponseContext2.setProtocollo(context.getProtocol());
                    postOutResponseContext2.setIntegrazione(context.getIntegrazione());
                    postOutResponseContext2.setIdModulo(idModulo);
                }
                catch (Exception e3) {
                    msgDiag.logErroreGenerico(e3, "postOutResponse, preparazione contesto");
                }
                GestoreHandlers.postOutResponse(postOutResponseContext2, msgDiag, logCore);
                throw throwable;
            }
        }
        try {
            if (stato != null) {
                stato.releaseResource();
            }
        }
        catch (Exception rawMessage) {
            // empty catch block
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (idTransazione != null) {
                c = RepositoryConnettori.removeConnettorePD(idTransazione);
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
        try {
            context.getPddContext().addObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA, dataAccettazioneRichiesta);
            if (dataIngressoRichiesta != null) {
                context.getPddContext().addObject(CostantiPdD.DATA_INGRESSO_RICHIESTA, dataIngressoRichiesta);
            }
            postOutResponseContext.setPddContext(context.getPddContext());
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            postOutResponseContext.setDataPrimaSpedizioneRisposta(DateManager.getDate());
            postOutResponseContext.setDataRispostaSpedita(DateManager.getDate());
            postOutResponseContext.setEsito(esito);
            postOutResponseContext.setMessaggio(msgResponse);
            if (msgRequest != null) {
                postOutResponseContext.setInputRequestMessageSize(msgRequest.getIncomingMessageContentLength());
                postOutResponseContext.setOutputRequestMessageSize(msgRequest.getOutgoingMessageContentLength());
            } else if (msg != null && msg.getMessage() != null) {
                postOutResponseContext.setInputRequestMessageSize(Long.valueOf(msg.getMessage().length));
            }
            if (msgResponse != null) {
                postOutResponseContext.setInputResponseMessageSize(msgResponse.getIncomingMessageContentLength());
                if (msgReturn != null && msgReturn.getMessage() != null) {
                    postOutResponseContext.setOutputResponseMessageSize(Long.valueOf(msgReturn.getMessage().length));
                }
            }
            if (errore != null) {
                postOutResponseContext.setReturnCode(500);
            } else {
                postOutResponseContext.setReturnCode(200);
            }
            if (context.getTipoPorta() != null) {
                postOutResponseContext.setTipoPorta(context.getTipoPorta());
            } else {
                postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
            }
            postOutResponseContext.setProtocollo(context.getProtocol());
            postOutResponseContext.setIntegrazione(context.getIntegrazione());
            postOutResponseContext.setIdModulo(idModulo);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
        }
        GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag, logCore);
        return integrationManagerMessage;
    }
}

