/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.service;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFault;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreRichieste;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.SoglieDimensioneMessaggi;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInAcceptRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamento;
import org.openspcoop2.pdd.logger.transazioni.InformazioniTransazione;
import org.openspcoop2.pdd.logger.transazioni.TracciamentoManager;
import org.openspcoop2.pdd.services.DirectVMProtocolInfo;
import org.openspcoop2.pdd.services.DumpRaw;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherErrorInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiHTTPtoSOAPConnector;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.messages.DumpRawConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DumpRawConnectorOutMessage;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.service.IRicezioneService;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiServiceUtils;
import org.openspcoop2.pdd.services.service.RicezionePropertiesConfig;
import org.openspcoop2.protocol.basic.builder.EsitoBuilder;
import org.openspcoop2.protocol.basic.registry.ServiceIdentificationReader;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RicezioneContenutiApplicativiHTTPtoSOAPService
implements IRicezioneService,
IAsyncResponseCallback {
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore;
    private RicezioneContenutiApplicativiContext context = null;
    private IProtocolFactory<?> protocolFactory = null;
    private OpenSPCoop2Properties openSPCoopProperties = null;
    private ConnectorInMessage req = null;
    private ConnectorOutMessage res = null;
    private Date dataAccettazioneRichiesta = null;
    private Date dataIngressoRichiesta = null;
    private RequestInfo requestInfo = null;
    private PdDContext pddContext = null;
    private byte[] inputBody = null;
    private OpenSPCoop2Message requestMessage = null;
    private OpenSPCoop2Message responseMessage = null;
    private Logger logCore = null;
    private MsgDiagnostico msgDiag = null;
    private DumpRaw dumpRaw = null;
    private String idModulo = null;
    private PostOutResponseContext postOutResponseContext = null;
    private String idTransazione = null;

    public static void forceXmlResponse(RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore) {
        generatoreErrore.setForceMessageTypeResponse(MessageType.XML);
        if (generatoreErrore.getProprietaErroreAppl() != null) {
            generatoreErrore.getProprietaErroreAppl().setFaultAsXML(true);
        }
    }

    public RicezioneContenutiApplicativiHTTPtoSOAPService(RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore) {
        this.generatoreErrore = generatoreErrore;
        if (this.generatoreErrore != null) {
            RicezioneContenutiApplicativiHTTPtoSOAPService.forceXmlResponse(this.generatoreErrore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ConnectorInMessage reqParam, ConnectorOutMessage resParam, Date dataAccettazioneRichiestaParam, boolean async) throws ConnectorException {
        this.req = reqParam;
        this.res = resParam;
        this.dataAccettazioneRichiesta = dataAccettazioneRichiestaParam;
        this.idModulo = this.req.getIdModulo();
        IDService idModuloAsService = this.req.getIdModuloAsIDService();
        this.requestInfo = this.req.getRequestInfo();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.logCore == null) {
            this.logCore = LoggerWrapperFactory.getLogger((String)this.idModulo);
        }
        this.openSPCoopProperties = OpenSPCoop2Properties.getInstance();
        PreInAcceptRequestContext preInAcceptRequestContext = null;
        SogliaReadTimeout sogliaReadTimeout = null;
        if (this.openSPCoopProperties != null && OpenSPCoop2Startup.initialize) {
            preInAcceptRequestContext = new PreInAcceptRequestContext();
            preInAcceptRequestContext.setTipoPorta(TipoPdD.DELEGATA);
            preInAcceptRequestContext.setIdModulo(this.idModulo);
            preInAcceptRequestContext.setRequestInfo(this.requestInfo);
            preInAcceptRequestContext.setLogCore(this.logCore);
            try {
                if (this.openSPCoopProperties.isConnettoriUseLimitedInputStream()) {
                    SogliaDimensioneMessaggio soglia = new SogliaDimensioneMessaggio();
                    soglia.setSogliaKb(this.openSPCoopProperties.getLimitedInputStreamThresholdKb());
                    soglia.setUseContentLengthHeader(this.openSPCoopProperties.isLimitedInputStreamUseContentLength());
                    soglia.setUseContentLengthHeaderAcceptZeroValue(this.openSPCoopProperties.isLimitedInputStreamUseContentLengthAcceptZeroValue());
                    soglia.setPolicyGlobale(true);
                    soglia.setNomePolicy("GovWayCore");
                    soglia.setIdPolicyConGruppo("GovWayCore");
                    this.req.setRequestLimitedStream(soglia);
                }
                if (this.openSPCoopProperties.isConnettoriUseTimeoutInputStream()) {
                    sogliaReadTimeout = new SogliaReadTimeout();
                    sogliaReadTimeout.setSogliaMs(this.openSPCoopProperties.getReadConnectionTimeoutRicezioneContenutiApplicativi());
                    sogliaReadTimeout.setConfigurazioneGlobale(true);
                    sogliaReadTimeout.setIdConfigurazione("GovWayCore");
                    this.req.setRequestReadTimeout(sogliaReadTimeout);
                }
                this.req.setThresholdContext(null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
            }
            catch (Throwable t) {
                this.logCore.error(t.getMessage(), t);
            }
            preInAcceptRequestContext.setReq(this.req);
            GestoreHandlers.preInRequest(preInAcceptRequestContext, this.logCore, this.logCore);
        }
        try {
            if (this.generatoreErrore == null) {
                this.generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(this.logCore, RicezioneContenutiApplicativiHTTPtoSOAPConnector.ID_MODULO, this.requestInfo);
                this.generatoreErrore.getProprietaErroreAppl().setFaultAsXML(true);
            }
        }
        catch (Exception e) {
            String msg = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            this.logCore.error(msg, (Throwable)e);
            ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        if (!OpenSPCoop2Startup.initialize || this.openSPCoopProperties == null) {
            String msg = "Inizializzazione di GovWay non correttamente effettuata: OpenSPCoopProperties";
            if (!OpenSPCoop2Startup.initialize) {
                msg = "Inizializzazione di GovWay non correttamente effettuata";
            }
            this.logCore.error(msg);
            ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, null, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        ConfigurazionePdDManager configPdDManager = null;
        try {
            configPdDManager = ConfigurazionePdDManager.getInstance();
            if (configPdDManager == null || !configPdDManager.isInitializedConfigurazionePdDReader()) {
                throw new CoreException("ConfigurazionePdDManager not initialized");
            }
        }
        catch (Throwable e) {
            String msg = "Inizializzazione di GovWay non correttamente effettuata: ConfigurazionePdDManager";
            this.logCore.error(msg);
            ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, e, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        Object oPddContextFromServlet = null;
        try {
            oPddContextFromServlet = this.req.getAttribute((String)((Object)CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_HEADER_HTTP.getValue()));
        }
        catch (Exception e) {
            this.logCore.error("req.getAttribute(" + String.valueOf(CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_HEADER_HTTP) + ") error: " + e.getMessage(), (Throwable)e);
        }
        PdDContext pddContextFromServlet = null;
        if (oPddContextFromServlet != null) {
            pddContextFromServlet = (PdDContext)oPddContextFromServlet;
        }
        if (this.requestInfo == null) {
            this.res.close(false);
            String msg = "RequestInfo undefined";
            this.logCore.error(msg);
            return;
        }
        ServiceIdentificationReader serviceIdentificationReader = null;
        try {
            serviceIdentificationReader = ServicesUtils.getServiceIdentificationReader(this.logCore, this.requestInfo, configPdDManager.getRegistroServiziManager(), configPdDManager);
        }
        catch (Exception e) {
            String msg = "Inizializzazione RegistryReader fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            this.logCore.error(msg, (Throwable)e);
            ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        try {
            this.context = new RicezioneContenutiApplicativiContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
            this.protocolFactory = this.req.getProtocolFactory();
            this.idTransazione = (String)this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        }
        catch (Throwable e) {
            this.context = null;
            this.protocolFactory = null;
        }
        try {
            GestoreRichieste.readRequestConfig(this.requestInfo);
        }
        catch (Exception e) {
            String msg = "GestoreRichieste readRequestConfig fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            this.logCore.error(msg, (Throwable)e);
            ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_500_ERRORE_INTERNO), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)e, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        if (this.idTransazione != null) {
            try {
                if (this.openSPCoopProperties.isTransazioniEnabled()) {
                    TransactionContext.createTransaction(this.idTransazione, "RicezioneContenutiApplicativiHTTPtoSOAP.1");
                }
                this.requestInfo.setIdTransazione(this.idTransazione);
                this.req.setThresholdContext(this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
            }
            catch (Throwable e) {
                this.context = null;
                this.protocolFactory = null;
            }
        }
        String nomePorta = this.requestInfo.getProtocolContext().getInterfaceName();
        this.msgDiag = MsgDiagnostico.newInstance(TipoPdD.DELEGATA, this.idModulo, nomePorta, this.requestInfo);
        this.msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
        if (this.context != null && this.protocolFactory != null) {
            this.msgDiag.setPddContext(this.context.getPddContext(), this.protocolFactory);
        }
        try {
            this.msgDiag.logPersonalizzato("ricezioneRichiesta.firstLog");
        }
        catch (Exception e) {
            this.logCore.error("Errore generazione diagnostico di ingresso", (Throwable)e);
        }
        try {
            this.req.setDiagnosticProducer(this.context != null ? this.context.getPddContext() : null, this.msgDiag);
        }
        catch (Throwable e) {
            this.logCore.error("Errore registrazione diagnostico sulla richiesta", e);
        }
        GestoreHandlers.emitDiagnostic(this.msgDiag, preInAcceptRequestContext, this.context != null ? this.context.getPddContext() : null, this.logCore, this.logCore);
        try {
            this.msgDiag.mediumDebug("Accesso configurazione della richiesta in corso...");
        }
        catch (Exception e) {
            this.logCore.error("Errore generazione diagnostico", (Throwable)e);
        }
        ConnectorDispatcherInfo cInfo = RicezioneContenutiApplicativiServiceUtils.updatePortaDelegataRequestInfo(this.requestInfo, this.logCore, this.req, this.res, this.generatoreErrore, serviceIdentificationReader, this.msgDiag, this.context != null ? this.context.getPddContext() : null);
        if (cInfo != null) {
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.context, this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        this.req.updateRequestInfo(this.requestInfo);
        try {
            try {
                this.msgDiag.mediumDebug("Lettura configurazione dump binario ...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            boolean dumpBinario = configPdDManager.dumpBinarioPD();
            PortaDelegata pd = null;
            if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getInterfaceName() != null) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(this.requestInfo.getProtocolContext().getInterfaceName());
                pd = configPdDManager.getPortaDelegataSafeMethod(idPD, this.requestInfo);
            }
            try {
                this.msgDiag.mediumDebug("Lettura configurazione dimensione massima della richiesta ...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            String azione = this.requestInfo != null && this.requestInfo.getIdServizio() != null ? this.requestInfo.getIdServizio().getAzione() : null;
            SoglieDimensioneMessaggi limitedInputStream = configPdDManager.getSoglieLimitedInputStream(pd, azione, this.idModulo, this.context != null && this.context.getPddContext() != null ? this.context.getPddContext() : null, this.requestInfo, this.protocolFactory, this.logCore);
            if (limitedInputStream != null) {
                this.req.setRequestLimitedStream(limitedInputStream.getRichiesta());
                if (this.context != null && this.context.getPddContext() != null) {
                    this.context.getPddContext().addObject(Costanti.LIMITED_STREAM, limitedInputStream.getRisposta());
                }
            } else if (!this.openSPCoopProperties.isLimitedInputStreamThresholdDefined()) {
                this.req.disableLimitedStream();
            }
            try {
                this.msgDiag.mediumDebug("Lettura configurazione timeout per la lettura della richiesta ...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            boolean useTimeoutInputStream = configPdDManager.isConnettoriUseTimeoutInputStream(pd);
            if (useTimeoutInputStream) {
                sogliaReadTimeout = configPdDManager.getRequestReadTimeout(pd, this.requestInfo, this.protocolFactory, (Context)(this.context != null ? this.context.getPddContext() : null), null);
                if (sogliaReadTimeout != null && sogliaReadTimeout.getSogliaMs() > 0) {
                    this.req.setRequestReadTimeout(sogliaReadTimeout);
                } else {
                    this.req.disableReadTimeout();
                }
            } else {
                this.req.disableReadTimeout();
            }
            try {
                this.msgDiag.mediumDebug("Lettura configurazione dump ...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            DumpConfigurazione dumpConfigurazione = configPdDManager.getDumpConfigurazione(pd);
            ConfigurazioneTracciamento configurazioneTracciamento = new ConfigurazioneTracciamento(this.logCore, configPdDManager, pd);
            boolean fileTraceHeaders = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioHeaderEnabled();
            boolean fileTracePayload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioPayloadEnabled();
            this.dumpRaw = new DumpRaw(this.logCore, this.requestInfo.getIdentitaPdD(), this.idModulo, TipoPdD.DELEGATA, dumpBinario, dumpConfigurazione, fileTraceHeaders, fileTracePayload);
            if (this.dumpRaw.isActiveDumpRichiesta()) {
                this.req = new DumpRawConnectorInMessage(this.logCore, this.req, this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
            }
            if (this.dumpRaw.isActiveDumpRisposta()) {
                this.res = new DumpRawConnectorOutMessage(this.logCore, this.res, this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository(), this.dumpRaw);
            }
        }
        catch (Throwable e) {
            String msg = "Inizializzazione di GovWay non correttamente effettuata: DumpRaw";
            this.logCore.error(msg, e);
            cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, e, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
            return;
        }
        if (this.context != null && this.context.getPddContext() != null && sogliaReadTimeout != null && sogliaReadTimeout.getSogliaMs() > 0) {
            this.context.getPddContext().put(CostantiPdD.REQUEST_READ_TIMEOUT, sogliaReadTimeout.getSogliaMs());
        }
        if (!ServiceBinding.SOAP.equals((Object)this.requestInfo.getIntegrationServiceBinding())) {
            String msg = "Servizio utilizzabile solamente con API SOAP, riscontrata API REST";
            this.logCore.error(msg);
            ConnectorDispatcherErrorInfo cInfoError = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(msg, this.protocolFactory), IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, null, null, this.res, this.logCore, false);
            this.res.close(false);
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(this.context, this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfoError);
            return;
        }
        String errorImbustamentoSoapNonRiuscito = null;
        MessageType messageTypeReq = null;
        String protocol = null;
        boolean completeProcess = false;
        try {
            String mime;
            try {
                this.msgDiag.mediumDebug("Creazione contesto ...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            if (this.protocolFactory == null) {
                this.protocolFactory = this.req.getProtocolFactory();
            }
            protocol = this.protocolFactory.getProtocol();
            if (this.context == null) {
                this.context = new RicezioneContenutiApplicativiContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
            }
            if (preInAcceptRequestContext != null && preInAcceptRequestContext.getPreContext() != null && !preInAcceptRequestContext.getPreContext().isEmpty()) {
                this.context.getPddContext().addAll((org.openspcoop2.utils.Map)preInAcceptRequestContext.getPreContext(), false);
            }
            this.context.setTipoPorta(TipoPdD.DELEGATA);
            this.context.setForceFaultAsXML(true);
            this.context.setIdModulo(this.idModulo);
            this.context.getPddContext().addObject(Costanti.PROTOCOL_NAME, this.protocolFactory.getProtocol());
            this.context.getPddContext().addObject(Costanti.REQUEST_INFO, this.req.getRequestInfo());
            RicezionePropertiesConfig rConfig = RicezioneContenutiApplicativiServiceUtils.readPropertiesConfig(this.req.getRequestInfo(), this.logCore, null);
            if (rConfig != null) {
                if (rConfig.getApiImplementation() != null && !rConfig.getApiImplementation().isEmpty()) {
                    this.context.getPddContext().addObject(Costanti.PROPRIETA_CONFIGURAZIONE, rConfig.getApiImplementation());
                }
                if (rConfig.getSoggettoFruitore() != null && !rConfig.getSoggettoFruitore().isEmpty()) {
                    this.context.getPddContext().addObject(Costanti.PROPRIETA_SOGGETTO_FRUITORE, rConfig.getSoggettoFruitore());
                }
                if (rConfig.getSoggettoErogatore() != null && !rConfig.getSoggettoErogatore().isEmpty()) {
                    this.context.getPddContext().addObject(Costanti.PROPRIETA_SOGGETTO_EROGATORE, rConfig.getSoggettoErogatore());
                }
            }
            this.msgDiag.setPddContext(this.context.getPddContext(), this.protocolFactory);
            this.pddContext = this.context.getPddContext();
            try {
                if (this.openSPCoopProperties.isTransazioniEnabled()) {
                    TransactionContext.createTransaction((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE), "RicezioneContenutiApplicativiHTTPtoSOAP.2");
                }
            }
            catch (Exception e) {
                this.logCore.error("Errore durante la creazione della transazione", (Throwable)e);
            }
            try {
                this.msgDiag.logPersonalizzato("ricezioneRichiesta.firstAccessRequestStream");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico di ingresso (stream access)", (Throwable)e);
            }
            if (this.dumpRaw != null && this.dumpRaw.isActiveDump()) {
                this.dumpRaw.setPddContext(this.msgDiag.getPorta(), this.context.getPddContext());
                this.dumpRaw.serializeContext(this.context, protocol);
            }
            DirectVMConnectorInMessage vm = null;
            ConnectorInMessage connectorInMessage = this.req;
            if (connectorInMessage instanceof DirectVMConnectorInMessage) {
                DirectVMConnectorInMessage directvmconnectorinmessage;
                vm = directvmconnectorinmessage = (DirectVMConnectorInMessage)connectorInMessage;
            } else {
                DumpRawConnectorInMessage dumprawconnectorinmessage;
                connectorInMessage = this.req;
                if (connectorInMessage instanceof DumpRawConnectorInMessage && (connectorInMessage = (dumprawconnectorinmessage = (DumpRawConnectorInMessage)connectorInMessage).getWrappedConnectorInMessage()) instanceof DirectVMConnectorInMessage) {
                    DirectVMConnectorInMessage directvmconnectorInmessage;
                    vm = directvmconnectorInmessage = (DirectVMConnectorInMessage)connectorInMessage;
                }
            }
            if (vm != null && vm.getDirectVMProtocolInfo() != null) {
                vm.getDirectVMProtocolInfo().setInfo(this.pddContext);
            }
            this.postOutResponseContext = new PostOutResponseContext(this.logCore, this.protocolFactory);
            this.postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
            this.postOutResponseContext.setPddContext(this.pddContext);
            this.postOutResponseContext.setIdModulo(this.idModulo);
            PreInRequestContext preInRequestContext = new PreInRequestContext(this.pddContext);
            if (pddContextFromServlet != null) {
                preInRequestContext.getPddContext().addAll((org.openspcoop2.utils.Map)pddContextFromServlet, true);
            }
            preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
            preInRequestContext.setIdModulo(this.idModulo);
            preInRequestContext.setProtocolFactory(this.protocolFactory);
            preInRequestContext.setRequestInfo(this.requestInfo);
            HashMap<String, Object> transportContext = new HashMap<String, Object>();
            transportContext.put("SERVLET_REQUEST", this.req);
            transportContext.put("SERVLET_RESPONSE", this.res);
            preInRequestContext.setTransportContext(transportContext);
            preInRequestContext.setLogCore(this.logCore);
            GestoreHandlers.preInRequest(preInRequestContext, this.msgDiag, this.logCore);
            this.pddContext.addAll((org.openspcoop2.utils.Map)preInRequestContext.getPddContext(), false);
            NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
            this.context.setNotifierInputStreamParams(notifierInputStreamParams);
            this.req.checkContentLengthLimit();
            if (this.dumpRaw != null && this.dumpRaw.isActiveDumpRichiesta()) {
                this.dumpRaw.serializeRequest((DumpRawConnectorInMessage)this.req, false, notifierInputStreamParams);
                this.dataIngressoRichiesta = this.req.getDataIngressoRichiesta();
                this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
            }
            this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio");
            messageTypeReq = MessageType.SOAP_11;
            boolean imbustamentoConAttachment = false;
            String tipoAttachment = "application/openspcoop2";
            String imb = TransportUtils.getFirstValue(this.req.getHeaderValues(this.openSPCoopProperties.getTunnelSOAPKeyWord_headerTrasporto()));
            if (imb != null && "true".equals(imb.trim())) {
                imbustamentoConAttachment = true;
                mime = TransportUtils.getFirstValue(this.req.getHeaderValues(this.openSPCoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto()));
                if (mime != null) {
                    tipoAttachment = mime.trim();
                }
            }
            if (imb == null && (imb = TransportUtils.getFirstValue(this.req.getParameterValues(this.openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()))) != null && "true".equals(imb.trim())) {
                imbustamentoConAttachment = true;
                mime = TransportUtils.getFirstValue(this.req.getParameterValues(this.openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased()));
                if (mime != null) {
                    tipoAttachment = mime.trim();
                }
            }
            if (imb == null && transportContext.get(this.openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()) != null && "true".equalsIgnoreCase((String)transportContext.get(this.openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()))) {
                imbustamentoConAttachment = true;
                if (transportContext.get(this.openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased()) != null) {
                    tipoAttachment = (String)transportContext.get(this.openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased());
                }
            }
            Object tipoLetturaRisposta = null;
            try {
                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiHTTPtoSOAP - Pre costruzione richiesta");
                this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.inCorso");
                DumpByteArrayOutputStream bout = this.req.getRequest();
                if (bout != null && bout.size() > 0) {
                    this.inputBody = bout.toByteArray();
                    bout.clearResources();
                    bout = null;
                }
                if (this.inputBody == null || this.inputBody.length <= 0) {
                    throw new CoreException("Ricevuto nessun contenuto da imbustare");
                }
                this.req.close();
                this.dataIngressoRichiesta = this.req.getDataIngressoRichiesta();
                this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
                if (imbustamentoConAttachment) {
                    tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + tipoAttachment;
                    this.requestMessage = TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2MessageFactory)org.openspcoop2.pdd.core.Utilities.getOpenspcoop2MessageFactory(this.logCore, this.requestInfo, MessageRole.REQUEST), (MessageType)messageTypeReq, (MessageRole)MessageRole.REQUEST, (byte[])this.inputBody, (String)tipoAttachment, (boolean)MailcapActivationReader.existsDataContentHandler((String)tipoAttachment), (String)this.req.getContentType(), (String)this.openSPCoopProperties.getHeaderSoapActorIntegrazione());
                    this.requestMessage.setTransportRequestContext((TransportRequestContext)this.requestInfo.getProtocolContext());
                } else {
                    tipoLetturaRisposta = "Imbustamento messaggio in un messaggio SOAP";
                    String contentTypeForEnvelope = null;
                    String soapAction = "\"GovWay\"";
                    OpenSPCoop2MessageParseResult pr = org.openspcoop2.pdd.core.Utilities.getOpenspcoop2MessageFactory(this.logCore, this.requestInfo, MessageRole.REQUEST).envelopingMessage(messageTypeReq, contentTypeForEnvelope, soapAction, (TransportRequestContext)this.requestInfo.getProtocolContext(), this.inputBody, notifierInputStreamParams, this.openSPCoopProperties.getAttachmentsProcessingMode(), this.openSPCoopProperties.isDeleteInstructionTargetMachineXml(), this.openSPCoopProperties.useSoapMessageReader(), this.openSPCoopProperties.getSoapMessageReaderBufferThresholdKb());
                    if (pr.getParseException() != null) {
                        this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                    }
                    this.requestMessage = pr.getMessage_throwParseException();
                }
                if (this.requestInfo.getProtocolContext().getHeaders() == null) {
                    this.requestInfo.getProtocolContext().setHeaders(new HashMap());
                }
                this.requestInfo.getProtocolContext().removeHeader("Content-Type");
                TransportUtils.setHeader((Map)this.requestInfo.getProtocolContext().getHeaders(), (String)"Content-Type", (String)this.requestMessage.getContentType());
                this.requestInfo.setIntegrationRequestMessageType(this.requestMessage.getMessageType());
                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiHTTPtoSOAP - Post costruzione richiesta");
                this.requestMessage.setProtocolName(this.protocolFactory.getProtocol());
                this.requestMessage.setTransactionId(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext));
                this.requestMessage.addContextProperty(Costanti.REQUEST_INFO, (Object)this.requestInfo);
                this.requestMessage.addContextProperty(Costanti.ID_TRANSAZIONE, this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                Object nomePortaInvocataObject = this.context.getPddContext().getObject(CostantiPdD.NOME_PORTA_INVOCATA);
                if (nomePortaInvocataObject instanceof String) {
                    this.requestMessage.addContextProperty(CostantiPdD.NOME_PORTA_INVOCATA, nomePortaInvocataObject);
                }
            }
            catch (Exception e) {
                this.logCore.error(tipoLetturaRisposta + " con errore: " + e.getMessage(), (Throwable)e);
                errorImbustamentoSoapNonRiuscito = tipoLetturaRisposta + " con errore: " + e.getMessage();
                throw e;
            }
            try {
                if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getCredential() != null && this.requestInfo.getProtocolContext().getCredential().getCertificate() != null && this.requestInfo.getProtocolContext().getCredential().getCertificate().getCertificate() != null) {
                    SecurityTokenUtilities.newSecurityToken((Context)this.pddContext);
                }
            }
            catch (Exception e) {
                this.logCore.error("Costruzione SecurityToken non riuscito: " + e.getMessage(), (Throwable)e);
            }
            this.context.setCredenziali(new Credenziali(this.req.getCredential()));
            this.context.setGestioneRisposta(true);
            this.context.setInvocazionePDPerRiferimento(false);
            this.context.setMessageRequest(this.requestMessage);
            this.context.setUrlProtocolContext(this.requestInfo.getProtocolContext());
            this.context.setMsgDiagnostico(this.msgDiag);
            this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.completata");
            this.registraTracciaInRequest();
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(this.context, this.generatoreErrore, async ? this : null);
            gestoreRichiesta.process(this.req);
            completeProcess = true;
        }
        catch (Throwable e) {
            if (this.context == null) {
                this.context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
                this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
                this.context.setTipoPorta(TipoPdD.DELEGATA);
                this.context.setForceFaultAsXML(true);
                this.context.setIdModulo(this.idModulo);
                this.context.getPddContext().addObject(Costanti.PROTOCOL_NAME, this.protocolFactory.getProtocol());
                this.pddContext = this.context.getPddContext();
                this.msgDiag.setPddContext(this.pddContext, this.protocolFactory);
                if (this.postOutResponseContext != null) {
                    this.postOutResponseContext.setPddContext(this.pddContext);
                }
            }
            Throwable tParsing = null;
            ParseException parseException = null;
            if (this.pddContext.containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION) && (parseException = (ParseException)this.pddContext.removeObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null) {
                tParsing = parseException.getParseException();
            }
            if (tParsing == null && (this.requestMessage == null || this.requestMessage.getParseException() == null)) {
                tParsing = ParseExceptionUtils.getParseException((Throwable)e);
            }
            if (errorImbustamentoSoapNonRiuscito != null) {
                this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                this.logCore.error("ImbustamentoSOAP", e);
                Throwable tMessage = null;
                tMessage = tParsing != null ? tParsing : e;
                String msgErrore = tMessage.getMessage();
                if (msgErrore == null) {
                    msgErrore = tMessage.toString();
                }
                this.msgDiag.logErroreGenerico(errorImbustamentoSoapNonRiuscito + "  " + msgErrore, "ImbustamentoSOAP");
                IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                if (parseException != null && parseException.getSourceException() != null && TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                } else if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                }
                this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_422_IMBUSTAMENTO_SOAP_NON_RIUSCITO_RICHIESTA_APPLICATIVA.getErrore422_MessaggioSOAPNonGenerabileTramiteImbustamentoSOAP(errorImbustamentoSoapNonRiuscito), tMessage, null);
            } else if (tParsing != null) {
                this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                String msgErrore = tParsing.getMessage();
                if (msgErrore == null) {
                    msgErrore = tParsing.toString();
                }
                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                this.logCore.error("parsingExceptionRichiesta", e);
                this.msgDiag.logPersonalizzato("parsingExceptionRichiesta");
                IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                if (parseException != null && parseException.getSourceException() != null && TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                } else if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                }
                this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_432_PARSING_EXCEPTION_RICHIESTA.getErrore432_MessaggioRichiestaMalformato(tParsing), tParsing, null);
            } else if (e instanceof HandlerException) {
                IntegrationFunctionError integrationError;
                ErroreIntegrazione errore;
                HandlerException he = (HandlerException)e;
                this.logCore.error("ErroreGenerale (HandlerException)", e);
                if (he.isEmettiDiagnostico()) {
                    this.msgDiag.logErroreGenerico(e, "Generale(richiesta-handler)");
                }
                if ((errore = he.convertToErroreIntegrazione()) == null) {
                    errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Generale(richiesta)");
                }
                if ((integrationError = he.getIntegrationFunctionError()) == null) {
                    integrationError = IntegrationFunctionError.BAD_REQUEST;
                }
                this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, integrationError, errore, e, null);
                he.customized(this.responseMessage);
            } else {
                this.logCore.error("ErroreGenerale", e);
                this.msgDiag.logErroreGenerico(e, "Generale(richiesta)");
                this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, IntegrationFunctionError.BAD_REQUEST, ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, e), e, null);
            }
        }
        finally {
            try {
                if (!completeProcess || !async) {
                    this.completeEngine(AsyncResponseCallbackClientEvent.NONE, completeProcess);
                }
            }
            finally {
                try {
                    GestoreRichieste.saveRequestConfig(this.requestInfo);
                }
                catch (Throwable e) {
                    this.logCore.error("Errore durante il salvataggio dei dati della richiesta: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void asyncComplete(AsyncResponseCallbackClientEvent clientEvent, Object ... args) throws ConnectorException {
        this.completeEngine(clientEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEngine(AsyncResponseCallbackClientEvent clientEvent, boolean completeProcess) throws ConnectorException {
        block163: {
            block161: {
                block162: {
                    if (completeProcess) {
                        this.responseMessage = this.context.getMessageResponse();
                    }
                    if ((this.requestMessage == null || this.requestMessage.getParseException() == null) && (this.pddContext == null || !this.pddContext.containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION))) break block161;
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    parseException = null;
                    parseException = this.requestMessage != null && this.requestMessage.getParseException() != null ? this.requestMessage.getParseException() : (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                    msgErrore = null;
                    if (parseException != null && parseException.getParseException() != null) {
                        msgErrore = parseException.getParseException().getMessage();
                    }
                    if (msgErrore == null) {
                        msgErrore = parseException.getParseException().toString();
                    }
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                    if (parseException != null) {
                        this.logCore.error("parsingExceptionRichiesta", parseException.getSourceException());
                    }
                    this.msgDiag.logPersonalizzato("parsingExceptionRichiesta");
                    integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                    if (parseException == null || parseException.getSourceException() == null || !TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) break block162;
                    integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                    break block163;
                }
                if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                    integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                    break block163;
                } else if (parseException != null) {
                    this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_432_PARSING_EXCEPTION_RICHIESTA.getErrore432_MessaggioRichiestaMalformato(parseException.getParseException()), parseException.getParseException(), null);
                }
                break block163;
            }
            if (this.responseMessage != null && this.responseMessage.getParseException() != null || this.pddContext != null && this.pddContext.containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) {
                if (this.pddContext != null) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                }
                parseException = null;
                parseException = this.responseMessage != null && this.responseMessage.getParseException() != null ? this.responseMessage.getParseException() : (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                msgErrore = parseException.getParseException().getMessage();
                if (msgErrore == null) {
                    msgErrore = parseException.getParseException().toString();
                }
                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                this.logCore.error("parsingExceptionRisposta", parseException.getSourceException());
                this.msgDiag.logPersonalizzato("parsingExceptionRisposta");
                this.responseMessage = this.generatoreErrore.build((Context)this.pddContext, IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato(parseException.getParseException()), parseException.getParseException(), null);
            }
        }
        try {
            v0 = urlProtocolContext = this.context != null ? this.context.getUrlProtocolContext() : null;
            if (urlProtocolContext == null) {
                urlProtocolContext = this.req.getURLProtocolContext();
            }
            if (urlProtocolContext != null) {
                urlInvocazione = urlProtocolContext.getUrlInvocazione_formBased();
                if (urlProtocolContext.getFunction() != null) {
                    urlInvocazione = "[" + urlProtocolContext.getFunction() + "] " + (String)urlInvocazione;
                }
                this.pddContext.addObject(Costanti.URL_INVOCAZIONE, urlInvocazione);
            }
        }
        catch (Throwable urlProtocolContext) {
            // empty catch block
        }
        try {
            v1 = credenziali = this.context != null ? this.context.getCredenziali() : null;
            if (credenziali == null) {
                credenziali = new Credenziali(this.req.getCredential());
            }
            if (credenziali != null && this.pddContext != null) {
                this.pddContext.addObject(Costanti.CREDENZIALI_INVOCAZIONE, credenziali.toString());
            }
        }
        catch (Throwable credenziali) {
            // empty catch block
        }
        try {
            this.req.close();
        }
        catch (Exception e) {
            this.logCore.error("Request.close() error: " + e.getMessage(), (Throwable)e);
        }
        dataPrimaSpedizioneRisposta = DateManager.getDate();
        dataRispostaSpedita = null;
        transazioneDaAggiornare = null;
        if (this.context != null) {
            if (this.context.getMsgDiagnostico() != null) {
                this.msgDiag = this.context.getMsgDiagnostico();
            }
            if (this.context.getResponseHeaders() == null) {
                this.context.setResponseHeaders(new HashMap<String, List<String>>());
            }
            ServicesUtils.setGovWayHeaderResponse(this.requestMessage != null ? this.requestMessage.getServiceBinding() : this.requestInfo.getProtocolServiceBinding(), this.responseMessage, this.openSPCoopProperties, this.context.getResponseHeaders(), this.logCore, true, this.context.getPddContext(), this.requestInfo);
        }
        if (this.context == null || this.context.getResponseHeaders() == null) ** GOTO lbl88
        keys = this.context.getResponseHeaders().keySet().iterator();
        while (true) {
            block165: {
                block164: {
                    if (!keys.hasNext()) break block164;
                    key = keys.next();
                    values = this.context.getResponseHeaders().get(key);
                    if (values == null || values.isEmpty()) continue;
                    break block165;
                }
                if (this.context != null && this.context.getProtocol() != null) {
                    this.generatoreErrore.updateDominio(this.context.getIdentitaPdD());
                    idServizio = null;
                    try {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(this.context.getProtocol().getTipoServizio(), this.context.getProtocol().getServizio(), this.context.getProtocol().getErogatore(), this.context.getProtocol().getVersioneServizio().intValue());
                    }
                    catch (Exception key) {
                        // empty catch block
                    }
                    if (idServizio != null) {
                        idServizio.setAzione(this.context.getProtocol().getAzione());
                        this.generatoreErrore.updateInformazioniCooperazione(this.context.getProtocol().getFruitore(), idServizio);
                    }
                    servizioApplicativo = null;
                    if (this.context.getIntegrazione() != null) {
                        servizioApplicativo = this.context.getIntegrazione().getServizioApplicativoFruitore();
                    }
                    this.generatoreErrore.updateInformazioniCooperazione(servizioApplicativo);
                    this.generatoreErrore.updateProprietaErroreApplicativo(this.context.getProprietaErroreAppl());
                }
                vm = null;
                value = this.res;
                if (value instanceof DirectVMConnectorOutMessage) {
                    vm = directvmconnectoroutmessage = (DirectVMConnectorOutMessage)value;
                } else {
                    value = this.req;
                    if (value instanceof DumpRawConnectorOutMessage && (value = (dumprawconnectoroutmessage = (DumpRawConnectorOutMessage)value).getWrappedConnectorOutMessage()) instanceof DirectVMConnectorOutMessage) {
                        vm = directvmconnectorOutmessage = (DirectVMConnectorOutMessage)value;
                    }
                }
                if (vm != null && this.context != null && this.context.getPddContext() != null) {
                    pInfo = new DirectVMProtocolInfo();
                    oIdTransazione = this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                    if (oIdTransazione != null) {
                        pInfo.setIdTransazione((String)oIdTransazione);
                    }
                    if (this.context.getProtocol() != null) {
                        if (this.context.getProtocol().getIdRichiesta() != null) {
                            pInfo.setIdMessaggioRichiesta(this.context.getProtocol().getIdRichiesta());
                        }
                        if (this.context.getProtocol().getIdRisposta() != null) {
                            pInfo.setIdMessaggioRisposta(this.context.getProtocol().getIdRisposta());
                        }
                    }
                    vm.setDirectVMProtocolInfo(pInfo);
                }
                informazioniErrori = ServicesUtils.readInformazioniErroriInfrastrutturali(this.pddContext);
                esito = null;
                descrizioneSoapFault = "";
                statoServletResponse = 200;
                erroreConsegnaRisposta = null;
                httpEmptyResponse = false;
                lengthOutResponse = -1L;
                erroreConnessioneClient = false;
                sendInvoked = false;
                registraTracciaOutResponse = false;
                try {
                    block167: {
                        block166: {
                            if (this.responseMessage == null || this.responseMessage.isForcedEmptyResponse() || this.responseMessage.getForcedResponse() != null) break block166;
                            forced = false;
                            if (this.responseMessage.getForcedResponseCode() != null) {
                                try {
                                    statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                                    forced = true;
                                }
                                catch (Exception var19_35) {
                                    // empty catch block
                                }
                            }
                            if (ServiceBinding.SOAP.equals((Object)this.responseMessage.getServiceBinding())) {
                                body = this.responseMessage.castAsSoap().getSOAPBody();
                                contentTypeRisposta = null;
                                risposta = null;
                                if (body != null && body.hasFault()) {
                                    statoServletResponse = 500;
                                    msgError = SoapUtils.safe_toString((OpenSPCoop2MessageFactory)this.responseMessage.getFactory(), (SOAPFault)body.getFault(), (boolean)false, (Logger)this.logCore);
                                    xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.responseMessage.getFactory());
                                    risposta = xmlUtils.toByteArray((Element)body.getFault(), true);
                                    contentTypeRisposta = this.responseMessage.getContentType();
                                    descrizioneSoapFault = " (" + msgError + ")";
                                } else {
                                    risposta = TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)this.responseMessage);
                                    if (risposta == null || risposta.length <= 0) {
                                        risposta = null;
                                        if (!forced) {
                                            statoServletResponse = 202;
                                        }
                                    } else {
                                        child = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)body);
                                        if (child != null && this.protocolFactory.createErroreApplicativoBuilder().isErroreApplicativo((Node)child)) {
                                            statoServletResponse = 500;
                                        }
                                        contentTypeRisposta = TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2MessageFactory)this.responseMessage.getFactory(), (SOAPBody)body) != false ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)body) : this.responseMessage.getContentType();
                                    }
                                }
                                if (risposta != null) {
                                    lengthOutResponse = risposta.length;
                                    ServicesUtils.setTransferLength(this.openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), this.req, this.res, Long.valueOf(risposta.length));
                                }
                                this.res.setStatus(statoServletResponse);
                                if (contentTypeRisposta != null) {
                                    this.res.setContentType(contentTypeRisposta);
                                }
                                esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getIntegrationServiceBinding(), this.responseMessage, this.context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)this.pddContext);
                                this.res.sendResponseHeaders(this.responseMessage);
                                registraTracciaOutResponse = true;
                                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                                if (risposta != null) {
                                    sendInvoked = true;
                                    this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])risposta));
                                }
                            } else {
                                ServicesUtils.setTransferLength(this.openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), this.req, this.res, this.responseMessage);
                                this.responseMessage.updateContentType();
                                ServicesUtils.setContentType(this.responseMessage, this.res);
                                consume = true;
                                if (this.responseMessage.castAsRest().isProblemDetailsForHttpApis_RFC7807() || MessageRole.FAULT.equals((Object)this.responseMessage.getMessageRole()) && (MessageType.XML.equals((Object)this.responseMessage.getMessageType()) || MessageType.JSON.equals((Object)this.responseMessage.getMessageType()))) {
                                    consume = false;
                                    contentAsString = null;
                                    try {
                                        contentAsString = this.responseMessage.castAsRest().getContentAsString();
                                    }
                                    catch (Throwable t) {
                                        this.logCore.error("Parsing errore non riuscito: " + t.getMessage(), t);
                                    }
                                    if (contentAsString != null && StringUtils.isNotEmpty((CharSequence)contentAsString)) {
                                        descrizioneSoapFault = " (" + contentAsString + ")";
                                    }
                                }
                                this.res.setStatus(statoServletResponse);
                                esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getIntegrationServiceBinding(), this.responseMessage, this.context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)this.pddContext);
                                registraTracciaOutResponse = true;
                                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Pre scrittura risposta");
                                sendInvoked = true;
                                if (TransferLengthModes.CONTENT_LENGTH.equals((Object)this.openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi())) {
                                    this.res.sendResponse(this.responseMessage, false);
                                } else {
                                    this.res.sendResponse(this.responseMessage, consume);
                                }
                                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Post scrittura risposta");
                            }
                            ** GOTO lbl387
                        }
                        if (this.responseMessage == null || this.responseMessage.getForcedResponse() == null) break block167;
                        response = this.responseMessage.getForcedResponse().getContent();
                        if (response != null) {
                            lengthOutResponse = response.length;
                        }
                        if (response != null && response.length < 1024) {
                            try {
                                descrizioneSoapFault = "(" + new String(response) + ")";
                            }
                            catch (Throwable t) {
                                descrizioneSoapFault = "";
                            }
                        }
                        if (this.responseMessage.getForcedResponse().getHeadersValues() != null && this.responseMessage.getForcedResponse().getHeadersValues().size() > 0) {
                            keys = this.responseMessage.getForcedResponse().getHeadersValues().keySet().iterator();
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    if (this.responseMessage != null && this.responseMessage.getForcedResponseCode() != null) {
                        try {
                            statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                        }
                        catch (Exception response) {}
                    } else {
                        statoServletResponse = this.protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                    }
                    this.res.setStatus(statoServletResponse);
                    httpEmptyResponse = true;
                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getIntegrationServiceBinding(), this.responseMessage, this.context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)this.pddContext);
                    registraTracciaOutResponse = true;
                    transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                    ** GOTO lbl387
                }
                catch (Throwable e) {
                    this.logCore.error("ErroreGenerale", e);
                    erroreConsegnaRisposta = e;
                    erroreConnessioneClient = ServicesUtils.isConnessioneClientNonDisponibile(e);
                    try {
                        esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                    try {
                        if (!sendInvoked) {
                            rispostaErrore = null;
                            returnCode = new ArrayList<Integer>();
                            informazioniErroriInfrastrutturaliError = null;
                            if (this.responseMessage != null && this.responseMessage.getParseException() != null || this.pddContext.containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) {
                                parseException = null;
                                parseException = this.responseMessage != null && this.responseMessage.getParseException() != null ? this.responseMessage.getParseException() : (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                                msgErrore = parseException.getParseException().getMessage();
                                if (msgErrore == null) {
                                    msgErrore = parseException.getParseException().toString();
                                }
                                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                                this.logCore.error("parsingExceptionRisposta", parseException.getSourceException());
                                this.msgDiag.logPersonalizzato("parsingExceptionRisposta");
                                rispostaErrore = this.generatoreErrore.buildAsByteArray(this.pddContext, IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato(parseException.getParseException()), returnCode);
                                informazioniErroriInfrastrutturaliError = new InformazioniErroriInfrastrutturali();
                                informazioniErroriInfrastrutturaliError.setContenutoRispostaNonRiconosciuto(true);
                            } else {
                                ife = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                                if (e instanceof HandlerException && (he = (HandlerException)e).getIntegrationFunctionError() != null) {
                                    ife = he.getIntegrationFunctionError();
                                }
                                rispostaErrore = this.generatoreErrore.buildAsByteArray(this.pddContext, ife, ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(false, e), returnCode);
                            }
                            lengthOutResponse = rispostaErrore.length;
                            ServicesUtils.setTransferLength(this.openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), this.req, this.res, Long.valueOf(rispostaErrore.length));
                            statoServletResponse = 200;
                            if (returnCode != null && !returnCode.isEmpty()) {
                                statoServletResponse = (Integer)returnCode.get(0);
                            }
                            this.res.setStatus(statoServletResponse);
                            if (informazioniErroriInfrastrutturaliError != null) {
                                esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getIntegrationServiceBinding(), null, this.context.getProprietaErroreAppl(), informazioniErroriInfrastrutturaliError, (org.openspcoop2.utils.Map)this.pddContext);
                            }
                            this.res.setContentType("text/xml");
                            if (!registraTracciaOutResponse) {
                                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                            }
                            this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])rispostaErrore));
                        }
                        ** GOTO lbl387
                    }
                    catch (Throwable error) {
                        if (!erroreConnessioneClient) {
                            erroreConnessioneClient = ServicesUtils.isConnessioneClientNonDisponibile(error);
                        }
                        this.logCore.error("Generazione di un risposta errore non riuscita", error);
                        statoServletResponse = 500;
                        try {
                            this.res.setStatus(500);
                        }
                        catch (Exception eStatus) {
                            this.logCore.error("Response.setStatus(500) error: " + eStatus.getMessage(), (Throwable)eStatus);
                        }
                        ris = error.toString().getBytes();
                        try {
                            this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])ris));
                        }
                        catch (Exception erroreStreamChiuso) {
                            erroreConnessioneClient = true;
                        }
                        lengthOutResponse = ris.length;
                    }
                    ** GOTO lbl387
                }
                finally {
                    block158: {
                        if (!sendInvoked) {
                            statoServletResponse = this.res.getResponseStatus();
                        }
                        this.msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + statoServletResponse);
                        this.msgDiag.addKeyword("@SOAP_FAULT@", (String)descrizioneSoapFault);
                        try {
                            this.res.flush(true);
                            this.res.close(clientEvent, true);
                            dataRispostaSpedita = DateManager.getDate();
                            if (erroreConsegnaRisposta != null) {
                                this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", erroreConsegnaRisposta.toString());
                                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                                break block158;
                            }
                            if (httpEmptyResponse) {
                                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativaVuota");
                                break block158;
                            }
                            if (statoServletResponse >= 300) {
                                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativaKoEffettuata");
                            } else {
                                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativaOkEffettuata");
                            }
                        }
                        catch (Exception e) {
                            erroreConnessioneClient = true;
                            this.logCore.error("Chiusura stream non riuscita", (Throwable)e);
                            this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", e.toString());
                            this.msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                            erroreConsegnaRisposta = e;
                            if (esito != null && EsitoTransazioneName.OK.equals((Object)esito.getName())) {
                                try {
                                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                                }
                                catch (Exception eBuildError) {
                                    esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                                }
                            }
                        }
                        finally {
                            if (dataRispostaSpedita == null) {
                                dataRispostaSpedita = DateManager.getDate();
                            }
                        }
                    }
                    if (this.dumpRaw != null && this.dumpRaw.isActiveDumpRisposta()) {
                        this.dumpRaw.serializeResponse((DumpRawConnectorOutMessage)this.res);
                    }
                }
            }
            i = 0;
            while (true) {
                if (i >= values.size()) ** break;
                value = values.get(i);
                verbo = "";
                try {
                    if (i == 0) {
                        verbo = "set";
                        this.res.setHeader(key, (String)value);
                    } else {
                        verbo = "add";
                        this.res.addHeader(key, (String)value);
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Response." + verbo + "Header(" + key + "," + (String)value + ") set failed: " + e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            break;
        }
        while (true) {
            if (keys.hasNext()) {
                key = (String)keys.next();
                values = (List)this.responseMessage.getForcedResponse().getHeadersValues().get(key);
                if (values == null || values.isEmpty()) continue;
            } else lbl-1000:
            // 2 sources

            {
                if (this.responseMessage.getForcedResponse().getContentType() != null) {
                    this.res.setContentType(this.responseMessage.getForcedResponse().getContentType());
                }
                if (this.responseMessage.getForcedResponse().getResponseCode() != null) {
                    try {
                        statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponse().getResponseCode());
                    }
                    catch (Exception keys) {}
                } else if (this.responseMessage != null && this.responseMessage.getForcedResponseCode() != null) {
                    try {
                        statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                    }
                    catch (Exception keys) {
                        // empty catch block
                    }
                }
                this.res.setStatus(statoServletResponse);
                if (this.context != null) {
                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getIntegrationServiceBinding(), this.responseMessage, this.context.getProprietaErroreAppl(), informazioniErrori, (org.openspcoop2.utils.Map)this.pddContext);
                }
                registraTracciaOutResponse = true;
                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                if (response != null) {
                    sendInvoked = true;
                    this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])response));
                }
lbl387:
                // 9 sources

                if (erroreConnessioneClient) {
                    try {
                        esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_CONNESSIONE_CLIENT_NON_DISPONIBILE);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                } else if (EsitoTransazioneName.OK.equals((Object)esito.getName()) && this.context != null && this.context.getPddContext() != null && this.context.getPddContext().containsKey(Costanti.EMESSI_DIAGNOSTICI_ERRORE)) {
                    esito = ServicesUtils.updateEsitoConAnomalie(esito, this.logCore, this.protocolFactory);
                }
                location = "...";
                try {
                    c = null;
                    if (this.context != null && this.context.getPddContext() != null && this.context.getPddContext().containsKey(Costanti.ID_TRANSAZIONE)) {
                        this.idTransazione = (String)this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                    }
                    if (this.idTransazione != null) {
                        c = RepositoryConnettori.removeConnettorePD(this.idTransazione);
                    }
                    if (c != null) {
                        location = c.getLocation();
                        c.disconnect();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logDisconnectError(e, location);
                }
                if (this.postOutResponseContext != null) {
                    try {
                        this.updateContext(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                        this.postOutResponseContext.setTransazioneDaAggiornare(transazioneDaAggiornare);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
                    }
                    GestoreHandlers.postOutResponse(this.postOutResponseContext, this.msgDiag, this.logCore);
                }
                try {
                    if (this.requestMessage != null && this.requestMessage.getNotifierInputStream() != null) {
                        this.requestMessage.getNotifierInputStream().close();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream richiesta");
                }
                try {
                    if (this.responseMessage != null && this.responseMessage.getNotifierInputStream() != null) {
                        this.responseMessage.getNotifierInputStream().close();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream risposta");
                }
                this.requestMessage = null;
                this.responseMessage = null;
                return;
            }
            i = 0;
            while (true) {
                if (i >= values.size()) ** break;
                value = (String)values.get(i);
                verbo = "";
                try {
                    if (i == 0) {
                        verbo = "set";
                        this.res.setHeader(key, value);
                    } else {
                        verbo = "add";
                        this.res.addHeader(key, value);
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Response(Forced)." + verbo + "Header(" + key + "," + value + ") error: " + e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            break;
        }
    }

    private void updateContext(Date dataPrimaSpedizioneRisposta, Date dataRispostaSpedita, EsitoTransazione esito, int statoServletResponse, Throwable erroreConsegnaRisposta, long lengthOutResponse) throws ConnectorException {
        if (this.postOutResponseContext != null) {
            this.postOutResponseContext.getPddContext().addObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA, this.dataAccettazioneRichiesta);
            if (this.dataIngressoRichiesta != null) {
                this.postOutResponseContext.getPddContext().addObject(CostantiPdD.DATA_INGRESSO_RICHIESTA, this.dataIngressoRichiesta);
            }
            this.postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            this.postOutResponseContext.setDataPrimaSpedizioneRisposta(dataPrimaSpedizioneRisposta);
            this.postOutResponseContext.setDataRispostaSpedita(dataRispostaSpedita);
            if (erroreConsegnaRisposta == null) {
                this.postOutResponseContext.setEsito(esito);
            } else {
                try {
                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                }
                catch (Exception eBuildError) {
                    esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                }
                this.postOutResponseContext.setEsito(esito);
            }
            this.postOutResponseContext.setReturnCode(statoServletResponse);
            this.postOutResponseContext.setResponseHeaders(this.context.getResponseHeaders());
            this.postOutResponseContext.setProtocollo(this.context.getProtocol());
            this.postOutResponseContext.setIntegrazione(this.context.getIntegrazione());
            if (this.context.getTipoPorta() != null) {
                this.postOutResponseContext.setTipoPorta(this.context.getTipoPorta());
            }
            this.postOutResponseContext.setIdModulo(this.idModulo);
            if (this.inputBody != null) {
                this.postOutResponseContext.setInputRequestMessageSize(Long.valueOf(this.inputBody.length));
            }
            if (this.requestMessage != null) {
                this.postOutResponseContext.setOutputRequestMessageSize(this.requestMessage.getOutgoingMessageContentLength());
            } else {
                this.postOutResponseContext.setInputRequestMessageSize((long)this.req.getContentLength() + 0L);
            }
            if (erroreConsegnaRisposta == null && this.responseMessage != null && !this.responseMessage.isForcedEmptyResponse() && this.responseMessage.getForcedResponse() == null) {
                this.postOutResponseContext.setInputResponseMessageSize(this.responseMessage.getIncomingMessageContentLength());
                this.postOutResponseContext.setOutputResponseMessageSize(lengthOutResponse);
                this.postOutResponseContext.setMessaggio(this.responseMessage);
            } else if (this.responseMessage != null && this.responseMessage.getForcedResponse() != null && this.responseMessage.getForcedResponse().getContent() != null) {
                this.postOutResponseContext.setInputResponseMessageSize(this.responseMessage.getIncomingMessageContentLength());
                this.postOutResponseContext.setOutputResponseMessageSize(Long.valueOf(this.responseMessage.getForcedResponse().getContent().length));
            }
        }
    }

    private Transazione registraTracciaOutResponse(Date dataPrimaSpedizioneRisposta, Date dataRispostaSpedita, EsitoTransazione esito, int statoServletResponse, Throwable erroreConsegnaRisposta, long lengthOutResponse) throws HandlerException {
        try {
            if (this.postOutResponseContext != null) {
                this.updateContext(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, lengthOutResponse);
                TracciamentoManager tracciamentoManager = new TracciamentoManager(FaseTracciamento.OUT_RESPONSE);
                if (!tracciamentoManager.isTransazioniEnabled()) {
                    return null;
                }
                InformazioniTransazione info = new InformazioniTransazione(this.postOutResponseContext);
                tracciamentoManager.invoke(info, this.postOutResponseContext.getEsito(), this.context.getResponseHeaders(), this.msgDiag);
                return info.getTransazioneDaAggiornare();
            }
        }
        catch (Exception e) {
            ServicesUtils.processTrackingException(e, this.postOutResponseContext.getLogCore(), FaseTracciamento.OUT_RESPONSE, this.context.getPddContext());
        }
        return null;
    }

    private void registraTracciaInRequest() throws HandlerException {
        try {
            TracciamentoManager tracciamentoManager = new TracciamentoManager(FaseTracciamento.IN_REQUEST);
            if (!tracciamentoManager.isTransazioniEnabled()) {
                return;
            }
            InformazioniTransazione info = new InformazioniTransazione();
            info.setContext(this.context.getPddContext());
            info.setTipoPorta(this.context.getTipoPorta());
            info.setProtocolFactory(this.protocolFactory);
            info.setProtocollo(this.context.getProtocol());
            info.setIntegrazione(this.context.getIntegrazione());
            info.setIdModulo(this.context.getIdModulo());
            TransportRequestContext transportRequestContext = null;
            if (this.context.getMessageRequest() != null) {
                transportRequestContext = this.context.getMessageRequest().getTransportRequestContext();
            }
            String esitoContext = EsitoBuilder.getTipoContext((TransportRequestContext)transportRequestContext, (EsitiProperties)EsitiProperties.getInstance((Logger)this.logCore, this.protocolFactory), (Logger)this.logCore);
            tracciamentoManager.invoke(info, esitoContext, this.msgDiag);
        }
        catch (Exception e) {
            ServicesUtils.processTrackingException(e, this.logCore, FaseTracciamento.IN_REQUEST, this.context.getPddContext());
        }
    }
}

