/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import java.util.List;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.core.FlowProperties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.slf4j.Logger;

public class RicezioneBusteUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowProperties getFlowPropertiesRequest(OpenSPCoop2Message requestMessage, Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, RequestInfo requestInfo, PdDContext pddContext, PortaApplicativa paFind) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = RuoloMessaggio.RICHIESTA;
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            PortaDelegata pd;
            IDPortaDelegata idPD;
            RepositoryBuste repository;
            Integrazione integrazione;
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente) && (integrazione = (repository = new RepositoryBuste((IState)state, true, protocolFactory)).getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiscontro(0).getID())).getNomePorta() != null) {
                idPD = new IDPortaDelegata();
                idPD.setNome(integrazione.getNomePorta());
                pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd);
                flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd);
            }
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pa);
                    }
                } else {
                    PortaDelegata pd2 = null;
                    if (state != null) {
                        RepositoryBuste repository2 = new RepositoryBuste((IState)state, false, protocolFactory);
                        Integrazione integrazione2 = repository2.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        IDPortaDelegata idPD2 = new IDPortaDelegata();
                        idPD2.setNome(integrazione2.getNomePorta());
                        pd2 = configurazionePdDReader.getPortaDelegataSafeMethod(idPD2, requestInfo);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd2);
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd2);
                    flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pa);
                    }
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setNome(integrazione.getNomePorta());
                    pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pd, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pd);
                } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, true, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setNome(integrazione.getNomePorta());
                    pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setNome(integrazione.getNomePorta());
                    pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pa);
                    }
                } else {
                    profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, protocolFactory);
                    if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        IDServizio idServizioPA;
                        IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                        PortaApplicativa pa = paFind;
                        if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                            idServizioPA.setAzione(idServizioOriginale.getAzione());
                            pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                        }
                        if (pa != null) {
                            flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                            flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pa);
                        }
                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, true, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setNome(integrazione.getNomePorta());
                        pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
                    } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, false, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setNome(integrazione.getNomePorta());
                        pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
                    }
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_RequestProperties");
            logCore.error("Lettura dati Message-Security / MTOM per la ricezione del messaggio non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowProperties getFlowPropertiesResponse(OpenSPCoop2Message requestMessage, Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, RequestInfo requestInfo, PdDContext pddContext, PortaApplicativa paFind, FlowProperties flowPropertiesRequest) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente)) {
                if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                    IDServizio idServizioPA;
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext, null);
                        flowProperties.messageSecurityRequest = flowPropertiesRequest != null ? flowPropertiesRequest.messageSecurity : null;
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pa);
                    }
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                IDServizio idServizioPA;
                PortaApplicativa pa = paFind;
                if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                    idServizioPA.setAzione(bustaRichiesta.getAzione());
                    pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                }
                if (pa != null) {
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext, null);
                    flowProperties.messageSecurityRequest = flowPropertiesRequest != null ? flowPropertiesRequest.messageSecurity : null;
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pa);
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDServizio idServizioPA;
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext, null);
                        flowProperties.messageSecurityRequest = flowPropertiesRequest != null ? flowPropertiesRequest.messageSecurity : null;
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pa);
                    }
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    RepositoryBuste repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(integrazione.getNomePorta());
                    PortaDelegata pd = configurazionePdDReader.getPortaDelegataSafeMethod(idPD, requestInfo);
                    flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pd, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext);
                    flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pd);
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, protocolFactory);
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDServizio idServizioPA;
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(bustaRichiesta.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext, null);
                        flowProperties.messageSecurityRequest = flowPropertiesRequest != null ? flowPropertiesRequest.messageSecurity : null;
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pa);
                    }
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    IDServizio idServizioPA;
                    IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idServizioPA = this.buildIdServizio(bustaRichiesta)) != null) {
                        idServizioPA.setAzione(idServizioOriginale.getAzione());
                        pa = this.getPortaApplicativaIgnoreNotFound(configurazionePdDReader, idServizioPA);
                    }
                    if (pa != null) {
                        flowProperties.messageSecurity = configurazionePdDReader.getMessageSecurityForSender(pa, logCore, requestMessage, bustaRichiesta, requestInfo, pddContext, null);
                        flowProperties.messageSecurityRequest = flowPropertiesRequest != null ? flowPropertiesRequest.messageSecurity : null;
                        flowProperties.mtom = configurazionePdDReader.getMTOMProcessorForSender(pa);
                    }
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_ResponseProperties");
            logCore.error("Lettura dati Message-Security / MTOM per la spedizione del messaggio di risposta non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    public PortaApplicativa getPortaApplicativa(ConfigurazionePdDManager configurazionePdDReader, IDServizio idServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        List<PortaApplicativa> listPa = configurazionePdDReader.getPorteApplicative(idServizio, false);
        if (listPa.isEmpty()) {
            throw new DriverConfigurazioneException("Non esiste alcuna porta applicativa indirizzabile tramite il servizio [" + String.valueOf(idServizio) + "]");
        }
        if (listPa.size() > 1) {
            throw new DriverConfigurazioneException("Esiste pi\u00f9 di una porta applicativa indirizzabile tramite il servizio [" + String.valueOf(idServizio) + "]");
        }
        return listPa.get(0);
    }

    public PortaApplicativa getPortaApplicativaIgnoreNotFound(ConfigurazionePdDManager configurazionePdDReader, IDServizio idServizio) throws Exception {
        try {
            return this.getPortaApplicativa(configurazionePdDReader, idServizio);
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            return null;
        }
    }

    private IDServizio buildIdServizio(Busta bustaRichiesta) {
        IDServizio idServizioPA = null;
        try {
            idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getVersioneServizio().intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idServizioPA;
    }
}

