/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativaConfig;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.MTOMProcessor;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.StatoServiziPdD;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiRest;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazione;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneHttpServletRequest;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.handlers.BaseContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.response_caching.HashGenerator;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.GestioneAttributeAuthority;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.mdb.InoltroRisposte;
import org.openspcoop2.pdd.mdb.SbustamentoMessage;
import org.openspcoop2.pdd.services.DirectVMProtocolInfo;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.pdd.services.core.FlowProperties;
import org.openspcoop2.pdd.services.core.RicezioneBusteContext;
import org.openspcoop2.pdd.services.core.RicezioneBusteGeneratoreBustaErrore;
import org.openspcoop2.pdd.services.core.RicezioneBusteGestioneAutenticazione;
import org.openspcoop2.pdd.services.core.RicezioneBusteGestioneRisposta;
import org.openspcoop2.pdd.services.core.RicezioneBusteGestioneToken;
import org.openspcoop2.pdd.services.core.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.core.RicezioneBusteParametriGenerazioneBustaErrore;
import org.openspcoop2.pdd.services.core.RicezioneBusteParametriInvioBustaErrore;
import org.openspcoop2.pdd.services.core.RicezioneBusteUtils;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.engine.MessageSecurityFactory;
import org.openspcoop2.security.message.engine.WSSUtilities;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RicezioneBuste
implements IAsyncResponseCallback {
    public static final String ID_MODULO = "RicezioneBuste";
    private static final String INIZIALIZZAZIONE_RISORSE = "InizializzazioneRisorseServizioRicezioneBuste";
    private static final String SOGGETTO_FRUITORE_NON_IDENTIFICATO = "Soggetto fruitore non identificato";
    public static boolean initializeService = false;
    public static String[] defaultGestoriIntegrazionePA = null;
    public static ConcurrentHashMap<String, String[]> defaultPerProtocolloGestoreIntegrazionePA = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneBusteExternalErrorGenerator generatoreErrore;
    private RicezioneBusteContext msgContext;
    private RicezioneBusteGeneratoreBustaErrore ricezioneBusteGeneratoreBustaErrore;
    private IAsyncResponseCallback asyncResponseCallback;
    private Logger logCore;
    private SbustamentoMessage sbustamentoMSG;
    private ConfigurazionePdDManager configurazionePdDReader;
    private RegistroServiziManager registroServiziReader;
    private MsgDiagnostico msgDiag;
    private PdDContext pddContext;
    private String idTransazione;
    private Transaction transaction = null;
    private String idMessageRequest;
    private Busta bustaRichiesta;
    private List<Eccezione> erroriValidazione;
    private List<Eccezione> erroriProcessamento;
    private OpenSPCoop2Message requestMessage;
    private boolean isMessaggioErroreProtocollo;
    private boolean bustaDiServizio;
    private boolean mittenteAnonimo = false;
    private String implementazionePdDMittente;
    private RuoloBusta ruoloBustaRicevuta;
    private String versioneProtocollo;
    private IDSoggetto identitaPdD;
    private IDSoggetto soggettoFruitore = null;
    private IDServizio idServizio = null;
    private TipoPdD tipoPorta;
    private PortaApplicativa pa = null;
    private PortaDelegata pd = null;
    private boolean oneWayVersione11;
    private boolean oneWayStateless;
    private boolean sincronoStateless;
    private boolean asincronoStateless;
    private boolean portaStateless;
    private boolean routingStateless;
    private boolean functionAsRouter;
    private boolean newConnectionForResponse;
    private boolean utilizzoIndirizzoTelematico;
    private OpenSPCoopState openspcoopstate = null;
    private Tracciamento tracciamento = null;
    private String correlazioneApplicativa = null;
    private GestoreMessaggi msgRequest = null;
    private RepositoryBuste repositoryBuste = null;
    private PdDContext context;
    private HashMap<String, Object> internalObjects = null;
    private InRequestContext inRequestContext = null;
    private RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore = null;
    private RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore = null;
    private MessageSecurityContext messageSecurityContext = null;
    private FlowProperties flowPropertiesResponse = null;
    private Integrazione infoIntegrazione;
    private HeaderIntegrazione headerIntegrazioneRichiesta;
    private String[] tipiIntegrazionePA = null;
    private IProtocolFactory<?> protocolFactory;
    private IProtocolVersionManager moduleManager;
    private ITraduttore traduttore;
    private boolean readQualifiedAttribute;
    private ProprietaManifestAttachments proprietaManifestAttachments;
    private boolean asyncWait = false;
    private EsitoLib esitoStatelessAfterSendRequest;
    private boolean terminataGestioneStateless = false;
    private boolean terminataGestioneStatelessErrorBeforeAsyncrConnettore = false;

    private static void logDebug(Logger logCore, String msg) {
        logCore.debug(msg);
    }

    private static void logDebug(Logger logCore, String msg, Throwable e) {
        logCore.debug(msg, e);
    }

    private static void logInfo(Logger logCore, String msg) {
        logCore.info(msg);
    }

    private static void logError(Logger logCore, String msg) {
        logCore.error(msg);
    }

    private static void logError(Logger logCore, String msg, Throwable e) {
        logCore.error(msg, e);
    }

    public static synchronized void initializeService(ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws CoreException, ProtocolException {
        if (initializeService) {
            return;
        }
        String effettuataSuffix = " effettuata.";
        Loader loader = Loader.getInstance();
        PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            RicezioneBuste.logInfo(logCore, "Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + effettuataSuffix);
        }
        catch (Exception e) {
            throw new CoreException("Riscontrato errore durante il caricamento della classe 'NodeSender' [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            RicezioneBuste.logInfo(logCore, "Inizializzazione gestore NodeReceiver di tipo " + classType + effettuataSuffix);
        }
        catch (Exception e) {
            throw new CoreException("Riscontrato errore durante il caricamento della classe 'NodeReceiver' [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        String[] tipiIntegrazioneDefault = propertiesReader.getTipoIntegrazionePA();
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < tipiIntegrazioneDefault.length; ++i) {
            try {
                IGestoreIntegrazionePA gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazioneDefault[i]);
                gestore.toString();
                s.add(tipiIntegrazioneDefault[i]);
                RicezioneBuste.logInfo(logCore, "Inizializzazione gestore dati di integrazione 'IGestoreIntegrazionePA' per le erogazioni di tipo " + tipiIntegrazioneDefault[i] + effettuataSuffix);
                continue;
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (!s.isEmpty()) {
            defaultGestoriIntegrazionePA = s.toArray(new String[1]);
        }
        defaultPerProtocolloGestoreIntegrazionePA = new ConcurrentHashMap();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePA = propertiesReader.getTipoIntegrazionePA(protocol);
            if (tipiIntegrazionePA == null || tipiIntegrazionePA.length <= 0) continue;
            ArrayList<String> tipiIntegrazionePerProtocollo = new ArrayList<String>();
            for (int i = 0; i < tipiIntegrazionePA.length; ++i) {
                try {
                    IGestoreIntegrazionePA gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                    gestore.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePA[i]);
                    RicezioneBuste.logInfo(logCore, "Inizializzazione gestore dati di integrazione (protocollo: " + protocol + ") per le erogazioni di tipo " + tipiIntegrazionePA[i] + effettuataSuffix);
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
            }
            if (tipiIntegrazionePerProtocollo.isEmpty()) continue;
            defaultPerProtocolloGestoreIntegrazionePA.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPA();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    RicezioneBuste.logInfo(logCore, "Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + effettuataSuffix);
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException("Riscontrato errore durante il caricamento della classe 'IGestoreCredenziali' [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneBuste(RicezioneBusteContext context, RicezioneBusteExternalErrorGenerator generatoreErrore, IAsyncResponseCallback asyncResponseCallback) {
        this.msgContext = context;
        this.generatoreErrore = generatoreErrore;
        this.asyncResponseCallback = asyncResponseCallback;
    }

    public void process(Object ... params) throws ConnectorException {
        try {
            this.internalProcess(params);
        }
        finally {
            if (this.asyncResponseCallback != null && !this.asyncWait) {
                this.asyncResponseCallback.asyncComplete(AsyncResponseCallbackClientEvent.NONE, new Object[0]);
            }
        }
    }

    @Override
    public void asyncComplete(AsyncResponseCallbackClientEvent clientEvent, Object ... args) throws ConnectorException {
        if (this.asyncResponseCallback == null) {
            throw new ConnectorException("Async context not active");
        }
        if (args == null || args.length < 1) {
            throw new ConnectorException("Async context invalid (EsitoLib not found)");
        }
        Object esito = args[0];
        if (!(esito instanceof EsitoLib)) {
            throw new ConnectorException("Async context invalid (EsitoLib with uncorrect type '" + esito.getClass().getName() + "')");
        }
        this.esitoStatelessAfterSendRequest = (EsitoLib)esito;
        this._statelessComplete(true);
        this.asyncResponseCallback.asyncComplete(clientEvent, new Object[0]);
    }

    private void internalProcess(Object ... params) {
        String tipo;
        OpenSPCoop2Properties properties;
        this.context = this.msgContext.getPddContext();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.logCore == null) {
            this.logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.msgDiag = this.msgContext.getMsgDiagnostico();
        this.requestMessage = this.msgContext.getMessageRequest();
        if (this.requestMessage == null) {
            this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, new Exception("Request message is null"), "LetturaMessaggioRichiesta");
        }
        try {
            if (this.context == null) {
                throw new CoreException("Context is null");
            }
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.context.getObject(org.openspcoop2.core.constants.Costanti.PROTOCOL_NAME));
        }
        catch (Exception e) {
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, this.logCore, this.msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        this.inRequestContext = new InRequestContext(this.logCore, this.protocolFactory, null);
        this.inRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        this.inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null && this.msgContext.getUrlProtocolContext().getHttpServletRequest() != null && (properties = OpenSPCoop2Properties.getInstance()) != null && (tipo = properties.getRealContainerCustom()) != null) {
            try {
                ClassNameProperties className = ClassNameProperties.getInstance();
                Loader loader = Loader.getInstance();
                String tipoClass = className.getRealmContainerCustom(tipo);
                IAutorizzazioneSecurityContainer authEngine = (IAutorizzazioneSecurityContainer)loader.newInstance(tipoClass);
                authEngine.init(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), this.context, this.protocolFactory);
                AutorizzazioneHttpServletRequest httpServletRequestAuth = new AutorizzazioneHttpServletRequest(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), authEngine);
                this.msgContext.getUrlProtocolContext().updateHttpServletRequest((HttpServletRequest)httpServletRequestAuth);
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "AutorizzazioneSecurityContainerInstance");
                return;
            }
        }
        connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        if (this.requestMessage != null && ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
            try {
                connettore.setSoapAction(this.requestMessage.castAsSoap().getSoapAction());
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "LetturaSoapAction");
                return;
            }
        }
        connettore.setFromLocation(this.msgContext.getSourceLocation());
        this.inRequestContext.setConnettore(connettore);
        this.inRequestContext.setDataAccettazioneRichiesta(this.msgContext.getDataAccettazioneRichiesta());
        this.inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        this.inRequestContext.setPddContext(this.context);
        this.inRequestContext.setMessaggio(this.requestMessage);
        try {
            GestoreHandlers.inRequest(this.inRequestContext, this.msgDiag, this.logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        this.internalObjects = new HashMap();
        try {
            this.processEngine(this.internalObjects, params);
        }
        catch (TracciamentoException tracciamentoException) {
            this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
            return;
        }
        catch (DumpException e) {
            this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            return;
        }
        catch (ProtocolException protocolException) {
            this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)protocolException), "ProtocolFactoryNonInstanziata");
            return;
        }
        if (this.asyncResponseCallback == null) {
            this._processComplete(false);
        }
    }

    private void _processComplete(boolean invokedFromAsyncConnector) {
        if (!this.internalObjects.containsKey("PROCESS_COMPLETE_SET_TIPO")) {
            try {
                if (invokedFromAsyncConnector) {
                    // empty if block
                }
                if (this.context != null && this.msgContext.getIntegrazione() != null) {
                    if (this.context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA)) {
                        this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)this.context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA)) {
                        this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)this.context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA)) {
                        this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)this.context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA)) {
                        this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)this.context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA));
                    }
                }
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "FinalizeIntegrationContextRicezioneBuste");
                return;
            }
            this.internalObjects.put("PROCESS_COMPLETE_SET_TIPO", true);
        }
        if (!this.internalObjects.containsKey("DumpRichiestaEffettuato") && Dump.isSistemaDumpDisponibile()) {
            try {
                OpenSPCoop2Message msgRichiesta;
                URLProtocolContext urlProtocolContext;
                if (this.configurazionePdDReader == null) {
                    this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                }
                if (!this.internalObjects.containsKey("DumpConfig") && (urlProtocolContext = this.msgContext.getUrlProtocolContext()) != null && urlProtocolContext.getInterfaceName() != null) {
                    IDPortaApplicativa identificativoPortaApplicativa = new IDPortaApplicativa();
                    identificativoPortaApplicativa.setNome(urlProtocolContext.getInterfaceName());
                    PortaApplicativa portaApplicativa = this.configurazionePdDReader.getPortaApplicativaSafeMethod(identificativoPortaApplicativa, this.msgContext.getRequestInfo());
                    if (portaApplicativa != null) {
                        DumpConfigurazione dumpConfig = this.configurazionePdDReader.getDumpConfigurazione(portaApplicativa);
                        this.internalObjects.put("DumpConfig", dumpConfig);
                    }
                }
                if ((msgRichiesta = this.inRequestContext.getMessaggio()) != null) {
                    Dump dumpApplicativo = this.getDump(this.configurazionePdDReader, this.protocolFactory, this.internalObjects, this.msgDiag.getPorta());
                    dumpApplicativo.dumpRichiestaIngresso(msgRichiesta, this.inRequestContext.getConnettore().getUrlProtocolContext());
                }
            }
            catch (DumpException dumpException) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)dumpException), "DumpNonRiuscito");
                return;
            }
            catch (Exception dumpException) {
                // empty catch block
            }
        }
        BaseContext outResponseContext = null;
        if (!this.internalObjects.containsKey("PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER")) {
            outResponseContext = new OutResponseContext(this.logCore, this.protocolFactory, null);
            outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
            outResponseContext.setIdModulo(this.msgContext.getIdModulo());
            outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            outResponseContext.setPddContext(this.inRequestContext.getPddContext());
            ((OutResponseContext)outResponseContext).setProtocollo(this.msgContext.getProtocol());
            ((OutResponseContext)outResponseContext).setIntegrazione(this.msgContext.getIntegrazione());
            ((OutResponseContext)outResponseContext).setResponseHeaders(this.msgContext.getResponseHeaders());
            OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
            outResponseContext.setMessaggio(msgResponse);
            try {
                GestoreHandlers.outResponse((OutResponseContext)outResponseContext, this.msgDiag, this.logCore);
            }
            catch (HandlerException e) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, e.getIdentitaHandler());
                return;
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "InvocazioneOutResponseHandler");
                return;
            }
            this.internalObjects.put("PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER", true);
        }
        OpenSPCoop2Message msgRisposta = null;
        if (outResponseContext != null) {
            try {
                msgRisposta = outResponseContext.getMessaggio();
                boolean rispostaPresente = true;
                OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
                if (properties != null) {
                    rispostaPresente = ServicesUtils.verificaRispostaRelazioneCodiceTrasporto202(this.protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
                }
                if (rispostaPresente) {
                    this.msgContext.setMessageResponse(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(null);
                    msgRisposta = null;
                }
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "FineGestioneRicezioneBuste");
                return;
            }
        }
        if (!this.internalObjects.containsKey("DumpRispostaEffettuato") && Dump.isSistemaDumpDisponibile() && outResponseContext != null) {
            try {
                if (this.configurazionePdDReader == null) {
                    this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                }
                if (msgRisposta != null) {
                    Dump dumpApplicativo = this.getDump(this.configurazionePdDReader, this.protocolFactory, this.internalObjects, this.msgDiag.getPorta());
                    if (((OutResponseContext)outResponseContext).getResponseHeaders() == null) {
                        ((OutResponseContext)outResponseContext).setResponseHeaders(new HashMap<String, List<String>>());
                    }
                    Map<String, List<String>> propertiesTrasporto = ((OutResponseContext)outResponseContext).getResponseHeaders();
                    ServiceBinding sb = this.requestMessage != null ? this.requestMessage.getServiceBinding() : this.msgContext.getRequestInfo().getProtocolServiceBinding();
                    ServicesUtils.setGovWayHeaderResponse(sb, msgRisposta, OpenSPCoop2Properties.getInstance(), propertiesTrasporto, this.logCore, false, outResponseContext.getPddContext(), this.msgContext.getRequestInfo());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, this.inRequestContext.getConnettore().getUrlProtocolContext(), ((OutResponseContext)outResponseContext).getResponseHeaders());
                    this.internalObjects.put("DumpRispostaEffettuato", true);
                }
            }
            catch (DumpException dumpException) {
                this.setSOAPFaultProcessamento(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)dumpException), "DumpNonRiuscito");
            }
            catch (Exception e) {
                RicezioneBuste.logError(this.logCore, e.getMessage(), e);
            }
        }
    }

    private Dump getDump(ConfigurazionePdDManager configurazionePdDReader, IProtocolFactory<?> protocolFactory, HashMap<String, Object> internalObjects, String nomePorta) throws DumpException, DriverRegistroServiziException {
        DumpConfigurazione dumpConfig = null;
        dumpConfig = internalObjects.containsKey("DumpConfig") ? (DumpConfigurazione)internalObjects.get("DumpConfig") : configurazionePdDReader.getDumpConfigurazionePortaApplicativa();
        ProtocolContext protocolContext = this.msgContext.getProtocol();
        URLProtocolContext urlProtocolContext = this.msgContext.getUrlProtocolContext();
        IDSoggetto soggettoErogatore = null;
        IDServizio idServizioForDump = null;
        IDSoggetto fruitore = null;
        IDSoggetto dominio = null;
        String idRichiesta = null;
        if (protocolContext != null) {
            if (protocolContext.getTipoServizio() != null && protocolContext.getServizio() != null && protocolContext.getVersioneServizio() != null && protocolContext.getErogatore() != null && protocolContext.getErogatore().getTipo() != null && protocolContext.getErogatore().getNome() != null) {
                idServizioForDump = IDServizioFactory.getInstance().getIDServizioFromValues(protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getErogatore(), protocolContext.getVersioneServizio().intValue());
            }
            dominio = protocolContext.getDominio();
            idRichiesta = protocolContext.getIdRichiesta();
            if (protocolContext.getFruitore() != null && protocolContext.getFruitore().getTipo() != null && protocolContext.getFruitore().getNome() != null) {
                fruitore = protocolContext.getFruitore();
            }
        }
        if ((dominio == null || fruitore == null || idServizioForDump == null) && urlProtocolContext != null && urlProtocolContext.getInterfaceName() != null) {
            IDPortaApplicativa identificativoPortaApplicativa = new IDPortaApplicativa();
            identificativoPortaApplicativa.setNome(urlProtocolContext.getInterfaceName());
            PortaApplicativa portaApplicativa = null;
            try {
                portaApplicativa = configurazionePdDReader.getPortaApplicativaSafeMethod(identificativoPortaApplicativa, this.msgContext.getRequestInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (portaApplicativa != null) {
                soggettoErogatore = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                if (portaApplicativa.getServizio() != null) {
                    idServizioForDump = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome(), soggettoErogatore, portaApplicativa.getServizio().getVersione().intValue());
                }
                dominio = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                try {
                    dominio.setCodicePorta(RegistroServiziManager.getInstance().getDominio(dominio, null, protocolFactory, this.msgContext.getRequestInfo()));
                }
                catch (Exception e) {
                    dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
                }
            }
        }
        if (idServizioForDump != null) {
            if (protocolContext != null && protocolContext.getAzione() != null) {
                idServizioForDump.setAzione(protocolContext.getAzione());
            } else if (this.msgContext.getRequestInfo() != null && this.msgContext.getRequestInfo().getIdServizio() != null && this.msgContext.getRequestInfo().getIdServizio().getAzione() != null) {
                idServizioForDump.setAzione(this.msgContext.getRequestInfo().getIdServizio().getAzione());
            }
        }
        if (dominio == null) {
            dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
        }
        Dump dumpApplicativo = null;
        dumpApplicativo = protocolContext != null ? new Dump(dominio, this.msgContext.getIdModulo(), idRichiesta, fruitore, idServizioForDump, this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig) : new Dump(dominio, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig);
        return dumpApplicativo;
    }

    private void setSOAPFaultProcessamento(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFaultEngine(integrationFunctionError, null, null, null, null, erroreIntegrazione, null, false);
    }

    private void setSOAPFaultProcessamento(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione, Exception e) {
        this.setSOAPFaultEngine(integrationFunctionError, null, null, e, null, erroreIntegrazione, null, false);
    }

    private void setSOAPFaultProcessamento(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        this.setSOAPFaultEngine(integrationFunctionError, logCore, msgDiag, e, null, null, posizione, false);
    }

    private void setSOAPFaultProcessamento(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, ErroreIntegrazione erroreIntegrazione, Exception e, String posizione) {
        this.setSOAPFaultEngine(integrationFunctionError, logCore, msgDiag, e, null, erroreIntegrazione, posizione, false);
    }

    private void setSOAPFaultIntestazione(IntegrationFunctionError integrationFunctionError, ErroreCooperazione erroreCooperazione) {
        this.setSOAPFaultEngine(integrationFunctionError, null, null, null, erroreCooperazione, null, null, true);
    }

    private void setSOAPFaultIntestazione(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFaultEngine(integrationFunctionError, null, null, null, null, erroreIntegrazione, null, true);
    }

    private void setSOAPFaultEngine(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, ErroreCooperazione erroreCooperazione, ErroreIntegrazione erroreIntegrazione, String posizioneErrore, boolean validazione) {
        HandlerException he = null;
        if (e instanceof HandlerException) {
            HandlerException heCast;
            he = heCast = (HandlerException)e;
        }
        PdDContext contextFault = this.msgContext.getPddContext();
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizioneErrore);
                }
            } else {
                String descrizioneErrore = null;
                if (erroreCooperazione != null) {
                    try {
                        descrizioneErrore = erroreCooperazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (descrizioneErrore == null && erroreIntegrazione != null) {
                    try {
                        descrizioneErrore = erroreIntegrazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (descrizioneErrore == null) {
                    descrizioneErrore = posizioneErrore;
                }
                msgDiag.logErroreGenerico(descrizioneErrore, posizioneErrore);
                if (logCore != null) {
                    if (e != null) {
                        RicezioneBuste.logError(logCore, descrizioneErrore + ": " + e.getMessage(), e);
                    } else {
                        RicezioneBuste.logError(logCore, descrizioneErrore);
                    }
                }
            }
        } else if (logCore != null) {
            if (e != null) {
                RicezioneBuste.logError(logCore, posizioneErrore + ": " + e.getMessage(), e);
            } else {
                RicezioneBuste.logError(logCore, posizioneErrore);
            }
        }
        if (this.msgContext.isGestioneRisposta()) {
            OpenSPCoop2Message messageFault = null;
            if (validazione) {
                if (erroreCooperazione != null) {
                    String descrizioneErrore = null;
                    try {
                        descrizioneErrore = erroreCooperazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                        messageFault = this.generatoreErrore.buildErroreIntestazione(contextFault, integrationFunctionError, erroreCooperazione.getCodiceErrore(), descrizioneErrore);
                    }
                    catch (Exception eP) {
                        messageFault = this.generatoreErrore.buildFault(eP, (Context)contextFault);
                    }
                } else {
                    messageFault = this.generatoreErrore.buildErroreIntestazione(contextFault, integrationFunctionError, erroreIntegrazione);
                }
            } else if (erroreIntegrazione != null) {
                messageFault = this.generatoreErrore.buildErroreProcessamento(contextFault, integrationFunctionError, erroreIntegrazione, e);
            } else if (e != null) {
                IntegrationFunctionError ifError = integrationFunctionError;
                ErroreIntegrazione erroreIntegrazioneGenerato = null;
                if (he != null) {
                    erroreIntegrazioneGenerato = he.convertToErroreIntegrazione();
                    if (he.getIntegrationFunctionError() != null) {
                        ifError = he.getIntegrationFunctionError();
                    }
                }
                if (erroreIntegrazioneGenerato == null) {
                    erroreIntegrazioneGenerato = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore);
                }
                messageFault = this.generatoreErrore.buildErroreProcessamento(contextFault, ifError, erroreIntegrazioneGenerato, e);
                if (he != null) {
                    he.customized(messageFault);
                }
            } else {
                messageFault = this.generatoreErrore.buildErroreProcessamento((Context)contextFault, integrationFunctionError, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore));
            }
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    private boolean checkInizializzazione(Logger logCore) {
        if (!OpenSPCoop2Startup.initialize) {
            String msgErrore = "Inizializzazione di GovWay non correttamente effettuata";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneGovWay");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (InizializzazioneGovWay): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA));
            return false;
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            String msgErrore = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneRisorseGovWay");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (InizializzazioneRisorseGovWay): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI));
            return false;
        }
        if (!TimerThresholdThread.freeSpace) {
            String msgErrore = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "DisponibilitaRisorseGovWay");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (DisponibilitaRisorseGovWay): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO));
            return false;
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            String msgErrore = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, Tracciamento.motivoMalfunzionamentoTracciamento);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Tracciamento");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Tracciamento): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE));
            return false;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            String msgErrore = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Diagnostica");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logDebug(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Diagnostica): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE));
            return false;
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            String msgErrore = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, Dump.getMotivoMalfunzionamentoDump());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Dump");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Dump): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE));
            return false;
        }
        this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
        try {
            this.configurazionePdDReader.verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica della consistenza della configurazione";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckConfigurazioneGovWay");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (CheckConfigurazioneGovWay): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e);
            return false;
        }
        this.registroServiziReader = RegistroServiziManager.getInstance();
        try {
            this.registroServiziReader.verificaConsistenzaRegistroServizi();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica del registro dei servizi";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckRegistroServizi");
                }
            }
            catch (Exception t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (CheckRegistroServizi): " + t.getMessage(), t);
            }
            this.setSOAPFaultProcessamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), e);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private void processEngine(HashMap<String, Object> internalObjects, Object ... params) throws TracciamentoException, DumpException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [172[CATCHBLOCK]], but top level block is 57[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void midProcess(Validatore validatore, BustaRawContent<?> soapHeaderElement, Servizio infoServizio, ProprietaValidazione properties, String servizioApplicativoFruitore, InRequestPAMessage inRequestPAMessage, RicezioneBusteGestioneToken gestioneToken, IDPortaApplicativa idPA, IDPortaDelegata idPD, InoltroBusteMessage inoltroMSG, boolean asincronoSimmetricoRisposta, boolean soggettoVirtuale, Credenziali credenziali) throws TracciamentoException, ProtocolException {
        ricezioneBusteUtils = new RicezioneBusteUtils();
        requestInfo = this.msgContext.getRequestInfo();
        propertiesReader = OpenSPCoop2Properties.getInstance();
        urlProtocolContext = this.msgContext.getUrlProtocolContext();
        pluginLoader = PddPluginLoader.getInstance();
        gestioneTokenAutenticazione = gestioneToken.getGestioneTokenAutenticazione();
        gestioneAutenticazione = new RicezioneBusteGestioneAutenticazione(this.msgDiag, this.logCore, this.tracciamento, this.correlazioneApplicativa, soapHeaderElement, this.bustaRichiesta, this.pa, idPA, this.pd, idPD, this.soggettoFruitore, credenziali, servizioApplicativoFruitore, gestioneTokenAutenticazione, this.requestMessage, asincronoSimmetricoRisposta, this.functionAsRouter, this.msgContext, this.generatoreErrore, this.inRequestContext, this.configurazionePdDReader, this.registroServiziReader, this.pddContext, this.idTransazione, this.identitaPdD, this.openspcoopstate, this.transaction, requestInfo, this.protocolFactory, validatore, this.parametriGenerazioneBustaErrore, this.parametriInvioBustaErrore);
        soggettoFruitoreIdentificatoTramiteProtocollo = false;
        soggettoAutenticato = false;
        if (!gestioneAutenticazione.process()) {
            return;
        }
        soggettoFruitoreIdentificatoTramiteProtocollo = gestioneAutenticazione.isSoggettoFruitoreIdentificatoTramiteProtocollo();
        soggettoAutenticato = gestioneAutenticazione.isSoggettoAutenticato();
        this.soggettoFruitore = gestioneAutenticazione.getSoggettoFruitore();
        servizioApplicativoFruitore = gestioneAutenticazione.getServizioApplicativoFruitore();
        trasmissioneSoggettoAutenticato = null;
        if (soggettoAutenticato || soggettoFruitoreIdentificatoTramiteProtocollo) {
            validatore.getBusta().setTipoMittente(this.soggettoFruitore.getTipo());
            validatore.getBusta().setMittente(this.soggettoFruitore.getNome());
            if (validatore.getBusta().sizeListaTrasmissioni() > 0) {
                for (i = 0; i < validatore.getBusta().sizeListaTrasmissioni(); ++i) {
                    trasmissione = validatore.getBusta().getTrasmissione(i);
                    if (trasmissione.getOrigine() != null || trasmissione.getTipoOrigine() != null || trasmissione.getIdentificativoPortaOrigine() != null) continue;
                    trasmissioneSoggettoAutenticato = trasmissione;
                    trasmissione.setTipoOrigine(this.soggettoFruitore.getTipo());
                    trasmissione.setOrigine(this.soggettoFruitore.getNome());
                }
            }
            validatore.setMittente(this.soggettoFruitore);
            this.bustaRichiesta = validatore.getBusta();
            this.msgDiag.addKeywords(validatore.getBusta(), true);
        }
        if (this.pddContext != null && this.bustaRichiesta != null) {
            DirectVMProtocolInfo.setInfoFromContext(this.pddContext, this.bustaRichiesta);
        }
        org.openspcoop2.pdd.core.Utilities.refreshIdentificativiPorta(this.bustaRichiesta, requestInfo.getIdentitaPdD(), this.registroServiziReader, this.protocolFactory, requestInfo);
        if (this.soggettoFruitore != null) {
            if (this.soggettoFruitore.getCodicePorta() == null) {
                this.soggettoFruitore.setCodicePorta(this.bustaRichiesta.getIdentificativoPortaMittente());
            }
            if (trasmissioneSoggettoAutenticato != null && trasmissioneSoggettoAutenticato.getIdentificativoPortaOrigine() == null) {
                trasmissioneSoggettoAutenticato.setIdentificativoPortaOrigine(this.bustaRichiesta.getIdentificativoPortaMittente());
            }
            this.msgDiag.setFruitore(this.soggettoFruitore);
        }
        if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null && this.idServizio.getSoggettoErogatore().getCodicePorta() == null) {
            this.idServizio.getSoggettoErogatore().setCodicePorta(this.bustaRichiesta.getIdentificativoPortaDestinatario());
        }
        if (servizioApplicativoFruitore != null) {
            if (this.bustaRichiesta != null) {
                this.bustaRichiesta.setServizioApplicativoFruitore(servizioApplicativoFruitore);
            }
        } else if (this.bustaRichiesta != null && this.bustaRichiesta.getServizioApplicativoFruitore() != null) {
            servizioApplicativoFruitore = this.bustaRichiesta.getServizioApplicativoFruitore();
        }
        this.idMessageRequest = this.bustaRichiesta != null ? this.bustaRichiesta.getID() : null;
        this.tipoPorta = TipoPdD.APPLICATIVA;
        if (this.functionAsRouter) {
            this.tipoPorta = TipoPdD.ROUTER;
        }
        this.msgContext.getProtocol().setDominio(this.identitaPdD);
        this.msgContext.setIdentitaPdD(this.identitaPdD);
        this.msgContext.setTipoPorta(this.tipoPorta);
        this.msgContext.getProtocol().setFruitore(this.soggettoFruitore);
        if (this.bustaRichiesta != null) {
            this.msgContext.getProtocol().setIndirizzoFruitore(this.bustaRichiesta.getIndirizzoMittente());
        }
        if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null) {
            this.msgContext.getProtocol().setErogatore(this.idServizio.getSoggettoErogatore());
        }
        if (this.bustaRichiesta != null) {
            this.msgContext.getProtocol().setIndirizzoErogatore(this.bustaRichiesta.getIndirizzoDestinatario());
        }
        if (this.idServizio != null) {
            this.msgContext.getProtocol().setTipoServizio(this.idServizio.getTipo());
            this.msgContext.getProtocol().setServizio(this.idServizio.getNome());
            this.msgContext.getProtocol().setVersioneServizio(this.idServizio.getVersione());
            this.msgContext.getProtocol().setAzione(this.idServizio.getAzione());
        }
        this.msgContext.getProtocol().setIdRichiesta(this.idMessageRequest);
        if (this.bustaRichiesta != null) {
            this.msgContext.getProtocol().setProfiloCollaborazione(this.bustaRichiesta.getProfiloDiCollaborazione(), this.bustaRichiesta.getProfiloDiCollaborazioneValue());
            this.msgContext.getProtocol().setCollaborazione(this.bustaRichiesta.getCollaborazione());
        }
        serviceIsEnabled = false;
        portaEnabled = false;
        serviceIsEnabledExceptionProcessamento = null;
        try {
            serviceIsEnabled = StatoServiziPdD.isEnabledPortaApplicativa(this.soggettoFruitore, this.idServizio);
            if (serviceIsEnabled) {
                portaEnabled = this.pa != null ? this.configurazionePdDReader.isPortaAbilitata(this.pa) : this.configurazionePdDReader.isPortaAbilitata(this.pd);
            }
        }
        catch (Exception e) {
            serviceIsEnabledExceptionProcessamento = e;
        }
        if (!serviceIsEnabled || !portaEnabled || serviceIsEnabledExceptionProcessamento != null) {
            errore = null;
            esito = null;
            integrationFunctionError = IntegrationFunctionError.API_SUSPEND;
            if (serviceIsEnabledExceptionProcessamento != null) {
                RicezioneBuste.logError(this.logCore, "[RicezioneBuste] Identificazione stato servizio di ricezione buste non riuscita: " + serviceIsEnabledExceptionProcessamento.getMessage(), serviceIsEnabledExceptionProcessamento);
                this.msgDiag.logErroreGenerico("Identificazione stato servizio di ricezione buste non riuscita", "PA");
                esito = "[RicezioneBuste] Identificazione stato servizio di ricezione buste non riuscita";
                errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
            } else {
                this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_SOSPENSIONE, "true");
                msg = "Servizio di ricezione buste disabilitato";
                if (serviceIsEnabled) {
                    msg = this.pa != null ? "Porta Applicativa [" + this.pa.getNome() + "] disabilitata" : "Porta Delegata [" + this.pd.getNome() + "] disabilitata";
                    errore = ErroriIntegrazione.ERRORE_446_PORTA_SOSPESA.getErroreIntegrazione();
                } else {
                    errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((String)msg, CodiceErroreIntegrazione.CODICE_551_PA_SERVICE_NOT_ACTIVE);
                }
                RicezioneBuste.logError(this.logCore, "[RicezioneBuste] " + (String)msg);
                this.msgDiag.logErroreGenerico((String)msg, "PA");
                esito = "[RicezioneBuste] " + (String)msg;
            }
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)esito);
                this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(errore);
                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, serviceIsEnabledExceptionProcessamento);
                if (IntegrationFunctionError.API_SUSPEND.equals((Object)integrationFunctionError) && propertiesReader.isEnabledServiceUnavailableRetryAfterPASuspend() && propertiesReader.getServiceUnavailableRetryAfterSecondsPASuspend() != null && propertiesReader.getServiceUnavailableRetryAfterSecondsPASuspend() > 0) {
                    seconds = propertiesReader.getServiceUnavailableRetryAfterSecondsPASuspend();
                    if (propertiesReader.getServiceUnavailableRetryAfterSecondsRandomBackoffPASuspend() != null && propertiesReader.getServiceUnavailableRetryAfterSecondsRandomBackoffPASuspend() > 0) {
                        seconds += ServicesUtils.getRandom().nextInt(propertiesReader.getServiceUnavailableRetryAfterSecondsRandomBackoffPASuspend());
                    }
                    errorOpenSPCoopMsg.forceTransportHeader("Retry-After", "" + seconds);
                }
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        this.msgDiag.mediumDebug("Gestione Attribute Authority...");
        attributeAuthorities = null;
        if (this.pa != null) {
            attributeAuthorities = this.pa.getAttributeAuthorityList();
        } else if (this.pd != null) {
            attributeAuthorities = this.pd.getAttributeAuthorityList();
        }
        this.msgContext.getIntegrazione().setAttributeAuthoritiesFromObjectList(attributeAuthorities);
        if (attributeAuthorities == null || attributeAuthorities.isEmpty()) {
            if (!asincronoSimmetricoRisposta) {
                this.msgDiag.logPersonalizzato("gestioneAADisabilitata");
            }
        } else {
            this.transaction.getTempiElaborazione().startAttributeAuthority();
            try {
                this.msgDiag.logPersonalizzato("gestioneAAInCorso");
                datiInvocazione = new org.openspcoop2.pdd.core.token.attribute_authority.pa.DatiInvocazionePortaApplicativa();
                datiInvocazione.setInfoConnettoreIngresso(this.inRequestContext.getConnettore());
                datiInvocazione.setState(this.openspcoopstate.getStatoRichiesta());
                datiInvocazione.setIdModulo(this.inRequestContext.getIdModulo());
                datiInvocazione.setMessage(this.requestMessage);
                datiInvocazione.setBusta(this.bustaRichiesta);
                datiInvocazione.setRequestInfo(requestInfo);
                datiInvocazione.setIdPA(idPA);
                datiInvocazione.setPa(this.pa);
                datiInvocazione.setIdPD(idPD);
                datiInvocazione.setPd(this.pd);
                gestioneAAEngine = new GestioneAttributeAuthority(this.logCore, this.idTransazione, this.pddContext, this.protocolFactory);
                esitiValidiRecuperoAttributi = new ArrayList<InformazioniAttributi>();
                for (AttributeAuthority aa : attributeAuthorities) {
                    try {
                        this.msgDiag.addKeyword("@ATTRIBUTE_AUTHORITY_NAME@", aa.getNome());
                        this.msgDiag.addKeyword("@ATTRIBUTE_AUTHORIY_ENDPOINT@", "-");
                        policyAttributeAuthority = this.configurazionePdDReader.getPolicyAttributeAuthority(false, aa.getNome(), requestInfo);
                        datiInvocazione.setPolicyAttributeAuthority(policyAttributeAuthority);
                        GestoreToken.validazioneConfigurazione(policyAttributeAuthority);
                        this.msgDiag.addKeyword("@ATTRIBUTE_AUTHORIY_ENDPOINT@", policyAttributeAuthority.getEndpoint());
                        this.msgDiag.logPersonalizzato("gestioneAAInCorso.retrieve");
                        esitoRecuperoAttributi = gestioneAAEngine.readAttributes(datiInvocazione);
                        if (esitoRecuperoAttributi.isValido()) {
                            attributiRecuperati = new StringBuilder();
                            if (esitoRecuperoAttributi.getInformazioniAttributi() != null && esitoRecuperoAttributi.getInformazioniAttributi().getAttributes() != null && !esitoRecuperoAttributi.getInformazioniAttributi().getAttributes().isEmpty()) {
                                for (String attrName : esitoRecuperoAttributi.getInformazioniAttributi().getAttributesNames()) {
                                    if (attributiRecuperati.length() > 0) {
                                        attributiRecuperati.append(",");
                                    }
                                    attributiRecuperati.append(attrName);
                                }
                            }
                            this.msgDiag.addKeyword("@ATTRIBUTES@", attributiRecuperati.toString());
                            if (esitoRecuperoAttributi.isInCache()) {
                                this.msgDiag.logPersonalizzato("gestioneAAInCorso.retrieve.completataSuccesso.inCache");
                            } else {
                                this.msgDiag.logPersonalizzato("gestioneAAInCorso.retrieve.completataSuccesso");
                            }
                            esitiValidiRecuperoAttributi.add(esitoRecuperoAttributi.getInformazioniAttributi());
                            continue;
                        }
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esitoRecuperoAttributi.getDetails());
                        this.msgDiag.logPersonalizzato("gestioneAAInCorso.retrieve.fallita");
                        msgErrore = "processo di gestione dell'attribute authority [" + aa.getNome() + "] fallito: " + esitoRecuperoAttributi.getDetails();
                        if (esitoRecuperoAttributi.getEccezioneProcessamento() != null) {
                            RicezioneBuste.logError(this.logCore, msgErrore, esitoRecuperoAttributi.getEccezioneProcessamento());
                            continue;
                        }
                        RicezioneBuste.logError(this.logCore, msgErrore);
                    }
                    catch (Throwable e) {
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        this.msgDiag.logPersonalizzato("gestioneAAInCorso.retrieve.fallita");
                        msgErrore = "processo di gestione dell'attribute authority [" + aa.getNome() + "] fallito: " + e.getMessage();
                        RicezioneBuste.logError(this.logCore, msgErrore, e);
                    }
                }
                informazioniAttributiNormalizzati = null;
                if (esitiValidiRecuperoAttributi != null && !esitiValidiRecuperoAttributi.isEmpty()) {
                    informazioniAttributiNormalizzati = GestoreToken.normalizeInformazioniAttributi(esitiValidiRecuperoAttributi, attributeAuthorities);
                    informazioniAttributiNormalizzati.setValid(true);
                }
                if (informazioniAttributiNormalizzati != null) {
                    this.pddContext.addObject(Costanti.PDD_CONTEXT_ATTRIBUTI_INFORMAZIONI_NORMALIZZATE, informazioniAttributiNormalizzati);
                    informazioniTokenNormalizzate = null;
                    if (this.pddContext.containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE)) {
                        informazioniTokenNormalizzate = (InformazioniToken)this.pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                    }
                    if (informazioniTokenNormalizzate != null) {
                        informazioniTokenNormalizzate.setAa(informazioniAttributiNormalizzati);
                    } else {
                        this.transaction.setInformazioniAttributi(informazioniAttributiNormalizzati);
                    }
                }
                this.msgDiag.logPersonalizzato("gestioneAACompletata");
            }
            catch (Throwable e) {
                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                this.msgDiag.logPersonalizzato("gestioneAAFallita");
                RicezioneBuste.logError(this.logCore, "processo di gestione delle attribute authorities fallito: " + e.getMessage(), e);
            }
            finally {
                this.transaction.getTempiElaborazione().endAttributeAuthority();
            }
        }
        try {
            this.msgDiag.mediumDebug("Aggiornamento del messaggio");
            this.requestMessage = this.protocolFactory.createProtocolManager().updateOpenSPCoop2MessageRequest(this.requestMessage, this.bustaRichiesta, this.protocolFactory.getCachedRegistryReader((Object)this.registroServiziReader, requestInfo));
        }
        catch (Exception e) {
            mittenteEsistente = validatore.getBusta() != null && (validatore.getBusta().getMittente() != null || validatore.getBusta().getTipoMittente() != null);
            this.msgDiag.emitRicezioneMessaggioModuloBuste(this.msgDiag, this.pddContext, mittenteEsistente == false);
            this.msgDiag.addKeywordErroreProcessamento(e, "Aggiornamento messaggio fallito");
            this.msgDiag.logErroreGenerico(e, "ProtocolManager.updateOpenSPCoop2Message");
            RicezioneBuste.logError(this.logCore, "ProtocolManager.updateOpenSPCoop2Message error: " + e.getMessage(), e);
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("ProtocolManager.updateOpenSPCoop2Message, non riuscito: " + e.getMessage()));
                this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        this.newConnectionForResponse = false;
        this.utilizzoIndirizzoTelematico = false;
        if (!this.functionAsRouter) {
            if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                this.newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponse();
                this.utilizzoIndirizzoTelematico = this.configurazionePdDReader.isUtilizzoIndirizzoTelematico();
                this.parametriInvioBustaErrore.setNewConnectionForResponse(this.newConnectionForResponse);
                this.parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(this.utilizzoIndirizzoTelematico);
            }
            if (!validatore.isErroreProtocollo() && !validatore.isBustaDiServizio()) {
                try {
                    scadenzaControllo = DateManager.getTimeMillis() + propertiesReader.getTimeoutBustaRispostaAsincrona();
                    checkIntervalControllo = propertiesReader.getCheckIntervalBustaRispostaAsincrona();
                    attendiTerminazioneRichiesta = this.gestioneRispostaAsincronaCheckPresenzaRichiesta(scadenzaControllo, checkIntervalControllo, this.bustaRichiesta, this.openspcoopstate, this.msgDiag, this.newConnectionForResponse, this.inRequestContext.getPddContext());
                    attendiTerminazioneRicevutaRichiesta = this.gestioneRispostaAsincronaCheckPresenzaRicevutaRichiesta(scadenzaControllo, checkIntervalControllo, this.bustaRichiesta, this.openspcoopstate, this.msgDiag, this.newConnectionForResponse, this.inRequestContext.getPddContext());
                    msgErroreIntegrazione = null;
                    motivoErrore = null;
                    if (attendiTerminazioneRichiesta) {
                        this.msgDiag.logPersonalizzato("attesaFineProcessamento.richiestaAsincrona.timeoutScaduto");
                        msgErroreIntegrazione = ErroriIntegrazione.ERRORE_538_RICHIESTA_ASINCRONA_ANCORA_IN_PROCESSAMENTO.getErroreIntegrazione();
                    } else if (attendiTerminazioneRicevutaRichiesta) {
                        this.msgDiag.logPersonalizzato("attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto");
                        msgErroreIntegrazione = ErroriIntegrazione.ERRORE_539_RICEVUTA_RICHIESTA_ASINCRONA_ANCORA_IN_PROCESSAMENTO.getErroreIntegrazione();
                    }
                    if (attendiTerminazioneRichiesta || attendiTerminazioneRicevutaRichiesta) {
                        if (this.msgContext.isTracciamentoAbilitato()) {
                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore(motivoErrore);
                            this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(msgErroreIntegrazione);
                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, null);
                            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        }
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                }
                catch (Exception e) {
                    mittenteEsistente = validatore.getBusta() != null && (validatore.getBusta().getMittente() != null || validatore.getBusta().getTipoMittente() != null);
                    this.msgDiag.emitRicezioneMessaggioModuloBuste(this.msgDiag, this.pddContext, mittenteEsistente == false);
                    this.msgDiag.logErroreGenerico(e, "checkPresenzaRichiestaRicevutaAsincronaAncoraInGestione");
                    RicezioneBuste.logError(this.logCore, "Controllo presenza richieste/ricevuteRichieste ancora in gestione correlate alla risposta/richiesta-stato asincrona simmetrica/asimmetrica arrivata, non riuscito", e);
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Controllo presenza richieste/ricevuteRichieste ancora in gestione correlate alla risposta/richiesta-stato asincrona simmetrica/asimmetrica arrivata, non riuscito: " + e.getMessage()));
                        this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
            if (this.ruoloBustaRicevuta != null) {
                try {
                    scenarioCooperazione = null;
                    if (ProfiloDiCollaborazione.ONEWAY.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                        scenarioCooperazione = "OneWay_InvocazioneServizio";
                    } else if (ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                        scenarioCooperazione = "Sincrono_InvocazioneServizio";
                    } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (RuoloBusta.RICHIESTA.equals(this.ruoloBustaRicevuta.toString())) {
                            scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                        } else if (RuoloBusta.RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                            scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                        }
                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (RuoloBusta.RICHIESTA.equals(this.ruoloBustaRicevuta.toString())) {
                            scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                        } else if (RuoloBusta.RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                            scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                        }
                    }
                    this.msgContext.getProtocol().setScenarioCooperazione(scenarioCooperazione);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "setScenarioCooperazione");
                }
            }
        }
        this.implementazionePdDMittente = null;
        implementazionePdDDestinatario = null;
        idPdDMittente = null;
        idPdDDestinatario = null;
        this.msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
        validazioneIDBustaCompleta = true;
        try {
            if (this.soggettoFruitore != null) {
                this.implementazionePdDMittente = this.registroServiziReader.getImplementazionePdD(this.soggettoFruitore, null, requestInfo);
            }
            if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null) {
                implementazionePdDDestinatario = this.registroServiziReader.getImplementazionePdD(this.idServizio.getSoggettoErogatore(), null, requestInfo);
            }
            if (this.soggettoFruitore != null) {
                idPdDMittente = this.registroServiziReader.getIdPortaDominio(this.soggettoFruitore, null, requestInfo);
            }
            if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null) {
                idPdDDestinatario = this.registroServiziReader.getIdPortaDominio(this.idServizio.getSoggettoErogatore(), null, requestInfo);
            }
            this.parametriGenerazioneBustaErrore.setImplementazionePdDMittente(this.implementazionePdDMittente);
            this.parametriGenerazioneBustaErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
            this.parametriInvioBustaErrore.setImplementazionePdDMittente(this.implementazionePdDMittente);
            this.parametriInvioBustaErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
            properties.setValidazioneConSchema(this.configurazionePdDReader.isLivelloValidazioneRigido(this.implementazionePdDMittente));
            properties.setValidazioneProfiloCollaborazione(this.configurazionePdDReader.isValidazioneProfiloCollaborazione(this.implementazionePdDMittente));
            if (this.openspcoopstate != null) {
                properties.setRuntimeState(this.openspcoopstate.getStatoRichiesta());
                if (propertiesReader.isTransazioniUsePddRuntimeDatasource()) {
                    properties.setTracceState(this.openspcoopstate.getStatoRichiesta());
                }
            }
            validatore.setProprietaValidazione(properties);
            contextParameters = new MessageSecurityContextParameters();
            contextParameters.setUseActorDefaultIfNotDefined(propertiesReader.isGenerazioneActorDefault(this.implementazionePdDMittente));
            contextParameters.setActorDefault(propertiesReader.getActorDefault(this.implementazionePdDMittente));
            contextParameters.setLog(this.logCore);
            contextParameters.setFunctionAsClient(false);
            contextParameters.setPrefixWsuId(propertiesReader.getPrefixWsuId());
            contextParameters.setRemoveAllWsuIdRef(propertiesReader.isRemoveAllWsuIdRef());
            contextParameters.setIdFruitore(this.soggettoFruitore);
            contextParameters.setPddFruitore(idPdDMittente);
            contextParameters.setIdServizio(this.idServizio);
            contextParameters.setPddErogatore(idPdDDestinatario);
            this.messageSecurityContext = new MessageSecurityFactory().getMessageSecurityContext(contextParameters);
            this.parametriGenerazioneBustaErrore.setMessageSecurityContext(this.messageSecurityContext);
            this.proprietaManifestAttachments = propertiesReader.getProprietaManifestAttachments(this.implementazionePdDMittente);
            this.readQualifiedAttribute = propertiesReader.isReadQualifiedAttribute(this.implementazionePdDMittente);
            validazioneIDBustaCompleta = propertiesReader.isValidazioneIDBustaCompleta(this.implementazionePdDMittente);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "ricercaImplementazionePdDSoggettiBusta");
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Errore durante la ricerca dell'implementazione della porta di dominio dei soggetti: " + e.getMessage()));
                this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        if (this.soggettoFruitore != null) {
            this.msgDiag.mediumDebug("ImplementazionePdD soggetto fruitore (" + this.soggettoFruitore.toString() + "): [" + this.implementazionePdDMittente + "]");
        }
        if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null) {
            this.msgDiag.mediumDebug("ImplementazionePdD soggetto erogatore (" + this.idServizio.getSoggettoErogatore().toString() + "): [" + implementazionePdDDestinatario + "]");
        }
        if (!this.functionAsRouter) {
            block270: {
                this.msgDiag.mediumDebug("Lettura manifest attachments impostato in porta applicativa/delegata...");
                try {
                    this.msgDiag.highDebug("Lettura porta applicativa/delegata (Set)...");
                    if (this.pa != null) {
                        properties.setValidazioneManifestAttachments(this.configurazionePdDReader.isValidazioneManifestAttachments(this.implementazionePdDMittente) != false && this.configurazionePdDReader.isGestioneManifestAttachments(this.pa, this.protocolFactory) != false);
                    } else if (this.pd != null) {
                        properties.setValidazioneManifestAttachments(this.configurazionePdDReader.isValidazioneManifestAttachments(implementazionePdDDestinatario) != false && this.configurazionePdDReader.isGestioneManifestAttachments(this.pd, this.protocolFactory) != false);
                    } else {
                        properties.setValidazioneManifestAttachments(this.configurazionePdDReader.isValidazioneManifestAttachments(this.implementazionePdDMittente));
                    }
                    this.msgDiag.highDebug("Lettura porta applicativa/delegata terminato");
                }
                catch (Exception e) {
                    if (e instanceof DriverConfigurazioneNotFound) break block270;
                    this.msgDiag.logErroreGenerico(e, "letturaPortaManifestAttachments");
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Errore durante la lettura della porta applicativa/delegata per la gestione ManifestAttachments: " + e.getMessage()));
                        this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
            this.msgDiag.highDebug("Lettura manifest attachments impostato in porta applicativa/delegata terminato");
        }
        idModuloInAttesa = null;
        if (this.msgContext.isGestioneRisposta()) {
            idModuloInAttesa = this.msgContext.getIdModulo();
        }
        richiestaApplicativa = null;
        if (idPA != null) {
            richiestaApplicativa = new RichiestaApplicativa(this.soggettoFruitore, idModuloInAttesa, this.identitaPdD, idPA);
            if (this.idServizio != null && this.idServizio.getAzione() != null && idPA != null && idPA.getIdentificativiErogazione() != null && idPA.getIdentificativiErogazione().getIdServizio() != null && idPA.getIdentificativiErogazione().getIdServizio().getAzione() == null) {
                idPA.getIdentificativiErogazione().getIdServizio().setAzione(this.idServizio.getAzione());
            }
        } else {
            richiestaApplicativa = new RichiestaApplicativa(this.soggettoFruitore, idModuloInAttesa, this.identitaPdD, this.idServizio);
        }
        richiestaApplicativa.setFiltroProprietaPorteApplicative(this.msgContext.getProprietaFiltroPortaApplicativa());
        richiestaApplicativa.setIntegrazione(this.msgContext.getIntegrazione());
        richiestaApplicativa.setProtocol(this.msgContext.getProtocol());
        try {
            protocolConfiguration = this.protocolFactory.createProtocolConfiguration();
            if (this.bustaRichiesta != null && this.bustaRichiesta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.UNKNOWN.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), this.bustaRichiesta.getProfiloDiCollaborazione())) {
                throw new CoreException("Profilo di Collaborazione [" + this.bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "]");
            }
            if (this.bustaRichiesta != null && this.bustaRichiesta.getScadenza() != null && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.SCADENZA)) {
                throw new CoreException(FunzionalitaProtocollo.SCADENZA.getEngineValue());
            }
            if (this.configurazionePdDReader.isGestioneManifestAttachments(this.pa, this.protocolFactory) && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                throw new CoreException(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS.getEngineValue());
            }
        }
        catch (Exception e) {
            this.msgDiag.addKeywordErroreProcessamento(e);
            this.msgDiag.logPersonalizzato("sbustamentoBusta.", "protocolli.funzionalita.unsupported");
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)this.msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), this.protocolFactory));
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        this.oneWayStateless = false;
        this.oneWayVersione11 = false;
        this.sincronoStateless = false;
        this.asincronoStateless = false;
        this.portaStateless = false;
        this.routingStateless = false;
        try {
            if (!this.functionAsRouter) {
                if (propertiesReader.isServerJ2EE() == null || !propertiesReader.isServerJ2EE().booleanValue()) {
                    this.oneWayStateless = true;
                    this.sincronoStateless = true;
                    this.asincronoStateless = true;
                } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                    if (!soggettoVirtuale) {
                        this.oneWayStateless = this.configurazionePdDReader.isModalitaStateless(this.pa, this.bustaRichiesta.getProfiloDiCollaborazione());
                    }
                } else if (ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                    this.sincronoStateless = this.configurazionePdDReader.isModalitaStateless(this.pa, this.bustaRichiesta.getProfiloDiCollaborazione());
                } else if ((ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) && !RuoloBusta.RICEVUTA_RICHIESTA.equals(this.ruoloBustaRicevuta.toString()) && !RuoloBusta.RICEVUTA_RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                    this.asincronoStateless = ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false && this.pd != null ? this.configurazionePdDReader.isModalitaStateless(this.pd, this.bustaRichiesta.getProfiloDiCollaborazione()) : this.configurazionePdDReader.isModalitaStateless(this.pa, this.bustaRichiesta.getProfiloDiCollaborazione());
                }
                v0 = this.oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && ProfiloDiCollaborazione.ONEWAY.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false && this.oneWayStateless == false;
                if (this.oneWayStateless || this.sincronoStateless || this.asincronoStateless || this.oneWayVersione11) {
                    this.portaStateless = true;
                    this.msgContext.getIntegrazione().setGestioneStateless(this.oneWayVersione11 == false);
                } else {
                    this.msgContext.getIntegrazione().setGestioneStateless(false);
                }
                if ((!this.portaStateless || this.oneWayVersione11) && !this.openspcoopstate.isUseConnection() && (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) && this.openspcoopstate.resourceReleased()) {
                    this.openspcoopstate.setUseConnection(true);
                    this.openspcoopstate.initResource(this.identitaPdD, this.msgContext.getIdModulo(), this.idTransazione);
                }
            } else {
                this.routingStateless = CostantiConfigurazione.ABILITATO.equals(propertiesReader.getStatelessRouting());
                this.msgContext.getIntegrazione().setGestioneStateless(this.routingStateless);
                if (!this.routingStateless && !this.openspcoopstate.isUseConnection() && this.openspcoopstate instanceof OpenSPCoopStateful && this.openspcoopstate.resourceReleased()) {
                    this.openspcoopstate.setUseConnection(true);
                    this.openspcoopstate.initResource(this.identitaPdD, this.msgContext.getIdModulo(), this.idTransazione);
                }
            }
            this.parametriInvioBustaErrore.setOnewayVersione11(this.oneWayVersione11);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "AnalisiModalitaGestioneStatefulStateless");
            RicezioneBuste.logError(this.logCore, "Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + String.valueOf(e));
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        if (!(this.bustaRichiesta == null || ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || this.oneWayStateless || this.sincronoStateless || this.asincronoStateless || this.routingStateless)) {
            this.newConnectionForResponse = this.configurazionePdDReader.newConnectionForResponse();
        }
        this.parametriInvioBustaErrore.setNewConnectionForResponse(this.newConnectionForResponse);
        if (!(this.oneWayStateless || this.sincronoStateless || this.asincronoStateless || this.routingStateless)) {
            this.utilizzoIndirizzoTelematico = this.configurazionePdDReader.isUtilizzoIndirizzoTelematico();
        }
        this.parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(this.utilizzoIndirizzoTelematico);
        if (this.routingStateless) {
            this.openspcoopstate.releaseResource();
        }
        this.infoIntegrazione = new Integrazione();
        this.infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
        this.infoIntegrazione.setStateless(this.portaStateless);
        this.parametriGenerazioneBustaErrore.setIntegrazione(this.infoIntegrazione);
        try {
            inRequestProtocolContext = new InRequestProtocolContext(this.inRequestContext);
            if (inRequestProtocolContext.getStato() == null) {
                inRequestProtocolContext.setStato(this.openspcoopstate.getStatoRichiesta());
            }
            if (inRequestProtocolContext.getConnettore() != null) {
                inRequestProtocolContext.getConnettore().setCredenziali(credenziali);
            }
            inRequestProtocolContext.setProtocollo(this.msgContext.getProtocol());
            inRequestProtocolContext.setIntegrazione(this.msgContext.getIntegrazione());
            GestoreHandlers.inRequestProtocol(inRequestProtocolContext, this.msgDiag, this.logCore);
        }
        catch (Exception e) {
            erroreIntegrazione = null;
            integrationFunctionError = null;
            if (e instanceof HandlerException) {
                he = (HandlerException)e;
                if (he.isEmettiDiagnostico()) {
                    this.msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                }
                RicezioneBuste.logError(this.logCore, "Gestione InRequestProtocolHandler non riuscita (" + he.getIdentitaHandler() + "): " + String.valueOf(he));
                if (this.msgContext.isGestioneRisposta()) {
                    erroreIntegrazione = he.convertToErroreIntegrazione();
                    integrationFunctionError = he.getIntegrationFunctionError();
                }
            } else {
                this.msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                RicezioneBuste.logError(this.logCore, "Gestione InRequestProtocolHandler non riuscita: " + String.valueOf(e));
            }
            if (this.msgContext.isGestioneRisposta()) {
                if (erroreIntegrazione == null) {
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_558_HANDLER_IN_PROTOCOL_REQUEST);
                }
                if (integrationFunctionError == null) {
                    integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                }
                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(erroreIntegrazione);
                errorMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                if (e instanceof HandlerException) {
                    he = (HandlerException)e;
                    he.customized(errorMsg);
                }
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        if (!this.functionAsRouter) {
            this.msgDiag.mediumDebug("Raccolta FlowParameter MTOM / Security proprieta...");
            mtomProcessor = null;
            flowPropertiesRequest = null;
            try {
                flowPropertiesRequest = ricezioneBusteUtils.getFlowPropertiesRequest(this.requestMessage, this.bustaRichiesta, this.configurazionePdDReader, (StateMessage)this.openspcoopstate.getStatoRichiesta(), this.msgDiag, this.logCore, propertiesReader, this.ruoloBustaRicevuta, this.implementazionePdDMittente, requestInfo, this.inRequestContext.getPddContext(), this.pa);
                this.flowPropertiesResponse = ricezioneBusteUtils.getFlowPropertiesResponse(this.requestMessage, this.bustaRichiesta, this.configurazionePdDReader, (StateMessage)this.openspcoopstate.getStatoRichiesta(), this.msgDiag, this.logCore, propertiesReader, this.ruoloBustaRicevuta, this.implementazionePdDMittente, requestInfo, this.inRequestContext.getPddContext(), this.pa, flowPropertiesRequest);
                this.parametriGenerazioneBustaErrore.setFlowPropertiesResponse(this.flowPropertiesResponse);
                if (flowPropertiesRequest != null && flowPropertiesRequest.messageSecurity != null && flowPropertiesRequest.messageSecurity.getFlowParameters() != null && flowPropertiesRequest.messageSecurity.getFlowParameters().size() > 0) {
                    this.messageSecurityContext.setIncomingProperties(flowPropertiesRequest.messageSecurity.getFlowParameters());
                }
                mtomProcessor = new MTOMProcessor(flowPropertiesRequest.mtom, flowPropertiesRequest.messageSecurity, this.tipoPorta, this.msgDiag, this.logCore, this.pddContext);
                this.msgDiag.mediumDebug("Raccolta FlowParameter MTOM / Security completata con successo");
            }
            catch (Exception e) {
                mittenteEsistente = validatore.getBusta() != null && (validatore.getBusta().getMittente() != null || validatore.getBusta().getTipoMittente() != null);
                this.msgDiag.emitRicezioneMessaggioModuloBuste(this.msgDiag, this.pddContext, mittenteEsistente == false);
                this.msgDiag.logErroreGenerico(e, "RaccoltaFlowParameter_MTOM_Security");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la lettura delle proprieta' di MTOM / SecurityMessage: " + e.getMessage()));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
            this.msgDiag.mediumDebug("MTOM Processor [BeforeSecurity]...");
            try {
                mtomProcessor.mtomBeforeSecurity(this.requestMessage, flowPropertiesRequest.tipoMessaggio);
            }
            catch (Exception e) {
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione MTOM(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + "): " + e.getMessage()));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
            this.msgDiag.logPersonalizzato("validazioneSemantica.beforeSecurity");
            presenzaRichiestaProtocollo = validatore.validazioneSemantica_beforeMessageSecurity(requestInfo.getProtocolServiceBinding(), false, null, requestInfo);
            if (!validatore.isRilevatiErroriDuranteValidazioneSemantica()) {
                try {
                    if (WSSUtilities.isNormalizeToSaajImpl((MessageSecurityContext)this.messageSecurityContext)) {
                        this.msgDiag.mediumDebug("Normalize to saajImpl");
                        this.requestMessage = this.requestMessage.normalizeToSaajImpl();
                        validatore.updateMsg(this.requestMessage);
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "NormalizeRequestToSaajImpl");
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione NormalizeRequestToSaajImpl: " + e.getMessage()));
                        this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        if (validatore.getErrore_integrationFunctionError() != null) {
                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(validatore.getErrore_integrationFunctionError());
                        }
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.openspcoopstate.releaseResource();
                    return;
                }
                this.msgDiag.mediumDebug("Lettura informazioni sulla Sicurezza dal Messaggio di richiesta ...");
                presenzaRichiestaProtocollo = validatore.validazioneSemantica_messageSecurity_readSecurityInfo(this.messageSecurityContext);
                this.msgDiag.mediumDebug("Lettura informazioni sulla Sicurezza dal Messaggio di richiesta completata con successo");
                if (!validatore.isRilevatiErroriDuranteValidazioneSemantica()) {
                    if (this.messageSecurityContext != null && this.messageSecurityContext.getIncomingProperties() != null && this.messageSecurityContext.getIncomingProperties().size() > 0) {
                        tipoSicurezza = SecurityConstants.convertActionToString((Map)this.messageSecurityContext.getIncomingProperties());
                        this.msgDiag.addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@", tipoSicurezza);
                        this.pddContext.addObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA, tipoSicurezza);
                        this.msgDiag.logPersonalizzato("messageSecurity.processamentoRichiestaInCorso");
                        bfErroreSecurity = new StringBuilder();
                        DynamicMapBuilderUtils.injectDynamicMap(this.bustaRichiesta, requestInfo, (org.openspcoop2.utils.Map<Object>)this.pddContext, this.logCore);
                        presenzaRichiestaProtocollo = validatore.validazioneSemantica_messageSecurity_process(this.messageSecurityContext, bfErroreSecurity, this.transaction != null ? this.transaction.getTempiElaborazione() : null, true);
                        if (bfErroreSecurity.length() > 0) {
                            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", bfErroreSecurity.toString());
                            this.msgDiag.logPersonalizzato("messageSecurity.processamentoRichiestaInErrore");
                        } else {
                            this.msgDiag.logPersonalizzato("messageSecurity.processamentoRichiestaEffettuato");
                        }
                    } else {
                        this.msgDiag.logPersonalizzato("messageSecurity.processamentoRichiestaDisabilitato");
                    }
                }
                if (!validatore.isRilevatiErroriDuranteValidazioneSemantica()) {
                    this.msgDiag.logPersonalizzato("validazioneSemantica.afterSecurity");
                    presenzaRichiestaProtocollo = validatore.validazioneSemantica_afterMessageSecurity(this.proprietaManifestAttachments, validazioneIDBustaCompleta, requestInfo);
                }
            }
            if (!presenzaRichiestaProtocollo) {
                mittenteEsistente = validatore.getBusta() != null && (validatore.getBusta().getMittente() != null || validatore.getBusta().getTipoMittente() != null);
                this.msgDiag.emitRicezioneMessaggioModuloBuste(this.msgDiag, this.pddContext, mittenteEsistente == false);
                try {
                    this.msgDiag.addKeyword("@ECCEZIONI@", validatore.getErrore().getDescrizione(this.protocolFactory));
                }
                catch (Exception e) {
                    RicezioneBuste.logError(this.logCore, "getDescrizione protocollo Error:" + e.getMessage(), e);
                }
                this.msgDiag.addKeyword("@TIPO_VALIDAZIONE_BUSTA@", "semantica");
                this.msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneNonRiuscita");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)this.msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneNonRiuscita"));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                    if (validatore.getErrore_integrationFunctionError() != null) {
                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(validatore.getErrore_integrationFunctionError());
                    }
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, validatore.getEccezioneProcessamentoValidazioneSemantica());
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
            this.msgDiag.mediumDebug("MTOM Processor [AfterSecurity]...");
            try {
                mtomProcessor.mtomAfterSecurity(this.requestMessage, flowPropertiesRequest.tipoMessaggio);
            }
            catch (Exception e) {
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione MTOM(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + "): " + e.getMessage()));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        this.erroriValidazione = validatore.getEccezioniValidazione();
        this.erroriProcessamento = validatore.getEccezioniProcessamento();
        integrationFunctionErrorValidazione = validatore.getErrore_integrationFunctionError();
        securityInfoRequest = validatore.getSecurityInfo();
        this.isMessaggioErroreProtocollo = validatore.isErroreProtocollo();
        if (this.isMessaggioErroreProtocollo && this.idServizio != null) {
            this.cleanDatiServizio(this.idServizio);
            this.idServizio.setAzione(null);
        }
        this.bustaDiServizio = validatore.isBustaDiServizio();
        if (validatore.getInfoServizio() != null && validatore.getInfoServizio().getIdAccordo() != null) {
            this.msgContext.getProtocol().setIdAccordo(validatore.getInfoServizio().getIdAccordo());
            richiestaApplicativa.setIdAccordo(validatore.getInfoServizio().getIdAccordo());
        } else if (infoServizio != null && infoServizio.getIdAccordo() != null) {
            this.msgContext.getProtocol().setIdAccordo(infoServizio.getIdAccordo());
            richiestaApplicativa.setIdAccordo(infoServizio.getIdAccordo());
        }
        if (this.bustaRichiesta != null && this.msgContext.getProtocol() != null) {
            this.msgContext.getProtocol().setProfiloCollaborazione(this.bustaRichiesta.getProfiloDiCollaborazione(), this.bustaRichiesta.getProfiloDiCollaborazioneValue());
            if (this.bustaRichiesta != null && this.bustaRichiesta.getVersioneServizio() != null && this.bustaRichiesta.getVersioneServizio() > 0 && this.msgContext.getProtocol().getVersioneServizio() != null && this.bustaRichiesta.getVersioneServizio().intValue() != this.msgContext.getProtocol().getVersioneServizio().intValue()) {
                this.msgContext.getProtocol().setVersioneServizio(this.bustaRichiesta.getVersioneServizio());
            }
        }
        if ("modipa".equals(this.protocolFactory.getProtocol()) && this.pddContext.containsKey(CostantiPdD.INTERMEDIARIO) && (o = this.pddContext.get(CostantiPdD.INTERMEDIARIO)) instanceof IDSoggetto) {
            intermediario = (IDSoggetto)o;
            if (this.soggettoFruitore != null && this.soggettoFruitore.equals((Object)intermediario) && this.bustaRichiesta != null && this.bustaRichiesta.getMittente() != null && !this.bustaRichiesta.getMittente().equals(intermediario.getNome())) {
                this.soggettoFruitore.setNome(this.bustaRichiesta.getMittente());
                this.soggettoFruitore.setCodicePorta(this.bustaRichiesta.getIdentificativoPortaMittente());
                if (this.msgDiag != null) {
                    this.msgDiag.setFruitore(this.soggettoFruitore);
                }
                if (this.msgContext.getProtocol() != null) {
                    this.msgContext.getProtocol().setFruitore(this.soggettoFruitore);
                }
            }
        }
        if ("modipa".equals(this.protocolFactory.getProtocol()) && this.pddContext.containsKey(org.openspcoop2.core.constants.Costanti.MODI_JTI_REQUEST_ID_UPDATE_DIAGNOSTIC) && (o = this.pddContext.get(org.openspcoop2.core.constants.Costanti.MODI_JTI_REQUEST_ID_UPDATE_DIAGNOSTIC)) instanceof String) {
            s = (String)o;
            if (this.msgDiag != null) {
                this.msgDiag.updateKeywordIdMessaggioRichiesta(s);
            }
            this.idMessageRequest = (String)o;
            this.msgContext.getProtocol().setIdRichiesta(this.idMessageRequest);
        }
        protocolConfig = this.protocolFactory.createProtocolConfiguration();
        if (infoServizio != null && infoServizio.getIdRiferimentoRichiesta() && protocolConfig.isIntegrationInfoRequired(TipoPdD.APPLICATIVA, requestInfo.getProtocolServiceBinding(), FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA)) {
            riferimentoRichiesta = null;
            if (this.headerIntegrazioneRichiesta != null && this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                riferimentoRichiesta = this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio();
            }
            if (riferimentoRichiesta == null) {
                bf = new StringBuilder();
                for (i = 0; i < this.tipiIntegrazionePA.length; ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(this.tipiIntegrazionePA[i]);
                }
                if (this.msgDiag != null) {
                    this.msgDiag.addKeyword("@TIPI_INTEGRAZIONE@", bf.toString());
                    this.msgDiag.logPersonalizzato("ricezioneBuste.", "riferimentoIdRichiesta.nonFornito");
                }
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)this.msgDiag.getMessaggio("ricezioneBuste.", "riferimentoIdRichiesta.nonFornito"));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_442_RIFERIMENTO_ID_MESSAGGIO.getErroreIntegrazione();
                    integrationFunctionError = IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND;
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(erroreIntegrazione);
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, null);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        headerProtocolloRichiesta = null;
        if (!this.functionAsRouter && !this.isMessaggioErroreProtocollo && this.erroriProcessamento.isEmpty() && this.erroriValidazione.isEmpty() && !this.bustaDiServizio) {
            this.msgDiag.highDebug("Tipo Messaggio Richiesta prima dello sbustamento [" + String.valueOf(FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA) + "] [" + this.requestMessage.getClass().getName() + "]");
            sbustatore = new Sbustamento(this.protocolFactory, this.openspcoopstate.getStatoRichiesta());
            protocolMessage = sbustatore.sbustamento(this.requestMessage, (Context)this.pddContext, this.bustaRichiesta, RuoloMessaggio.RICHIESTA, properties.isValidazioneManifestAttachments(), this.proprietaManifestAttachments, FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA, requestInfo);
            if (protocolMessage != null) {
                headerProtocolloRichiesta = protocolMessage.isUseBustaRawContentReadByValidation() != false ? soapHeaderElement : protocolMessage.getBustaRawContent();
                this.requestMessage = protocolMessage.getMessage();
            }
            this.msgDiag.highDebug("Tipo Messaggio Richiesta dopo lo sbustamento [" + String.valueOf(FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA) + "] [" + (this.requestMessage != null ? this.requestMessage.getClass().getName() : null) + "]");
        } else {
            headerProtocolloRichiesta = soapHeaderElement;
        }
        if (!this.functionAsRouter && !this.isMessaggioErroreProtocollo && this.erroriProcessamento.isEmpty() && this.erroriValidazione.isEmpty() && !this.bustaDiServizio && this.pa != null && this.pa.getCorrelazioneApplicativa() != null) {
            gestoreCorrelazioneApplicativa = null;
            try {
                caConfig = new GestoreCorrelazioneApplicativaConfig();
                caConfig.setState(this.openspcoopstate.getStatoRichiesta());
                caConfig.setAlog(this.logCore);
                caConfig.setSoggettoFruitore(this.soggettoFruitore);
                caConfig.setIdServizio(this.idServizio);
                caConfig.setBusta(this.bustaRichiesta);
                caConfig.setServizioApplicativo(servizioApplicativoFruitore);
                caConfig.setProtocolFactory(this.protocolFactory);
                caConfig.setTransaction(this.transaction);
                caConfig.setPddContext(this.pddContext);
                caConfig.setPa(this.pa);
                gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(caConfig);
                gestoreCorrelazioneApplicativa.verificaCorrelazione(this.pa.getCorrelazioneApplicativa(), urlProtocolContext, this.requestMessage, this.headerIntegrazioneRichiesta, false);
                if (gestoreCorrelazioneApplicativa.getIdCorrelazione() == null) ** GOTO lbl811
                this.correlazioneApplicativa = gestoreCorrelazioneApplicativa.getIdCorrelazione();
            }
            catch (Exception e) {
                this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_CORRELAZIONE_APPLICATIVA_RICHIESTA, "true");
                this.msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa(" + this.bustaRichiesta.getID() + ")");
                RicezioneBuste.logError(this.logCore, "Riscontrato errore durante la correlazione applicativa [" + this.bustaRichiesta.getID() + "]", e);
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la correlazione applicativa [" + this.bustaRichiesta.getID() + "]: " + e.getMessage()));
                    this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                }
                if (this.msgContext.isGestioneRisposta()) {
                    errore = null;
                    if (gestoreCorrelazioneApplicativa != null) {
                        errore = gestoreCorrelazioneApplicativa.getErrore();
                    }
                    if (errore == null) {
                        errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                    }
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(errore);
                    integrationFunctionError = null;
                    integrationFunctionError = CodiceErroreIntegrazione.CODICE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.equals((Object)errore.getCodiceErrore()) != false ? IntegrationFunctionError.APPLICATION_CORRELATION_IDENTIFICATION_REQUEST_FAILED : IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.openspcoopstate.releaseResource();
                return;
            }
        } else {
            this.correlazioneApplicativa = null;
        }
lbl811:
        // 3 sources

        if (this.tipiIntegrazionePA != null) {
            if (inRequestPAMessage != null) {
                inRequestPAMessage.setBustaRichiesta(this.bustaRichiesta);
                inRequestPAMessage.setSoggettoMittente(this.soggettoFruitore);
            }
            for (i = 0; i < this.tipiIntegrazionePA.length; ++i) {
                try {
                    gestore = pluginLoader.newIntegrazionePortaApplicativa(this.tipiIntegrazionePA[i]);
                    if (gestore == null) continue;
                    classType = null;
                    try {
                        classType = gestore.getClass().getName();
                        AbstractCore.init(gestore, this.pddContext, this.protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] da utilizzare per la gestione dell'integrazione delle erogazioni (aggiornamento/eliminazione) di tipo [" + this.tipiIntegrazionePA[i] + "]: " + e.getMessage());
                    }
                    if (!(gestore instanceof IGestoreIntegrazionePASoap)) continue;
                    gestorePASoap = (IGestoreIntegrazionePASoap)gestore;
                    if (propertiesReader.deleteHeaderIntegrazioneRequestPA()) {
                        gestorePASoap.deleteInRequestHeader(inRequestPAMessage);
                        continue;
                    }
                    gestorePASoap.updateInRequestHeader(inRequestPAMessage, this.idMessageRequest, servizioApplicativoFruitore, this.correlazioneApplicativa);
                    continue;
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "HeaderIntegrazione(" + this.tipiIntegrazionePA[i] + ")");
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione dell'Header di Integrazione(" + this.tipiIntegrazionePA[i] + "): " + e.getMessage()));
                        this.tracciamento.registraRichiesta(this.requestMessage, null, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
                    }
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_541_GESTIONE_HEADER_INTEGRAZIONE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
        }
        this.msgDiag.setIdCorrelazioneApplicativa(this.correlazioneApplicativa);
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(this.correlazioneApplicativa);
        }
        this.parametriGenerazioneBustaErrore.setMsgDiag(this.msgDiag);
        this.parametriInvioBustaErrore.setMsgDiag(this.msgDiag);
        dettaglioEccezione = null;
        this.mittenteAnonimo = false;
        this.mittenteAnonimo = validatore.getBusta() == null || validatore.getBusta().getMittente() == null && validatore.getBusta().getTipoMittente() == null;
        if (this.isMessaggioErroreProtocollo) {
            if (validatore.isMessaggioErroreIntestazione()) {
                this.msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Intestazione");
            } else {
                this.msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Processamento");
            }
            this.msgDiag.logPersonalizzato("ricezioneMessaggioErrore");
            try {
                dettaglioEccezione = XMLUtils.getDettaglioEccezione((Logger)this.logCore, (OpenSPCoop2Message)this.requestMessage);
            }
            catch (Exception e) {
                RicezioneBuste.logError(this.logCore, "Errore durante l'analisi del dettaglio dell'eccezione", e);
            }
        } else {
            this.msgDiag.emitRicezioneMessaggioModuloBuste(this.msgDiag, this.pddContext, this.mittenteAnonimo);
        }
        this.versioneProtocollo = validatore.getProfiloGestione();
        this.msgDiag.mediumDebug("Profilo di gestione [RicezioneBuste] della busta: " + this.versioneProtocollo);
        richiestaApplicativa.setProfiloGestione(this.versioneProtocollo);
        this.parametriGenerazioneBustaErrore.setProfiloGestione(this.versioneProtocollo);
        this.moduleManager = this.protocolFactory.createProtocolVersionManager(this.versioneProtocollo);
        if (!(this.functionAsRouter || !ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || this.bustaRichiesta.getRiferimentoMessaggio() == null || this.isMessaggioErroreProtocollo || this.ruoloBustaRicevuta != null && this.ruoloBustaRicevuta.equals((Object)RuoloBusta.RICHIESTA))) {
            ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), this.protocolFactory);
            this.erroriValidazione.add(ecc);
        }
        this.msgDiag.mediumDebug("Gestione errori...");
        if (!this.erroriProcessamento.isEmpty() || this.functionAsRouter && !this.erroriValidazione.isEmpty()) {
            errore = new StringBuilder();
            for (k = 0; k < this.erroriProcessamento.size(); ++k) {
                erroreProcessamento = this.erroriProcessamento.get(k);
                try {
                    errore.append("Processamento[" + this.traduttore.toString(erroreProcessamento.getCodiceEccezione(), erroreProcessamento.getSubCodiceEccezione()) + "] " + this.erroriProcessamento.get(k).getDescrizione(this.protocolFactory) + "\n");
                    continue;
                }
                catch (Exception e) {
                    RicezioneBuste.logError(this.logCore, "getDescrizione failure:" + e.getMessage(), e);
                }
            }
            for (k = 0; k < this.erroriValidazione.size(); ++k) {
                erroreValidazione = this.erroriValidazione.get(k);
                try {
                    errore.append("Validazione[" + this.traduttore.toString(erroreValidazione.getCodiceEccezione(), erroreValidazione.getSubCodiceEccezione()) + "] " + this.erroriValidazione.get(k).getDescrizione(this.protocolFactory) + "\n");
                    continue;
                }
                catch (Exception e) {
                    RicezioneBuste.logError(this.logCore, "getDescrizione errore validazione fallita:" + e.getMessage(), e);
                }
            }
            this.msgDiag.addKeyword("@ECCEZIONI@", errore.toString());
            this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + (this.erroriProcessamento.size() + this.erroriValidazione.size()));
            this.msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)this.msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta"));
                this.tracciamento.registraRichiesta(this.requestMessage, securityInfoRequest, soapHeaderElement, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
            }
            if (this.msgContext.isGestioneRisposta()) {
                errorOpenSPCoopMsg = null;
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                if (!this.erroriProcessamento.isEmpty()) {
                    for (j = 0; j < this.erroriValidazione.size(); ++j) {
                        this.erroriProcessamento.add(this.erroriValidazione.get(j));
                    }
                    this.parametriGenerazioneBustaErrore.setError(this.erroriProcessamento);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, null);
                } else {
                    this.parametriGenerazioneBustaErrore.setError(this.erroriValidazione);
                    if (integrationFunctionErrorValidazione != null) {
                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionErrorValidazione);
                    }
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                }
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        if (this.msgContext.isTracciamentoAbilitato()) {
            this.msgDiag.mediumDebug("Tracciamento busta di richiesta...");
            esitoTraccia = null;
            if (!this.erroriProcessamento.isEmpty() || !this.erroriValidazione.isEmpty()) {
                foundErroriGravi = false;
                dettaglioErrore = null;
                eccBuffer = new StringBuilder();
                for (k = 0; k < this.erroriProcessamento.size(); ++k) {
                    er = this.erroriProcessamento.get(k);
                    if (k > 0) {
                        eccBuffer.append(" ");
                    }
                    eccBuffer.append(er.toString(this.protocolFactory));
                    eccBuffer.append(";");
                    if (this.moduleManager.isIgnoraEccezioniLivelloNonGrave()) {
                        if (er.getRilevanza() != null) {
                            if (!LivelloRilevanza.isEccezioneLivelloGrave((LivelloRilevanza)er.getRilevanza())) continue;
                            foundErroriGravi = true;
                            continue;
                        }
                        foundErroriGravi = true;
                        continue;
                    }
                    foundErroriGravi = true;
                }
                for (k = 0; k < this.erroriValidazione.size(); ++k) {
                    er = this.erroriValidazione.get(k);
                    if (eccBuffer.length() > 0) {
                        eccBuffer.append(" ");
                    }
                    eccBuffer.append(er.toString(this.protocolFactory));
                    eccBuffer.append(";");
                    if (this.moduleManager.isIgnoraEccezioniLivelloNonGrave()) {
                        if (er.getRilevanza() != null) {
                            if (!LivelloRilevanza.isEccezioneLivelloGrave((LivelloRilevanza)er.getRilevanza())) continue;
                            foundErroriGravi = true;
                            continue;
                        }
                        foundErroriGravi = true;
                        continue;
                    }
                    foundErroriGravi = true;
                }
                this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + (this.erroriProcessamento.size() + this.erroriValidazione.size()));
                this.msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                dettaglioErrore = this.isMessaggioErroreProtocollo != false ? this.msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBustaErrore.listaEccezioniMalformata") : this.msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
                esitoTraccia = foundErroriGravi ? EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)dettaglioErrore) : EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioRicevuto((String)dettaglioErrore);
            } else {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioRicevuto();
            }
            this.tracciamento.registraRichiesta(this.requestMessage, securityInfoRequest, headerProtocolloRichiesta, this.bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getSourceLocation()), this.correlazioneApplicativa);
        }
        this.msgDiag.mediumDebug("Controllo mittente/destinatario/servizio (se sconosciuto, risposta immediata sulla connessione)...");
        for (k = 0; k < this.erroriValidazione.size(); ++k) {
            er = this.erroriValidazione.get(k);
            if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneDestinatario((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneServizio((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneIdentificativoMessaggio((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneSicurezzaAutorizzazione((CodiceErroreCooperazione)er.getCodiceEccezione()) || !this.functionAsRouter && this.moduleManager.isEccezioniLivelloInfoAbilitato() && LivelloRilevanza.INFO.equals((Object)er.getRilevanza())) continue;
            eccBuffer = new StringBuilder();
            for (j = 0; j < this.erroriValidazione.size(); ++j) {
                if (j > 0) {
                    eccBuffer.append("\n");
                }
                eccBuffer.append(this.erroriValidazione.get(j).toString(this.protocolFactory));
            }
            this.msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
            this.msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + this.erroriValidazione.size());
            this.msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                errs = new ArrayList<Eccezione>();
                for (add = 0; add < this.erroriValidazione.size(); ++add) {
                    errs.add(this.erroriValidazione.get(add));
                }
                this.parametriGenerazioneBustaErrore.setError(errs);
                if (integrationFunctionErrorValidazione != null) {
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionErrorValidazione);
                } else if (CodiceErroreCooperazione.isEccezioneSicurezzaAutorizzazione((CodiceErroreCooperazione)er.getCodiceEccezione())) {
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.AUTHORIZATION);
                } else {
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_REQUEST);
                }
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                this.parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(false);
                this.parametriInvioBustaErrore.setNewConnectionForResponse(false);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.openspcoopstate.releaseResource();
            return;
        }
        this.finalProcess(validatore, servizioApplicativoFruitore, gestioneToken, idPA, idPD, inoltroMSG, gestioneAutenticazione, implementazionePdDDestinatario, richiestaApplicativa, dettaglioEccezione, integrationFunctionErrorValidazione, credenziali);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void finalProcess(Validatore validatore, String servizioApplicativoFruitore, RicezioneBusteGestioneToken gestioneToken, IDPortaApplicativa idPA, IDPortaDelegata idPD, InoltroBusteMessage inoltroMSG, RicezioneBusteGestioneAutenticazione gestioneAutenticazione, String implementazionePdDDestinatario, RichiestaApplicativa richiestaApplicativa, DettaglioEccezione dettaglioEccezione, IntegrationFunctionError integrationFunctionErrorValidazione, Credenziali credenziali) throws ProtocolException {
        block244: {
            block243: {
                block242: {
                    requestInfo = this.msgContext.getRequestInfo();
                    propertiesReader = OpenSPCoop2Properties.getInstance();
                    loader = Loader.getInstance();
                    token = gestioneToken.getToken();
                    dataIngressoRichiesta = this.msgContext.getDataIngressoRichiesta();
                    className = ClassNameProperties.getInstance();
                    soggettoAutenticato = gestioneAutenticazione.isSoggettoAutenticato();
                    supportatoAutenticazioneSoggetti = gestioneAutenticazione.isSupportatoAutenticazioneSoggetti();
                    idApplicativoToken = gestioneAutenticazione.getIdApplicativoToken();
                    autenticazioneOpzionale = gestioneAutenticazione.isAutenticazioneOpzionale();
                    eccezioniValidazioni = false;
                    for (k = 0; k < this.erroriValidazione.size(); ++k) {
                        er = this.erroriValidazione.get(k);
                        if (!this.functionAsRouter && this.moduleManager.isEccezioniLivelloInfoAbilitato() && LivelloRilevanza.INFO.equals((Object)er.getRilevanza())) continue;
                        eccezioniValidazioni = true;
                        break;
                    }
                    this.msgDiag.mediumDebug("Autorizzazione ...");
                    tipoAutorizzazione = null;
                    try {
                        if (this.functionAsRouter) {
                            tipoAutorizzazione = propertiesReader.getTipoAutorizzazioneBuste();
                        } else if (this.pa != null) {
                            tipoAutorizzazione = this.configurazionePdDReader.getAutorizzazione(this.pa);
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    isAttivoAutorizzazioneBuste = tipoAutorizzazione != null && "none".equalsIgnoreCase(tipoAutorizzazione) == false;
                    this.msgContext.getIntegrazione().setTipoAutorizzazione(tipoAutorizzazione);
                    if (tipoAutorizzazione != null) {
                        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE@", tipoAutorizzazione);
                        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_BUSTE@", tipoAutorizzazione);
                    }
                    if (!isAttivoAutorizzazioneBuste) {
                        this.msgDiag.logPersonalizzato("autorizzazioneBusteDisabilitata");
                    }
                    datiInvocazione = null;
                    if (isAttivoAutorizzazioneBuste && !this.isMessaggioErroreProtocollo && !this.bustaDiServizio && !eccezioniValidazioni) {
                        this.transaction.getTempiElaborazione().startAutorizzazione();
                        try {
                            this.msgDiag.mediumDebug("Autorizzazione di tipo [" + tipoAutorizzazione + "]...");
                            identitaMittente = null;
                            if (credenziali != null && !soggettoAutenticato && !"".equals(credenziali.toString()) && (identitaMittente = credenziali.toString()).endsWith(" ")) {
                                identitaMittente = identitaMittente.substring(0, identitaMittente.length() - 1);
                            }
                            subjectMessageSecurity = null;
                            if (this.messageSecurityContext != null) {
                                subjectMessageSecurity = this.messageSecurityContext.getSubject();
                            }
                            idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(this.idServizio, this.soggettoFruitore, this.functionAsRouter, this.bustaRichiesta, this.ruoloBustaRicevuta);
                            idSoggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(this.idServizio, this.soggettoFruitore, this.functionAsRouter, this.bustaRichiesta, this.ruoloBustaRicevuta, supportatoAutenticazioneSoggetti);
                            soggettoMittentePerAutorizzazione = null;
                            if (idSoggettoMittentePerAutorizzazione != null) {
                                soggettoMittentePerAutorizzazione = this.registroServiziReader.getSoggetto(idSoggettoMittentePerAutorizzazione, null, requestInfo);
                            }
                            tipoMessaggio = "messaggio";
                            if (this.ruoloBustaRicevuta != null && (RuoloBusta.RICEVUTA_RICHIESTA.equals(this.ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(this.ruoloBustaRicevuta.toString()))) {
                                tipoMessaggio = "ricevuta asincrona";
                            }
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO_BUSTA@", tipoMessaggio);
                            if (idSoggettoMittentePerAutorizzazione != null) {
                                this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "fruitore [" + idSoggettoMittentePerAutorizzazione.toString() + "] -> servizio [" + idServizioPerAutorizzazione.toString() + "]");
                            } else {
                                this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "servizio [" + idServizioPerAutorizzazione.toString() + "]");
                            }
                            if (identitaMittente != null) {
                                this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", " credenzialiMittente " + identitaMittente);
                            } else {
                                this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
                            }
                            if (servizioApplicativoFruitore != null) {
                                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                            } else {
                                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                            }
                            if (subjectMessageSecurity != null) {
                                this.msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", " subjectMessageSecurity [" + subjectMessageSecurity + "]");
                            } else {
                                this.msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", "");
                            }
                            this.msgDiag.logPersonalizzato("autorizzazioneBusteInCorso");
                            identitaServizioApplicativoFruitore = new IDServizioApplicativo();
                            identitaServizioApplicativoFruitore.setNome(servizioApplicativoFruitore);
                            identitaServizioApplicativoFruitore.setIdSoggettoProprietario(idSoggettoMittentePerAutorizzazione);
                            datiInvocazione = new DatiInvocazionePortaApplicativa();
                            datiInvocazione.setBusta(this.bustaRichiesta);
                            datiInvocazione.setToken(token);
                            datiInvocazione.setPddContext(this.pddContext);
                            datiInvocazione.setInfoConnettoreIngresso(this.inRequestContext.getConnettore());
                            datiInvocazione.setIdServizio(idServizioPerAutorizzazione);
                            datiInvocazione.setState(this.openspcoopstate.getStatoRichiesta());
                            datiInvocazione.setRequestInfo(requestInfo);
                            datiInvocazione.setCredenzialiPdDMittente(credenziali);
                            datiInvocazione.setIdentitaServizioApplicativoFruitore(identitaServizioApplicativoFruitore);
                            datiInvocazione.setSubjectServizioApplicativoFruitoreFromMessageSecurityHeader(subjectMessageSecurity);
                            datiInvocazione.setIdPA(idPA);
                            datiInvocazione.setPa(this.pa);
                            datiInvocazione.setIdPD(idPD);
                            datiInvocazione.setPd(this.pd);
                            datiInvocazione.setIdSoggettoFruitore(idSoggettoMittentePerAutorizzazione);
                            datiInvocazione.setSoggettoFruitore(soggettoMittentePerAutorizzazione);
                            datiInvocazione.setRuoloBusta(this.ruoloBustaRicevuta);
                            esito = GestoreAutorizzazione.verificaAutorizzazionePortaApplicativa(tipoAutorizzazione, datiInvocazione, this.pddContext, this.protocolFactory, this.requestMessage, this.logCore);
                            CostantiPdD.addKeywordInCache(this.msgDiag, esito.isEsitoPresenteInCache(), this.pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE);
                            if (esito.getDetails() == null) {
                                this.msgDiag.addKeyword("@DETAILS@", "");
                            } else {
                                this.msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                            }
                            if (!esito.isAutorizzato()) {
                                this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, "true");
                                descrizioneErrore = null;
                                try {
                                    descrizioneErrore = esito.getErroreCooperazione() != null ? esito.getErroreCooperazione().getDescrizione(this.protocolFactory) : esito.getErroreIntegrazione().getDescrizione(this.protocolFactory);
                                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", descrizioneErrore);
                                }
                                catch (Exception e) {
                                    RicezioneBuste.logError(this.logCore, "getDescrizione Error:" + e.getMessage(), e);
                                }
                                this.msgDiag.addKeyword("@POSIZIONE_ERRORE@", this.traduttore.toString(esito.getErroreCooperazione().getCodiceErrore()));
                                this.msgDiag.logPersonalizzato("autorizzazioneBusteFallita");
                                errorMsg = "Riscontrato errore durante il processo di Autorizzazione per il messaggio con identificativo [" + this.bustaRichiesta.getID() + "]: " + descrizioneErrore;
                                if (esito.getEccezioneProcessamento() != null) {
                                    RicezioneBuste.logError(this.logCore, errorMsg, esito.getEccezioneProcessamento());
                                } else {
                                    RicezioneBuste.logError(this.logCore, errorMsg);
                                }
                                if (this.msgContext.isGestioneRisposta()) {
                                    if (esito.getErrorMessage() != null) {
                                        this.msgContext.setMessageResponse(esito.getErrorMessage());
                                    } else {
                                        errorOpenSPCoopMsg = null;
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        integrationFunctionError = esito.getIntegrationFunctionError();
                                        if (esito.getErroreCooperazione() != null) {
                                            this.parametriGenerazioneBustaErrore.setErroreCooperazione(esito.getErroreCooperazione());
                                            if (CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals((Object)esito.getErroreCooperazione().getCodiceErrore()) || CodiceErroreCooperazione.SICUREZZA_FALSIFICAZIONE_MITTENTE.equals((Object)esito.getErroreCooperazione().getCodiceErrore()) || CodiceErroreCooperazione.SICUREZZA_TOKEN_AUTORIZZAZIONE_FALLITA.equals((Object)esito.getErroreCooperazione().getCodiceErrore())) {
                                                if (integrationFunctionError == null) {
                                                    integrationFunctionError = IntegrationFunctionError.AUTHORIZATION;
                                                }
                                                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                                            } else if (CodiceErroreCooperazione.SERVIZIO_SCONOSCIUTO.equals((Object)esito.getErroreCooperazione().getCodiceErrore())) {
                                                this.parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione());
                                                if (integrationFunctionError == null) {
                                                    integrationFunctionError = IntegrationFunctionError.NOT_FOUND;
                                                }
                                                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                                            } else {
                                                if (integrationFunctionError == null) {
                                                    integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                                }
                                                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, esito.getEccezioneProcessamento());
                                            }
                                        } else {
                                            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(esito.getErroreIntegrazione());
                                            if (integrationFunctionError == null) {
                                                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                            }
                                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, esito.getEccezioneProcessamento());
                                        }
                                        if (esito.getWwwAuthenticateErrorHeader() != null) {
                                            errorOpenSPCoopMsg.forceTransportHeader("WWW-Authenticate", esito.getWwwAuthenticateErrorHeader());
                                        }
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                    }
                                }
                                this.openspcoopstate.releaseResource();
                                return;
                            }
                            this.msgDiag.logPersonalizzato("autorizzazioneBusteEffettuata");
                        }
                        catch (Exception e) {
                            CostantiPdD.addKeywordInCache(this.msgDiag, false, this.pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE);
                            this.msgDiag.logErroreGenerico(e, "AutorizzazioneMessaggio(" + this.bustaRichiesta.getID() + ")");
                            RicezioneBuste.logError(this.logCore, "Riscontrato errore durante il processo di Autorizzazione per il messaggio con identificativo [" + this.bustaRichiesta.getID() + "]", e);
                            if (this.msgContext.isGestioneRisposta()) {
                                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_504_AUTORIZZAZIONE));
                                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                            }
                            this.openspcoopstate.releaseResource();
                            return;
                        }
                        finally {
                            this.transaction.getTempiElaborazione().endAutorizzazione();
                        }
                    }
                    this.msgDiag.mediumDebug("Verifica canale utilizzato...");
                    tipiSoggettiSupportatiCanale = this.protocolFactory.createProtocolConfiguration().getTipiSoggetti();
                    tipiServiziSupportatiCanale = this.protocolFactory.createProtocolConfiguration().getTipiServizi(this.requestMessage.getServiceBinding());
                    erroreVerificaTipoByProtocol = null;
                    if (this.soggettoFruitore != null && this.soggettoFruitore.getTipo() != null && !tipiSoggettiSupportatiCanale.contains(this.soggettoFruitore.getTipo())) {
                        if (autenticazioneOpzionale && !propertiesReader.isAutorizzazioneBustaAutenticazioneOpzionaleSoggettoFruitoreProfiloInteroperabilitaDifferenteServizioBloccaRichiesta()) {
                            this.msgDiag.logPersonalizzato("protocolli.tipoSoggetto.fruitore.unsupported.warning");
                        } else {
                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                            this.msgDiag.logPersonalizzato("protocolli.tipoSoggetto.fruitore.unsupported");
                            erroreVerificaTipoByProtocol = ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione();
                        }
                    } else if (this.idServizio != null && this.idServizio.getSoggettoErogatore() != null && this.idServizio.getSoggettoErogatore().getTipo() != null && !tipiSoggettiSupportatiCanale.contains(this.idServizio.getSoggettoErogatore().getTipo())) {
                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                        this.msgDiag.logPersonalizzato("protocolli.tipoSoggetto.erogatore.unsupported");
                        erroreVerificaTipoByProtocol = ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione();
                    } else if (this.idServizio != null && this.idServizio.getTipo() != null && !tipiServiziSupportatiCanale.contains(this.idServizio.getTipo())) {
                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                        this.msgDiag.logPersonalizzato("protocolli.tipoServizio.unsupported");
                        erroreVerificaTipoByProtocol = ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione();
                    } else if (idApplicativoToken != null && idApplicativoToken.getIdSoggettoProprietario() != null && idApplicativoToken.getIdSoggettoProprietario().getTipo() != null && !tipiSoggettiSupportatiCanale.contains(idApplicativoToken.getIdSoggettoProprietario().getTipo())) {
                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                        this.msgDiag.logPersonalizzato("protocolli.tipoSoggetto.applicativoToken.unsupported");
                        erroreVerificaTipoByProtocol = ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione();
                    }
                    if (erroreVerificaTipoByProtocol != null) {
                        if (this.msgContext.isGestioneRisposta()) {
                            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                            this.parametriGenerazioneBustaErrore.setErroreCooperazione(erroreVerificaTipoByProtocol);
                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        }
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                    validazioneContenutoApplicativoApplicativo = null;
                    proprietaPorta = null;
                    tipoAutorizzazionePerContenuto = null;
                    if (!this.functionAsRouter && !this.isMessaggioErroreProtocollo && this.erroriProcessamento.isEmpty() && this.erroriValidazione.isEmpty() && !this.bustaDiServizio && this.pa != null) {
                        this.msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta...");
                        isRicevutaAsincronaModalitaAsincrona = false;
                        try {
                            if ((ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) && this.bustaRichiesta.getRiferimentoMessaggio() != null) {
                                this.msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta (check asincrono)...");
                                if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                                    if (this.bustaRichiesta.getRiferimentoMessaggio() == null) {
                                        validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pa, this.implementazionePdDMittente, true);
                                        proprietaPorta = this.pa.getProprietaList();
                                        tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pa);
                                    } else if (RuoloBusta.RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                                        validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pd, this.implementazionePdDMittente, true);
                                        proprietaPorta = this.pd.getProprietaList();
                                        tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pd);
                                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(this.ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                                        if (this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(this.pd)) {
                                            isRicevutaAsincronaModalitaAsincrona = true;
                                        } else {
                                            validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pd, this.implementazionePdDMittente, true);
                                            proprietaPorta = this.pd.getProprietaList();
                                            tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pd);
                                        }
                                    }
                                } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                                    if (this.bustaRichiesta.getRiferimentoMessaggio() == null) {
                                        validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pa, this.implementazionePdDMittente, true);
                                        proprietaPorta = this.pa.getProprietaList();
                                        tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pa);
                                    } else if (RuoloBusta.RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                                        validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pa, this.implementazionePdDMittente, true);
                                        proprietaPorta = this.pa.getProprietaList();
                                        tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pa);
                                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(this.ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                                        if (this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(this.pd)) {
                                            isRicevutaAsincronaModalitaAsincrona = true;
                                        } else {
                                            validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pd, this.implementazionePdDMittente, true);
                                            proprietaPorta = this.pd.getProprietaList();
                                            tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pd);
                                        }
                                    }
                                }
                                ((StateMessage)this.openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            } else {
                                this.msgDiag.mediumDebug("Controllo abilitazione validazione dei contenuti applicativi della richiesta...");
                                validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.pa, this.implementazionePdDMittente, true);
                                proprietaPorta = this.pa.getProprietaList();
                                tipoAutorizzazionePerContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.pa);
                            }
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "getTipoValidazione/Autorizzazione ContenutoApplicativo");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                            }
                            this.openspcoopstate.releaseResource();
                            return;
                        }
                        if (!isRicevutaAsincronaModalitaAsincrona) {
                            if (validazioneContenutoApplicativoApplicativo != null && validazioneContenutoApplicativoApplicativo.getTipo() != null) {
                                tipo = ValidatoreMessaggiApplicativi.getTipo(validazioneContenutoApplicativoApplicativo);
                                this.msgContext.getIntegrazione().setTipoValidazioneContenuti(tipo);
                                this.msgDiag.addKeyword("@TIPO_VALIDAZIONE_CONTENUTI@", tipo);
                                this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", "");
                            }
                            if (validazioneContenutoApplicativoApplicativo != null && (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals((Object)validazioneContenutoApplicativoApplicativo.getStato()) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato()))) {
                                this.transaction.getTempiElaborazione().startValidazioneRichiesta();
                                binXSD = null;
                                try {
                                    this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaInCorso");
                                    readInterface = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo());
                                    if (ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                        xomReferences = null;
                                        if (StatoFunzionalita.ABILITATO.equals((Object)validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                                            this.msgDiag.mediumDebug("Validazione xsd della richiesta (mtomFastUnpackagingForXSDConformance)...");
                                            if (!ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                                throw new CoreException("Funzionalita 'AcceptMtomMessage' valida solamente per Service Binding SOAP");
                                            }
                                            xomReferences = this.requestMessage.castAsSoap().mtomFastUnpackagingForXSDConformance();
                                        }
                                        this.msgDiag.mediumDebug("Validazione della richiesta (initValidator)...");
                                        validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(this.registroServiziReader, this.idServizio, this.requestMessage, readInterface, propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeGestione(), proprietaPorta, this.pddContext);
                                        if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo())) {
                                            this.msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                                            validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true);
                                        }
                                        this.msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                                        validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true);
                                        if ((CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo())) && propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeGestione() && propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeRipulituraDopoValidazione()) {
                                            this.msgDiag.mediumDebug("Ripristino elementi modificati per supportare validazione wsdl della richiesta ...");
                                            validatoreMessaggiApplicativi.restoreOriginalDocument(true);
                                        }
                                        if (xomReferences != null && !xomReferences.isEmpty()) {
                                            this.msgDiag.mediumDebug("Validazione xsd della richiesta (mtomRestoreAfterXSDConformance)...");
                                            if (!ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                                throw new CoreException("Funzionalita 'AcceptMtomMessage' valida solamente per Service Binding SOAP");
                                            }
                                            this.requestMessage.castAsSoap().mtomRestoreAfterXSDConformance(xomReferences);
                                        }
                                    } else {
                                        this.msgDiag.mediumDebug("Validazione della richiesta (initValidator)...");
                                        validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativiRest(this.registroServiziReader, this.idServizio, this.requestMessage, readInterface, proprietaPorta, this.protocolFactory, this.pddContext);
                                        if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) && this.requestMessage.castAsRest().hasContent()) {
                                            this.msgDiag.mediumDebug("Validazione xsd della richiesta ...");
                                            validatoreMessaggiApplicativi.validateWithSchemiXSD(true);
                                        } else {
                                            validatoreMessaggiApplicativi.validateRequestWithInterface(true);
                                        }
                                    }
                                    this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaEffettuata");
                                }
                                catch (ValidatoreMessaggiApplicativiException ex) {
                                    this.msgDiag.addKeywordErroreProcessamento(ex);
                                    RicezioneBuste.logError(this.logCore, "[ValidazioneContenutiApplicativi Richiesta] " + ex.getMessage(), ex);
                                    if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) {
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly");
                                    } else {
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita");
                                    }
                                    if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) ** GOTO lbl371
                                    this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_VALIDAZIONE_RICHIESTA, "true");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        integrationFunctionError = null;
                                        integrationFunctionError = ex.getErrore() != null && CodiceErroreIntegrazione.CODICE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.equals((Object)ex.getErrore().getCodiceErrore()) != false ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ex.getErrore());
                                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, ex);
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                    }
                                    this.openspcoopstate.releaseResource();
                                    return;
                                }
                                catch (Exception ex) {
                                    this.msgDiag.addKeywordErroreProcessamento(ex);
                                    RicezioneBuste.logError(this.logCore, "Riscontrato errore durante la validazione dei contenuti applicativi (richiesta applicativa)", ex);
                                    if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) {
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly");
                                    } else {
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita");
                                    }
                                    if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) ** GOTO lbl371
                                    this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_VALIDAZIONE_RICHIESTA, "true");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
                                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, ex);
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                    }
                                    this.openspcoopstate.releaseResource();
                                    return;
                                }
                                finally {
                                    this.transaction.getTempiElaborazione().endValidazioneRichiesta();
                                    if (binXSD != null) {
                                        try {
                                            binXSD.close();
                                        }
                                        catch (Exception integrationFunctionError) {}
                                    }
                                }
                            } else {
                                this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaDisabilitata");
                            }
                        }
lbl371:
                        // 6 sources

                        this.msgContext.getIntegrazione().setTipoAutorizzazioneContenuto(tipoAutorizzazionePerContenuto);
                        if (tipoAutorizzazionePerContenuto != null) {
                            this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_CONTENUTO@", tipoAutorizzazionePerContenuto);
                        }
                        if (!"none".equalsIgnoreCase(tipoAutorizzazionePerContenuto)) {
                            this.transaction.getTempiElaborazione().startAutorizzazioneContenuti();
                            try {
                                identitaMittente = null;
                                if (credenziali != null && !soggettoAutenticato && !"".equals(credenziali.toString()) && (identitaMittente = credenziali.toString()).endsWith(" ")) {
                                    identitaMittente = identitaMittente.substring(0, identitaMittente.length() - 1);
                                }
                                subjectMessageSecurity = null;
                                if (this.messageSecurityContext != null) {
                                    subjectMessageSecurity = this.messageSecurityContext.getSubject();
                                }
                                idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(this.idServizio, this.soggettoFruitore, this.functionAsRouter, this.bustaRichiesta, this.ruoloBustaRicevuta);
                                idSoggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(this.idServizio, this.soggettoFruitore, this.functionAsRouter, this.bustaRichiesta, this.ruoloBustaRicevuta, supportatoAutenticazioneSoggetti);
                                soggettoMittentePerAutorizzazione = null;
                                if (idSoggettoMittentePerAutorizzazione != null) {
                                    soggettoMittentePerAutorizzazione = this.registroServiziReader.getSoggetto(idSoggettoMittentePerAutorizzazione, null, requestInfo);
                                }
                                tipoMessaggio = "messaggio";
                                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(this.ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(this.ruoloBustaRicevuta.toString())) {
                                    tipoMessaggio = "ricevuta asincrona";
                                }
                                this.msgDiag.addKeyword("@TIPO_MESSAGGIO_BUSTA@", tipoMessaggio);
                                if (idSoggettoMittentePerAutorizzazione != null) {
                                    this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "fruitore [" + idSoggettoMittentePerAutorizzazione.toString() + "] -> servizio [" + idServizioPerAutorizzazione.toString() + "]");
                                } else {
                                    this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "servizio [" + idServizioPerAutorizzazione.toString() + "]");
                                }
                                if (identitaMittente != null) {
                                    this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", " credenzialiMittente " + identitaMittente);
                                } else {
                                    this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
                                }
                                if (servizioApplicativoFruitore != null) {
                                    this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                                } else {
                                    this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                                }
                                if (subjectMessageSecurity != null) {
                                    this.msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", " subjectMessageSecurity [" + subjectMessageSecurity + "]");
                                } else {
                                    this.msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", "");
                                }
                                this.msgDiag.logPersonalizzato("autorizzazioneContenutiBusteInCorso");
                                if (datiInvocazione == null) {
                                    identitaServizioApplicativoFruitore = new IDServizioApplicativo();
                                    identitaServizioApplicativoFruitore.setNome(servizioApplicativoFruitore);
                                    identitaServizioApplicativoFruitore.setIdSoggettoProprietario(idSoggettoMittentePerAutorizzazione);
                                    datiInvocazione = new DatiInvocazionePortaApplicativa();
                                    datiInvocazione.setBusta(this.bustaRichiesta);
                                    datiInvocazione.setToken(token);
                                    datiInvocazione.setPddContext(this.pddContext);
                                    datiInvocazione.setInfoConnettoreIngresso(this.inRequestContext.getConnettore());
                                    datiInvocazione.setIdServizio(idServizioPerAutorizzazione);
                                    datiInvocazione.setState(this.openspcoopstate.getStatoRichiesta());
                                    datiInvocazione.setRequestInfo(requestInfo);
                                    datiInvocazione.setCredenzialiPdDMittente(credenziali);
                                    datiInvocazione.setIdentitaServizioApplicativoFruitore(identitaServizioApplicativoFruitore);
                                    datiInvocazione.setSubjectServizioApplicativoFruitoreFromMessageSecurityHeader(subjectMessageSecurity);
                                    datiInvocazione.setIdPA(idPA);
                                    datiInvocazione.setPa(this.pa);
                                    datiInvocazione.setIdPD(idPD);
                                    datiInvocazione.setPd(this.pd);
                                    datiInvocazione.setIdSoggettoFruitore(idSoggettoMittentePerAutorizzazione);
                                    datiInvocazione.setSoggettoFruitore(soggettoMittentePerAutorizzazione);
                                    datiInvocazione.setRuoloBusta(this.ruoloBustaRicevuta);
                                }
                                esito = GestoreAutorizzazione.verificaAutorizzazioneContenutoPortaApplicativa(tipoAutorizzazionePerContenuto, datiInvocazione, this.pddContext, this.protocolFactory, this.requestMessage, this.logCore);
                                CostantiPdD.addKeywordInCache(this.msgDiag, esito.isEsitoPresenteInCache(), this.pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI);
                                if (esito.getDetails() == null) {
                                    this.msgDiag.addKeyword("@DETAILS@", "");
                                } else {
                                    this.msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                                }
                                if (!esito.isAutorizzato()) {
                                    this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.ERRORE_AUTORIZZAZIONE, "true");
                                    try {
                                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esito.getErroreCooperazione().getDescrizione(this.protocolFactory));
                                    }
                                    catch (Exception e) {
                                        RicezioneBuste.logError(this.logCore, "getDescrizione Error:" + e.getMessage(), e);
                                    }
                                    this.msgDiag.addKeyword("@POSIZIONE_ERRORE@", this.traduttore.toString(esito.getErroreCooperazione().getCodiceErrore()));
                                    this.msgDiag.logPersonalizzato("autorizzazioneContenutiBusteFallita");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        errorMsg = null;
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        this.parametriGenerazioneBustaErrore.setErroreCooperazione(esito.getErroreCooperazione());
                                        integrationFunctionError = esito.getIntegrationFunctionError();
                                        if (CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals((Object)esito.getErroreCooperazione().getCodiceErrore()) || CodiceErroreCooperazione.SICUREZZA_FALSIFICAZIONE_MITTENTE.equals((Object)esito.getErroreCooperazione().getCodiceErrore())) {
                                            if (integrationFunctionError == null) {
                                                integrationFunctionError = IntegrationFunctionError.CONTENT_AUTHORIZATION_DENY;
                                            }
                                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                            errorMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                                        } else {
                                            if (integrationFunctionError == null) {
                                                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                            }
                                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(integrationFunctionError);
                                            errorMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, esito.getEccezioneProcessamento());
                                        }
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                    }
                                    this.openspcoopstate.releaseResource();
                                    return;
                                }
                                this.msgDiag.logPersonalizzato("autorizzazioneContenutiBusteEffettuata");
                            }
                            catch (Exception ex) {
                                CostantiPdD.addKeywordInCache(this.msgDiag, false, this.pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI);
                                this.msgDiag.logErroreGenerico(ex, "AutorizzazioneContenuto Messaggio(" + this.bustaRichiesta.getID() + ")");
                                RicezioneBuste.logError(this.logCore, "Riscontrato errore durante il processo di Autorizzazione del Contenuto per il messaggio con identificativo [" + this.bustaRichiesta.getID() + "]", ex);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_542_AUTORIZZAZIONE_CONTENUTO));
                                    errorMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, ex);
                                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                }
                                this.openspcoopstate.releaseResource();
                                return;
                            }
                            finally {
                                this.transaction.getTempiElaborazione().endAutorizzazioneContenuti();
                            }
                        }
                        this.msgDiag.logPersonalizzato("autorizzazioneContenutiBusteDisabilitata");
                    }
                    Utilities.printFreeMemory((String)"RicezioneBuste - Recupero configurazione per salvataggio risposta in cache ...");
                    this.msgDiag.mediumDebug("Recupero configurazione per salvataggio risposta in cache ...");
                    try {
                        responseCachingConfig = null;
                        responseCachingConfig = this.pa != null ? this.configurazionePdDReader.getConfigurazioneResponseCaching(this.pa) : this.configurazionePdDReader.getConfigurazioneResponseCaching();
                        if (responseCachingConfig == null || !StatoFunzionalita.ABILITATO.equals((Object)responseCachingConfig.getStato())) break block242;
                        this.transaction.getTempiElaborazione().startResponseCachingCalcoloDigest();
                        try {
                            this.msgDiag.mediumDebug("Calcolo digest per salvataggio risposta ...");
                            hashGenerator = new HashGenerator(propertiesReader.getCachingResponseDigestAlgorithm());
                            digest = hashGenerator.buildKeyCache(this.requestMessage, requestInfo, responseCachingConfig);
                            this.requestMessage.addContextProperty(CostantiPdD.RESPONSE_CACHE_REQUEST_DIGEST, (Object)digest);
                        }
                        finally {
                            this.transaction.getTempiElaborazione().endResponseCachingCalcoloDigest();
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "calcoloDigestSalvataggioRisposta");
                        RicezioneBuste.logError(this.logCore, "Calcolo Digest Salvataggio Risposta non riuscito: " + String.valueOf(e));
                        if (this.msgContext.isGestioneRisposta()) {
                            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_561_DIGEST_REQUEST));
                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        }
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                }
                try {
                    if (this.oneWayStateless || this.sincronoStateless || this.asincronoStateless || this.oneWayVersione11 || this.routingStateless) {
                        this.openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)this.openspcoopstate, true);
                        this.parametriGenerazioneBustaErrore.setOpenspcoop(this.openspcoopstate);
                        this.parametriInvioBustaErrore.setOpenspcoop(this.openspcoopstate);
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "OpenSPCoopState.toStateless");
                    RicezioneBuste.logError(this.logCore, "Creazione stato STATEFUL/STATELESS non riuscita: " + String.valueOf(e));
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.openspcoopstate.releaseResource();
                    return;
                }
                tipoMsg = "INBOX";
                if (this.functionAsRouter) {
                    tipoMsg = "OUTBOX";
                }
                this.msgRequest = new GestoreMessaggi(this.openspcoopstate, true, this.idMessageRequest, tipoMsg, this.msgDiag, this.inRequestContext.getPddContext());
                this.msgRequest.setOneWayVersione11(this.oneWayVersione11);
                this.msgRequest.setRoutingStateless(this.routingStateless);
                this.repositoryBuste = new RepositoryBuste(this.openspcoopstate.getStatoRichiesta(), true, this.protocolFactory);
                this.msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
                if (!this.functionAsRouter || !this.routingStateless) {
                    try {
                        if (this.msgRequest.existsMessage_noCache()) {
                            proprietarioMessaggio = this.msgRequest.getProprietario(this.msgContext.getIdModulo());
                            if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                this.msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                                msg = this.msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.marcatoDaEliminare");
                                if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                    this.msgRequest._deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamentoAttesaAttiva(), propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                } else {
                                    this.msgRequest.deleteMessageByNow();
                                }
                            } else {
                                v0 = rispostaModalitaSincrona = ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false && this.configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(this.pa) != false || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false && this.configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(this.pa) != false;
                                if (rispostaModalitaSincrona) {
                                    this.msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                                    this.msgDiag.logPersonalizzato("messaggioInGestione.gestioneSincrona");
                                    this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.RICHIESTA_DUPLICATA, "true");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(this.idMessageRequest));
                                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.CONFLICT_IN_QUEUE);
                                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, null);
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                                    }
                                    this.openspcoopstate.releaseResource();
                                    return;
                                }
                                this.msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                                this.msgDiag.logPersonalizzato("messaggioInGestione.gestioneAsincrona");
                                scadenzaWhile = DateManager.getTimeMillis() + propertiesReader.getMsgGiaInProcessamentoAttesaAttiva();
                                isErroreMsgGiaRicevuto = true;
                                msgAttesaFineProcessamento = false;
                                millisecondiTrascorsi = 0;
                                while (DateManager.getTimeMillis() < scadenzaWhile) {
                                    proprietarioMessaggio = this.msgRequest.getProprietario(this.msgContext.getIdModulo());
                                    if (Inoltro.SENZA_DUPLICATI.equals((Object)this.bustaRichiesta.getInoltro()) || this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento()) {
                                        if ("ConsegnaContenutiApplicativi".equals(proprietarioMessaggio) || "GestoreMessaggi".equals(proprietarioMessaggio) || !this.msgRequest.existsMessage_noCache()) {
                                            this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.RICHIESTA_DUPLICATA, "true");
                                            if (this.msgContext.isGestioneRisposta()) {
                                                this.msgContext.setMessageResponse(this.ricezioneBusteGeneratoreBustaErrore.generaRispostaMsgGiaRicevuto(this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento() == false, this.bustaRichiesta, this.infoIntegrazione, this.msgDiag, this.openspcoopstate, this.logCore, propertiesReader, this.versioneProtocollo, this.ruoloBustaRicevuta, this.implementazionePdDMittente, this.protocolFactory, this.identitaPdD, this.idTransazione, loader, this.oneWayVersione11, this.implementazionePdDMittente, this.tracciamento, this.correlazioneApplicativa, this.pddContext, IntegrationFunctionError.CONFLICT));
                                            }
                                            this.openspcoopstate.releaseResource();
                                            return;
                                        }
                                        if (!msgAttesaFineProcessamento) {
                                            this.msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamentoAttesaAttiva() / 1000L);
                                            this.msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato");
                                            msgAttesaFineProcessamento = true;
                                        }
                                    } else {
                                        if (!msgAttesaFineProcessamento) {
                                            this.msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamentoAttesaAttiva() / 1000L);
                                            this.msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato");
                                            msgAttesaFineProcessamento = true;
                                        }
                                        if (!(existsMessage = this.msgRequest.existsMessage_noCache())) {
                                            this.msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata");
                                            isErroreMsgGiaRicevuto = false;
                                            break;
                                        }
                                        if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                            this.msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione");
                                            msg = this.msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione");
                                            if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                                this.msgRequest._deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamentoAttesaAttiva() - (long)millisecondiTrascorsi, propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                            } else {
                                                this.msgRequest.deleteMessageByNow();
                                            }
                                            isErroreMsgGiaRicevuto = false;
                                            break;
                                        }
                                    }
                                    Utilities.sleep((long)propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                    millisecondiTrascorsi += propertiesReader.getMsgGiaInProcessamentoCheckInterval();
                                }
                                if (isErroreMsgGiaRicevuto) {
                                    this.msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.timeoutScaduto");
                                    this.pddContext.addObject(org.openspcoop2.core.constants.Costanti.RICHIESTA_DUPLICATA, "true");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(this.idMessageRequest));
                                        this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.CONFLICT_IN_QUEUE);
                                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, null);
                                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore, false);
                                    }
                                    this.openspcoopstate.releaseResource();
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                        RicezioneBuste.logError(this.logCore, "Controllo/gestione presenza messaggio gia in gestione non riuscito", e);
                        if (this.msgContext.isGestioneRisposta()) {
                            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        }
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                }
                this.msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                try {
                    this.msgRequest.registraMessaggio(this.requestMessage, dataIngressoRichiesta, this.oneWayStateless != false || this.sincronoStateless != false || this.asincronoStateless != false || this.routingStateless != false, this.correlazioneApplicativa);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "msgRequest.registraMessaggio");
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_508_SAVE_REQUEST_MSG));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.msgRequest.deleteMessageFromFileSystem();
                    this.openspcoopstate.releaseResource();
                    return;
                }
                this.msgDiag.mediumDebug("Registrazione busta di richiesta nel RepositoryBuste...");
                try {
                    if (!(this.oneWayStateless || this.sincronoStateless || this.asincronoStateless || this.routingStateless)) {
                        if (this.repositoryBuste.isRegistrata(this.bustaRichiesta.getID(), tipoMsg)) {
                            try {
                                this.repositoryBuste.aggiornaBusta(this.bustaRichiesta, tipoMsg, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), this.erroriValidazione);
                                this.repositoryBuste.impostaUtilizzoPdD(this.bustaRichiesta.getID(), tipoMsg);
                            }
                            catch (Exception e) {
                                if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                    causa = "Aggiornamento dati busta con id [" + this.bustaRichiesta.getID() + "] tipo[" + tipoMsg + "] non riuscito: " + e.getMessage();
                                    try {
                                        GestoreMessaggi.acquireLock(this.msgRequest, TimerLock.newInstance(TipoLock._getLockGestioneRepositoryMessaggi()), this.msgDiag, causa, propertiesReader.getMsgGiaInProcessamentoAttesaAttiva(), propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                        if (this.repositoryBuste.isRegistrata(this.bustaRichiesta.getID(), tipoMsg)) {
                                            this.repositoryBuste.aggiornaBusta(this.bustaRichiesta, tipoMsg, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), this.erroriValidazione);
                                            this.repositoryBuste.impostaUtilizzoPdD(this.bustaRichiesta.getID(), tipoMsg);
                                        }
                                        this.repositoryBuste.registraBusta(this.bustaRichiesta, tipoMsg, this.erroriValidazione, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                                    }
                                    finally {
                                        try {
                                            GestoreMessaggi.releaseLock(this.msgRequest, TimerLock.newInstance(TipoLock._getLockGestioneRepositoryMessaggi()), this.msgDiag, causa);
                                        }
                                        catch (Exception scadenzaWhile) {}
                                    }
                                }
                                throw e;
                            }
                        } else {
                            this.repositoryBuste.registraBusta(this.bustaRichiesta, tipoMsg, this.erroriValidazione, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                        }
                        this.repositoryBuste.aggiornaInfoIntegrazione(this.bustaRichiesta.getID(), tipoMsg, this.infoIntegrazione);
                        break block243;
                    }
                    ((StatelessMessage)this.openspcoopstate.getStatoRichiesta()).setBusta(this.bustaRichiesta);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "repositoryBuste.registraBusta");
                    if (this.msgContext.isGestioneRisposta()) {
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    }
                    this.msgRequest.deleteMessageFromFileSystem();
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
            try {
                if (this.functionAsRouter) {
                    this.msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBuste (router)...");
                    if (this.msgRequest != null) {
                        this.msgRequest.aggiornaProprietarioMessaggio("InoltroBuste");
                    }
                    this.msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                    inoltroMSG.setBusta(this.bustaRichiesta);
                    rd = new RichiestaDelegata(this.soggettoFruitore);
                    rd.setDominio(this.identitaPdD);
                    rd.setIdModuloInAttesa(this.msgContext.getIdModulo());
                    rd.setIdServizio(this.idServizio);
                    rd.setIdCorrelazioneApplicativa(this.correlazioneApplicativa);
                    rd.setServizioApplicativo(servizioApplicativoFruitore);
                    rd.setIntegrazione(this.msgContext.getIntegrazione());
                    rd.setProtocol(this.msgContext.getProtocol());
                    inoltroMSG.setRichiestaDelegata(rd);
                    inoltroMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDMittente);
                    inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                    inoltroMSG.setPddContext(this.inRequestContext.getPddContext());
                    if (this.routingStateless) break block244;
                    classTypeNodeSender = null;
                    nodeSender = null;
                    try {
                        classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                        nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                        AbstractCore.init(nodeSender, this.pddContext, this.protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante il caricamento della classe (INodeSender) [" + classTypeNodeSender + "] per la spedizione nell'infrastruttura: " + e.getMessage());
                    }
                    nodeSender.send(inoltroMSG, "InoltroBuste", this.msgDiag, this.identitaPdD, this.msgContext.getIdModulo(), this.idMessageRequest, this.msgRequest);
                    break block244;
                }
                this.msgDiag.mediumDebug("Invio messaggio al modulo di Sbustamento...");
                this.msgRequest.aggiornaProprietarioMessaggio("Sbustamento");
                if (proprietaPorta != null && !proprietaPorta.isEmpty() && (filtroDuplicatiTestEnabled = CostantiProprieta.isFiltroDuplicatiTestEnabled(proprietaPorta, false))) {
                    this.pddContext.addObject(CostantiPdD.FILTRO_DUPLICATI_TEST, filtroDuplicatiTestEnabled);
                }
                this.msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                richiestaApplicativa.setIdCorrelazioneApplicativa(this.correlazioneApplicativa);
                richiestaApplicativa.setIdentitaServizioApplicativoFruitore(servizioApplicativoFruitore);
                this.sbustamentoMSG.setRichiestaApplicativa(richiestaApplicativa);
                this.sbustamentoMSG.setBusta(this.bustaRichiesta);
                this.sbustamentoMSG.setErrors(this.erroriValidazione, integrationFunctionErrorValidazione);
                this.sbustamentoMSG.setMessaggioErroreProtocollo(this.isMessaggioErroreProtocollo);
                this.sbustamentoMSG.setIsBustaDiServizio(this.bustaDiServizio);
                this.sbustamentoMSG.setServizioCorrelato(validatore.getServizioCorrelato());
                this.sbustamentoMSG.setTipoServizioCorrelato(validatore.getTipoServizioCorrelato());
                this.sbustamentoMSG.setVersioneServizioCorrelato(validatore.getVersioneServizioCorrelato());
                this.sbustamentoMSG.setRuoloBustaRicevuta(this.ruoloBustaRicevuta);
                this.sbustamentoMSG.setOneWayVersione11(this.oneWayVersione11);
                this.sbustamentoMSG.setStateless(this.oneWayStateless != false || this.sincronoStateless != false || this.asincronoStateless != false);
                this.sbustamentoMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDMittente);
                this.sbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                this.sbustamentoMSG.setPddContext(this.inRequestContext.getPddContext());
                this.sbustamentoMSG.setDettaglioEccezione(dettaglioEccezione);
                if (validatore.getInfoServizio() != null) {
                    this.sbustamentoMSG.setFiltroDuplicatiRichiestoAccordo(Inoltro.SENZA_DUPLICATI.equals((Object)validatore.getInfoServizio().getInoltro()));
                    if (StatoFunzionalitaProtocollo.REGISTRO.equals((Object)this.moduleManager.getConsegnaAffidabile(this.bustaRichiesta))) {
                        this.sbustamentoMSG.setConfermaRicezioneRichiestoAccordo(validatore.getInfoServizio().getConfermaRicezione());
                    }
                    if (StatoFunzionalitaProtocollo.REGISTRO.equals((Object)this.moduleManager.getConsegnaInOrdine(this.bustaRichiesta))) {
                        this.sbustamentoMSG.setConsegnaOrdineRichiestoAccordo(validatore.getInfoServizio().getOrdineConsegna());
                    }
                }
                if (this.portaStateless) break block244;
                RicezioneBuste.logDebug(this.logCore, "RicezioneBuste :eseguo send a sbustamento");
                classTypeNodeSender = null;
                nodeSender = null;
                try {
                    classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                    nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                    AbstractCore.init(nodeSender, this.pddContext, this.protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new CoreException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
                }
                nodeSender.send(this.sbustamentoMSG, "Sbustamento", this.msgDiag, this.identitaPdD, this.msgContext.getIdModulo(), this.idMessageRequest, this.msgRequest);
                RicezioneBuste.logDebug(this.logCore, "RicezioneBuste :send a sbustamento eseguita");
            }
            catch (Exception e) {
                if (this.functionAsRouter) {
                    RicezioneBuste.logError(this.logCore, "Spedizione->InoltroBuste(router) non riuscita", e);
                    this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                } else {
                    RicezioneBuste.logError(this.logCore, "Spedizione->Sbustamento non riuscita", e);
                    this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(Sbustamento)");
                }
                if (this.msgContext.isGestioneRisposta()) {
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND));
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                }
                this.msgRequest.deleteMessageFromFileSystem();
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            this.openspcoopstate.commit();
            RicezioneBuste.logDebug(this.logCore, "RicezioneBuste :RicezioneBuste commit eseguito");
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit()");
            if (this.msgContext.isGestioneRisposta()) {
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_506_COMMIT_JDBC));
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            }
            this.msgRequest.deleteMessageFromFileSystem();
            this.openspcoopstate.releaseResource();
            return;
        }
        if (validatore != null) {
            if (validatore.getValidatoreSintattico() != null) {
                validatore.getValidatoreSintattico().setHeaderSOAP(null);
            }
            validatore.setValidatoreSintattico(null);
        }
        validatore = null;
        if (!this.portaStateless && !this.routingStateless) {
            if (this.msgRequest != null) {
                this.msgRequest.addMessaggiIntoCache_readFromTable("RicezioneBuste", "richiesta");
            }
            if (this.msgRequest != null) {
                this.msgRequest.addProprietariIntoCache_readFromTable("RicezioneBuste", "richiesta", null, this.functionAsRouter);
            }
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            this.openspcoopstate.releaseResource();
        }
        this.bustaRichiesta = this.bustaRichiesta.newInstance();
        if (this.routingStateless) {
            this.openspcoopstate.setMessageLib(inoltroMSG);
            this.openspcoopstate.setIDMessaggioSessione(this.idMessageRequest);
            this.openspcoopstate.setUseConnection(false);
            lib = null;
            try {
                lib = new InoltroBuste(this.logCore);
                esito = lib.onMessage(this.openspcoopstate);
                if (esito.getStatoInvocazione() == 1 || esito.getStatoInvocazione() == 2) {
                    this.msgDiag.mediumDebug("Invocazione libreria InoltroBuste riuscito con esito: " + esito.getStatoInvocazione());
                } else if (esito.getStatoInvocazione() == 3) {
                    throw new CoreException("Errore non gestito dalla libreria");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestioneRoutingStateless");
                RicezioneBuste.logError(this.logCore, "Errore Generale durante la gestione del routing stateless: " + e.getMessage(), e);
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.openspcoopstate.setUseConnection(true);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                this.openspcoopstate.releaseResource();
                return;
            }
            this.openspcoopstate.setUseConnection(true);
        }
        if (this.portaStateless && !(resultRequest = this.comportamentoStatelessRichiesta())) {
            this.openspcoopstate.releaseResource();
            return;
        }
        if (this.asyncResponseCallback == null || this.terminataGestioneStatelessErrorBeforeAsyncrConnettore) {
            this._statelessComplete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _statelessComplete(boolean invokedFromAsyncConnector) {
        try {
            if (this.portaStateless && !this.terminataGestioneStateless) {
                boolean resultResponse = this.comportamentoStatelessRisposta(invokedFromAsyncConnector);
                if (!resultResponse) {
                    this.openspcoopstate.releaseResource();
                    return;
                }
                this.openspcoopstate.setUseConnection(true);
            }
            OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
            this.registroServiziReader = this.registroServiziReader.refreshState(this.openspcoopstate.getStatoRichiesta(), this.openspcoopstate.getStatoRisposta());
            this.configurazionePdDReader = this.configurazionePdDReader.refreshState(this.registroServiziReader);
            this.tracciamento.updateState(this.configurazionePdDReader);
            this.msgDiag.updateState(this.configurazionePdDReader);
            this.msgDiag.mediumDebug("Gestione risposta...");
            if (!this.msgContext.isGestioneRisposta()) {
                if (this.portaStateless) {
                    this.openspcoopstate.releaseResource();
                }
                return;
            }
            boolean richiestaRispostaProtocollo = true;
            if (this.functionAsRouter) {
                if (!ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) && this.newConnectionForResponse) {
                    this.msgContext.setMessageResponse(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)this.requestMessage.getFactory(), (MessageType)this.requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE));
                    return;
                }
                richiestaRispostaProtocollo = false;
            } else {
                if (this.utilizzoIndirizzoTelematico && this.bustaRichiesta.getIndirizzoMittente() != null && this.moduleManager.isUtilizzoIndirizzoSoggettoPresenteBusta() && !this.oneWayStateless && !this.sincronoStateless && !this.asincronoStateless || !ProfiloDiCollaborazione.SINCRONO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) && this.newConnectionForResponse && !this.oneWayStateless && !this.sincronoStateless && !this.asincronoStateless) {
                    this.msgContext.setMessageResponse(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)this.requestMessage.getFactory(), (MessageType)this.requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE));
                    if (this.portaStateless) {
                        this.openspcoopstate.releaseResource();
                    }
                    return;
                }
                if (this.isMessaggioErroreProtocollo || this.bustaDiServizio || StatoFunzionalitaProtocollo.DISABILITATA.equals((Object)this.moduleManager.getConsegnaAffidabile(this.bustaRichiesta)) || !propertiesReader.isGestioneRiscontri(this.implementazionePdDMittente) || ProfiloDiCollaborazione.ONEWAY.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) && !this.bustaRichiesta.isConfermaRicezione() || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione())) {
                    richiestaRispostaProtocollo = false;
                }
            }
            RicezioneBusteGestioneRisposta parametriGestioneRisposta = new RicezioneBusteGestioneRisposta();
            parametriGestioneRisposta.setPropertiesReader(propertiesReader);
            parametriGestioneRisposta.setRichiestaRispostaProtocollo(richiestaRispostaProtocollo);
            parametriGestioneRisposta.setPddContext(this.inRequestContext.getPddContext());
            try {
                this.gestioneRisposta(parametriGestioneRisposta);
            }
            catch (Exception e) {
                block52: {
                    RicezioneBuste.logError(this.logCore, "ErroreGenerale", e);
                    this.msgDiag.logErroreGenerico(e, "Generale");
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                    OpenSPCoop2Message errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    this.openspcoopstate.releaseResource();
                    try {
                        if (this.openspcoopstate != null) {
                            this.openspcoopstate.forceFinallyReleaseResource();
                        }
                    }
                    catch (Throwable e2) {
                        if (this.msgDiag != null) {
                            try {
                                this.msgDiag.logErroreGenerico(e2, "Rilascio risorsa");
                            }
                            catch (Throwable eLog) {
                                RicezioneBuste.logError(this.logCore, "Diagnostico errore per Rilascio risorsa: " + eLog.getMessage(), eLog);
                            }
                            break block52;
                        }
                        RicezioneBuste.logError(this.logCore, "Rilascio risorsa: " + e2.getMessage(), e2);
                    }
                }
                this._processComplete(invokedFromAsyncConnector);
                return;
            }
        }
        finally {
            try {
                if (this.openspcoopstate != null) {
                    this.openspcoopstate.forceFinallyReleaseResource();
                }
            }
            catch (Throwable e) {
                if (this.msgDiag != null) {
                    try {
                        this.msgDiag.logErroreGenerico(e, "Rilascio risorsa");
                    }
                    catch (Throwable eLog) {
                        RicezioneBuste.logError(this.logCore, "Diagnostico errore per Rilascio risorsa: " + eLog.getMessage(), eLog);
                    }
                }
                RicezioneBuste.logError(this.logCore, "Rilascio risorsa: " + e.getMessage(), e);
            }
            this._processComplete(invokedFromAsyncConnector);
        }
    }

    private boolean comportamentoStatelessRichiesta() {
        return this._comportamentoStateless(true, false);
    }

    private boolean comportamentoStatelessRisposta(boolean invokedFromAsyncConnector) {
        return this._comportamentoStateless(false, invokedFromAsyncConnector);
    }

    private boolean _comportamentoStateless(boolean gestioneRichiesta, boolean invokedFromAsyncConnector) {
        boolean esitoReturn = true;
        OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
        if (gestioneRichiesta) {
            this.openspcoopstate.setMessageLib(this.sbustamentoMSG);
        }
        this.openspcoopstate.setIDMessaggioSessione(this.idMessageRequest);
        this.openspcoopstate.setUseConnection(false);
        EsitoLib esito = new EsitoLib();
        try {
            boolean jumpTocheckEsitoConsegna = false;
            if (gestioneRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioResponseMsgLib("");
            } else {
                esito = this.esitoStatelessAfterSendRequest;
                jumpTocheckEsitoConsegna = true;
            }
            while (!((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                boolean libreriaSbustamento = false;
                if (((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
                    libreriaSbustamento = true;
                }
                boolean libreriaConsegnaContenutiRichiesta = false;
                if (((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
                    libreriaConsegnaContenutiRichiesta = true;
                }
                boolean libreriaImbustamentoRisposte = false;
                if (!gestioneRichiesta && ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
                    libreriaImbustamentoRisposte = true;
                }
                if (!jumpTocheckEsitoConsegna) {
                    if (((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte") && propertiesReader.isRinegoziamentoConnessione(this.bustaRichiesta.getProfiloDiCollaborazione()) && (this.oneWayStateless || this.sincronoStateless || this.asincronoStateless) && this.openspcoopstate.resourceReleased()) {
                        this.registroServiziReader = this.registroServiziReader.refreshState(this.openspcoopstate.getStatoRichiesta(), this.openspcoopstate.getStatoRisposta());
                        this.configurazionePdDReader = this.configurazionePdDReader.refreshState(this.registroServiziReader);
                        this.tracciamento.updateState(this.configurazionePdDReader);
                        this.msgDiag.updateState(this.configurazionePdDReader);
                    }
                    esito = this.chiamaLibreria((OpenSPCoopStateless)this.openspcoopstate, this.logCore, this.registroServiziReader, this.configurazionePdDReader);
                    if (gestioneRichiesta && libreriaConsegnaContenutiRichiesta) {
                        return true;
                    }
                }
                if (this.oneWayVersione11 && this.newConnectionForResponse && esito.getStatoInvocazione() == 1 && libreriaSbustamento) {
                    ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioResponseMsgLib(ID_MODULO);
                    this.openspcoopstate.setUseConnection(true);
                    this.openspcoopstate.commit();
                    this.openspcoopstate.setUseConnection(false);
                }
                if (esito.getStatoInvocazione() == 2) {
                    if (this.oneWayVersione11 && this.newConnectionForResponse && libreriaSbustamento) {
                        this.openspcoopstate.setUseConnection(true);
                        this.openspcoopstate.commit();
                        this.openspcoopstate.setUseConnection(false);
                    }
                    if (libreriaSbustamento) {
                        this.terminataGestioneStatelessErrorBeforeAsyncrConnettore = true;
                    }
                    this.terminataGestioneStateless = true;
                    break;
                }
                if (esito.getStatoInvocazione() == 3) {
                    throw new CoreException("Errore non gestito dalla libreria");
                }
                if (libreriaSbustamento && propertiesReader.isRinegoziamentoConnessione(this.bustaRichiesta.getProfiloDiCollaborazione()) && (this.oneWayStateless || this.sincronoStateless || this.asincronoStateless)) {
                    this.openspcoopstate.setUseConnection(true);
                    this.openspcoopstate.commit();
                    this.openspcoopstate.releaseResource();
                    this.openspcoopstate.setUseConnection(false);
                }
                if (!jumpTocheckEsitoConsegna) continue;
                jumpTocheckEsitoConsegna = false;
                if (!libreriaImbustamentoRisposte || !invokedFromAsyncConnector) continue;
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioRequestMsgLib("");
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneStateless");
            this.logCore.error("Errore Generale durante la gestione stateless: " + e.getMessage(), (Throwable)e);
            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
            OpenSPCoop2Message errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
            this.openspcoopstate.setUseConnection(true);
            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            this.openspcoopstate.releaseResource();
            return false;
        }
        if (!gestioneRichiesta) {
            this.terminataGestioneStateless = true;
        }
        if (!gestioneRichiesta || this.terminataGestioneStateless) {
            this.openspcoopstate.setUseConnection(true);
        }
        return esitoReturn;
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI@", credenzialiFornite);
    }

    /*
     * Unable to fully structure code
     */
    private void gestioneRisposta(RicezioneBusteGestioneRisposta parametriGestioneRisposta) throws Exception {
        propertiesReader = parametriGestioneRisposta.getPropertiesReader();
        if (this.headerIntegrazioneRichiesta != null) {
            // empty if block
        }
        richiestaRispostaProtocollo = parametriGestioneRisposta.isRichiestaRispostaProtocollo();
        pddContextGestioneRisposta = parametriGestioneRisposta.getPddContext();
        if (pddContextGestioneRisposta == null) {
            pddContextGestioneRisposta = this.pddContext;
        }
        if (this.idTransazione == null) {
            this.idTransazione = PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContextGestioneRisposta);
        }
        requestInfo = (RequestInfo)pddContextGestioneRisposta.getObject(org.openspcoop2.core.constants.Costanti.REQUEST_INFO);
        loader = Loader.getInstance();
        pluginLoader = PddPluginLoader.getInstance();
        msgResponse = null;
        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)this.requestMessage.getFactory(), (MessageType)this.requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
        bustaRisposta = null;
        idMessaggioSblocco = null;
        contenutoRispostaPresente = false;
        ricezioneBusteMSG = null;
        idCorrelazioneApplicativaRisposta = null;
        try {
            this.msgDiag.mediumDebug("Attesa/lettura risposta...");
            if (!this.portaStateless && !this.routingStateless) {
                classType = null;
                nodeReceiver = null;
                try {
                    classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                    nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                    AbstractCore.init(nodeReceiver, pddContextGestioneRisposta, this.protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new CoreException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                }
                ricezioneBusteMSG = (RicezioneBusteMessage)nodeReceiver.receive(this.msgDiag, this.identitaPdD, this.msgContext.getIdModulo(), this.idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneBuste(), propertiesReader.getNodeReceiverCheckInterval());
                pddContextGestioneRisposta = ricezioneBusteMSG.getPddContext();
                if (pddContextGestioneRisposta != null && (enumPddContext = pddContextGestioneRisposta.keys()) != null && !enumPddContext.isEmpty()) {
                    for (MapKey key : enumPddContext) {
                        this.msgContext.getPddContext().addObject(key, pddContextGestioneRisposta.getObject(key));
                    }
                }
            } else {
                ricezioneBusteMSG = (RicezioneBusteMessage)this.openspcoopstate.getMessageLib();
            }
            v0 = contenutoRispostaPresente = ricezioneBusteMSG.getBustaRisposta() != null;
            if (richiestaRispostaProtocollo && !contenutoRispostaPresente) {
                throw new CoreException("Risposta attesa e non ritornata: ErroreInterno");
            }
            if (contenutoRispostaPresente) {
                bustaRisposta = ricezioneBusteMSG.getBustaRisposta();
                this.msgContext.getProtocol().setIdRisposta(bustaRisposta.getID());
                this.msgContext.getProtocol().setCollaborazione(bustaRisposta.getCollaborazione());
            } else {
                idMessaggioSblocco = ricezioneBusteMSG.getIdMessaggioSblocco();
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneRisposta(" + this.msgContext.getIdModulo() + ")");
            RicezioneBuste.logError(this.logCore, "Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore", e);
            if (!this.portaStateless && !this.routingStateless) {
                try {
                    this.msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    this.openspcoopstate.updateResource(this.idTransazione);
                }
                catch (Exception eDB) {
                    this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, this.logCore, this.msgDiag, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB, "openspcoopstate.updateDatabaseResource");
                    return;
                }
            }
            if (e instanceof NodeTimeoutException) {
                try {
                    this.msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                    this.msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    this.openspcoopstate.commit();
                }
                catch (Exception eDel) {
                    this.msgDiag.logErroreGenerico(eDel.getMessage(), "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                }
            }
            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
            this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE));
            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
            this.openspcoopstate.releaseResource();
            return;
        }
        if (contenutoRispostaPresente) {
            this.msgDiag.setIdMessaggioRisposta(bustaRisposta.getID());
            this.msgDiag.addKeywords(bustaRisposta, false);
        } else {
            this.msgDiag.setIdMessaggioRisposta(idMessaggioSblocco);
        }
        this.parametriGenerazioneBustaErrore.setMsgDiag(this.msgDiag);
        this.parametriInvioBustaErrore.setMsgDiag(this.msgDiag);
        if (!this.portaStateless && !this.routingStateless) {
            try {
                this.msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                this.openspcoopstate.updateResource(this.idTransazione);
            }
            catch (Exception e) {
                this.setSOAPFaultProcessamento(IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, this.logCore, this.msgDiag, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e, "openspcoopstate.updateDatabaseResource");
                return;
            }
            msgResponse = contenutoRispostaPresente != false ? new GestoreMessaggi(this.openspcoopstate, false, bustaRisposta.getID(), "OUTBOX", this.msgDiag, pddContextGestioneRisposta) : new GestoreMessaggi(this.openspcoopstate, false, idMessaggioSblocco, "OUTBOX", this.msgDiag, pddContextGestioneRisposta);
            if (contenutoRispostaPresente || this.functionAsRouter) {
                this.msgDiag.mediumDebug("Lettura messaggio di risposta...");
                try {
                    responseMessage = msgResponse.getMessage();
                    if (responseMessage != null && this.msgContext.getPddContext() != null) {
                        o = responseMessage.getContextProperty(org.openspcoop2.core.constants.Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO);
                        if (o instanceof Boolean) {
                            this.msgContext.getPddContext().addObject(org.openspcoop2.core.constants.Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                        }
                        if ((o = responseMessage.getContextProperty(org.openspcoop2.core.constants.Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) instanceof ParseException) {
                            this.msgContext.getPddContext().addObject(org.openspcoop2.core.constants.Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                        }
                        if ((o = responseMessage.getContextProperty(org.openspcoop2.core.constants.Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO)) instanceof Boolean) {
                            this.msgContext.getPddContext().addObject(org.openspcoop2.core.constants.Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                        }
                        if ((o = responseMessage.getContextProperty(org.openspcoop2.core.constants.Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) instanceof ParseException) {
                            this.msgContext.getPddContext().addObject(org.openspcoop2.core.constants.Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                        }
                    }
                    idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                }
                catch (Exception e) {
                    if (this.functionAsRouter && !contenutoRispostaPresente) ** GOTO lbl130
                    this.msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG));
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
        } else {
            responseMessage = ((OpenSPCoopStateless)this.openspcoopstate).getRispostaMsg();
            idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativaRisposta();
            if (responseMessage != null) {
                this.parametriGenerazioneBustaErrore.setParseException(responseMessage.getParseException());
            }
        }
lbl130:
        // 6 sources

        this.parametriGenerazioneBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        this.parametriInvioBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        this.msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        }
        if (contenutoRispostaPresente) {
            tras = null;
            if (propertiesReader.isGenerazioneListaTrasmissioni(this.implementazionePdDMittente)) {
                this.msgDiag.mediumDebug("Impostazione trasmissione nella busta di risposta...");
                tras = new Trasmissione();
                tras.setOrigine(this.identitaPdD.getNome());
                tras.setTipoOrigine(this.identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(this.identitaPdD.getCodicePorta());
                for (i = 0; i < this.bustaRichiesta.sizeListaTrasmissioni(); ++i) {
                    if (!this.identitaPdD.getTipo().equals(this.bustaRichiesta.getTrasmissione(i).getTipoDestinazione()) || !this.identitaPdD.getNome().equals(this.bustaRichiesta.getTrasmissione(i).getDestinazione())) continue;
                    tipoOrigineValido = true;
                    try {
                        this.traduttore.toProtocolOrganizationType(this.bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                    }
                    catch (Exception e) {
                        tipoOrigineValido = false;
                    }
                    if (!tipoOrigineValido) continue;
                    tras.setDestinazione(this.bustaRichiesta.getTrasmissione(i).getOrigine());
                    tras.setTipoDestinazione(this.bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                }
                if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                    tras.setDestinazione(bustaRisposta.getDestinatario());
                    tras.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                }
                try {
                    dominio = this.registroServiziReader.getDominio(new IDSoggetto(tras.getTipoDestinazione(), tras.getDestinazione()), null, this.protocolFactory, requestInfo);
                    tras.setIdentificativoPortaDestinazione(dominio);
                }
                catch (Exception dominio) {
                    // empty catch block
                }
                tras.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                tras.setTempo(propertiesReader.getTipoTempoBusta(this.implementazionePdDMittente));
                bustaRisposta.addTrasmissione(tras);
            }
            scartaBody = false;
            if (!this.functionAsRouter) {
                allegaBody = this.configurazionePdDReader.isAllegaBody(this.pa);
                scartaBody = allegaBody != false ? true : this.configurazionePdDReader.isScartaBody(this.pa);
            }
            if (!this.functionAsRouter && bustaRisposta.sizeListaEccezioni() == 0 && this.moduleManager.isIgnoraEccezioniLivelloNonGrave()) {
                for (i = 0; i < this.erroriValidazione.size(); ++i) {
                    ec = this.erroriValidazione.get(i);
                    if (!LivelloRilevanza.INFO.equals((Object)ec.getRilevanza())) continue;
                    bustaRisposta.addEccezione(ec);
                }
                if (this.erroriProcessamento != null) {
                    // empty if block
                }
            }
            this.msgDiag.mediumDebug("Imbustamento della risposta...");
            headerBustaRisposta = null;
            gestioneManifestRisposta = false;
            imbustatore = null;
            try {
                gestioneManifestRisposta = this.functionAsRouter != false ? this.configurazionePdDReader.isGestioneManifestAttachments() : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.bustaRichiesta.getProfiloDiCollaborazione()) != false && RuoloBusta.RISPOSTA.equals(this.ruoloBustaRicevuta.toString()) != false && this.pd != null ? this.configurazionePdDReader.isGestioneManifestAttachments(this.pd, this.protocolFactory) : this.configurazionePdDReader.isGestioneManifestAttachments(this.pa, this.protocolFactory));
                imbustatore = new Imbustamento(this.logCore, this.protocolFactory, this.openspcoopstate.getStatoRichiesta());
                if (!(!this.functionAsRouter || this.identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && this.identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    if (propertiesReader.isGenerazioneListaTrasmissioni(this.implementazionePdDMittente)) {
                        this.msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                        protocolMessage = imbustatore.addTrasmissione(responseMessage, tras, this.readQualifiedAttribute, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBustaRisposta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        this.msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                    } else {
                        v = new Validatore(responseMessage, (Context)pddContextGestioneRisposta, this.openspcoopstate.getStatoRichiesta(), this.logCore, this.protocolFactory);
                        headerBustaRisposta = v.getHeaderProtocollo_senzaControlli();
                    }
                } else {
                    this.msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                    protocolMessage = imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContextGestioneRisposta, bustaRisposta, this.bustaRichiesta, this.infoIntegrazione, gestioneManifestRisposta, scartaBody, this.proprietaManifestAttachments, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                    if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                        headerBustaRisposta = protocolMessage.getBustaRawContent();
                        responseMessage = protocolMessage.getMessage();
                    }
                    this.msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                if (msgResponse != null && !this.portaStateless && !this.routingStateless) {
                    try {
                        this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta (statefull) ...");
                        msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    }
                    catch (Throwable var21_42) {
                        // empty catch block
                    }
                }
                if (!(!this.functionAsRouter || this.identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && this.identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    this.msgDiag.logErroreGenerico(e, "imbustatore.pre-security.addTrasmissione(risposta)");
                } else {
                    this.msgDiag.logErroreGenerico(e, "imbustatore.pre-security-imbustamento(risposta)");
                }
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_526_GESTIONE_IMBUSTAMENTO));
                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.INTEROPERABILITY_PROFILE_ENVELOPING_RESPONSE_FAILED);
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                if (responseMessage != null && responseMessage.getParseException() != null) {
                    errorOpenSPCoopMsg.setParseException(responseMessage.getParseException());
                }
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                this.openspcoopstate.releaseResource();
                return;
            }
            mtomProcessor = null;
            if (!this.functionAsRouter && this.flowPropertiesResponse != null) {
                this.msgDiag.mediumDebug("init MTOM Processor ...");
                mtomProcessor = new MTOMProcessor(this.flowPropertiesResponse.mtom, this.flowPropertiesResponse.messageSecurity, this.tipoPorta, this.msgDiag, this.logCore, pddContextGestioneRisposta);
            }
            if (mtomProcessor != null) {
                try {
                    mtomProcessor.mtomBeforeSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                }
                catch (Exception e) {
                    if (msgResponse != null && !this.portaStateless && !this.routingStateless) {
                        try {
                            this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta (before security) ...");
                            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        }
                        catch (Throwable var22_49) {
                            // empty catch block
                        }
                    }
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
            if (!this.functionAsRouter) {
                if (this.flowPropertiesResponse != null && this.flowPropertiesResponse.messageSecurity != null && this.flowPropertiesResponse.messageSecurity.getFlowParameters() != null && this.flowPropertiesResponse.messageSecurity.getFlowParameters().size() > 0) {
                    try {
                        this.configurazionePdDReader.updateMessageSecurityForSender(this.flowPropertiesResponse.messageSecurity, this.logCore, responseMessage, this.bustaRichiesta, requestInfo, pddContextGestioneRisposta, this.flowPropertiesResponse.messageSecurityRequest);
                        this.messageSecurityContext.setFunctionAsClient(true);
                        this.messageSecurityContext.setOutgoingProperties(this.flowPropertiesResponse.messageSecurity.getFlowParameters());
                        tipoSicurezza = SecurityConstants.convertActionToString((Map)this.messageSecurityContext.getOutgoingProperties());
                        this.msgDiag.addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@", tipoSicurezza);
                        pddContextGestioneRisposta.addObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA, tipoSicurezza);
                        this.msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInCorso");
                        if (WSSUtilities.isNormalizeToSaajImpl((MessageSecurityContext)this.messageSecurityContext)) {
                            this.msgDiag.mediumDebug("Normalize to saajImpl");
                            responseMessage = responseMessage.normalizeToSaajImpl();
                        }
                        DynamicMapBuilderUtils.injectDynamicMap(this.bustaRichiesta, requestInfo, (org.openspcoop2.utils.Map<Object>)pddContextGestioneRisposta, this.logCore);
                        if (!this.messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)pddContextGestioneRisposta, this.transaction != null ? this.transaction.getTempiElaborazione() : null)) {
                            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", this.messageSecurityContext.getMsgErrore());
                            this.msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInErrore");
                            this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                            this.parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(this.messageSecurityContext.getMsgErrore(), this.messageSecurityContext.getCodiceErrore()));
                            this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED);
                            errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                            this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                            this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                            this.openspcoopstate.releaseResource();
                            return;
                        }
                        this.msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaEffettuato");
                    }
                    catch (Exception e) {
                        if (msgResponse != null && !this.portaStateless && !this.routingStateless) {
                            try {
                                this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta (security) ...");
                                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            }
                            catch (Throwable errorOpenSPCoopMsg) {
                                // empty catch block
                            }
                        }
                        this.msgDiag.addKeywordErroreProcessamento(e);
                        this.msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInErrore");
                        RicezioneBuste.logError(this.logCore, "[MessageSecurityResponse]" + e.getMessage(), e);
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                }
                this.msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaDisabilitato");
            }
            if (mtomProcessor != null) {
                try {
                    mtomProcessor.mtomAfterSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                }
                catch (Exception e) {
                    if (msgResponse != null && !this.portaStateless && !this.routingStateless) {
                        try {
                            this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta (after security) ...");
                            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        }
                        catch (Throwable errorOpenSPCoopMsg) {
                            // empty catch block
                        }
                    }
                    this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED);
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                    this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                    this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                    this.openspcoopstate.releaseResource();
                    return;
                }
            }
            this.msgDiag.mediumDebug("Imbustamento della risposta dopo la sicurezza...");
            try {
                if (!(!this.functionAsRouter || this.identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && this.identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    if (propertiesReader.isGenerazioneListaTrasmissioni(this.implementazionePdDMittente)) {
                        this.msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                        protocolMessage = imbustatore.addTrasmissione(responseMessage, tras, this.readQualifiedAttribute, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBustaRisposta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        this.msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    }
                } else {
                    this.msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    protocolMessage = imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContextGestioneRisposta, bustaRisposta, this.bustaRichiesta, this.infoIntegrazione, gestioneManifestRisposta, scartaBody, this.proprietaManifestAttachments, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                    if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                        headerBustaRisposta = protocolMessage.getBustaRawContent();
                        responseMessage = protocolMessage.getMessage();
                    }
                    this.msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                if (msgResponse != null && !this.portaStateless && !this.routingStateless) {
                    try {
                        this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                        msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    }
                    catch (Throwable errorOpenSPCoopMsg) {
                        // empty catch block
                    }
                }
                if (!(!this.functionAsRouter || this.identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && this.identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    this.msgDiag.logErroreGenerico(e, "imbustatore.after-security.addTrasmissione(risposta)");
                } else {
                    this.msgDiag.logErroreGenerico(e, "imbustatore.after-security-imbustamento(risposta)");
                }
                errorOpenSPCoopMsg = null;
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.INTEROPERABILITY_PROFILE_ENVELOPING_RESPONSE_FAILED);
                if (e instanceof ProtocolException && (pe = (ProtocolException)e).isInteroperabilityError()) {
                    this.parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(e.getMessage()));
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(this.parametriGenerazioneBustaErrore);
                } else {
                    this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_526_GESTIONE_IMBUSTAMENTO));
                    errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                }
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                this.openspcoopstate.releaseResource();
                return;
            }
            this.msgDiag.mediumDebug("Tracciamento busta di risposta...");
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                securityInfoResponse = null;
                if (!this.functionAsRouter && this.messageSecurityContext != null && this.messageSecurityContext.getDigestReader(responseMessage.getFactory()) != null) {
                    validazioneSemantica = this.protocolFactory.createValidazioneSemantica(this.openspcoopstate.getStatoRichiesta());
                    securityInfoResponse = validazioneSemantica.readSecurityInformation(this.messageSecurityContext.getDigestReader(responseMessage.getFactory()), responseMessage);
                }
                this.tracciamento.registraRisposta(responseMessage, securityInfoResponse, headerBustaRisposta, bustaRisposta, esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getSourceLocation()), this.correlazioneApplicativa, idCorrelazioneApplicativaRisposta);
            }
            validatoreErrori = this.protocolFactory.createValidatoreErrori(this.openspcoopstate.getStatoRichiesta());
            protocolManager = this.protocolFactory.createProtocolManager();
            pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
            pValidazioneErrori.setVersioneProtocollo(this.versioneProtocollo);
            if (validatoreErrori.isBustaErrore(bustaRisposta, responseMessage, pValidazioneErrori)) {
                if (this.mittenteAnonimo) {
                    this.msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.mittenteAnonimo");
                } else {
                    this.msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
                }
            } else if (this.mittenteAnonimo) {
                this.msgDiag.logPersonalizzato("generazioneMessaggioRisposta.mittenteAnonimo");
            } else {
                this.msgDiag.logPersonalizzato("generazioneMessaggioRisposta");
            }
            this.msgDiag.mediumDebug("Eliminazione accesso da PdD...");
            this.repositoryBuste.eliminaUtilizzoPdDFromOutBox(bustaRisposta.getID());
        }
        if (this.pa != null) {
            this.msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
            headerIntegrazioneRisposta = new HeaderIntegrazione(this.idTransazione);
            headerIntegrazioneRisposta.setBusta(new HeaderIntegrazioneBusta());
            headerIntegrazioneRisposta.getBusta().setTipoMittente(this.bustaRichiesta.getTipoMittente());
            headerIntegrazioneRisposta.getBusta().setMittente(this.bustaRichiesta.getMittente());
            headerIntegrazioneRisposta.getBusta().setTipoDestinatario(this.bustaRichiesta.getTipoDestinatario());
            headerIntegrazioneRisposta.getBusta().setDestinatario(this.bustaRichiesta.getDestinatario());
            headerIntegrazioneRisposta.getBusta().setTipoServizio(this.bustaRichiesta.getTipoServizio());
            headerIntegrazioneRisposta.getBusta().setServizio(this.bustaRichiesta.getServizio());
            headerIntegrazioneRisposta.getBusta().setVersioneServizio(this.bustaRichiesta.getVersioneServizio());
            headerIntegrazioneRisposta.getBusta().setAzione(this.bustaRichiesta.getAzione());
            if (this.bustaRichiesta.getCollaborazione() != null) {
                headerIntegrazioneRisposta.getBusta().setIdCollaborazione(this.bustaRichiesta.getCollaborazione());
            } else if (bustaRisposta != null && bustaRisposta.getCollaborazione() != null) {
                headerIntegrazioneRisposta.getBusta().setIdCollaborazione(bustaRisposta.getCollaborazione());
            }
            headerIntegrazioneRisposta.getBusta().setID(this.bustaRichiesta.getID());
            headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(this.bustaRichiesta.getProfiloDiCollaborazione());
            headerIntegrazioneRisposta.setIdApplicativo(this.correlazioneApplicativa);
            tipiIntegrazionePAResponse = null;
            this.msgDiag.mediumDebug("Header integrazione...");
            if (this.functionAsRouter) {
                this.msgDiag.highDebug("Header integrazione (Default gestori integrazione Router)");
                tipiIntegrazionePAResponse = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(this.protocolFactory.getProtocol()) ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(this.protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
            } else {
                this.msgDiag.highDebug("Header integrazione (Gestori integrazione...)");
                if (this.pa != null && this.msgContext.isTracciamentoAbilitato()) {
                    this.msgDiag.mediumDebug("Lettura header di integrazione...");
                    try {
                        tipiIntegrazionePAResponse = this.configurazionePdDReader.getTipiIntegrazione(this.pa);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "configurazionePdDReader.getTipiIntegrazione(pa)");
                        this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                        this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                        this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                        this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                        this.openspcoopstate.releaseResource();
                        return;
                    }
                    this.msgDiag.highDebug("Header integrazione (Gestori integrazione terminato)");
                    if (tipiIntegrazionePAResponse == null) {
                        tipiIntegrazionePAResponse = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(this.protocolFactory.getProtocol()) != false ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(this.protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                    }
                }
            }
            outResponsePAMessage = new OutResponsePAMessage();
            outResponsePAMessage.setBustaRichiesta(this.bustaRichiesta);
            outResponsePAMessage.setMessage(responseMessage);
            propertiesIntegrazioneRisposta = new HashMap<String, List<String>>();
            outResponsePAMessage.setHeaders(propertiesIntegrazioneRisposta);
            outResponsePAMessage.setPortaDelegata(this.pd);
            outResponsePAMessage.setPortaApplicativa(this.pa);
            outResponsePAMessage.setSoggettoMittente(this.soggettoFruitore);
            outResponsePAMessage.setServizio(this.idServizio);
            if (tipiIntegrazionePAResponse != null) {
                for (i = 0; i < tipiIntegrazionePAResponse.length; ++i) {
                    try {
                        gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazionePAResponse[i]);
                        if (gestore != null) {
                            classType = null;
                            try {
                                classType = gestore.getClass().getName();
                                AbstractCore.init(gestore, pddContextGestioneRisposta, this.protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new CoreException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] da utilizzare per la gestione dell'integrazione delle erogazioni (Risposta Update/Delete) di tipo [" + tipiIntegrazionePAResponse[i] + "]: " + e.getMessage());
                            }
                            if (gestore instanceof IGestoreIntegrazionePASoap) {
                                if (propertiesReader.deleteHeaderIntegrazioneResponsePA()) {
                                    if (responseMessage == null) {
                                        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)this.requestMessage.getFactory(), (MessageType)this.requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
                                        outResponsePAMessage.setMessage(responseMessage);
                                    }
                                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                                }
                                continue;
                            }
                            if (responseMessage == null) {
                                responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)this.requestMessage.getFactory(), (MessageType)this.requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
                                outResponsePAMessage.setMessage(responseMessage);
                            }
                            gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                            continue;
                        }
                        throw new CoreException("Gestore non inizializzato");
                    }
                    catch (Exception e) {
                        this.msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePAResponse[i]);
                        this.msgDiag.addKeywordErroreProcessamento(e);
                        this.msgDiag.logPersonalizzato("headerIntegrazione.creazioneFallita");
                        RicezioneBuste.logError(this.logCore, this.msgDiag.getMessaggio_replaceKeywords("headerIntegrazione.creazioneFallita"), e);
                    }
                }
            }
            this.msgContext.setResponseHeaders(propertiesIntegrazioneRisposta);
        }
        if (this.oneWayStateless || this.sincronoStateless || this.asincronoStateless) {
            this.msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                this.openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneBuste.logError(this.logCore, "Riscontrato errore durante l'aggiornamento proprietario messaggio", e);
                this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        if (this.oneWayVersione11) {
            this.msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless ibrido ...");
            try {
                this.openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneBuste.logError(this.logCore, "Riscontrato errore durante il commit della gestione oneWay stateful/stateless ibrido", e);
                this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                this.parametriGenerazioneBustaErrore.setBusta(this.bustaRichiesta);
                this.parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = this.ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(this.parametriGenerazioneBustaErrore, e);
                this.parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                this.parametriInvioBustaErrore.setBusta(this.parametriGenerazioneBustaErrore.getBusta());
                this.ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(this.parametriInvioBustaErrore);
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        if (!this.portaStateless && !this.routingStateless) {
            this.msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
            if (msgResponse != null) {
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
            }
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della risposta...");
            this.openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable("RicezioneBuste", "risposta");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable("RicezioneBuste", "risposta", this.idMessageRequest, this.functionAsRouter);
            }
        }
        this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
        this.openspcoopstate.releaseResource();
        this.msgDiag.mediumDebug("Imposto risposta nel context...");
        this.msgContext.setMessageResponse(responseMessage);
        this.msgDiag.mediumDebug("Lavoro Terminato.");
    }

    private boolean gestioneRispostaAsincronaCheckPresenzaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws ProtocolException, GestoreMessaggiException {
        boolean attendiTerminazioneRichiesta = false;
        if (this.protocolFactory == null) {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(org.openspcoop2.core.constants.Costanti.PROTOCOL_NAME));
        }
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), this.protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            msgDiag.mediumDebug("RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamento())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamento())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento della gestione della richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null?? non gestibile, si attende il completamento della gestione della richiesta");
            }
            Utilities.sleep((long)checkInterval);
        }
        return attendiTerminazioneRichiesta;
    }

    private boolean gestioneRispostaAsincronaCheckPresenzaRicevutaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws ProtocolException, GestoreMessaggiException {
        boolean attendiTerminazioneRicevutaRichiesta = false;
        if (this.protocolFactory == null) {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(org.openspcoop2.core.constants.Costanti.PROTOCOL_NAME));
        }
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), this.protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            msgDiag.mediumDebug("RICEVUTA RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento della gestione della ricevuta alla richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null??? non gestibile, si attende il completamento della gestione della ricevuta alla richiesta");
            }
            Utilities.sleep((long)checkInterval);
        }
        return attendiTerminazioneRicevutaRichiesta;
    }

    private EsitoLib chiamaLibreria(OpenSPCoopStateless openspcoopstate, Logger log, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager) throws OpenSPCoopStateException, GenericLibException {
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
            org.openspcoop2.pdd.mdb.Sbustamento lib = new org.openspcoop2.pdd.mdb.Sbustamento(log);
            return lib.onMessage(openspcoopstate, registroServiziManager, configurazionePdDManager);
        }
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
            EsitoLib result = lib.onMessage(openspcoopstate, registroServiziManager, configurazionePdDManager, this.asyncResponseCallback != null ? this : null);
            if (this.asyncResponseCallback != null) {
                this.asyncWait = true;
            }
            this.esitoStatelessAfterSendRequest = result;
            if (result.getStatoInvocazione() == 1) {
                openspcoopstate.setDestinatarioRequestMsgLib("");
            }
            return result;
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
            ImbustamentoRisposte lib = new ImbustamentoRisposte(log);
            return lib.onMessage(openspcoopstate, registroServiziManager, configurazionePdDManager);
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("InoltroRisposte")) {
            InoltroRisposte lib = new InoltroRisposte(log);
            return lib.onMessage(openspcoopstate, registroServiziManager, configurazionePdDManager);
        }
        throw new OpenSPCoopStateException("RicezioneBuste.chiamaLibreria: nome libreria non valido");
    }

    private IDServizio getIdServizioPerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) throws CoreException, DriverRegistroServiziException {
        IDSoggetto soggettoDestinatarioPerAutorizzazione = null;
        if (functionAsRouter) {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else {
                if (soggettoFruitore == null) {
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else {
                if (soggettoFruitore == null) {
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            }
        } else {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        }
        IDServizio idServizioPerAutorizzazione = IDServizioFactory.getInstance().getIDServizioFromValues(idServizio.getTipo(), idServizio.getNome(), soggettoDestinatarioPerAutorizzazione, idServizio.getVersione().intValue());
        idServizioPerAutorizzazione.setUriAccordoServizioParteComune(idServizio.getUriAccordoServizioParteComune());
        idServizioPerAutorizzazione.setAzione(idServizio.getAzione());
        idServizioPerAutorizzazione.setTipologia(idServizio.getTipologia());
        return idServizioPerAutorizzazione;
    }

    private IDSoggetto getIDSoggettoMittentePerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta, boolean supportatoAutenticazioneSoggetti) throws CoreException {
        IDSoggetto soggettoMittentePerAutorizzazione = null;
        if (functionAsRouter) {
            if (soggettoFruitore == null) {
                throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (soggettoFruitore == null) {
                if (supportatoAutenticazioneSoggetti) {
                    return null;
                }
                throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else {
                soggettoMittentePerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else {
                soggettoMittentePerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            }
        } else {
            if (soggettoFruitore == null) {
                if (supportatoAutenticazioneSoggetti) {
                    return null;
                }
                throw new CoreException(SOGGETTO_FRUITORE_NON_IDENTIFICATO);
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        }
        return soggettoMittentePerAutorizzazione;
    }

    private void overwriteIdSoggetto(IDServizio idServizio, IDSoggetto idSoggetto) {
        idServizio.setSoggettoErogatore(idSoggetto);
    }

    private void cleanDatiServizio(IDServizio idServizio) {
        idServizio.setVersione(null);
        idServizio.setNome(null);
        idServizio.setTipo(null);
    }
}

