/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.IntegrationContext;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public abstract class AbstractContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Date dataAccettazioneRichiesta;
    protected Date dataIngressoRichiesta;
    protected PdDContext pddContext;
    protected RequestInfo requestInfo;
    private URLProtocolContext urlProtocolContext;
    private String idMessage;
    private IDService idModuloAsIDService;
    private String idModulo;
    protected IDSoggetto identitaPdD;
    private OpenSPCoop2Message messageRequest;
    private OpenSPCoop2Message messageResponse;
    private boolean gestioneRisposta;
    private Credenziali credenziali;
    protected String fromLocation;
    private ProtocolContext protocol;
    private IntegrationContext integrazione;
    private TipoPdD tipoPorta;
    private MsgDiagnostico msgDiagnostico;
    private Map<String, List<String>> responseHeaders;
    private NotifierInputStreamParams notifierInputStreamParams;

    public Date getDataAccettazioneRichiesta() {
        return this.dataAccettazioneRichiesta;
    }

    public void setDataIngressoRichiesta(Date dataIngressoRichiesta) {
        this.dataIngressoRichiesta = dataIngressoRichiesta;
    }

    public Date getDataIngressoRichiesta() {
        return this.dataIngressoRichiesta;
    }

    public PdDContext getPddContext() {
        return this.pddContext;
    }

    public AbstractContext(IDService idModuloAsIDService, Date dataAccettazioneRichiesta, RequestInfo requestInfo) throws UniqueIdentifierException {
        this.pddContext = new PdDContext();
        this.pddContext.addObject(Costanti.ID_TRANSAZIONE, UniqueIdentifierManager.newUniqueIdentifier().getAsString());
        if (requestInfo != null) {
            this.pddContext.addObject(Costanti.REQUEST_INFO, requestInfo);
        }
        this.dataAccettazioneRichiesta = dataAccettazioneRichiesta;
        if (requestInfo != null) {
            this.identitaPdD = requestInfo.getIdentitaPdD();
        }
        this.idModuloAsIDService = idModuloAsIDService;
        this.requestInfo = requestInfo;
    }

    protected AbstractContext(IDService idModuloAsIDService) {
        this.idModuloAsIDService = idModuloAsIDService;
    }

    public IDService getIdModuloAsIDService() {
        return this.idModuloAsIDService;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void setIdModulo(String idModulo) {
        this.idModulo = idModulo;
    }

    public OpenSPCoop2Message getMessageRequest() {
        return this.messageRequest;
    }

    public OpenSPCoop2Message getMessageResponse() {
        return this.messageResponse;
    }

    public void setMessageRequest(OpenSPCoop2Message message) {
        this.messageRequest = message;
    }

    public void setMessageResponse(OpenSPCoop2Message messageResponse) {
        this.messageResponse = messageResponse;
    }

    public Credenziali getCredenziali() {
        return this.credenziali;
    }

    public void setCredenziali(Credenziali credenziali) {
        this.credenziali = credenziali;
    }

    public boolean isGestioneRisposta() {
        return this.gestioneRisposta;
    }

    public void setGestioneRisposta(boolean gestioneRisposta) {
        this.gestioneRisposta = gestioneRisposta;
    }

    public String getSourceLocation() {
        return this.requestInfo != null && this.requestInfo.getProtocolContext() != null ? this.requestInfo.getProtocolContext().getSource() : null;
    }

    public MsgDiagnostico getMsgDiagnostico() {
        return this.msgDiagnostico;
    }

    public void setMsgDiagnostico(MsgDiagnostico msgDiagnostico) {
        this.msgDiagnostico = msgDiagnostico;
    }

    public String getIdMessage() {
        return this.idMessage;
    }

    public void setIdMessage(String id) {
        this.idMessage = id;
    }

    public ProtocolContext getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolContext p) {
        this.protocol = p;
    }

    public IntegrationContext getIntegrazione() {
        return this.integrazione;
    }

    public void setIntegrazione(IntegrationContext integrazione) {
        this.integrazione = integrazione;
    }

    public TipoPdD getTipoPorta() {
        return this.tipoPorta;
    }

    public void setTipoPorta(TipoPdD tipoPorta) {
        this.tipoPorta = tipoPorta;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> propertiesRispostaTrasporto) {
        this.responseHeaders = propertiesRispostaTrasporto;
    }

    public IDSoggetto getIdentitaPdD() {
        return this.identitaPdD;
    }

    public void setIdentitaPdD(IDSoggetto identitaPdD) {
        this.identitaPdD = identitaPdD;
    }

    public URLProtocolContext getUrlProtocolContext() {
        return this.urlProtocolContext;
    }

    public void setUrlProtocolContext(URLProtocolContext urlProtocolContext) {
        this.urlProtocolContext = urlProtocolContext;
    }

    public NotifierInputStreamParams getNotifierInputStreamParams() {
        return this.notifierInputStreamParams;
    }

    public void setNotifierInputStreamParams(NotifierInputStreamParams notifierInputStreamParams) {
        this.notifierInputStreamParams = notifierInputStreamParams;
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }
}

