/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.messages;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.DumpRaw;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class DumpRawConnectorOutMessage
implements ConnectorOutMessage {
    private Logger log;
    private ConnectorOutMessage connectorOutMessage;
    private DumpByteArrayOutputStream bout = null;
    private MessageType messageType = null;
    private ParseException parseException = null;
    private Map<String, List<String>> trasporto = new HashMap<String, List<String>>();
    private Integer contentLenght;
    private String contentType;
    private Integer status;
    private OpenSPCoop2Properties openspcoopProperties;
    private Context context;
    private String idTransazione;
    private int soglia;
    private File repositoryFile;
    private DumpRaw dumpRaw;
    private boolean emitDiagnostic = false;

    public DumpRawConnectorOutMessage(Logger log, ConnectorOutMessage connectorOutMessage, Context context, int soglia, File repositoryFile, DumpRaw dump) {
        this.log = log;
        this.connectorOutMessage = connectorOutMessage;
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.context = context;
        if (this.context != null) {
            this.idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
        this.dumpRaw = dump;
    }

    public ConnectorOutMessage getWrappedConnectorOutMessage() {
        return this.connectorOutMessage;
    }

    public DumpByteArrayOutputStream getDumpByteArrayOutputStream() {
        if (this.bout != null && this.bout.size() > 0) {
            return this.bout;
        }
        return null;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean isParsingResponseError() {
        return this.parseException != null;
    }

    public String getParsingResponseErrorAsString() {
        if (this.parseException != null) {
            try {
                ByteArrayOutputStream boutError = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(boutError);
                this.parseException.getSourceException().printStackTrace(pw);
                pw.flush();
                boutError.flush();
                pw.close();
                boutError.close();
                return boutError.toString();
            }
            catch (Exception e) {
                return "ParsingResponseError, serializazione eccezione non riuscita: " + e.getMessage();
            }
        }
        return null;
    }

    public Map<String, List<String>> getTrasporto() {
        return this.trasporto;
    }

    public Integer getContentLenght() {
        return this.contentLenght;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Integer getStatus() {
        return this.status;
    }

    private void emitDiagnosticStartDumpBinarioRispostaUscita() {
        if (this.dumpRaw != null && !this.emitDiagnostic) {
            this.emitDiagnostic = true;
            this.dumpRaw.emitDiagnosticStartDumpBinarioRispostaUscita();
        }
    }

    private void sendHeadersEngine(OpenSPCoop2Message message) throws MessageException, ConnectorException {
        if (message == null) {
            throw new MessageException("Message is null");
        }
        OpenSPCoop2MessageProperties forwardHeader = null;
        forwardHeader = ServiceBinding.REST.equals((Object)message.getServiceBinding()) ? message.getForwardTransportHeader(this.openspcoopProperties.getRESTServicesHeadersForwardConfig(false)) : message.getForwardTransportHeader(this.openspcoopProperties.getSOAPServicesHeadersForwardConfig(false));
        if (forwardHeader != null && forwardHeader.size() > 0) {
            Iterator keys = forwardHeader.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                List values = forwardHeader.getPropertyValues(key);
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    this.addHeader(key, value);
                }
            }
        }
    }

    @Override
    public void sendResponse(OpenSPCoop2Message message, boolean consume) throws ConnectorException {
        this.emitDiagnosticStartDumpBinarioRispostaUscita();
        try {
            this.sendHeadersEngine(message);
            if (this.bout != null) {
                this.bout.clearResources();
                this.bout = null;
            }
            this.bout = new DumpByteArrayOutputStream(this.soglia, this.repositoryFile, this.idTransazione, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.getValue());
            boolean hasContent = false;
            if (message != null && ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                hasContent = true;
                OpenSPCoop2SoapMessage soap = message.castAsSoap();
                if (soap.hasSOAPFault()) {
                    soap.saveChanges();
                }
            }
            if (message != null && ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                OpenSPCoop2RestMessage rest = message.castAsRest();
                hasContent = rest.hasContent();
            }
            if (hasContent) {
                message.writeTo((OutputStream)this.bout, consume);
            }
            if (message != null) {
                this.messageType = message.getMessageType();
            }
        }
        catch (Throwable t) {
            this.bout = null;
            this.parseException = message.getParseException() != null ? message.getParseException() : ParseExceptionUtils.buildParseException((Throwable)t, (MessageRole)MessageRole.RESPONSE);
            this.log.error("SendResponse error: " + t.getMessage(), t);
            throw new ConnectorException(this.parseException.getSourceException());
        }
        finally {
            try {
                if (this.bout != null) {
                    this.bout.flush();
                }
            }
            catch (Throwable hasContent) {}
            try {
                if (this.bout != null) {
                    this.bout.close();
                }
            }
            catch (Throwable hasContent) {}
        }
        if (this.bout != null) {
            this.connectorOutMessage.sendResponse(this.bout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(DumpByteArrayOutputStream message) throws ConnectorException {
        this.emitDiagnosticStartDumpBinarioRispostaUscita();
        try {
            if (this.bout != null) {
                this.bout.clearResources();
                this.bout = null;
            }
            if (message != null && message.size() > 0) {
                this.bout = message;
            }
        }
        catch (Throwable t) {
            try {
                this.bout = DumpByteArrayOutputStream.newInstance((byte[])("SendResponse byte[] error: " + t.getMessage()).getBytes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log.error("SendResponse byte[] error: " + t.getMessage(), t);
        }
        finally {
            try {
                if (this.bout != null) {
                    this.bout.flush();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (this.bout != null) {
                    this.bout.close();
                }
            }
            catch (Throwable throwable) {}
        }
        this.connectorOutMessage.sendResponse(message);
    }

    @Override
    public void sendResponseHeaders(OpenSPCoop2Message message) throws ConnectorException {
        this.emitDiagnosticStartDumpBinarioRispostaUscita();
        try {
            this.sendHeadersEngine(message);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setHeader(String key, String value) throws ConnectorException {
        try {
            TransportUtils.setHeader(this.trasporto, (String)key, (String)value);
        }
        catch (Throwable t) {
            try {
                this.bout = DumpByteArrayOutputStream.newInstance((byte[])("setHeader [" + key + "] error: " + t.getMessage()).getBytes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log.error("Set Header [" + key + "][" + value + "] error: " + t.getMessage(), t);
        }
        this.connectorOutMessage.setHeader(key, value);
    }

    @Override
    public void addHeader(String key, String value) throws ConnectorException {
        try {
            TransportUtils.addHeader(this.trasporto, (String)key, (String)value);
        }
        catch (Throwable t) {
            try {
                this.bout = DumpByteArrayOutputStream.newInstance((byte[])("addHeader [" + key + "] error: " + t.getMessage()).getBytes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log.error("Add Header [" + key + "][" + value + "] error: " + t.getMessage(), t);
        }
        this.connectorOutMessage.addHeader(key, value);
    }

    @Override
    public void setContentLength(int length) throws ConnectorException {
        this.contentLenght = length;
        this.connectorOutMessage.setContentLength(length);
    }

    @Override
    public void setContentType(String type) throws ConnectorException {
        this.contentType = type;
        this.connectorOutMessage.setContentType(type);
    }

    @Override
    public void setStatus(int status) throws ConnectorException {
        this.status = status;
        this.connectorOutMessage.setStatus(status);
    }

    @Override
    public int getResponseStatus() throws ConnectorException {
        return this.connectorOutMessage.getResponseStatus();
    }

    @Override
    public void flush(boolean throwException) throws ConnectorException {
        this.connectorOutMessage.flush(throwException);
    }

    @Override
    public void close(AsyncResponseCallbackClientEvent clientEvent, boolean throwException) throws ConnectorException {
        this.connectorOutMessage.close(throwException);
    }
}

