/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.Eccezione;
import org.openspcoop2.core.eccezione.details.constants.TipoEccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.SbustamentoRisposteMessage;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.protocol.engine.driver.FiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

public class SbustamentoRisposte
extends GenericLib {
    public static final String ID_MODULO = "SbustamentoRisposte";
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore;

    public SbustamentoRisposte(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected synchronized void inizializza() throws GenericLibException {
        super.inizializza();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        ServizioApplicativo sa;
        PortaDelegata pd;
        EJBUtils ejbUtils;
        String ricevutaAsincrona;
        RepositoryBuste repositoryBuste;
        History historyBuste;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione;
        GestoreMessaggi msgResponse;
        String jtiIdModIRequest;
        String idMessageRequest;
        IDSoggetto identitaPdD;
        boolean bustaDiServizio;
        boolean isMessaggioErroreProtocollo;
        IntegrationFunctionError validazione_integrationFunctionError;
        List<org.openspcoop2.protocol.sdk.Eccezione> errors;
        RichiestaDelegata richiestaDelegata;
        String implementazionePdDDestinatario;
        String idResponse;
        Busta bustaRisposta;
        ITraduttore traduttore;
        IProtocolVersionManager protocolManager;
        IProtocolFactory protocolFactory;
        RequestInfo requestInfo;
        String idTransazione;
        PdDContext pddContext;
        ParseException parseException;
        SbustamentoRisposteMessage sbustamentoRisposteMsg;
        EsitoLib esito;
        block168: {
            OpenSPCoop2Message msgRisposta;
            esito = new EsitoLib();
            sbustamentoRisposteMsg = (SbustamentoRisposteMessage)openspcoopstate.getMessageLib();
            parseException = null;
            if (openspcoopstate instanceof OpenSPCoopStateless && (msgRisposta = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg()) != null) {
                parseException = msgRisposta.getParseException();
            }
            pddContext = sbustamentoRisposteMsg.getPddContext();
            idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
            requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
            protocolFactory = null;
            protocolManager = null;
            traduttore = null;
            try {
                protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
                protocolManager = protocolFactory.createProtocolVersionManager(sbustamentoRisposteMsg.getRichiestaDelegata().getProfiloGestione());
                traduttore = protocolFactory.createTraduttore();
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            msgDiag.setPddContext(pddContext, protocolFactory);
            bustaRisposta = sbustamentoRisposteMsg.getBusta();
            idResponse = bustaRisposta.getID();
            implementazionePdDDestinatario = sbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario();
            richiestaDelegata = sbustamentoRisposteMsg.getRichiestaDelegata();
            if (richiestaDelegata == null) {
                msgDiag.logErroreGenerico("RichiestaDelegata is null", "RichiestaDelegata.checkNull");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                return esito;
            }
            TipoPdD tipoPdD = TipoPdD.DELEGATA;
            if (msgDiag.getPorta() == null && richiestaDelegata != null && richiestaDelegata.getIdPortaDelegata() != null) {
                msgDiag.updatePorta(tipoPdD, richiestaDelegata.getIdPortaDelegata().getNome(), requestInfo);
            }
            richiestaDelegata.setProfiloCollaborazione(bustaRisposta.getProfiloDiCollaborazione(), bustaRisposta.getProfiloDiCollaborazioneValue());
            errors = sbustamentoRisposteMsg.getErrors();
            validazione_integrationFunctionError = sbustamentoRisposteMsg.getIntegrationFunctionErrorValidazione();
            isMessaggioErroreProtocollo = sbustamentoRisposteMsg.isMessaggioErroreProtocollo();
            bustaDiServizio = sbustamentoRisposteMsg.getIsBustaDiServizio();
            identitaPdD = sbustamentoRisposteMsg.getRichiestaDelegata().getDominio();
            msgDiag.setDominio(identitaPdD);
            msgDiag.setPrefixMsgPersonalizzati("sbustamentoRispostaBusta.");
            msgDiag.addKeywords(richiestaDelegata.getIdSoggettoFruitore(), richiestaDelegata.getIdServizio(), null);
            msgDiag.addKeywords(bustaRisposta, false);
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaDelegata.getServizioApplicativo());
            msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
            msgDiag.setIdCorrelazioneRisposta(richiestaDelegata.getIdCorrelazioneApplicativaRisposta());
            msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaDelegata.getIdCorrelazioneApplicativa());
            String profiloGestione = richiestaDelegata.getProfiloGestione();
            msgDiag.mediumDebug("Profilo di gestione [SbustamentoRisposte] della busta: " + profiloGestione);
            ProprietaErroreApplicativo proprietaErroreAppl = richiestaDelegata.getFault();
            if (proprietaErroreAppl == null) {
                msgDiag.logErroreGenerico("ProprietaErroreApplicativo is null", "ProprietaErroreApplicativo.checkNull");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                return esito;
            }
            proprietaErroreAppl.setIdModulo(ID_MODULO);
            try {
                this.generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(this.log, this.idModulo, requestInfo);
                this.generatoreErrore.updateInformazioniCooperazione(richiestaDelegata.getIdSoggettoFruitore(), richiestaDelegata.getIdServizio());
                this.generatoreErrore.updateInformazioniCooperazione(richiestaDelegata.getServizioApplicativo());
                if (proprietaErroreAppl != null) {
                    this.generatoreErrore.updateProprietaErroreApplicativo(proprietaErroreAppl);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "RicezioneContenutiApplicativiGeneratoreErrore.instanziazione");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
            openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
            registroServiziManager = registroServiziManager.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
            configurazionePdDManager = configurazionePdDManager.refreshState(registroServiziManager);
            msgDiag.updateState(configurazionePdDManager);
            idMessageRequest = openspcoopstate.getIDMessaggioSessione();
            jtiIdModIRequest = null;
            if (pddContext.containsKey(Costanti.MODI_JTI_REQUEST_ID)) {
                jtiIdModIRequest = (String)pddContext.get(Costanti.MODI_JTI_REQUEST_ID);
            }
            msgDiag.setIdMessaggioRichiesta(idMessageRequest);
            msgDiag.setIdMessaggioRisposta(idResponse);
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
            msgDiag.setFruitore(richiestaDelegata.getIdSoggettoFruitore());
            msgDiag.setServizio(richiestaDelegata.getIdServizio());
            msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
            msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
            msgDiag.setIdCorrelazioneRisposta(richiestaDelegata.getIdCorrelazioneApplicativaRisposta());
            msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
            msgResponse = null;
            profiloCollaborazione = null;
            try {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRisposta(), protocolFactory);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            historyBuste = new History(openspcoopstate.getStatoRisposta());
            repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
            ricevutaAsincrona = null;
            ejbUtils = null;
            try {
                ejbUtils = new EJBUtils(identitaPdD, tipoPdD, ID_MODULO, idMessageRequest, idResponse, "INBOX", openspcoopstate, msgDiag, false, sbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente(), sbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario(), profiloGestione, pddContext);
                ejbUtils.setSpedizioneMsgIngresso(sbustamentoRisposteMsg.getSpedizioneMsgIngresso());
                ejbUtils.setRicezioneMsgRisposta(sbustamentoRisposteMsg.getRicezioneMsgRisposta());
                ejbUtils.setScenarioCooperazione(richiestaDelegata.getScenario());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "EJBUtils.new");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            try {
                RicezioneBusteExternalErrorGenerator generatoreErrorePA = new RicezioneBusteExternalErrorGenerator(this.log, this.idModulo, requestInfo, openspcoopstate.getStatoRichiesta());
                generatoreErrorePA.updateInformazioniCooperazione(richiestaDelegata.getIdSoggettoFruitore(), richiestaDelegata.getIdServizio());
                generatoreErrorePA.updateInformazioniCooperazione(richiestaDelegata.getServizioApplicativo());
                generatoreErrorePA.updateTipoPdD(TipoPdD.DELEGATA);
                ejbUtils.setGeneratoreErrorePortaApplicativa(generatoreErrorePA);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "RicezioneBusteExternalErrorGenerator.instanziazione");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            boolean oneWayVersione11 = sbustamentoRisposteMsg.isOneWayVersione11();
            ejbUtils.setOneWayVersione11(oneWayVersione11);
            pd = null;
            sa = null;
            try {
                pd = configurazionePdDManager.getPortaDelegata(richiestaDelegata.getIdPortaDelegata(), requestInfo);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "getPortaDelegata()");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            try {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setNome(richiestaDelegata.getServizioApplicativo());
                idSA.setIdSoggettoProprietario(richiestaDelegata.getIdSoggettoFruitore());
                sa = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
            }
            catch (Exception e) {
                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(richiestaDelegata.getServizioApplicativo())) break block168;
                msgDiag.logErroreGenerico(e, "getServizioApplicativo()");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
        }
        boolean sendRispostaApplicativa = false;
        boolean statelessAsincrono = false;
        if ("Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
            sendRispostaApplicativa = true;
        } else if ("AsincronoAsimmetrico_Polling".equals(richiestaDelegata.getScenario())) {
            try {
                statelessAsincrono = configurazionePdDManager.isModalitaStateless(pd, bustaRisposta.getProfiloDiCollaborazione());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "AsincronoAsimmetricoPolling.isModalitaStateless(pd)");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            sendRispostaApplicativa = true;
        } else {
            if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_ConsegnaRisposta".equals(richiestaDelegata.getScenario())) {
                try {
                    statelessAsincrono = configurazionePdDManager.isModalitaStateless(pd, bustaRisposta.getProfiloDiCollaborazione());
                    sendRispostaApplicativa = statelessAsincrono || richiestaDelegata.isRicevutaAsincrona();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Asincrono.isModalitaStateless(pd)");
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    return esito;
                }
            }
            if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                try {
                    sendRispostaApplicativa = configurazionePdDManager.isModalitaStateless(pd, ProfiloDiCollaborazione.ONEWAY);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "OnewayInvocazioneServizio.isModalitaStateless(pd)");
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    return esito;
                }
            }
        }
        boolean rollbackRiferimentoMessaggio = false;
        if (sendRispostaApplicativa) {
            if ("Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                rollbackRiferimentoMessaggio = true;
            } else if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                rollbackRiferimentoMessaggio = true;
            }
        }
        RuoloBusta ruoloBustaRicevuta = sbustamentoRisposteMsg.getRuoloBustaRicevuta();
        try {
            org.openspcoop2.protocol.sdk.Eccezione ecc;
            block180: {
                block181: {
                    block182: {
                        block178: {
                            block179: {
                                boolean checkDuplicato;
                                boolean imbustamentoFiltroDuplicatiAbilitato;
                                boolean ricezioneRiscontri;
                                block172: {
                                    block177: {
                                        block173: {
                                            ErroreIntegrazione erroreIntegrazioneDaInviareServizioApplicativo;
                                            org.openspcoop2.protocol.sdk.Eccezione eccezioneDaInviareServizioApplicativo;
                                            DettaglioEccezione dettaglioEccezione;
                                            block169: {
                                                StringBuilder bfDescrizione;
                                                block174: {
                                                    block176: {
                                                        block175: {
                                                            ricezioneRiscontri = false;
                                                            switch (protocolManager.getConsegnaAffidabile(bustaRisposta)) {
                                                                case ABILITATA: {
                                                                    ricezioneRiscontri = true;
                                                                    break;
                                                                }
                                                                case DISABILITATA: {
                                                                    ricezioneRiscontri = false;
                                                                    break;
                                                                }
                                                                default: {
                                                                    ricezioneRiscontri = this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario);
                                                                }
                                                            }
                                                            imbustamentoFiltroDuplicatiAbilitato = false;
                                                            switch (protocolManager.getFiltroDuplicati(bustaRisposta)) {
                                                                case ABILITATA: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = true;
                                                                    break;
                                                                }
                                                                case DISABILITATA: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = false;
                                                                    break;
                                                                }
                                                                default: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = Inoltro.SENZA_DUPLICATI.equals((Object)bustaRisposta.getInoltro()) || this.propertiesReader.isCheckFromRegistroFiltroDuplicatiAbilitato(implementazionePdDDestinatario) && sbustamentoRisposteMsg.isFiltroDuplicati();
                                                                }
                                                            }
                                                            try {
                                                                IProtocolConfiguration protocolConfiguration = protocolFactory.createProtocolConfiguration();
                                                                if (imbustamentoFiltroDuplicatiAbilitato && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                                                                    throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                msgDiag.addKeywordErroreProcessamento(e);
                                                                msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                                                                if (sendRispostaApplicativa) {
                                                                    OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), e, parseException);
                                                                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                                                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                                                                } else {
                                                                    ejbUtils.releaseInboxMessage(false);
                                                                    esito.setStatoInvocazioneErroreNonGestito(e);
                                                                }
                                                                openspcoopstate.releaseResource();
                                                                esito.setEsitoInvocazione(true);
                                                                return esito;
                                                            }
                                                            if (!isMessaggioErroreProtocollo) break block172;
                                                            msgDiag.mediumDebug("Gestione messaggio errore protocollo...");
                                                            boolean msgErroreProtocolloValido = true;
                                                            if (!configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) && errors.size() != 0) {
                                                                StringBuilder eccBuffer = new StringBuilder();
                                                                for (int k = 0; k < errors.size(); ++k) {
                                                                    org.openspcoop2.protocol.sdk.Eccezione er = errors.get(k);
                                                                    if (k > 0) {
                                                                        eccBuffer.append("\n");
                                                                    }
                                                                    eccBuffer.append(er.toString(protocolFactory));
                                                                }
                                                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                                                                msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                                                msgDiag.logPersonalizzato("validazioneBustaErrore.listaEccezioniMalformata");
                                                                if (configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                                                    msgErroreProtocolloValido = false;
                                                                }
                                                            }
                                                            if (msgErroreProtocolloValido && bustaRisposta.sizeListaEccezioni() > 0) {
                                                                msgDiag.addKeyword("@ECCEZIONI@", bustaRisposta.toStringListaEccezioni(protocolFactory));
                                                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + bustaRisposta.sizeListaEccezioni());
                                                                msgDiag.logPersonalizzato("ricezioneBustaErrore");
                                                            }
                                                            if ((dettaglioEccezione = sbustamentoRisposteMsg.getDettaglioEccezione()) != null) {
                                                                msgDiag.addKeyword("@OPENSPCOOP2_DETAILS@", XMLUtils.toString((DettaglioEccezione)dettaglioEccezione));
                                                                msgDiag.logPersonalizzato("ricezioneBustaErroreDetails");
                                                            }
                                                            boolean inoltraClientBustaRispostaErroreRicevuta = OpenSPCoop2Properties.getInstance().isErroreApplicativoInoltraClientBustaRispostaErroreRicevuta(protocolFactory.getProtocol());
                                                            boolean sbustamentoInformazioniProtocolloRisposta = true;
                                                            try {
                                                                sbustamentoInformazioniProtocolloRisposta = configurazionePdDManager.invocazionePortaDelegataSbustamentoInformazioniProtocollo(sa);
                                                            }
                                                            catch (Exception e) {
                                                                msgDiag.logErroreGenerico(e, "acquisizione informazione sbustamentoInformazioniProtocolloRisposta");
                                                            }
                                                            if (sendRispostaApplicativa && msgErroreProtocolloValido && !sbustamentoInformazioniProtocolloRisposta && inoltraClientBustaRispostaErroreRicevuta) break block172;
                                                            msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                                            if (!sendRispostaApplicativa) break block173;
                                                            eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                                            erroreIntegrazioneDaInviareServizioApplicativo = null;
                                                            if (!msgErroreProtocolloValido) break block174;
                                                            if (bustaRisposta.sizeListaEccezioni() <= 1) break block175;
                                                            bfDescrizione = new StringBuilder();
                                                            for (int k = 0; k < bustaRisposta.sizeListaEccezioni(); ++k) {
                                                                org.openspcoop2.protocol.sdk.Eccezione eccListaEccezioni = bustaRisposta.getEccezione(k);
                                                                if (eccListaEccezioni.getDescrizione(protocolFactory) == null) continue;
                                                                bfDescrizione.append("[" + traduttore.toString(eccListaEccezioni.getCodiceEccezione(), eccListaEccezioni.getSubCodiceEccezione()) + "] " + eccListaEccezioni.getDescrizione(protocolFactory) + "\n");
                                                            }
                                                            if (bfDescrizione.length() > 0) {
                                                                eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                            }
                                                            break block169;
                                                        }
                                                        if (bustaRisposta.sizeListaEccezioni() != 1) break block176;
                                                        eccezioneDaInviareServizioApplicativo = bustaRisposta.getEccezione(0);
                                                        break block169;
                                                    }
                                                    if (dettaglioEccezione != null && dettaglioEccezione.getExceptions() != null && dettaglioEccezione.getExceptions().sizeExceptionList() > 0) {
                                                        Eccezione e = dettaglioEccezione.getExceptions().getException(0);
                                                        if (TipoEccezione.PROTOCOL.equals((Object)e.getType())) {
                                                            ErroreCooperazione msgErroreCooperazione = new ErroreCooperazione(e.getDescription(), traduttore.toCodiceErroreCooperazione(e.getCode()));
                                                            eccezioneDaInviareServizioApplicativo = new org.openspcoop2.protocol.sdk.Eccezione(msgErroreCooperazione, false, ID_MODULO, protocolFactory);
                                                            break block169;
                                                        } else {
                                                            eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(e.getDescription()), (IProtocolFactory)protocolFactory);
                                                        }
                                                        break block169;
                                                    } else {
                                                        eccezioneDaInviareServizioApplicativo = new org.openspcoop2.protocol.sdk.Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione(), false, ID_MODULO, protocolFactory);
                                                    }
                                                    break block169;
                                                }
                                                if (errors.size() > 1) {
                                                    bfDescrizione = new StringBuilder();
                                                    for (int k = 0; k < errors.size(); ++k) {
                                                        org.openspcoop2.protocol.sdk.Eccezione error = errors.get(k);
                                                        if (error.getDescrizione(protocolFactory) == null) continue;
                                                        bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                                    }
                                                    if (bfDescrizione.length() > 0) {
                                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                    }
                                                } else {
                                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                                }
                                            }
                                            OpenSPCoop2Message responseMessageError = null;
                                            responseMessageError = eccezioneDaInviareServizioApplicativo != null ? this.generatoreErrore.build(pddContext, IntegrationFunctionError.INTEROPERABILITY_PROFILE_RESPONSE_ERROR, eccezioneDaInviareServizioApplicativo, richiestaDelegata.getIdServizio().getSoggettoErogatore(), dettaglioEccezione, parseException) : this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTEROPERABILITY_PROFILE_RESPONSE_ERROR, erroreIntegrazioneDaInviareServizioApplicativo, null, parseException);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, "BustaErrore");
                                            break block177;
                                        }
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazione(3, "BustaErrore");
                                    }
                                    msgDiag.mediumDebug("Rilascio connessione...");
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (!isMessaggioErroreProtocollo && !configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO)) {
                                    boolean validazioneConErrori;
                                    boolean bl = validazioneConErrori = errors.size() > 0;
                                    if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || this.propertiesReader.ignoraEccezioniNonGraviValidazione()) {
                                        validazioneConErrori = Busta.containsEccezioniGravi(errors);
                                    }
                                    if (validazioneConErrori) {
                                        msgDiag.mediumDebug("Gestione messaggio di protocollo che non ha superato la validazione...");
                                        boolean mittenteRegistrato = true;
                                        StringBuilder eccBuffer = new StringBuilder();
                                        ArrayList<org.openspcoop2.protocol.sdk.Eccezione> errorsClone = new ArrayList<org.openspcoop2.protocol.sdk.Eccezione>();
                                        for (int k = 0; k < errors.size(); ++k) {
                                            org.openspcoop2.protocol.sdk.Eccezione er = errors.get(k);
                                            errorsClone.add(er);
                                            if (k > 0) {
                                                eccBuffer.append("\n");
                                            }
                                            eccBuffer.append(er.toString(protocolFactory));
                                            if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione())) continue;
                                            mittenteRegistrato = false;
                                        }
                                        msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                                        msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                                        if (configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                            boolean segnalazioneErrore = false;
                                            if (mittenteRegistrato && segnalazioneErrore) {
                                                if (openspcoopstate.resourceReleased()) {
                                                    ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                                    ((OpenSPCoopState)openspcoopstate).initResource(identitaPdD, "EJBUtils.segnalazioneErroreBustaRisposta", idTransazione);
                                                }
                                                msgDiag.mediumDebug("Invio segnalazione di errore ...");
                                                ejbUtils.sendAsRispostaBustaErrore_inoltroSegnalazioneErrore(bustaRisposta, errorsClone);
                                            }
                                            msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                            if (sendRispostaApplicativa) {
                                                org.openspcoop2.protocol.sdk.Eccezione eccezioneDaInviareServizioApplicativo = null;
                                                if (errors.size() > 1) {
                                                    eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                                    StringBuilder bfDescrizione = new StringBuilder();
                                                    for (int k = 0; k < errors.size(); ++k) {
                                                        org.openspcoop2.protocol.sdk.Eccezione error = errors.get(k);
                                                        if (error.getDescrizione(protocolFactory) == null) continue;
                                                        bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                                    }
                                                    if (bfDescrizione.length() > 0) {
                                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                    }
                                                } else {
                                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                                }
                                                IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE;
                                                if (validazione_integrationFunctionError != null) {
                                                    integrationFunctionError = validazione_integrationFunctionError;
                                                }
                                                OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, integrationFunctionError, eccezioneDaInviareServizioApplicativo, richiestaDelegata.getIdSoggettoFruitore(), parseException);
                                                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                            } else {
                                                ejbUtils.releaseInboxMessage(false);
                                                esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                            }
                                            msgDiag.mediumDebug("Rilascio connessione...");
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            return esito;
                                        }
                                    }
                                }
                                if (!bustaRisposta.containsEccezioniGravi() && bustaRisposta.sizeListaEccezioni() > 0) {
                                    msgDiag.addKeyword("@ECCEZIONI@", bustaRisposta.toStringListaEccezioni(protocolFactory));
                                    msgDiag.logPersonalizzato("ricezioneBusta.eccezioniNonGravi");
                                }
                                if (!Busta.containsEccezioniGravi(errors) && errors.size() > 0) {
                                    msgDiag.addKeyword("@ECCEZIONI@", Busta.toStringListaEccezioni(errors, (IProtocolFactory)protocolFactory));
                                    msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                                    msgDiag.logPersonalizzato("validazioneBusta.eccezioniNonGravi");
                                }
                                if (ricezioneRiscontri && bustaRisposta.sizeListaRiscontri() > 0) {
                                    if (openspcoopstate.resourceReleased()) {
                                        ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                        openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                                    }
                                    for (int i = 0; i < bustaRisposta.sizeListaRiscontri(); ++i) {
                                        Riscontro r = bustaRisposta.getRiscontro(i);
                                        msgDiag.addKeyword("@ID_BUSTA_RISCONTRATA@", r.getID());
                                        msgDiag.addKeyword("@DATA_RISCONTRO@", r.getOraRegistrazione().toString());
                                        msgDiag.logPersonalizzato("ricezioneRiscontro");
                                        try {
                                            GestoreMessaggi msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, r.getID(), "OUTBOX", msgDiag, pddContext);
                                            msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato();
                                            continue;
                                        }
                                        catch (Exception e) {
                                            msgDiag.logErroreGenerico(e, "msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato(" + r.getID() + ")");
                                        }
                                    }
                                }
                                msgDiag.mediumDebug("Controllo appartenenza Destinazione Busta (controllo esistenza soggetto)...");
                                boolean existsSoggetto = false;
                                try {
                                    existsSoggetto = configurazionePdDManager.existsSoggetto(new IDSoggetto(bustaRisposta.getTipoDestinatario(), bustaRisposta.getDestinatario()), requestInfo);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsSoggetto(" + bustaRisposta.getTipoDestinatario() + "/" + bustaRisposta.getDestinatario() + ")");
                                    if (sendRispostaApplicativa) {
                                        OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, parseException);
                                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                        esito.setStatoInvocazione(2, "existsSoggetto(" + bustaRisposta.getTipoDestinatario() + "/" + bustaRisposta.getDestinatario() + ")");
                                    } else {
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazioneErroreNonGestito(e);
                                    }
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (!existsSoggetto) {
                                    msgDiag.logPersonalizzato("soggettoDestinatarioNonGestito");
                                    if (sendRispostaApplicativa) {
                                        OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_528_RISPOSTA_RICHIESTA_NON_VALIDA), null, parseException);
                                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                                    } else {
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                                    }
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (bustaDiServizio) {
                                    msgDiag.logPersonalizzato("ricezioneBustaServizio");
                                    if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario()) && sendRispostaApplicativa) {
                                        msgDiag.mediumDebug("Gestione riscontro per oneway in modalita sincrona...");
                                    } else {
                                        if (sendRispostaApplicativa) {
                                            OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.EXPECTED_RESPONSE_NOT_FOUND, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_517_RISPOSTA_RICHIESTA_NON_RITORNATA), null, parseException);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                                        } else {
                                            ejbUtils.releaseInboxMessage(true);
                                            esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                                        }
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        return esito;
                                    }
                                }
                                if (checkDuplicato = imbustamentoFiltroDuplicatiAbilitato) {
                                    try {
                                        boolean bustaDuplicata;
                                        String gestoreFiltroDuplicatiType = this.propertiesReader.getGestoreFiltroDuplicatiRepositoryBuste();
                                        ClassNameProperties prop = ClassNameProperties.getInstance();
                                        String gestoreFiltroDuplicatiClass = prop.getFiltroDuplicati(gestoreFiltroDuplicatiType);
                                        if (gestoreFiltroDuplicatiClass == null) {
                                            throw new Exception("GestoreFiltroDuplicati non registrato (" + gestoreFiltroDuplicatiType + ")");
                                        }
                                        IFiltroDuplicati gestoreFiltroDuplicati = (IFiltroDuplicati)this.loader.newInstance(gestoreFiltroDuplicatiClass);
                                        pddContext.addObject(Costanti.OPENSPCOOP_STATE, openspcoopstate);
                                        gestoreFiltroDuplicati.init((Object)pddContext);
                                        if (gestoreFiltroDuplicati instanceof FiltroDuplicati) {
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setHistoryBuste(historyBuste);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryBuste(repositoryBuste);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setGestioneStateless(openspcoopstate instanceof OpenSPCoopStateless);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryIntervalloScadenzaMessaggi(this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                                        }
                                        boolean oldGestioneConnessione = false;
                                        boolean rinegozia = false;
                                        if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && !openspcoopstate.resourceReleased()) {
                                            rinegozia = true;
                                            msgDiag.mediumDebug("Rilascio connessione al database prima di verificare se la risposta \u00e8 duplicata ...");
                                            oldGestioneConnessione = ((OpenSPCoopState)openspcoopstate).isUseConnection();
                                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                            openspcoopstate.commit();
                                            openspcoopstate.releaseResource();
                                        }
                                        boolean initConnectionForDuplicate = false;
                                        if (!gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && openspcoopstate.resourceReleased()) {
                                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                            openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                                            historyBuste.updateState(openspcoopstate.getStatoRichiesta());
                                            repositoryBuste.updateState(openspcoopstate.getStatoRichiesta());
                                            profiloCollaborazione.updateState(openspcoopstate.getStatoRichiesta());
                                            ejbUtils.updateOpenSPCoopState(openspcoopstate);
                                            initConnectionForDuplicate = true;
                                        }
                                        if (bustaDuplicata = gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRisposta.getID())) {
                                            pddContext.addObject(Costanti.RISPOSTA_DUPLICATA, "true");
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata.count");
                                            gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRisposta.getID());
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata");
                                        } else {
                                            gestoreFiltroDuplicati.registraBusta(protocolFactory, bustaRisposta);
                                            msgDiag.logPersonalizzato("ricezioneBusta.registrazionePerFiltroDuplicati");
                                        }
                                        if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && rinegozia) {
                                            msgDiag.mediumDebug("Rinegozio connessione dopo la verifica di risposta duplicata ...");
                                            try {
                                                openspcoopstate.updateResource(idTransazione);
                                                ((OpenSPCoopState)openspcoopstate).setUseConnection(oldGestioneConnessione);
                                            }
                                            catch (Exception e) {
                                                throw new Exception("Rinegoziazione connessione dopo la verifica di risposta duplicata fallita: " + e.getMessage(), e);
                                            }
                                        }
                                        if (!gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && initConnectionForDuplicate) {
                                            openspcoopstate.commit();
                                        }
                                        if (bustaDuplicata) {
                                            if (sendRispostaApplicativa) {
                                                OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.CONFLICT_RESPONSE, org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), identitaPdD, parseException);
                                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                                ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            } else {
                                                ejbUtils.releaseInboxMessage(false, true);
                                                esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                            }
                                            openspcoopstate.commit();
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            return esito;
                                        }
                                    }
                                    catch (Exception e) {
                                        msgDiag.logErroreGenerico(e, "GestioneHistoryBusteRicevute");
                                        if (sendRispostaApplicativa) {
                                            OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, parseException);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, "GestioneHistoryBusteRicevute");
                                        } else {
                                            ejbUtils.releaseInboxMessage(false);
                                            esito.setStatoInvocazioneErroreNonGestito(e);
                                        }
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        return esito;
                                    }
                                    pddContext.removeObject(Costanti.OPENSPCOOP_STATE);
                                }
                                ecc = null;
                                msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", richiestaDelegata.getScenario());
                                if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay...");
                                    if (bustaRisposta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso OneWay)."), (IProtocolFactory)protocolFactory);
                                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !bustaRisposta.getRiferimentoMessaggio().equals(idMessageRequest) && !bustaRisposta.getRiferimentoMessaggio().equals(jtiIdModIRequest)) {
                                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                    }
                                }
                                if (!"Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) break block178;
                                msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono...");
                                if (ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) break block179;
                                msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso Sincrono)."), (IProtocolFactory)protocolFactory);
                                break block180;
                            }
                            if (bustaRisposta.getRiferimentoMessaggio() == null) {
                                msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                break block180;
                            } else if (bustaRisposta.getRiferimentoMessaggio() != null && !bustaRisposta.getRiferimentoMessaggio().equals(idMessageRequest) && !bustaRisposta.getRiferimentoMessaggio().equals(jtiIdModIRequest)) {
                                msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            break block180;
                        }
                        if (!"AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) && !"AsincronoSimmetrico_ConsegnaRisposta".equals(richiestaDelegata.getScenario())) break block181;
                        msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico...");
                        if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) break block182;
                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso AsincronoSimmetrico)."), (IProtocolFactory)protocolFactory);
                        break block180;
                    }
                    if (bustaRisposta.getRiferimentoMessaggio() == null) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                        break block180;
                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !bustaRisposta.getRiferimentoMessaggio().equals(idMessageRequest) && !bustaRisposta.getRiferimentoMessaggio().equals(jtiIdModIRequest)) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    }
                    break block180;
                }
                if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoAsimmetrico_Polling".equals(richiestaDelegata.getScenario())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico...");
                    if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso AsincronoAsimmetrico)."), (IProtocolFactory)protocolFactory);
                    } else if (bustaRisposta.getRiferimentoMessaggio() == null) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !bustaRisposta.getRiferimentoMessaggio().equals(idMessageRequest) && !bustaRisposta.getRiferimentoMessaggio().equals(jtiIdModIRequest)) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    }
                }
            }
            if (ecc != null) {
                if (sendRispostaApplicativa) {
                    OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE, ecc, richiestaDelegata.getIdSoggettoFruitore(), parseException);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                    esito.setStatoInvocazione(2, ecc.toString(protocolFactory));
                } else {
                    ejbUtils.releaseInboxMessage(false);
                    esito.setStatoInvocazione(3, ecc.toString(protocolFactory));
                }
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                return esito;
            }
            msgDiag.mediumDebug("Gestione profilo...");
            if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                msgDiag.logPersonalizzato("rispostaOneway");
            } else {
                if (ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (elimina richiesta in OutBox)...");
                    try {
                        profiloCollaborazione.sincrono_eliminaRichiestaInOutBox(bustaRisposta.getRiferimentoMessaggio());
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "profiloCollaborazione.sincrono_eliminaRichiestaInOutBox");
                        OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, parseException);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloCollaborazione.sincrono_eliminaRichiestaInOutBox");
                        return esito;
                    }
                }
                if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                    if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        ricevutaAsincrona = "ricevuta di una richiesta asincrona simmetrica";
                    } else {
                        if (!RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                            String motivazioneErrore = "Gestione busta di risposta asincrona simmetrica non permessa (Busta " + bustaRisposta.getID() + "); il modulo attendeva una ricevuta asincrona";
                            msgDiag.logErroreGenerico(motivazioneErrore, "GestioneProfiloAsincronoSimmetrico");
                            ejbUtils.releaseInboxMessage(false);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(3, motivazioneErrore);
                            return esito;
                        }
                        ricevutaAsincrona = "ricevuta di una risposta asincrona simmetrica";
                    }
                } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                    if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        ricevutaAsincrona = "ricevuta di una richiesta asincrona asimmetrica";
                    } else {
                        if (!RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                            String motivazioneErrore = "Gestione busta di risposta asincrona asimmetrica non permessa (Busta " + bustaRisposta.getID() + "); il modulo attendeva una ricevuta asincrona";
                            msgDiag.logErroreGenerico(motivazioneErrore, "GestioneProfiloAsincronoAsimmetrico");
                            ejbUtils.releaseInboxMessage(false);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(3, motivazioneErrore);
                            return esito;
                        }
                        ricevutaAsincrona = "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato";
                    }
                }
            }
            if (sendRispostaApplicativa) {
                if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                    msgResponse = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "INBOX", msgDiag, pddContext);
                    msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgDiag.mediumDebug("Elimino accesso da PdD...");
                    repositoryBuste.eliminaUtilizzoPdDFromInBox(idResponse);
                    msgDiag.mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi, oneway con scenario sincrono...");
                    msgResponse = protocolManager.isHttpEmptyResponseOneWay() ? ejbUtils.sendRispostaApplicativaOK(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE), richiestaDelegata, pd, sa) : ejbUtils.sendRispostaApplicativaOK(ejbUtils.buildOpenSPCoopOK(requestInfo.getIntegrationRequestMessageType(), idMessageRequest), richiestaDelegata, pd, sa);
                } else {
                    msgDiag.mediumDebug("Send risposta applicativa...");
                    msgResponse = ejbUtils.sendRispostaApplicativa(richiestaDelegata, pd, sa);
                }
            } else {
                msgResponse = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "INBOX", msgDiag, pddContext);
                msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                msgDiag.mediumDebug("Elimino accesso da PdD...");
                repositoryBuste.eliminaUtilizzoPdDFromInBox(idResponse, statelessAsincrono);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
        }
        catch (Throwable e) {
            this.log.error("ErroreGenerale", e);
            msgDiag.logErroreGenerico(e, "Generale");
            if (sendRispostaApplicativa) {
                OpenSPCoop2Message responseMessageError = this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, parseException);
                try {
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                    esito.setStatoInvocazione(2, "ErroreGenerale");
                    esito.setEsitoInvocazione(true);
                }
                catch (Exception er) {
                    msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta sincrona non riuscita", esito);
                    esito.setStatoInvocazioneErroreNonGestito(er);
                    esito.setEsitoInvocazione(false);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), esito);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (msgResponse != null) {
            msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposte");
        }
        if (msgResponse != null) {
            msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposte", idMessageRequest, false);
        }
        if (ricevutaAsincrona != null) {
            msgDiag.mediumDebug("Gestione ricevute asincrone...");
            try {
                boolean forzaEliminazioneMessaggio = false;
                if (openspcoopstate instanceof OpenSPCoopStateless && "ricevuta di una richiesta asincrona simmetrica".equals(ricevutaAsincrona)) {
                    forzaEliminazioneMessaggio = true;
                }
                GestoreMessaggi msgRiscontrato = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getRiferimentoMessaggio(), "OUTBOX", msgDiag, pddContext);
                msgRiscontrato.setReadyForDrop(forzaEliminazioneMessaggio);
                msgRiscontrato.validateAndDeleteMsgAsincronoRiscontrato(bustaRisposta);
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevutaAsincrona);
                msgDiag.logPersonalizzato("validazioneRicevutaAsincrona");
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Validazione(" + ricevutaAsincrona + ")");
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        msgDiag.mediumDebug("Lavoro Terminato.");
        esito.setStatoInvocazione(1, null);
        esito.setEsitoInvocazione(true);
        return esito;
    }
}

