/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.ArrayList;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.constants.TipoEccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.core.transazioni.FiltroDuplicati;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.SbustamentoMessage;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class Sbustamento
extends GenericLib {
    public static final String ID_MODULO = "Sbustamento";
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore;

    public Sbustamento(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected synchronized void inizializza() throws GenericLibException {
        super.inizializza();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        sbustamentoMsg = (SbustamentoMessage)openspcoopstate.getMessageLib();
        esito = new EsitoLib();
        pddContext = sbustamentoMsg.getPddContext();
        idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
        requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        protocolFactory = null;
        protocolManager = null;
        traduttore = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            protocolManager = protocolFactory.createProtocolVersionManager(sbustamentoMsg.getRichiestaApplicativa().getProfiloGestione());
            traduttore = protocolFactory.createTraduttore();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.setPddContext(pddContext, protocolFactory);
        bustaRichiesta = sbustamentoMsg.getBusta();
        implementazionePdDMittente = sbustamentoMsg.getImplementazionePdDSoggettoMittente();
        richiestaApplicativa = sbustamentoMsg.getRichiestaApplicativa();
        if (richiestaApplicativa == null) {
            msgDiag.logErroreGenerico("RichiestaApplicativa is null", "RichiestaApplicativa.checkNull");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            return esito;
        }
        tipoPdD = TipoPdD.APPLICATIVA;
        if (msgDiag.getPorta() == null && richiestaApplicativa != null && richiestaApplicativa.getIdPortaApplicativa() != null) {
            msgDiag.updatePorta(tipoPdD, richiestaApplicativa.getIdPortaApplicativa().getNome(), requestInfo);
        }
        idServizio = richiestaApplicativa.getIDServizio();
        idSoggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
        errors = sbustamentoMsg.getErrors();
        validazione_integrationFunctionError = sbustamentoMsg.getIntegrationFunctionErrorValidazione();
        isMessaggioErroreProtocollo = sbustamentoMsg.isMessaggioErroreProtocollo();
        bustaDiServizio = sbustamentoMsg.getIsBustaDiServizio();
        identitaPdD = sbustamentoMsg.getRichiestaApplicativa().getDominio();
        msgDiag.setDominio(identitaPdD);
        msgDiag.setPrefixMsgPersonalizzati("sbustamentoBusta.");
        msgDiag.addKeywords(bustaRichiesta, true);
        if (richiestaApplicativa.getIdentitaServizioApplicativoFruitore() != null) {
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaApplicativa.getIdentitaServizioApplicativoFruitore());
        }
        msgDiag.setIdCorrelazioneApplicativa(richiestaApplicativa.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaApplicativa.getIdCorrelazioneApplicativa());
        profiloGestione = richiestaApplicativa.getProfiloGestione();
        msgDiag.mediumDebug("Profilo di gestione [Sbustamento] della busta: " + profiloGestione);
        try {
            this.generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(this.log, this.idModulo, requestInfo);
            this.generatoreErrore.updateInformazioniCooperazione(idSoggettoFruitore, idServizio);
            this.generatoreErrore.updateTipoPdD(TipoPdD.APPLICATIVA);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "RicezioneContenutiApplicativiGeneratoreErrore.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, "Sbustamento", idTransazione);
        registroServiziManager = registroServiziManager.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        configurazionePdDManager = configurazionePdDManager.refreshState(registroServiziManager);
        msgDiag.updateState(configurazionePdDManager);
        idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        msgDiag.setIdMessaggioRichiesta(idMessageRequest);
        msgDiag.setFruitore(idSoggettoFruitore);
        msgDiag.setServizio(idServizio);
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPdD, "Sbustamento", idMessageRequest, idMessageRequest, "INBOX", openspcoopstate, msgDiag, false, sbustamentoMsg.getImplementazionePdDSoggettoMittente(), sbustamentoMsg.getImplementazionePdDSoggettoDestinatario(), profiloGestione, pddContext);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        try {
            generatoreErrorePA = new RicezioneBusteExternalErrorGenerator(this.log, this.idModulo, requestInfo, openspcoopstate.getStatoRichiesta());
            generatoreErrorePA.updateInformazioniCooperazione(idSoggettoFruitore, idServizio);
            generatoreErrorePA.updateInformazioniCooperazione(richiestaApplicativa.getIdentitaServizioApplicativoFruitore());
            generatoreErrorePA.updateTipoPdD(TipoPdD.APPLICATIVA);
            ejbUtils.setGeneratoreErrorePortaApplicativa(generatoreErrorePA);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "RicezioneBusteExternalErrorGenerator.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        oneWayVersione11 = sbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        ejbUtils.setPortaDiTipoStateless_esclusoOneWay11(sbustamentoMsg.isStateless());
        profiloCollaborazione = null;
        try {
            profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        historyBuste = new History(openspcoopstate.getStatoRichiesta());
        repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        ricevutaAsincrona = null;
        msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, "INBOX", msgDiag, pddContext);
        msgResponse = null;
        msgRequest.setOneWayVersione11(oneWayVersione11);
        servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
        idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
        newConnectionForResponse = false;
        if (!ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && !sbustamentoMsg.isStateless()) {
            newConnectionForResponse = configurazionePdDManager.newConnectionForResponse();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        gestioneIndirizzoTelematico = false;
        if (!sbustamentoMsg.isStateless()) {
            gestioneIndirizzoTelematico = configurazionePdDManager.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        sendSbloccoRicezioneBuste = true;
        if (configurazionePdDManager.isUtilizzoIndirizzoTelematico() && bustaRichiesta.getIndirizzoMittente() != null && !sbustamentoMsg.isStateless()) {
            sendSbloccoRicezioneBuste = false;
        } else if (newConnectionForResponse) {
            sendSbloccoRicezioneBuste = false;
        }
        ruoloBustaRicevuta = sbustamentoMsg.getRuoloBustaRicevuta();
        bustaHTTPReply = null;
        try {
            block291: {
                block293: {
                    block290: {
                        ricezioneRiscontri = false;
                        switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaAffidabile(bustaRichiesta).ordinal()]) {
                            case 1: {
                                ricezioneRiscontri = true;
                                break;
                            }
                            case 2: {
                                ricezioneRiscontri = false;
                                break;
                            }
                            default: {
                                ricezioneRiscontri = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente);
                            }
                        }
                        consegnaAffidabile = false;
                        switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaAffidabile(bustaRichiesta).ordinal()]) {
                            case 1: {
                                consegnaAffidabile = true;
                                break;
                            }
                            case 2: {
                                consegnaAffidabile = false;
                                break;
                            }
                            default: {
                                consegnaAffidabile = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) != false && bustaRichiesta.isConfermaRicezione() != false;
                            }
                        }
                        idCollaborazione = false;
                        switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getCollaborazione(bustaRichiesta).ordinal()]) {
                            case 1: {
                                idCollaborazione = true;
                                break;
                            }
                            case 2: {
                                idCollaborazione = false;
                                break;
                            }
                            default: {
                                idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) != false && bustaRichiesta.getCollaborazione() != null;
                            }
                        }
                        consegnaInOrdine = false;
                        switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaInOrdine(bustaRichiesta).ordinal()]) {
                            case 1: {
                                consegnaInOrdine = true;
                                break;
                            }
                            case 2: {
                                consegnaInOrdine = false;
                                break;
                            }
                            default: {
                                gestioneConsegnaInOrdineAbilitata = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) != false && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) != false && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDMittente) != false;
                                consegnaInOrdine = gestioneConsegnaInOrdineAbilitata != false && bustaRichiesta.getSequenza() != -1L;
                            }
                        }
                        imbustamentoFiltroDuplicatiAbilitato = false;
                        switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getFiltroDuplicati(bustaRichiesta).ordinal()]) {
                            case 1: {
                                imbustamentoFiltroDuplicatiAbilitato = true;
                                break;
                            }
                            case 2: {
                                imbustamentoFiltroDuplicatiAbilitato = false;
                                break;
                            }
                            default: {
                                imbustamentoFiltroDuplicatiAbilitato = Inoltro.SENZA_DUPLICATI.equals((Object)bustaRichiesta.getInoltro()) != false || this.propertiesReader.isCheckFromRegistroFiltroDuplicatiAbilitato(implementazionePdDMittente) != false && sbustamentoMsg.isFiltroDuplicatiRichiestoAccordo() != false;
                            }
                        }
                        try {
                            protocolConfiguration = protocolFactory.createProtocolConfiguration();
                            if (bustaRichiesta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.UNKNOWN.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), bustaRichiesta.getProfiloDiCollaborazione())) {
                                throw new Exception("Profilo di Collaborazione [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "]");
                            }
                            if (imbustamentoFiltroDuplicatiAbilitato && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                                throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                            }
                            if (consegnaAffidabile && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.CONFERMA_RICEZIONE)) {
                                throw new Exception(FunzionalitaProtocollo.CONFERMA_RICEZIONE.getEngineValue());
                            }
                            if (idCollaborazione && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.COLLABORAZIONE)) {
                                throw new Exception(FunzionalitaProtocollo.COLLABORAZIONE.getEngineValue());
                            }
                            if (consegnaInOrdine && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.CONSEGNA_IN_ORDINE)) {
                                throw new Exception(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE.getEngineValue());
                            }
                        }
                        catch (Exception e) {
                            msgDiag.addKeywordErroreProcessamento(e);
                            msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                            ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL);
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                            return esito;
                        }
                        if (isMessaggioErroreProtocollo) {
                            msgDiag.mediumDebug("Gestione messaggio errore protocollo...");
                            msgErroreProtocolloValido = true;
                            if (!configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) && errors.size() != 0) {
                                eccBuffer = new StringBuilder();
                                for (k = 0; k < errors.size(); ++k) {
                                    er = errors.get(k);
                                    if (k > 0) {
                                        eccBuffer.append("\n");
                                    }
                                    eccBuffer.append(er.toString(protocolFactory));
                                }
                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                                msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                msgDiag.logPersonalizzato("validazioneBustaErrore.listaEccezioniMalformata");
                                if (configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                    msgErroreProtocolloValido = false;
                                }
                            }
                            if (msgErroreProtocolloValido && bustaRichiesta.sizeListaEccezioni() > 0) {
                                msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni(protocolFactory));
                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + bustaRichiesta.sizeListaEccezioni());
                                msgDiag.logPersonalizzato("ricezioneBustaErrore");
                            }
                            if ((dettaglioEccezione = sbustamentoMsg.getDettaglioEccezione()) != null) {
                                msgDiag.addKeyword("@OPENSPCOOP2_DETAILS@", XMLUtils.toString((DettaglioEccezione)dettaglioEccezione));
                                msgDiag.logPersonalizzato("ricezioneBustaErroreDetails");
                            }
                            if (sendSbloccoRicezioneBuste) {
                                msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                                msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                            }
                            msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                            eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            erroreIntegrazioneDaInviareServizioApplicativo = null;
                            if (msgErroreProtocolloValido) {
                                if (bustaRichiesta.sizeListaEccezioni() > 1) {
                                    bfDescrizione = new StringBuilder();
                                    for (k = 0; k < bustaRichiesta.sizeListaEccezioni(); ++k) {
                                        eccLista = bustaRichiesta.getEccezione(k);
                                        if (eccLista.getDescrizione(protocolFactory) == null) continue;
                                        bfDescrizione.append("[" + traduttore.toString(eccLista.getCodiceEccezione(), eccLista.getSubCodiceEccezione()) + "] " + eccLista.getDescrizione(protocolFactory) + "\n");
                                    }
                                    if (bfDescrizione.length() > 0) {
                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                    }
                                } else if (bustaRichiesta.sizeListaEccezioni() == 1) {
                                    eccezioneDaInviareServizioApplicativo = bustaRichiesta.getEccezione(0);
                                } else if (dettaglioEccezione != null && dettaglioEccezione.getExceptions() != null && dettaglioEccezione.getExceptions().sizeExceptionList() > 0) {
                                    e = dettaglioEccezione.getExceptions().getException(0);
                                    if (TipoEccezione.PROTOCOL.equals((Object)e.getType())) {
                                        msgErroreCooperazione = new ErroreCooperazione(e.getDescription(), traduttore.toCodiceErroreCooperazione(e.getCode()));
                                        eccezioneDaInviareServizioApplicativo = new Eccezione(msgErroreCooperazione, false, "Sbustamento", protocolFactory);
                                    } else {
                                        eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(e.getDescription()), (IProtocolFactory)protocolFactory);
                                    }
                                } else {
                                    eccezioneDaInviareServizioApplicativo = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione(), false, "Sbustamento", protocolFactory);
                                }
                            } else if (errors.size() > 1) {
                                bfDescrizione = new StringBuilder();
                                for (k = 0; k < errors.size(); ++k) {
                                    error = errors.get(k);
                                    if (error.getDescrizione(protocolFactory) == null) continue;
                                    bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                }
                                if (bfDescrizione.length() > 0) {
                                    eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                }
                            } else {
                                eccezioneDaInviareServizioApplicativo = errors.get(0);
                            }
                            integrationFunctionError = validazione_integrationFunctionError;
                            if (integrationFunctionError == null) {
                                integrationFunctionError = ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) != false ? IntegrationFunctionError.INTERNAL_RESPONSE_ERROR : IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                            }
                            this.gestioneErroreProtocollo(configurazionePdDManager, ejbUtils, profiloCollaborazione, repositoryBuste, bustaRichiesta, identitaPdD, eccezioneDaInviareServizioApplicativo, erroreIntegrazioneDaInviareServizioApplicativo, new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente()), dettaglioEccezione, protocolFactory, (IProtocolManager)protocolManager, pddContext, requestInfo, integrationFunctionError);
                            openspcoopstate.commit();
                            msgDiag.mediumDebug("Rilascio connessione...");
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "RicevutoMsgBustaErrore");
                            return esito;
                        }
                        if (!isMessaggioErroreProtocollo && !configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO)) {
                            v0 = validazioneConErrori = errors.size() > 0;
                            if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || this.propertiesReader.ignoraEccezioniNonGraviValidazione()) {
                                validazioneConErrori = Busta.containsEccezioniGravi(errors);
                            }
                            if (validazioneConErrori) {
                                msgDiag.mediumDebug("Gestione messaggio di protocollo che non ha superato la validazione...");
                                mittenteRegistrato = true;
                                eccBuffer = new StringBuilder();
                                errorsClone = new ArrayList<Eccezione>();
                                for (k = 0; k < errors.size(); ++k) {
                                    er = errors.get(k);
                                    errorsClone.add(er);
                                    if (k > 0) {
                                        eccBuffer.append("\n");
                                    }
                                    eccBuffer.append(er.toString(protocolFactory));
                                    if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione())) continue;
                                    mittenteRegistrato = false;
                                }
                                msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                                msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                                if (configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals((Object)CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                    bustaNonValida = bustaRichiesta.newInstance();
                                    ejbUtils.setRollbackRichiestaInCasoErrore(false);
                                    if (mittenteRegistrato) {
                                        msgDiag.mediumDebug("Invio segnalazione di errore ...");
                                        integrationFunctionError = validazione_integrationFunctionError;
                                        if (integrationFunctionError == null) {
                                            integrationFunctionError = ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) != false ? IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE : IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_REQUEST;
                                        }
                                        ejbUtils.setIntegrationFunctionErrorPortaApplicativa(integrationFunctionError);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, errorsClone, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
                                    } else if (sendSbloccoRicezioneBuste) {
                                        msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                                        msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                                    }
                                    ejbUtils.setRollbackRichiestaInCasoErrore(true);
                                    eccezioneDaInviareServizioApplicativo = null;
                                    if (errors.size() > 1) {
                                        eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                        bfDescrizione = new StringBuilder();
                                        for (k = 0; k < errors.size(); ++k) {
                                            error = errors.get(k);
                                            if (error.getDescrizione(protocolFactory) == null) continue;
                                            bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                        }
                                        if (bfDescrizione.length() > 0) {
                                            eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                        }
                                    } else {
                                        eccezioneDaInviareServizioApplicativo = errors.get(0);
                                    }
                                    msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                    integrationFunctionError = validazione_integrationFunctionError;
                                    if (integrationFunctionError == null) {
                                        integrationFunctionError = ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) != false ? IntegrationFunctionError.INTERNAL_RESPONSE_ERROR : IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                    }
                                    if (validazione_integrationFunctionError != null) {
                                        integrationFunctionError = validazione_integrationFunctionError;
                                    }
                                    this.gestioneErroreProtocollo(configurazionePdDManager, ejbUtils, profiloCollaborazione, repositoryBuste, bustaNonValida, identitaPdD, eccezioneDaInviareServizioApplicativo, null, identitaPdD, null, protocolFactory, (IProtocolManager)protocolManager, pddContext, requestInfo, integrationFunctionError);
                                    openspcoopstate.commit();
                                    msgDiag.mediumDebug("Rilascio connessione...");
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                    return esito;
                                }
                            }
                        }
                        if (!bustaRichiesta.containsEccezioniGravi() && bustaRichiesta.sizeListaEccezioni() > 0) {
                            msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni(protocolFactory));
                            msgDiag.logPersonalizzato("ricezioneBusta.eccezioniNonGravi");
                        }
                        if (!Busta.containsEccezioniGravi(errors) && errors.size() > 0) {
                            msgDiag.addKeyword("@ECCEZIONI@", Busta.toStringListaEccezioni(errors, (IProtocolFactory)protocolFactory));
                            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "" + errors.size());
                            msgDiag.logPersonalizzato("validazioneBusta.eccezioniNonGravi");
                        }
                        if (ricezioneRiscontri && bustaRichiesta.sizeListaRiscontri() > 0) {
                            for (i = 0; i < bustaRichiesta.sizeListaRiscontri(); ++i) {
                                r = bustaRichiesta.getRiscontro(i);
                                msgDiag.addKeyword("@ID_BUSTA_RISCONTRATA@", r.getID());
                                msgDiag.addKeyword("@DATA_RISCONTRO@", r.getOraRegistrazione().toString());
                                msgDiag.logPersonalizzato("ricezioneRiscontro");
                                try {
                                    msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, r.getID(), "OUTBOX", msgDiag, pddContext);
                                    msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato();
                                    continue;
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato(" + r.getID() + ")");
                                }
                            }
                        }
                        msgDiag.mediumDebug("Controllo appartenenza Destinazione Busta (controllo esistenza soggetto)...");
                        existsSoggetto = false;
                        try {
                            existsSoggetto = configurazionePdDManager.existsSoggetto(idServizio.getSoggettoErogatore(), requestInfo);
                        }
                        catch (Exception e) {
                            if (idServizio != null && idServizio.getSoggettoErogatore() != null) {
                                msgDiag.logErroreGenerico(e, "existsSoggetto(" + idServizio.getSoggettoErogatore().toString() + ")");
                            } else {
                                msgDiag.logErroreGenerico(e, "existsSoggetto()");
                            }
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "existsSoggetto()");
                            return esito;
                        }
                        isSoggettoVirtuale = configurazionePdDManager.isSoggettoVirtuale(idServizio.getSoggettoErogatore(), requestInfo);
                        if (!existsSoggetto && !isSoggettoVirtuale) {
                            msgDiag.logPersonalizzato("soggettoDestinatarioNonGestito");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_451_SOGGETTO_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                            return esito;
                        }
                        if (bustaDiServizio) {
                            msgDiag.logPersonalizzato("ricezioneBustaServizio");
                            if (sendSbloccoRicezioneBuste) {
                                msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                            }
                            ejbUtils.releaseInboxMessage(false);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                            return esito;
                        }
                        returnProtocolReply = false;
                        tipoOraRegistrazione = this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente);
                        bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                        if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                            if (this.propertiesReader.isCheckFromRegistroConfermaRicezioneAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConfermaRicezioneRichiestoAccordo() && !bustaRichiesta.isConfermaRicezione() && !consegnaAffidabile) {
                                msgDiag.logPersonalizzato("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente");
                                e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente"));
                                return esito;
                            }
                            if (this.propertiesReader.isCheckFromRegistroConsegnaInOrdineAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConsegnaOrdineRichiestoAccordo() && bustaRichiesta.getSequenza() < 0L) {
                                msgDiag.logPersonalizzato("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente");
                                e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_NON_GESTIBILE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente"));
                                return esito;
                            }
                        }
                        if (!(checkDuplicato = imbustamentoFiltroDuplicatiAbilitato)) break block293;
                        try {
                            block295: {
                                block296: {
                                    block294: {
                                        gestoreFiltroDuplicati = Sbustamento.getGestoreFiltroDuplicati(this.propertiesReader, this.loader, openspcoopstate, pddContext, historyBuste, repositoryBuste, oneWayVersione11);
                                        oldGestioneConnessione = false;
                                        rinegozia = false;
                                        if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && !openspcoopstate.resourceReleased()) {
                                            rinegozia = true;
                                            msgDiag.mediumDebug("Rilascio connessione al database prima di verificare se la richiesta \u00e8 duplicata ...");
                                            oldGestioneConnessione = ((OpenSPCoopState)openspcoopstate).isUseConnection();
                                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                            openspcoopstate.commit();
                                            openspcoopstate.releaseResource();
                                        }
                                        initConnectionForDuplicate = false;
                                        if (!gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && openspcoopstate.resourceReleased()) {
                                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                                            openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                                            historyBuste.updateState(openspcoopstate.getStatoRichiesta());
                                            repositoryBuste.updateState(openspcoopstate.getStatoRichiesta());
                                            profiloCollaborazione.updateState(openspcoopstate.getStatoRichiesta());
                                            ejbUtils.updateOpenSPCoopState(openspcoopstate);
                                            initConnectionForDuplicate = true;
                                        }
                                        if (bustaDuplicata = gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRichiesta.getID())) {
                                            pddContext.addObject(Costanti.RICHIESTA_DUPLICATA, "true");
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata.count");
                                            gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRichiesta.getID());
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata");
                                        } else {
                                            gestoreFiltroDuplicati.registraBusta(protocolFactory, bustaRichiesta);
                                            msgDiag.logPersonalizzato("ricezioneBusta.registrazionePerFiltroDuplicati");
                                        }
                                        if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && rinegozia) {
                                            msgDiag.mediumDebug("Rinegozio connessione dopo la verifica di richiesta duplicata ...");
                                            try {
                                                openspcoopstate.updateResource(idTransazione);
                                                ((OpenSPCoopState)openspcoopstate).setUseConnection(oldGestioneConnessione);
                                            }
                                            catch (Exception e) {
                                                throw new Exception("Rinegoziazione connessione dopo la verifica di richiesta duplicata fallita: " + e.getMessage(), e);
                                            }
                                        }
                                        if (!gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && initConnectionForDuplicate) {
                                            openspcoopstate.commit();
                                        }
                                        if (!bustaDuplicata) break block290;
                                        if (!ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || !consegnaAffidabile) break block294;
                                        msgDiag.logPersonalizzato("ricezioneBuste.", "generazioneRiscontro");
                                        r = new Riscontro();
                                        r.setID(bustaRichiesta.getID());
                                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setVersioneServizioRichiedenteBustaDiServizio(bustaRichiesta.getVersioneServizio());
                                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                                        bustaHTTPReply.addRiscontro(r);
                                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        break block295;
                                    }
                                    if (!(!ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione() || !protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() && !this.propertiesReader.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente))) {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.CONFLICT);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
                                    }
                                    if (ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.CONFLICT);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
                                    }
                                    if (!ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && !ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) break block296;
                                    ricevuta = null;
                                    if (!ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) ** GOTO lbl526
                                    ricevutaAbilitata = true;
                                    try {
                                        if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            msgDiag.mediumDebug("Lettura Porta Delegata ...");
                                            idAsincronoCorrelazioneRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                                            if (idAsincronoCorrelazioneRichiesta == null) {
                                                idAsincronoCorrelazioneRichiesta = bustaRichiesta.getCollaborazione();
                                            }
                                            integrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(idAsincronoCorrelazioneRichiesta);
                                            idPD = new IDPortaDelegata();
                                            idPD.setNome(integrazione.getNomePorta());
                                            pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                                            ricevutaAbilitata = configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pd);
                                        } else {
                                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                            pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                                            ricevutaAbilitata = configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pa);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.error("Errore durante l'identificazione della Porta (Delegata/Applicativa) associata alla busta: " + e.getMessage(), (Throwable)e);
                                    }
                                    if (!ricevutaAbilitata) {
                                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                            ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                                        } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            ricevuta = "ricevuta di una risposta asincrona simmetrica";
                                        }
                                    } else {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.CONFLICT);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
lbl526:
                                        // 1 sources

                                        msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                        pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                                        if (!configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pa)) {
                                            if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
                                            } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
                                            }
                                        } else {
                                            ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                            ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.CONFLICT);
                                            ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                            return esito;
                                        }
                                    }
                                    if (ricevuta != null) {
                                        msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                                        msgDiag.logPersonalizzato("ricezioneBuste.", "generazioneRicevutaAsincrona");
                                        bustaHTTPReply.setVersioneServizio(bustaRichiesta.getVersioneServizio());
                                        bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                        bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                                        bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                        if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                            bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                        }
                                        if (!consegnaAffidabile) {
                                            bustaHTTPReply.setConfermaRicezione(false);
                                        }
                                        if (imbustamentoFiltroDuplicatiAbilitato) {
                                            bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                        }
                                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    }
                                    break block295;
                                }
                                if (protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() || this.propertiesReader.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente)) {
                                    ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                    ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.CONFLICT);
                                    ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                    return esito;
                                }
                                if (sendSbloccoRicezioneBuste) {
                                    msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                                }
                            }
                            ejbUtils.releaseInboxMessage(false, true);
                            if (msgResponse != null) {
                                msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata");
                            }
                            if (msgResponse != null) {
                                msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata", idMessageRequest, false);
                            }
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(1, null);
                            return esito;
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "GestioneHistoryBusteRicevute");
                            ejbUtils.rollbackMessage("Gestione dell'history delle buste ricevute non riuscita", esito);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(false);
                            esito.setStatoInvocazioneErroreNonGestito(e);
                            return esito;
                        }
                    }
                    pddContext.removeObject(Costanti.OPENSPCOOP_STATE);
                }
                if (consegnaAffidabile) {
                    msgDiag.mediumDebug("Gestione eventuali riscontri da inviare...");
                    senza_piggy_backing = true;
                    if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && senza_piggy_backing && bustaRichiesta.isConfermaRicezione()) {
                        r = new Riscontro();
                        r.setID(bustaRichiesta.getID());
                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                        bustaHTTPReply.addRiscontro(r);
                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                        returnProtocolReply = true;
                    }
                }
                if (consegnaInOrdine && !ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione vincoli consegna in ordine...");
                    msgDiag.logPersonalizzato("consegnaInOrdine.profiloDiversoOneway");
                    e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_NON_SUPPORTATA.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.profiloDiversoOneway"));
                    return esito;
                }
                scenarioCooperazione = null;
                generazioneMsgOK = false;
                existsPA = true;
                pa = null;
                sa = null;
                integrazioneAsincrona = null;
                if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay...");
                    scenarioCooperazione = "OneWay_InvocazioneServizio";
                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay (existsPA)...");
                    try {
                        existsPA = configurazionePdDManager.existsPA(richiestaApplicativa, requestInfo);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,oneway)");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,oneway)");
                        return esito;
                    }
                    if (!existsPA) {
                        nomePA = "";
                        if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getNome() != null) {
                            nomePA = " [" + richiestaApplicativa.getIdPortaApplicativa().getNome() + "]";
                        }
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Porta Applicativa" + (String)nomePA + " non esistente");
                        msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                        ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.API_IN_UNKNOWN);
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                        return esito;
                    }
                    msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                    pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                    soggettoVirtuale = false;
                    try {
                        if (richiestaApplicativa.getDominio() != null) {
                            soggettoVirtuale = configurazionePdDManager.isSoggettoVirtuale(richiestaApplicativa.getDominio(), requestInfo);
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "isSoggettoVirtuale(richiestaApplicativa,oneway)");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "isSoggettoVirtuale(richiestaApplicativa,oneway)");
                        return esito;
                    }
                    generazioneMsgOK = !soggettoVirtuale ? !configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione()) : true;
                } else {
                    if (ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono...");
                        if (!(bustaRichiesta.getRiferimentoMessaggio() == null || ruoloBustaRicevuta != null && ruoloBustaRicevuta.equals((Object)RuoloBusta.RICHIESTA))) {
                            msgDiag.logPersonalizzato("ricezioneRispostaSincrona");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneRispostaSincrona"));
                            return esito;
                        }
                        scenarioCooperazione = "Sincrono_InvocazioneServizio";
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (existsPA)...");
                        try {
                            existsPA = configurazionePdDManager.existsPA(richiestaApplicativa, requestInfo);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,sincrono)");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,sincrono)");
                            return esito;
                        }
                        if (!existsPA) {
                            nomePA = "";
                            if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getNome() != null) {
                                nomePA = " [" + richiestaApplicativa.getIdPortaApplicativa().getNome() + "]";
                            }
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Porta Applicativa" + (String)nomePA + " non esistente");
                            msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                            ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.API_IN_UNKNOWN);
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                            return esito;
                        }
                        msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                        pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (registra busta ricevuta)...");
                        try {
                            profiloCollaborazione.registraBustaRicevuta(bustaRichiesta.getID());
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "profiloCollaborazione.registraBustaRicevuta(" + bustaRichiesta.getID() + ")");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "profiloCollaborazione.registraBustaRicevuta(" + bustaRichiesta.getID() + ")");
                            return esito;
                        }
                    }
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (openspcoopstate.resourceReleased()) {
                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                            openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                            profiloCollaborazione.updateState(openspcoopstate.getStatoRichiesta());
                            repositoryBuste.updateState(openspcoopstate.getStatoRichiesta());
                        }
                        if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = configurazionePdDManager.existsPA(richiestaApplicativa, requestInfo);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoSimmetricoRichiesta)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoSimmetricoRichiesta)");
                                return esito;
                            }
                            if (!existsPA) {
                                nomePA = "";
                                if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getNome() != null) {
                                    nomePA = " [" + richiestaApplicativa.getIdPortaApplicativa().getNome() + "]";
                                }
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Porta Applicativa" + (String)nomePA + " non esistente");
                                msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                                ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.API_IN_UNKNOWN);
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (controllo ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "ricevutaAsincronaSimmetricaAbilitata(pa)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "ricevutaAsincronaSimmetricaAbilitata(pa)");
                                return esito;
                            }
                            generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                tipoServizioCorrelato = null;
                                servizioCorrelato = null;
                                versioneServizioCorrelato = null;
                                if (bustaRichiesta.getTipoServizioCorrelato() != null && bustaRichiesta.getServizioCorrelato() != null) {
                                    tipoServizioCorrelato = bustaRichiesta.getTipoServizioCorrelato();
                                    servizioCorrelato = bustaRichiesta.getServizioCorrelato();
                                    versioneServizioCorrelato = bustaRichiesta.getVersioneServizioCorrelato() != null && bustaRichiesta.getVersioneServizioCorrelato() > 0 ? bustaRichiesta.getVersioneServizioCorrelato() : Integer.valueOf(1);
                                } else {
                                    validazione = registroServiziManager.validaServizio(idSoggettoFruitore, idServizio, null);
                                    if (validazione == null || !validazione.getServizioRegistrato()) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non esiste nel registro dei servizi");
                                    }
                                    if (validazione.getServizioCorrelato() == null || validazione.getTipoServizioCorrelato() == null || validazione.getVersioneServizioCorrelato() == null) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non possiede un servizio correlato associato");
                                    }
                                    tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
                                    servizioCorrelato = validazione.getServizioCorrelato();
                                    versioneServizioCorrelato = validazione.getVersioneServizioCorrelato();
                                }
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, tipoServizioCorrelato, servizioCorrelato, versioneServizioCorrelato, richiestaApplicativa.isRicevutaAsincrona(), this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoSimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "SalvataggioInformazioniProfiloAsincronoSimmetrico");
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnProtocolReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if (!consegnaAffidabile) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                }
                                if (imbustamentoFiltroDuplicatiAbilitato) {
                                    bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                }
                            }
                        } else {
                            if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta...");
                                scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                            } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta asincrona...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona simmetrica";
                            } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta asincrona ...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona simmetrica";
                            } else {
                                msgDiag.logPersonalizzato("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta (raccolta dati per consegna risposta)...");
                            try {
                                if (ricevutaAsincrona == null) {
                                    integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRisposta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta));
                                }
                                integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoSimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "RaccoltaDatiIntegrazioneProfiloAsincronoSimmetrico");
                                return esito;
                            }
                        }
                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (openspcoopstate.resourceReleased()) {
                            ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                            openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                            profiloCollaborazione.updateState(openspcoopstate.getStatoRichiesta());
                            repositoryBuste.updateState(openspcoopstate.getStatoRichiesta());
                        }
                        if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = configurazionePdDManager.existsPA(richiestaApplicativa, requestInfo);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiesta)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiesta)");
                                return esito;
                            }
                            if (!existsPA) {
                                nomePA = "";
                                if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getNome() != null) {
                                    nomePA = " [" + richiestaApplicativa.getIdPortaApplicativa().getNome() + "]";
                                }
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Porta Applicativa" + (String)nomePA + " non esistente");
                                msgDiag.logPersonalizzato_prefix("(Richiesta) ", "portaApplicativaNonEsistente");
                                ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.API_IN_UNKNOWN);
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "(Richiesta) " + msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (lettura servizio applicativo)...");
                            servizioApplicativo = null;
                            try {
                                servizioApplicativo = configurazionePdDManager.getServiziApplicativi(pa);
                                if (servizioApplicativo == null) {
                                    throw new Exception("Servizio applicativo non esistente");
                                }
                                if (servizioApplicativo.length > 1) {
                                    throw new Exception("profilo non utilizzabile con una porta applicativa a cui sono stati associati piu' servizi applicativi");
                                }
                                if (servizioApplicativo.length <= 0) {
                                    throw new Exception("Non sono stati associati servizi applicativi alla porta applicativa");
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "LetturaServizioApplicatiProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "LetturaServizioApplicatiProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            richiestaApplicativa.setServizioApplicativo(servizioApplicativo[0]);
                            msgDiag.mediumDebug("Lettura Servizio Applicativo ...");
                            try {
                                idSA = new IDServizioApplicativo();
                                idSA.setNome(servizioApplicativo[0]);
                                idSA.setIdSoggettoProprietario(richiestaApplicativa.getIDServizio().getSoggettoErogatore());
                                sa = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
                            }
                            catch (DriverConfigurazioneNotFound e) {
                                msgDiag.logErroreGenerico("Servizio applicativo [" + servizioApplicativo[0] + "] non esistente", "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_453_SA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "Servizio applicativo [" + servizioApplicativo[0] + "] non esistente");
                                return esito;
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (exists ConsegnaRispostAsincrona)...");
                            existsConsegnaRispostaAsincrona = false;
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", sa.getNome());
                            try {
                                existsConsegnaRispostaAsincrona = configurazionePdDManager.existsConsegnaRispostaAsincrona(sa);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona_ProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsConsegnaRispostaAsincrona_ProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            if (!existsConsegnaRispostaAsincrona) {
                                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_411_RICEZIONE_CONTENUTI_ASINCRONA_RICHIESTA.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (servizio correlato)...");
                            if (sbustamentoMsg.getServizioCorrelato() == null || sbustamentoMsg.getTipoServizioCorrelato() == null) {
                                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "ricevutaAsincronaAsimmetricaAbilitata(pa)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "ricevutaAsincronaAsimmetricaAbilitata(pa)");
                                return esito;
                            }
                            generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                profiloCollaborazione.asincronoAsimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, sbustamentoMsg.getTipoServizioCorrelato(), sbustamentoMsg.getServizioCorrelato(), sbustamentoMsg.getVersioneServizioCorrelato(), richiestaApplicativa.isRicevutaAsincrona(), this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "SalvataggioInformazioniProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnProtocolReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                if (protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente)) {
                                    bustaHTTPReply.setServizioCorrelato(sbustamentoMsg.getServizioCorrelato());
                                    bustaHTTPReply.setTipoServizioCorrelato(sbustamentoMsg.getTipoServizioCorrelato());
                                }
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if (!consegnaAffidabile) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                }
                                if (imbustamentoFiltroDuplicatiAbilitato) {
                                    bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                }
                            }
                        } else {
                            if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato...");
                                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                                idServizioOriginale = null;
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato (lettura servizio originale)...");
                                try {
                                    idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta));
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta");
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta");
                                    return esito;
                                }
                                idServizioRichiesta = IDServizioFactory.getInstance().getIDServizioFromValues(idServizioOriginale.getTipo(), idServizioOriginale.getNome(), richiestaApplicativa.getIDServizio().getSoggettoErogatore(), idServizioOriginale.getVersione().intValue());
                                idServizioRichiesta.setAzione(idServizioOriginale.getAzione());
                                idServizioRichiesta.setTipologia(richiestaApplicativa.getIDServizio().getTipologia());
                                idServizioRichiesta.setUriAccordoServizioParteComune(richiestaApplicativa.getIDServizio().getUriAccordoServizioParteComune());
                                richiestaApplicativa.updateIDServizio(idServizioRichiesta);
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta Stato (existsPA)...");
                                try {
                                    existsPA = configurazionePdDManager.existsPA(richiestaApplicativa, requestInfo);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiestaStato)");
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiestaStato)");
                                    return esito;
                                }
                                if (!existsPA) {
                                    nomePA = "";
                                    if (richiestaApplicativa.getIdPortaApplicativa() != null && richiestaApplicativa.getIdPortaApplicativa().getNome() != null) {
                                        nomePA = " [" + richiestaApplicativa.getIdPortaApplicativa().getNome() + "]";
                                    }
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Porta Applicativa" + (String)nomePA + " non esistente");
                                    msgDiag.logPersonalizzato_prefix("(RichiestaStato) ", "portaApplicativaNonEsistente");
                                    ejbUtils.setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError.API_IN_UNKNOWN);
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "(RichiestaStato) " + msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                    return esito;
                                }
                                msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                pa = configurazionePdDManager.getPortaApplicativaSafeMethod(richiestaApplicativa.getIdPortaApplicativa(), requestInfo);
                            } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona asimmetrica";
                            } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato";
                            } else {
                                msgDiag.logPersonalizzato("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                return esito;
                            }
                            try {
                                if (ricevutaAsincrona == null) ** GOTO lbl1057
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico ricevuta (raccolta dati consegna per ricevuta)...");
                                integrazioneAsincrona = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "RaccoltaDatiIntegrazioneProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                        }
                    } else {
                        ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_SCONOSCIUTO.getErroreProfiloCollaborazioneSconosciuto(bustaRichiesta.getProfiloDiCollaborazioneValue()), (IProtocolFactory)protocolFactory);
                        msgDiag.addKeyword("@ECCEZIONI@", ecc.toString(protocolFactory));
                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "1");
                        msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ecc, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                        return esito;
                    }
                }
lbl1057:
                // 10 sources

                msgDiag.mediumDebug("Gestione profilo di collaborazione Asincrono, raccolta dati consegna...");
                consegnaApplicativaAsincrona = null;
                pdConsegnaApplicativaAsincrona = null;
                saConsegnaApplicativaAsincrona = null;
                try {
                    block292: {
                        if (integrazioneAsincrona == null) break block291;
                        soggettoFruitoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario());
                        soggettoErogatoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente());
                        servizioRichiestaAsincrona = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), soggettoErogatoreRichiestaAsincrona, bustaRichiesta.getVersioneServizio().intValue());
                        servizioRichiestaAsincrona.setAzione(bustaRichiesta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD((IProtocolManager)protocolManager);
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo("Sbustamento");
                        idPD = configurazionePdDManager.getIDPortaDelegata(integrazioneAsincrona.getNomePorta(), requestInfo, protocolFactory);
                        consegnaApplicativaAsincrona = new RichiestaDelegata(idPD, integrazioneAsincrona.getServizioApplicativo(), null, proprietaErroreApplAsincrono, identitaPdD);
                        consegnaApplicativaAsincrona.setScenario(scenarioCooperazione);
                        consegnaApplicativaAsincrona.setProfiloGestione(profiloGestione);
                        pdConsegnaApplicativaAsincrona = configurazionePdDManager.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata(), requestInfo);
                        try {
                            idSA = new IDServizioApplicativo();
                            idSA.setNome(consegnaApplicativaAsincrona.getServizioApplicativo());
                            idSA.setIdSoggettoProprietario(soggettoFruitoreRichiestaAsincrona);
                            saConsegnaApplicativaAsincrona = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block292;
                            throw e;
                        }
                    }
                    configurazionePdDManager.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, saConsegnaApplicativaAsincrona);
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(true);
                    } else {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    }
                    if (ricevutaAsincrona != null) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        if (profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(bustaRichiesta.getRiferimentoMessaggio()) && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                            consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                        }
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneAsincrona.getIdModuloInAttesa());
                    } else {
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(richiestaApplicativa.getIdModuloInAttesa());
                        if (!consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                            profiloCollaborazione.eliminaBustaInviata(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta), true);
                        }
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pdConsegnaApplicativaAsincrona, bustaRichiesta.getProfiloDiCollaborazione()) == false ? consegnaApplicativaAsincrona.isRicevutaAsincrona() == false : false;
                        if (generazioneMsgOK) {
                            returnProtocolReply = true;
                            bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                            bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                            bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                            bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                            bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                            if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                            }
                            bustaHTTPReply.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                            if (!consegnaAffidabile) {
                                bustaHTTPReply.setConfermaRicezione(false);
                            }
                            if (imbustamentoFiltroDuplicatiAbilitato) {
                                bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "GestioneConsegnaProfiloAsincrono");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "GestioneConsegnaProfiloAsincrono");
                    return esito;
                }
            }
            msgDiag.mediumDebug("Impostazione scenario di cooperazione...");
            try {
                richiestaApplicativa.setScenario(scenarioCooperazione);
                repositoryBuste.aggiornaInfoIntegrazioneIntoInBox_Scenario(bustaRichiesta.getID(), scenarioCooperazione);
                ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "repository.aggiornaInfoIntegrazioneIntoInBox_Scenario");
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "repository.aggiornaInfoIntegrazioneIntoInBox_Scenario");
                return esito;
            }
            behaviour = null;
            try {
                if (ricevutaAsincrona == null) {
                    if (consegnaApplicativaAsincrona == null) {
                        msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi...");
                        behaviour = ejbUtils.sendToConsegnaContenutiApplicativi(requestInfo, richiestaApplicativa, bustaRichiesta, msgRequest, pa, repositoryBuste);
                        if (ejbUtils.isGestioneStatelessConIntegrationManager()) {
                            generazioneMsgOK = true;
                            sendSbloccoRicezioneBuste = true;
                        }
                    } else {
                        msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi (consegnaAsincrona)...");
                        ejbUtils.sendToConsegnaContenutiApplicativi_gestioneMessaggio(consegnaApplicativaAsincrona, bustaRichiesta, msgRequest, saConsegnaApplicativaAsincrona);
                    }
                } else if (consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                    msgDiag.mediumDebug("Invio messaggio asincrono a Ricezione/Consegna ContenutiApplicativi...");
                    ejbUtils.updateIdSessione(bustaRichiesta.getRiferimentoMessaggio());
                    msgRequest = ejbUtils.sendRispostaApplicativa(consegnaApplicativaAsincrona, pdConsegnaApplicativaAsincrona, saConsegnaApplicativaAsincrona);
                    ejbUtils.updateIdSessione(idMessageRequest);
                }
                msgDiag.setServizioApplicativo(null);
            }
            catch (EJBUtilsConsegnaException e) {
                msgDiag.logPersonalizzato_custom(e.getMessaggio(), e.getLivello(), e.getCodice());
                if (e.getIntegrationFunctionError() != null) {
                    ejbUtils.setIntegrationFunctionErrorPortaApplicativa(e.getIntegrationFunctionError());
                }
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, e.getMessaggio());
                return esito;
            }
            catch (Exception e) {
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "Abilitazione modulo ConsegnaMessaggio non riuscita (Busta " + bustaRichiesta.getID() + "): " + e.getMessage());
                return esito;
            }
            v1 = behaviourResponseTo = behaviour != null && behaviour.isResponseTo() != false;
            if (generazioneMsgOK || behaviourResponseTo) {
                try {
                    pddContext.addObject(Costanti.DATA_PRESA_IN_CARICO, DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
                    if (behaviourResponseTo) {
                        msgReplyTo = null;
                        bustaReplyTo = null;
                        if (behaviour.getResponseTo() != null) {
                            msgReplyTo = behaviour.getResponseTo().getMessage();
                            bustaReplyTo = behaviour.getResponseTo().getBusta();
                        }
                        if (msgReplyTo == null) {
                            msgReplyTo = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                        }
                        msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi (Behaviour)...");
                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaReplyTo, msgReplyTo, profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    }
                    if (!returnProtocolReply) {
                        if (!sendSbloccoRicezioneBuste) ** GOTO lbl1221
                        msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                    }
                    msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi...");
                    msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "GenerazioneMsgOK(Riscontro/Ricevuta/Sblocco)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "GenerazioneMsgOK(Riscontro/Ricevuta/Sblocco)");
                    return esito;
                }
            } else if (ricevutaAsincrona != null) {
                try {
                    pddContext.addObject(Costanti.DATA_PRESA_IN_CARICO, DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
                    if (sendSbloccoRicezioneBuste) {
                        msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste (ricevuta asincrona)...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "SendSbloccoDopoRicezione(" + ricevutaAsincrona + ")");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "SendSbloccoDopoRicezione(" + ricevutaAsincrona + ")");
                    return esito;
                }
            }
lbl1221:
            // 7 sources

            msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
            if (ricevutaAsincrona == null) {
                msgRequest.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
            } else if (consegnaApplicativaAsincrona != null && !consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                repositoryBuste.eliminaUtilizzoPdDFromInBox(idMessageRequest, true);
                msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
        }
        catch (Throwable e) {
            this.log.error("ErroreGenerale", e);
            msgDiag.logErroreGenerico(e, "Generale");
            if (ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                try {
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, e, null);
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "ErroreGenerale");
                }
                catch (Exception er) {
                    msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta sincrona non riuscita", esito);
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(er);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), esito);
                esito.setStatoInvocazioneErroreNonGestito(e);
                esito.setEsitoInvocazione(false);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (msgRequest != null) {
            msgRequest.addMessaggiIntoCache_readFromTable("Sbustamento", "richiesta");
        }
        if (msgResponse != null) {
            msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta");
        }
        if (msgRequest != null) {
            msgRequest.addProprietariIntoCache_readFromTable("Sbustamento", "richiesta", null, false);
        }
        if (msgResponse != null) {
            msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta", idMessageRequest, false);
        }
        if (ricevutaAsincrona != null) {
            msgDiag.mediumDebug("Gestione ricevute asincrone...");
            try {
                forzaEliminazioneMessaggio = false;
                if (openspcoopstate instanceof OpenSPCoopStateless && "ricevuta di una richiesta asincrona simmetrica".equals(ricevutaAsincrona)) {
                    forzaEliminazioneMessaggio = true;
                }
                msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, bustaRichiesta.getRiferimentoMessaggio(), "OUTBOX", msgDiag, pddContext);
                msgRiscontrato.setReadyForDrop(forzaEliminazioneMessaggio);
                msgRiscontrato.validateAndDeleteMsgAsincronoRiscontrato(bustaRichiesta);
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevutaAsincrona);
                msgDiag.logPersonalizzato("validazioneRicevutaAsincrona");
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Validazione(" + ricevutaAsincrona + ")");
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        msgDiag.mediumDebug("Lavoro Terminato.");
        esito.setEsitoInvocazione(true);
        esito.setStatoInvocazione(1, null);
        return esito;
    }

    private void gestioneErroreProtocollo(ConfigurazionePdDManager configurazionePdDManager, EJBUtils ejbUtils, org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione, RepositoryBuste repositoryBuste, Busta busta, IDSoggetto identitaPdD, Eccezione eccezioneProtocollo, ErroreIntegrazione erroreIntegrazione, IDSoggetto soggettoProduttoreEccezione, DettaglioEccezione dettaglioEccezione, IProtocolFactory<?> protocolFactory, IProtocolManager protocolManager, PdDContext pddContext, RequestInfo requestInfo, IntegrationFunctionError integrationFunctionError) throws Exception {
        if (ProfiloDiCollaborazione.SINCRONO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() != null) {
            ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione())) {
            Integrazione integrazioneRispostaErrore = null;
            boolean spedizioneRichiestaInCorso = profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(busta.getRiferimentoMessaggio());
            boolean spedizioneRispostaInCorso = profiloCollaborazione.asincrono_spedizioneRispostaInCorso(busta.getRiferimentoMessaggio());
            boolean ricevutaApplicativaAbilitata = true;
            boolean gestioneEffettuata = false;
            if ((spedizioneRichiestaInCorso || spedizioneRispostaInCorso) && (ricevutaApplicativaAbilitata = profiloCollaborazione.asincrono_ricevutaApplicativaAbilitata(busta.getRiferimentoMessaggio()))) {
                try {
                    integrazioneRispostaErrore = repositoryBuste.getInfoIntegrazioneFromOutBox(busta.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante l'esamina dei dati di integrazione per la generazione di una risposta applicativa asincrona, in seguito alla ricezione di un Messaggio Errore Protocollo: " + e.getMessage());
                }
                if (integrazioneRispostaErrore != null) {
                    ServizioApplicativo sappl;
                    PortaDelegata pd;
                    RichiestaDelegata consegnaApplicativaAsincrona;
                    ProprietaErroreApplicativo proprietaErroreApplAsincrono;
                    block14: {
                        IDSoggetto soggettoFruitoreAsincrono = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                        IDSoggetto soggettoErogatoreAsincrono = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        IDServizio servizioAsincrono = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), soggettoErogatoreAsincrono, busta.getVersioneServizio().intValue());
                        servizioAsincrono.setAzione(busta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD(protocolManager);
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo(ID_MODULO);
                        IDPortaDelegata idPD = configurazionePdDManager.getIDPortaDelegata(integrazioneRispostaErrore.getNomePorta(), requestInfo, protocolFactory);
                        consegnaApplicativaAsincrona = new RichiestaDelegata(idPD, integrazioneRispostaErrore.getServizioApplicativo(), null, proprietaErroreApplAsincrono, identitaPdD);
                        pd = configurazionePdDManager.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata(), requestInfo);
                        sappl = null;
                        try {
                            IDServizioApplicativo idSA = new IDServizioApplicativo();
                            idSA.setNome(consegnaApplicativaAsincrona.getServizioApplicativo());
                            idSA.setIdSoggettoProprietario(soggettoFruitoreAsincrono);
                            sappl = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block14;
                            throw e;
                        }
                    }
                    configurazionePdDManager.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, sappl);
                    consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                    if (spedizioneRichiestaInCorso && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                    }
                    consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneRispostaErrore.getIdModuloInAttesa());
                    this.generatoreErrore.updateDominio(consegnaApplicativaAsincrona.getDominio());
                    this.generatoreErrore.updateProprietaErroreApplicativo(proprietaErroreApplAsincrono);
                    this.generatoreErrore.updateTipoPdD(TipoPdD.DELEGATA);
                    this.generatoreErrore.updateInformazioniCooperazione(consegnaApplicativaAsincrona.getServizioApplicativo());
                    this.generatoreErrore.updateInformazioniCooperazione(consegnaApplicativaAsincrona.getIdSoggettoFruitore(), consegnaApplicativaAsincrona.getIdServizio());
                    OpenSPCoop2Message responseMessageError = null;
                    responseMessageError = eccezioneProtocollo != null ? this.generatoreErrore.build(pddContext, integrationFunctionError, eccezioneProtocollo, soggettoProduttoreEccezione, dettaglioEccezione, null) : this.generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, null, null);
                    ejbUtils.updateIdSessione(busta.getRiferimentoMessaggio());
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, consegnaApplicativaAsincrona, spedizioneRichiestaInCorso, pd, sappl);
                    ejbUtils.updateIdSessione(busta.getID());
                    gestioneEffettuata = true;
                } else if (spedizioneRichiestaInCorso) {
                    ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
                    gestioneEffettuata = true;
                }
            }
            if (!gestioneEffettuata) {
                ejbUtils.releaseInboxMessage(true);
            }
        } else {
            ejbUtils.releaseInboxMessage(true);
        }
    }

    public static IFiltroDuplicati getGestoreFiltroDuplicati(OpenSPCoop2Properties propertiesReader, Loader loader, IOpenSPCoopState openspcoopstate, PdDContext pddContext, History historyBuste, RepositoryBuste repositoryBuste, boolean oneWayVersione11) throws Exception {
        String gestoreFiltroDuplicatiType = propertiesReader.getGestoreFiltroDuplicatiRepositoryBuste();
        ClassNameProperties prop = ClassNameProperties.getInstance();
        String gestoreFiltroDuplicatiClass = prop.getFiltroDuplicati(gestoreFiltroDuplicatiType);
        if (gestoreFiltroDuplicatiClass == null) {
            throw new Exception("GestoreFiltroDuplicati non registrato (" + gestoreFiltroDuplicatiType + ")");
        }
        IFiltroDuplicati gestoreFiltroDuplicati = (IFiltroDuplicati)loader.newInstance(gestoreFiltroDuplicatiClass);
        if (pddContext != null) {
            pddContext.addObject(Costanti.OPENSPCOOP_STATE, openspcoopstate);
        }
        gestoreFiltroDuplicati.init((Object)pddContext);
        if (gestoreFiltroDuplicati instanceof org.openspcoop2.protocol.engine.driver.FiltroDuplicati) {
            ((org.openspcoop2.protocol.engine.driver.FiltroDuplicati)gestoreFiltroDuplicati).setHistoryBuste(historyBuste);
            ((org.openspcoop2.protocol.engine.driver.FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryBuste(repositoryBuste);
            ((org.openspcoop2.protocol.engine.driver.FiltroDuplicati)gestoreFiltroDuplicati).setGestioneStateless(openspcoopstate instanceof OpenSPCoopStateless && !oneWayVersione11);
            ((org.openspcoop2.protocol.engine.driver.FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryIntervalloScadenzaMessaggi(propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
        } else if (gestoreFiltroDuplicati instanceof FiltroDuplicati && pddContext != null && pddContext.containsKey(CostantiPdD.FILTRO_DUPLICATI_TEST)) {
            ((FiltroDuplicati)gestoreFiltroDuplicati).setUseTransactionIdForTest(true);
        }
        return gestoreFiltroDuplicati;
    }
}

