/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class InoltroBusteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private transient MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                if (log != null) {
                    log.error("[InoltroBuste] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                if (log != null) {
                    log.error("[InoltroBuste] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                if (log != null) {
                    log.error("[InoltroBuste] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.isSistemaDumpDisponibile()) {
                log.error("[InoltroBuste] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (log == null) {
                LoggerWrapperFactory.getLogger(InoltroBusteMDB.class).error("[ImbustamentoRisposte] Logger nullo.");
            }
            InoltroBuste lib = null;
            try {
                lib = new InoltroBuste(log);
            }
            catch (Exception e) {
                if (log != null) {
                    log.error("InoltroBuste.instanziazione: " + e.getMessage(), (Throwable)e);
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.getInizializzazioneUltimata()) {
                log = LoggerWrapperFactory.getLogger(InoltroBusteMDB.class);
                log.error("[InoltroBuste] Inizializzazione non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.DELEGATA, "InoltroBuste");
            msgDiag.mediumDebug("Ricezione richiesta (InoltroBusteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            InoltroBusteMessage inoltroBusteMsg = null;
            try {
                inoltroBusteMsg = (InoltroBusteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(InoltroBusteMessage)");
                return;
            }
            if (inoltroBusteMsg.getRichiestaDelegata() != null && inoltroBusteMsg.getRichiestaDelegata().getIdPortaDelegata() != null) {
                RequestInfo requestInfo = null;
                if (inoltroBusteMsg.getPddContext() != null && inoltroBusteMsg.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)inoltroBusteMsg.getPddContext().getObject(Costanti.REQUEST_INFO);
                }
                msgDiag.updatePorta(inoltroBusteMsg.getRichiestaDelegata().getIdPortaDelegata().getNome(), requestInfo);
            }
            String idMessageRequest = null;
            try {
                idMessageRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopState stato = null;
            try {
                if (inoltroBusteMsg.getOpenspcoopstate() != null) {
                    stato = inoltroBusteMsg.getOpenspcoopstate();
                    stato.setUseConnection(true);
                    stato.setMessageLib(inoltroBusteMsg);
                    ((OpenSPCoopStateless)stato).setIDMessaggioSessione(idMessageRequest);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDMessaggioSessione(idMessageRequest);
                    ((OpenSPCoopStateful)stato).setMessageLib(inoltroBusteMsg);
                }
            }
            catch (Exception e) {
                if (log != null) {
                    log.error("[InoltroBuste] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = inoltroBusteMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME)));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "InoltroBuste", idMessageRequest, "OUTBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessageRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "InoltroBuste");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                if (log != null) {
                    log.error("[InoltroBuste] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                }
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                if (log != null) {
                    log.info("[InoltroBuste] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                }
                this.ctxMDB.setRollbackOnly();
            } else if (log != null) {
                log.debug("[InoltroBuste] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

